SKIPUNZIP=1
MODDIR=${0%/*}

if $BOOTMODE; then
    ui_print "- Installing from Magisk app"
else
    ui_print "*********************************************************"
    ui_print "! Install from recovery is NOT supported"
    ui_print "! Please install from Magisk app"
    abort    "*********************************************************"
fi

unzip -o "$ZIPFILE" 'module.prop' -d "$MODPATH" >&2
unzip -o "$ZIPFILE" 'temp' -d "$MODPATH" >&2

TEMPDIR=$MODDIR/temp

ui_print "- Magisk version: $MAGISK_VER_CODE"
ui_print "- Api version: $API"
ui_print "- ABI version: $ARCH"

if [ "$API" -ge 24 ] && [ "$API" -le 28 ] && [ "$ARCH" == "arm" ]; then
	unzip -o "$ZIPFILE" 'files/webview-24-arm.apk' -d "$TEMPDIR"
	pm install -r "$TEMPDIR/files/webview-24-arm.apk"

elif [ "$API" -ge 24 ] && [ "$API" -le 28 ] && [ "$ARCH" == "arm64" ]; then
	unzip -o "$ZIPFILE" 'files/webview-24-arm64.apk' -d "$TEMPDIR"
	pm install -r "$TEMPDIR/files/webview-24-arm64.apk"

elif [ "$API" -ge 29 ] && [ "$ARCH" == "arm" ]; then
	unzip -o "$ZIPFILE" 'files/trichromelibrary-arm.apk' -d "$TEMPDIR"
	unzip -o "$ZIPFILE" 'files/webview-29-arm/*' -d "$TEMPDIR"
	pm install -r "$TEMPDIR/files/trichromelibrary-arm.apk"
	pm install -r "$TEMPDIR/files/webview-29-arm/base.apk" "$TEMPDIR/files/webview-29-arm/split_config.en.apk" "$TEMPDIR/files/webview-29-arm/split_config.ru.apk" "$TEMPDIR/files/webview-29-arm/split_weblayer.apk"

elif [ "$API" -ge 29 ] && [ "$ARCH" == "arm64" ]; then
	unzip -o "$ZIPFILE" 'files/trichromelibrary-arm64.apk' -d "$TEMPDIR"
	unzip -o "$ZIPFILE" 'files/webview-29-arm64/*' -d "$TEMPDIR"
	pm install -r "$TEMPDIR/files/trichromelibrary-arm64.apk"
	pm install -r "$TEMPDIR/files/webview-29-arm64/base.apk" "$TEMPDIR/files/webview-29-arm64/split_config.en.apk" "$TEMPDIR/files/webview-29-arm64/split_config.ru.apk" "$TEMPDIR/files/webview-29-arm64/split_weblayer.apk"
else
	abort "- Your API $API or ABI $ARCH is not supported!"
fi

rm -rf "$TEMPDIR"
