/* $Id: system-get-nt-xxx-win.cpp 110684 2025-08-11 17:18:47Z klaus.espenlaub@oracle.com $ */
/** @file
 * IPRT - RTSystemGetNtXxxx functions.
 */

/*
 * Copyright (C) 2008-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * The contents of this file may alternatively be used under the terms
 * of the Common Development and Distribution License Version 1.0
 * (CDDL), a copy of it is provided in the "COPYING.CDDL" file included
 * in the VirtualBox distribution, in which case the provisions of the
 * CDDL are applicable instead of those of the GPL.
 *
 * You may elect to license modified versions of this file under the
 * terms and conditions of either the GPL or the CDDL or both.
 *
 * SPDX-License-Identifier: GPL-3.0-only OR CDDL-1.0
 */


/*********************************************************************************************************************************
*   Header Files                                                                                                                 *
*********************************************************************************************************************************/
#include "internal/iprt.h"
#include <iprt/win/windows.h>

#include "internal-r3-win.h"
#include <iprt/system.h>
#include <iprt/assert.h>
#include <iprt/err.h>
#include <iprt/win/reg.h>


RTDECL(uint32_t) RTSystemGetNtBuildNo(void)
{
    Assert(g_WinOsInfoEx.dwOSVersionInfoSize > 0);
    return g_WinOsInfoEx.dwBuildNumber;
}


RTDECL(uint64_t) RTSystemGetNtVersion(void)
{
    Assert(g_WinOsInfoEx.dwOSVersionInfoSize > 0);
    return RTSYSTEM_MAKE_NT_VERSION(g_WinOsInfoEx.dwMajorVersion, g_WinOsInfoEx.dwMinorVersion, g_WinOsInfoEx.dwBuildNumber);
}


RTDECL(uint8_t) RTSystemGetNtProductType(void)
{
    Assert(g_WinOsInfoEx.dwOSVersionInfoSize > 0);
    return g_WinOsInfoEx.wProductType; /* It's a byte, not a word as 'w' normally indicates. (Baka Maikurosofuto!) */
}


/** @todo this is a bit out of place, since it's a query and it's about
 *        windows feature according to the GUI. */
RTDECL(int) RTSystemQueryNtFeatureEnabled(RTSYSNTFEATURE enmFeature, bool *pfEnabled)
{
    AssertPtrReturn(pfEnabled, VERR_INVALID_POINTER);
    *pfEnabled = false;

    switch (enmFeature)
    {
        case RTSYSNTFEATURE_CORE_ISOLATION_MEMORY_INTEGRITY: /* aka Code Integrity */
        {
            uint32_t fEnabled = 0;
            int rc = RTWinRegQueryValueU32(kRTWinRegRoot_LocalMachine,
                                           L"SYSTEM\\CurrentControlSet\\Control\\DeviceGuard\\Scenarios\\HypervisorEnforcedCodeIntegrity",
                                           L"Enabled",
                                           &fEnabled);
            if (RT_SUCCESS(rc))
                *pfEnabled = RT_BOOL(fEnabled);
            else if (rc == VERR_FILE_NOT_FOUND || rc == VERR_PATH_NOT_FOUND || rc == VERR_NOT_FOUND)
                rc = VERR_NOT_SUPPORTED;
            return rc;
        }

        case RTSYSNTFEATURE_INVALID:
        case RTSYSNTFEATURE_32_BIT_HACK:
            break;
    }
    return VERR_INVALID_PARAMETER;
}

