/*
 * Autogenerated by $Id: IEMAllCImplA64SysRegsAndIns-armv8.cpp 110970 2025-09-13 01:41:04Z knut.osmundsen@oracle.com $
 * from the open source v9Ap6-A specs, build 406 (5e0a212688c6bd7aee92394b6f5e491b4d0fee1d)
 * dated Sun Dec 15 22:18:44 2024 UTC.
 *
 * Do not edit!
 */

/*
 * Copyright (C) 2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */


#define LOG_GROUP LOG_GROUP_IEM_CIMPL
#define VMCPU_INCL_CPUM_GST_CTX
#include "IEMInternal.h"
#include <VBox/vmm/vm.h>
#include "VBox/err.h"

#include "iprt/armv8.h"

#include "IEMMc.h"
#include "IEMInline-armv8.h"





/*
 * A64.MRS
 *
 *  615 registers
 *  507 complete - 297 with unresolved registers
 *   67 incomplete
 *
 * Warnings:
 *   Assignment from Identifier: Unable to map AArch64.ICV_BPR0_EL1 to anything
 *   Assignment from Identifier: Unable to map AArch64.ICV_BPR1_EL1 to anything
 *   Assignment from Identifier: Unable to map AArch64.ICV_CTLR_EL1 to anything (2 times)
 *   Assignment from Identifier: Unable to map AArch64.ICV_HPPIR0_EL1 to anything
 *   Assignment from Identifier: Unable to map AArch64.ICV_HPPIR1_EL1 to anything
 *   Assignment from Identifier: Unable to map AArch64.ICV_IAR0_EL1 to anything
 *   Assignment from Identifier: Unable to map AArch64.ICV_IAR1_EL1 to anything
 *   Assignment from Identifier: Unable to map AArch64.ICV_IGRPEN0_EL1 to anything
 *   Assignment from Identifier: Unable to map AArch64.ICV_IGRPEN1_EL1 to anything
 *   Assignment from Identifier: Unable to map AArch64.ICV_NMIAR1_EL1 to anything
 *   Assignment from Identifier: Unable to map AArch64.ICV_PMR_EL1 to anything (2 times)
 *   Assignment from Identifier: Unable to map AArch64.ICV_RPR_EL1 to anything (2 times)
 *   Assignment/Identifier: No CPUMCTX mapping for register AArch64.CNTHV_CVAL_EL2 (3 times)
 *   Assignment/Identifier: No CPUMCTX mapping for register AArch64.RCWMASK_EL1 (2 times)
 *   Assignment/Identifier: No CPUMCTX mapping for register AArch64.RCWSMASK_EL1
 *   Call to untranslated function: CNTHCTL_EL2_VHE
 *   Call to untranslated function: ConstrainUnpredictableProcedure (6 times)
 *   Call to untranslated function: EffectivePMSCR_EL2_EE
 *   Call to untranslated function: EffectiveTRFCR_EL2_EE (2 times)
 *   Call to untranslated function: GetNumEventCountersAccessible (4 times)
 *   Call to untranslated function: GetNumEventCountersSelfHosted (2 times)
 *   Call to untranslated function: UInt (98 times)
 *   Call to untranslated function: UnimplementedIDRegister (3 times)
 *   Call to untranslated function: ZeroExtend (3 times)
 *   Generic field: Field "AMCNTEN0" not found in register "HAFGRTR_EL2" (2 times)
 *   Generic field: Field "AMCNTEN1" not found in register "HAFGRTR_EL2" (2 times)
 *   Generic field: Field "F0" not found in register "PMUACR_EL1" (2 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.CNTHV_CTL_EL2 (looking up field ENABLE) (3 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.ICC_SRE_EL1 (looking up field SRE) (12 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.ICC_SRE_EL2 (looking up field Enable)
 *   Generic field: No CPUMCTX mapping for register AArch64.ICC_SRE_EL2 (looking up field SRE) (18 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.ICH_HCR_EL2 (looking up field TALL0) (4 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.ICH_HCR_EL2 (looking up field TALL1) (5 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.ICH_HCR_EL2 (looking up field TC) (3 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAM2_EL2 (looking up field EnMPAMSM)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAM2_EL2 (looking up field TIDR)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAM2_EL2 (looking up field TRAPMPAM0EL1)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAM2_EL2 (looking up field TRAPMPAM1EL1)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAMBW2_EL2 (looking up field nTRAP_MPAMBW0_EL1)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAMBW2_EL2 (looking up field nTRAP_MPAMBW1_EL1)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAMBW2_EL2 (looking up field nTRAP_MPAMBWIDR_EL1)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAMBW2_EL2 (looking up field nTRAP_MPAMBWSM_EL1)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAMHCR_EL2 (looking up field TRAP_MPAMIDR_EL1)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAMIDR_EL1 (looking up field HAS_HCR) (12 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAMIDR_EL1 (looking up field HAS_TIDR)
 *   Generic field: No CPUMCTX mapping for register AArch64.MPAMIDR_EL1 (looking up field VPMR_MAX) (7 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.PMSELR_EL0 (looking up field SEL) (22 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.SPMSELR_EL0 (looking up field SYSPMUSEL) (69 times)
 *   Generic field: No CPUMCTX mapping for register AArch64.TRFCR_EL1 (looking up field EE)
 */


/**
 * OSDTRRX_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0000', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_OSDTRRX_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(27)/*TDCC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,0,2), "OSDTRRX_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,0,2), "OSDTRRX_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (Halted() && ConstrainUnpredictableBool(Unpredictable_IGNORETRAPINDEBUG))
    //     X<t,0x40> = OSDTRRX_EL1;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (EL2Enabled() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL2.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = OSDTRRX_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = OSDTRRX_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = OSDTRRX_EL1;
}


/**
 * MDCCINT_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MDCCINT_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(27)/*TDCC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.MDccInt.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.MDccInt.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (Halted() && ConstrainUnpredictableBool(Unpredictable_IGNORETRAPINDEBUG))
    //     X<t,0x40> = MDCCINT_EL1;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (EL2Enabled() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL2.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDCCINT_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDCCINT_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MDCCINT_EL1;
}


/**
 * MDSCR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MDSCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x158, puDst);
        *puDst = pVCpu->cpum.GstCtx.Mdscr.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Mdscr.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.MDSCR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x158>;
    //     else
    //         X<t,0x40> = MDSCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDSCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MDSCR_EL1;
}


/**
 * OSDTRTX_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0000', 'CRm': '0011', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_OSDTRTX_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(27)/*TDCC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,3,2), "OSDTRTX_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,3,2), "OSDTRTX_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (Halted() && ConstrainUnpredictableBool(Unpredictable_IGNORETRAPINDEBUG))
    //     X<t,0x40> = OSDTRTX_EL1;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (EL2Enabled() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL2.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = OSDTRTX_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = OSDTRTX_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = OSDTRTX_EL1;
}


/**
 * MDSELR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0000', 'CRm': '0100', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MDSELR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fDebugV8p9)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,4,2), "MDSELR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,4,2), "MDSELR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_Debugv8p9))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EBWE == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nMDSELR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EBWE == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDSELR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EBWE == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EBWE == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDSELR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MDSELR_EL1;
}


/**
 * MDSTEPOP_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0000', 'CRm': '0101', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MDSTEPOP_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fStep2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,5,2), "MDSTEPOP_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,5,2), "MDSTEPOP_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_STEP2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnSTEPOP == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nMDSTEPOP_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnSTEPOP == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDSTEPOP_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnSTEPOP == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnSTEPOP == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDSTEPOP_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MDSTEPOP_EL1;
}


/**
 * OSECCR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0000', 'CRm': '0110', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_OSECCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (!(pVCpu->cpum.GstCtx.fOsLck & UINT32_C(1)/*OSLK*/))
            *puDst = 0;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,6,2),
                                         "OSECCR_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (!(pVCpu->cpum.GstCtx.fOsLck & UINT32_C(1)/*OSLK*/))
            *puDst = 0;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,0,6,2),
                                         "OSECCR_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.OSECCR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (AArch64.OSLSR_EL1.OSLK == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = OSECCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (AArch64.OSLSR_EL1.OSLK == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = OSECCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.OSLSR_EL1.OSLK == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = OSECCR_EL1;
}


/**
 * MDRAR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0001', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MDRAR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x900) /*TDE,TDRA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,1,0,0), "MDRAR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,1,0,0), "MDRAR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDRA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDRAR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDRAR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MDRAR_EL1;
}


/**
 * OSLSR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0001', 'CRm': '0001', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_OSLSR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x500) /*TDE,TDOSA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,1,1,4), "OSLSR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,1,1,4), "OSLSR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDOSA == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.OSLSR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDOSA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDOSA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = OSLSR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDOSA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDOSA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = OSLSR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = OSLSR_EL1;
}


/**
 * OSDLR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0001', 'CRm': '0011', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_OSDLR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x500) /*TDE,TDOSA*/) && pGstFeats->fDoubleLock)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,1,3,4), "OSDLR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,1,3,4), "OSDLR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && AArch64.MDCR_EL3.TDOSA == '1'
    //         && (IsFeatureImplemented(FEAT_DoubleLock) || ImpDefBool("Trapped by MDCR_EL3.TDOSA")))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && IsFeatureImplemented(FEAT_DoubleLock)
    //              && AArch64.HDFGRTR_EL2.OSDLR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDOSA) != '00'
    //              && (IsFeatureImplemented(FEAT_DoubleLock) || ImpDefBool("Trapped by MDCR_EL2.TDOSA")))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && AArch64.MDCR_EL3.TDOSA == '1'
    //              && (IsFeatureImplemented(FEAT_DoubleLock) || ImpDefBool("Trapped by MDCR_EL3.TDOSA")))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = OSDLR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && AArch64.MDCR_EL3.TDOSA == '1'
    //         && (IsFeatureImplemented(FEAT_DoubleLock) || ImpDefBool("Trapped by MDCR_EL3.TDOSA")))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && AArch64.MDCR_EL3.TDOSA == '1'
    //              && (IsFeatureImplemented(FEAT_DoubleLock) || ImpDefBool("Trapped by MDCR_EL3.TDOSA")))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = OSDLR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = OSDLR_EL1;
}


/**
 * DBGPRCR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0001', 'CRm': '0100', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_DBGPRCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x500) /*TDE,TDOSA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,1,4,4), "DBGPRCR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,1,4,4), "DBGPRCR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDOSA == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.DBGPRCR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDOSA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDOSA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = DBGPRCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDOSA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDOSA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = DBGPRCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = DBGPRCR_EL1;
}


/**
 * PMCCNTSVR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '1110', 'CRm': '1011', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMCCNTSVR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPmuV3Ss)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,14,11,7), "PMCCNTSVR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PMUv3_SS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMSS == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nPMSSDATA == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMSS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMCCNTSVR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMSS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMSS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMCCNTSVR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMCCNTSVR_EL1;
}


/**
 * PMICNTSVR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '1110', 'CRm': '1100', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMICNTSVR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPmuV3Icntr || !pGstFeats->fPmuV3Ss)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,14,12,0), "PMICNTSVR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_PMUv3_ICNTR) && IsFeatureImplemented(FEAT_PMUv3_SS)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMSS == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nPMSSDATA == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMSS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMICNTSVR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMSS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMSS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMICNTSVR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMICNTSVR_EL1;
}


/**
 * DBGAUTHSTATUS_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0111', 'CRm': '1110', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_DBGAUTHSTATUS_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,7,14,6),
                                     "DBGAUTHSTATUS_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu,
                                 ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,7,14,6),
                                 "DBGAUTHSTATUS_EL1",
                                 puDst,
                                 uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.DBGAUTHSTATUS_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = DBGAUTHSTATUS_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = DBGAUTHSTATUS_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = DBGAUTHSTATUS_EL1;
}


/**
 * DBGCLAIMSET_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0111', 'CRm': '1000', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_DBGCLAIMSET_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,7,8,6),
                                     "DBGCLAIMSET_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,7,8,6), "DBGCLAIMSET_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.DBGCLAIM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = DBGCLAIMSET_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = DBGCLAIMSET_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = DBGCLAIMSET_EL1;
}


/**
 * DBGCLAIMCLR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '0111', 'CRm': '1001', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_DBGCLAIMCLR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,7,9,6),
                                     "DBGCLAIMCLR_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,7,9,6), "DBGCLAIMCLR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.DBGCLAIM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = DBGCLAIMCLR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = DBGCLAIMCLR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = DBGCLAIMCLR_EL1;
}


/**
 * SPMACCESSR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '1001', 'CRm': '1101', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMACCESSR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x8e8, puDst);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,9,13,3),
                                     "SPMACCESSR_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,4,9,13,3),
                                     "SPMACCESSR_EL2",
                                     puDst,
                                     uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,9,13,3), "SPMACCESSR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMACCESSR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x8e8>;
    //     else
    //         X<t,0x40> = SPMACCESSR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = SPMACCESSR_EL2;
    //     else
    //         X<t,0x40> = SPMACCESSR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMACCESSR_EL1;
}


/**
 * SPMIIDR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '1001', 'CRm': '1101', 'op2': '100'})
 * Transformation status: 15 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMIIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMIIDR_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMIIDR_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMID == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMIIDR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMIIDR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMIIDR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMDEVARCH_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '1001', 'CRm': '1101', 'op2': '101'})
 * Transformation status: 15 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMDEVARCH_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMDEVARCH_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMDEVARCH_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMID == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMDEVARCH_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMDEVARCH_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMDEVARCH_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMDEVAFF_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '1001', 'CRm': '1101', 'op2': '110'})
 * Transformation status: 15 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMDEVAFF_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMDEVAFF_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMDEVAFF_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMDEVAFF_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMDEVAFF_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMDEVAFF_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMDEVAFF_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMCFGR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '1001', 'CRm': '1101', 'op2': '111'})
 * Transformation status: 15 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMCFGR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMCFGR_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMCFGR_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMID == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCFGR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCFGR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMCFGR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMINTENSET_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '1001', 'CRm': '1110', 'op2': '001'})
 * Transformation status: 15 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMINTENSET_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMINTENSET_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMINTENSET_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMINTEN == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMINTENSET_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMINTENSET_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMINTENSET_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMINTENCLR_EL1 - OrderedDict({'op0': '10', 'op1': '000', 'CRn': '1001', 'CRm': '1110', 'op2': '010'})
 * Transformation status: 15 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMINTENCLR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMINTENCLR_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMINTENCLR_EL1<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMINTEN == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMINTENCLR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMINTENCLR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMINTENCLR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * TRCTRACEIDR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCTRACEIDR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,0,1), "TRCTRACEIDR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,0,1), "TRCTRACEIDR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCTRACEIDR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCTRACEIDR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCTRACEIDR;
}


/**
 * TRCVICTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCVICTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,0,2), "TRCVICTLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,0,2), "TRCVICTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCVICTLR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVICTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVICTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVICTLR;
}


/**
 * TRCIDR8 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR8(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,0,6));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,0,6));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR8;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR8;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR8;
}


/**
 * TRCIMSPEC0 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIMSPEC0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,0,7), "TRCIMSPEC0", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,0,7), "TRCIMSPEC0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCIMSPECn == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIMSPEC0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIMSPEC0;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIMSPEC0;
}


/**
 * TRCPRGCTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCPRGCTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,1,0), "TRCPRGCTLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,1,0), "TRCPRGCTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCPRGCTLR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCPRGCTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCPRGCTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCPRGCTLR;
}


/**
 * TRCQCTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0001', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCQCTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,8,7)) >> 14) & UINT32_C(1)/*QFILT*/) != 1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,1,1), "TRCQCTLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,1,1), "TRCQCTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && AArch64.TRCIDR0.QFILT == '1'))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCQCTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCQCTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCQCTLR;
}


/**
 * TRCVIIECTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0001', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCVIIECTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || (iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7)) & UINT32_C(0xf)/*NUMACPAIRS*/) <= 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,1,2), "TRCVIIECTLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,1,2), "TRCVIIECTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && UInt(AArch64.TRCIDR4.NUMACPAIRS) > 0))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVIIECTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVIIECTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVIIECTLR;
}


/**
 * TRCIDR9 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0001', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR9(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,1,6));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,1,6));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR9;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR9;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR9;
}


/**
 * TRCRSR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCRSR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,10,0), "TRCRSR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,10,0), "TRCRSR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCRSR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCRSR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCRSR;
}


/**
 * TRCIDR2 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1010', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR2(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,10,7));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,10,7));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR2;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR2;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR2;
}


/**
 * TRCSTALLCTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1011', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCSTALLCTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,11,7)) >> 26) & UINT32_C(1)/*STALLCTL*/) != 1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,11,0),
                                     "TRCSTALLCTLR",
                                     puDst,
                                     uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,11,0), "TRCSTALLCTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && AArch64.TRCIDR3.STALLCTL == '1'))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSTALLCTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSTALLCTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSTALLCTLR;
}


/**
 * TRCIDR3 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1011', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR3(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,11,7));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,11,7));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR3;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR3;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR3;
}


/**
 * TRCTSCTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1100', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCTSCTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || !(iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,8,7)) & UINT32_C(0x1f000000)/*TSSIZE*/))
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,0), "TRCTSCTLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,0), "TRCTSCTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && AArch64.TRCIDR0.TSSIZE != '00000'))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCTSCTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCTSCTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCTSCTLR;
}


/**
 * TRCIDR4 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1100', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR4(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR4;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR4;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR4;
}


/**
 * TRCSYNCPR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1101', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCSYNCPR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,13,0), "TRCSYNCPR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,13,0), "TRCSYNCPR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSYNCPR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSYNCPR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSYNCPR;
}


/**
 * TRCIDR5 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1101', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR5(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,13,7));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,13,7));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR5;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR5;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR5;
}


/**
 * TRCCCCTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1110', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCCCCTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,8,7)) >>  7) & UINT32_C(1)/*TRCCCI*/) != 1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,14,0), "TRCCCCTLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,14,0), "TRCCCCTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && AArch64.TRCIDR0.TRCCCI == '1'))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCCCTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCCCTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCCCTLR;
}


/**
 * TRCIDR6 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1110', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR6(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,14,7));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,14,7));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR6;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR6;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR6;
}


/**
 * TRCBBCTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1111', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCBBCTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,8,7)) >>  5) & UINT32_C(1)/*TRCBB*/) != 1
        || (iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7)) & UINT32_C(0xf)/*NUMACPAIRS*/) <= 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,15,0), "TRCBBCTLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,15,0), "TRCBBCTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(   IsFeatureImplemented(FEAT_ETE)
    //     && IsFeatureImplemented(FEAT_TRC_SR)
    //     && AArch64.TRCIDR0.TRCBB == '1'
    //     && UInt(AArch64.TRCIDR4.NUMACPAIRS) > 0))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCBBCTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCBBCTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCBBCTLR;
}


/**
 * TRCIDR7 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1111', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR7(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,15,7));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,15,7));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR7;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR7;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR7;
}


/**
 * TRCITEEDCR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0010', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCITEEDCR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr || !pGstFeats->fIte)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,2,1), "TRCITEEDCR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,2,1), "TRCITEEDCR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && IsFeatureImplemented(FEAT_ITE)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCITEEDCR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCITEEDCR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCITEEDCR;
}


/**
 * TRCVISSCTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0010', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCVISSCTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || (iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7)) & UINT32_C(0xf)/*NUMACPAIRS*/) <= 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,2,2), "TRCVISSCTLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,2,2), "TRCVISSCTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && UInt(AArch64.TRCIDR4.NUMACPAIRS) > 0))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVISSCTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVISSCTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVISSCTLR;
}


/**
 * TRCIDR10 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0010', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR10(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,2,6));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,2,6));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR10;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR10;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR10;
}


/**
 * TRCSTATR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0011', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCSTATR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,3,0), "TRCSTATR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,3,0), "TRCSTATR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCSTATR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSTATR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSTATR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSTATR;
}


/**
 * TRCVIPCSSCTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0011', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCVIPCSSCTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7)) >> 12) & UINT32_C(0xf)/*NUMPC*/) <= 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,3,2),
                                     "TRCVIPCSSCTLR",
                                     puDst,
                                     uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,3,2), "TRCVIPCSSCTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && UInt(AArch64.TRCIDR4.NUMPC) > 0))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVIPCSSCTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVIPCSSCTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVIPCSSCTLR;
}


/**
 * TRCIDR11 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0011', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR11(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,3,6));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,3,6));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR11;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR11;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR11;
}


/**
 * TRCCONFIGR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0100', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCCONFIGR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,4,0), "TRCCONFIGR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,4,0), "TRCCONFIGR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCONFIGR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCONFIGR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCONFIGR;
}


/**
 * TRCIDR12 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0100', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR12(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,4,6));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,4,6));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR12;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR12;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR12;
}


/**
 * TRCIDR13 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0101', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR13(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,5,6));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,5,6));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR13;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR13;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR13;
}


/**
 * TRCAUXCTLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0110', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCAUXCTLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,6,0), "TRCAUXCTLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,6,0), "TRCAUXCTLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCAUXCTLR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCAUXCTLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCAUXCTLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCAUXCTLR;
}


/**
 * TRCSEQRSTEVR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0110', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCSEQRSTEVR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || !(iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,13,7)) & UINT32_C(0xe000000)/*NUMSEQSTATE*/))
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,6,4), "TRCSEQRSTEVR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,6,4), "TRCSEQRSTEVR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && AArch64.TRCIDR5.NUMSEQSTATE != '000'))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSEQRSTEVR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSEQRSTEVR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSEQRSTEVR;
}


/**
 * TRCSEQSTR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '0111', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCSEQSTR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || !(iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,13,7)) & UINT32_C(0xe000000)/*NUMSEQSTATE*/))
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,7,4), "TRCSEQSTR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,7,4), "TRCSEQSTR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && AArch64.TRCIDR5.NUMSEQSTATE != '000'))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCSEQSTR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSEQSTR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSEQSTR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCSEQSTR;
}


/**
 * TRCEVENTCTL0R - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCEVENTCTL0R(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || !(iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7)) & UINT32_C(0xf0000)/*NUMRSPAIR*/))
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,8,0),
                                     "TRCEVENTCTL0R",
                                     puDst,
                                     uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,8,0), "TRCEVENTCTL0R", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR) && AArch64.TRCIDR4.NUMRSPAIR != '0000'))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCEVENTCTL0R;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCEVENTCTL0R;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCEVENTCTL0R;
}


/**
 * TRCIDR0 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1000', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,8,7));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,8,7));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR0;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR0;
}


/**
 * TRCEVENTCTL1R - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCEVENTCTL1R(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,9,0),
                                     "TRCEVENTCTL1R",
                                     puDst,
                                     uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,9,0), "TRCEVENTCTL1R", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCEVENTCTL1R;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCEVENTCTL1R;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCEVENTCTL1R;
}


/**
 * TRCIDR1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0000', 'CRm': '1001', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCIDR1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,9,7));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,9,7));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCIDR1;
}


/**
 * TRCOSLSR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0001', 'CRm': '0001', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCOSLSR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,1,1,4), "TRCOSLSR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,1,1,4), "TRCOSLSR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCOSLSR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCOSLSR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCOSLSR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCOSLSR;
}


/**
 * TRCCIDCCTLR0 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0011', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCCIDCCTLR0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7)) >> 24) & UINT32_C(0xf)/*NUMCIDC*/) <= 0
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,10,7)) >>  5) & UINT32_C(0x1f)/*CIDSIZE*/) <= 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,3,0,2), "TRCCIDCCTLR0", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,3,0,2), "TRCCIDCCTLR0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(   IsFeatureImplemented(FEAT_ETE)
    //     && IsFeatureImplemented(FEAT_TRC_SR)
    //     && UInt(AArch64.TRCIDR4.NUMCIDC) > 0
    //     && UInt(AArch64.TRCIDR2.CIDSIZE) > 0))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCIDCCTLR0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCIDCCTLR0;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCIDCCTLR0;
}


/**
 * TRCCIDCCTLR1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0011', 'CRm': '0001', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCCIDCCTLR1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7)) >> 24) & UINT32_C(0xf)/*NUMCIDC*/) <= 4
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,10,7)) >>  5) & UINT32_C(0x1f)/*CIDSIZE*/) <= 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,3,1,2), "TRCCIDCCTLR1", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,3,1,2), "TRCCIDCCTLR1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(   IsFeatureImplemented(FEAT_ETE)
    //     && IsFeatureImplemented(FEAT_TRC_SR)
    //     && UInt(AArch64.TRCIDR4.NUMCIDC) > 4
    //     && UInt(AArch64.TRCIDR2.CIDSIZE) > 0))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCIDCCTLR1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCIDCCTLR1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCIDCCTLR1;
}


/**
 * TRCVMIDCCTLR0 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0011', 'CRm': '0010', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCVMIDCCTLR0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7)) >> 28) & UINT32_C(0xf)/*NUMVMIDC*/) <= 0
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,10,7)) >> 10) & UINT32_C(0x1f)/*VMIDSIZE*/) <= 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,3,2,2),
                                     "TRCVMIDCCTLR0",
                                     puDst,
                                     uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,3,2,2), "TRCVMIDCCTLR0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(   IsFeatureImplemented(FEAT_ETE)
    //     && IsFeatureImplemented(FEAT_TRC_SR)
    //     && UInt(AArch64.TRCIDR4.NUMVMIDC) > 0
    //     && UInt(AArch64.TRCIDR2.VMIDSIZE) > 0))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVMIDCCTLR0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVMIDCCTLR0;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVMIDCCTLR0;
}


/**
 * TRCVMIDCCTLR1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0011', 'CRm': '0011', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCVMIDCCTLR1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (   !pGstFeats->fEte
        || !pGstFeats->fTrcSr
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,12,7)) >> 28) & UINT32_C(0xf)/*NUMVMIDC*/) <= 4
        || ((iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,0,10,7)) >> 10) & UINT32_C(0x1f)/*VMIDSIZE*/) <= 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,3,3,2),
                                     "TRCVMIDCCTLR1",
                                     puDst,
                                     uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,3,3,2), "TRCVMIDCCTLR1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(   IsFeatureImplemented(FEAT_ETE)
    //     && IsFeatureImplemented(FEAT_TRC_SR)
    //     && UInt(AArch64.TRCIDR4.NUMVMIDC) > 4
    //     && UInt(AArch64.TRCIDR2.VMIDSIZE) > 0))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVMIDCCTLR1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVMIDCCTLR1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCVMIDCCTLR1;
}


/**
 * TRCAUTHSTATUS - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0111', 'CRm': '1110', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCAUTHSTATUS(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,14,6),
                                     "TRCAUTHSTATUS",
                                     puDst,
                                     uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,14,6), "TRCAUTHSTATUS", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCAUTHSTATUS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCAUTHSTATUS;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCAUTHSTATUS;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCAUTHSTATUS;
}


/**
 * TRCDEVARCH - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0111', 'CRm': '1111', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCDEVARCH(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,15,6));
    }
    else
    {
        if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,15,6));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCDEVARCH;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCDEVARCH;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCDEVARCH;
}


/**
 * TRCDEVID - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0111', 'CRm': '0010', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCDEVID(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,2,7), "TRCDEVID", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,2,7), "TRCDEVID", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCID == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCDEVID;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCDEVID;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCDEVID;
}


/**
 * TRCCLAIMSET - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0111', 'CRm': '1000', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCCLAIMSET(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,8,6), "TRCCLAIMSET", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,8,6), "TRCCLAIMSET", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCCLAIM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCLAIMSET;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCLAIMSET;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCLAIMSET;
}


/**
 * TRCCLAIMCLR - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '0111', 'CRm': '1001', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCCLAIMCLR(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(28)/*TTA*/)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,9,6), "TRCCLAIMCLR", puDst, uInstrEssence);
    }
    if (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(20)/*TTA*/)
        return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,7,9,6), "TRCCLAIMCLR", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ETE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.TTA == '1')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRCCLAIM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCLAIMCLR;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TTA == '1')
    //         Undefined()
    //     else if (AArch64.CPTR_EL2.TTA == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TTA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCLAIMCLR;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.TTA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRCCLAIMCLR;
}


/**
 * BRBCR_EL1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '1001', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_BRBCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fBrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x8e0, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,0,0), "BRBCR_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,4,9,0,0), "BRBCR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,0,0), "BRBCR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_BRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.nBRBCTL == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x8e0>;
    //     else
    //         X<t,0x40> = BRBCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = BRBCR_EL2;
    //     else
    //         X<t,0x40> = BRBCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = BRBCR_EL1;
}


/**
 * BRBFCR_EL1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '1001', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_BRBFCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fBrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,0,1), "BRBFCR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,0,1), "BRBFCR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_BRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.nBRBCTL == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBFCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBFCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = BRBFCR_EL1;
}


/**
 * BRBTS_EL1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '1001', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_BRBTS_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fBrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,0,2), "BRBTS_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,0,2), "BRBTS_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_BRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.nBRBDATA == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBTS_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBTS_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = BRBTS_EL1;
}


/**
 * BRBINFINJ_EL1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '1001', 'CRm': '0001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_BRBINFINJ_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fBrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,1,0),
                                     "BRBINFINJ_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,1,0), "BRBINFINJ_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_BRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.nBRBDATA == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBINFINJ_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBINFINJ_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = BRBINFINJ_EL1;
}


/**
 * BRBSRCINJ_EL1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '1001', 'CRm': '0001', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_BRBSRCINJ_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fBrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,1,1),
                                     "BRBSRCINJ_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,1,1), "BRBSRCINJ_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_BRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.nBRBDATA == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBSRCINJ_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBSRCINJ_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = BRBSRCINJ_EL1;
}


/**
 * BRBTGTINJ_EL1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '1001', 'CRm': '0001', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_BRBTGTINJ_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fBrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,1,2),
                                     "BRBTGTINJ_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,1,2), "BRBTGTINJ_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_BRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.nBRBDATA == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBTGTINJ_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBTGTINJ_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = BRBTGTINJ_EL1;
}


/**
 * BRBIDR0_EL1 - OrderedDict({'op0': '10', 'op1': '001', 'CRn': '1001', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_BRBIDR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fBrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,2,0), "BRBIDR0_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,2,0), "BRBIDR0_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_BRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.nBRBIDR == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBIDR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBIDR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = BRBIDR0_EL1;
}


/**
 * MDCCSR_EL0 - OrderedDict({'op0': '10', 'op1': '011', 'CRn': '0000', 'CRm': '0001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MDCCSR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pVCpu->cpum.GstCtx.Mdscr.u64 & RT_BIT_32(12)/*TDCC*/)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(27)/*TDCC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
                || (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/)))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,3,0,1,0), "MDCCSR_EL0", puDst, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(27)/*TDCC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,3,0,1,0), "MDCCSR_EL0", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,3,0,1,0), "MDCCSR_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (Halted() && ConstrainUnpredictableBool(Unpredictable_IGNORETRAPINDEBUG))
    //     X<t,0x40> = MDCCSR_EL0;
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (AArch64.MDSCR_EL1.TDCC == '1')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.HCR_EL2.TGE == '1' || (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDCCSR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (EL2Enabled() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL2.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDCCSR_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MDCCSR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MDCCSR_EL0;
}


/**
 * DBGDTR_EL0 - OrderedDict({'op0': '10', 'op1': '011', 'CRn': '0000', 'CRm': '0100', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_DBGDTR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pVCpu->cpum.GstCtx.Mdscr.u64 & RT_BIT_32(12)/*TDCC*/)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(27)/*TDCC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
                || (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/)))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplHlpReadDbgDtrEl0U64(pVCpu, puDst);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(27)/*TDCC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplHlpReadDbgDtrEl0U64(pVCpu, puDst);
    }
    return iemCImplHlpReadDbgDtrEl0U64(pVCpu, puDst);
    /* -------- Original code specification: -------- */
    // if (Halted())
    //     X<t,0x40> = Read_DBGDTR_EL0(0x40);
    // else if (PSTATE.EL == EL0)
    //     if (AArch64.MDSCR_EL1.TDCC == '1')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.HCR_EL2.TGE == '1' || (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = Read_DBGDTR_EL0(0x40);
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL2.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = Read_DBGDTR_EL0(0x40);
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = Read_DBGDTR_EL0(0x40);
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = Read_DBGDTR_EL0(0x40);
}


/**
 * DBGDTRRX_EL0 - OrderedDict({'op0': '10', 'op1': '011', 'CRn': '0000', 'CRm': '0101', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_DBGDTRRX_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pVCpu->cpum.GstCtx.Mdscr.u64 & RT_BIT_32(12)/*TDCC*/)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(27)/*TDCC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
                || (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/)))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplHlpReadDbgDtrEl0U32(pVCpu, puDst);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(27)/*TDCC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & UINT64_C(0x300) /*TDE,TDA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplHlpReadDbgDtrEl0U32(pVCpu, puDst);
    }
    return iemCImplHlpReadDbgDtrEl0U32(pVCpu, puDst);
    /* -------- Original code specification: -------- */
    // if (Halted())
    //     X<t,0x20> = Read_DBGDTR_EL0(0x20);
    // else if (PSTATE.EL == EL0)
    //     if (AArch64.MDSCR_EL1.TDCC == '1')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.HCR_EL2.TGE == '1' || (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x20> = Read_DBGDTR_EL0(0x20);
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL2.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (AArch64.MDCR_EL2.TDE):(AArch64.MDCR_EL2.TDA) != '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x20> = Read_DBGDTR_EL0(0x20);
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && IsFeatureImplemented(FEAT_FGT) && AArch64.MDCR_EL3.TDCC == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x20> = Read_DBGDTR_EL0(0x20);
    // else if (PSTATE.EL == EL3)
    //     X<t,0x20> = Read_DBGDTR_EL0(0x20);
}


/**
 * SPMCR_EL0 - OrderedDict({'op0': '10', 'op1': '011', 'CRn': '1001', 'CRm': '1100', 'op2': '000'})
 * Transformation status: 33 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMCR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (!(pVCpu->cpum.GstCtx.Mdscr.u64 & RT_BIT_64(34)/*EnSPM*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMCR_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMCR_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMCR_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (AArch64.MDSCR_EL1.EnSPM == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   !ELIsInHost(EL0)
    //              &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMCR_EL0 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMCR_EL0 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMCR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMCNTENSET_EL0 - OrderedDict({'op0': '10', 'op1': '011', 'CRn': '1001', 'CRm': '1100', 'op2': '001'})
 * Transformation status: 33 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMCNTENSET_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (!(pVCpu->cpum.GstCtx.Mdscr.u64 & RT_BIT_64(34)/*EnSPM*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMCNTENSET_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMCNTENSET_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMCNTENSET_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (AArch64.MDSCR_EL1.EnSPM == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   !ELIsInHost(EL0)
    //              &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMCNTEN == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCNTENSET_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMCNTEN == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCNTENSET_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCNTENSET_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMCNTENSET_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMCNTENCLR_EL0 - OrderedDict({'op0': '10', 'op1': '011', 'CRn': '1001', 'CRm': '1100', 'op2': '010'})
 * Transformation status: 33 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMCNTENCLR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (!(pVCpu->cpum.GstCtx.Mdscr.u64 & RT_BIT_64(34)/*EnSPM*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMCNTENCLR_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMCNTENCLR_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMCNTENCLR_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (AArch64.MDSCR_EL1.EnSPM == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   !ELIsInHost(EL0)
    //              &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMCNTEN == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCNTENCLR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMCNTEN == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCNTENCLR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMCNTENCLR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMCNTENCLR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMOVSCLR_EL0 - OrderedDict({'op0': '10', 'op1': '011', 'CRn': '1001', 'CRm': '1100', 'op2': '011'})
 * Transformation status: 33 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMOVSCLR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (!(pVCpu->cpum.GstCtx.Mdscr.u64 & RT_BIT_64(34)/*EnSPM*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMOVSCLR_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMOVSCLR_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMOVSCLR_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (AArch64.MDSCR_EL1.EnSPM == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   !ELIsInHost(EL0)
    //              &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMOVS == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMOVSCLR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMOVS == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMOVSCLR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMOVSCLR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMOVSCLR_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMSELR_EL0 - OrderedDict({'op0': '10', 'op1': '011', 'CRn': '1001', 'CRm': '1100', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMSELR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (!(pVCpu->cpum.GstCtx.Mdscr.u64 & RT_BIT_64(34)/*EnSPM*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,3,9,12,5), "SPMSELR_EL0", puDst, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,3,9,12,5), "SPMSELR_EL0", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,3,9,12,5), "SPMSELR_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (AArch64.MDSCR_EL1.EnSPM == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMSELR_EL0 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMSELR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMSELR_EL0 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMSELR_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMSELR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMSELR_EL0;
}


/**
 * SPMOVSSET_EL0 - OrderedDict({'op0': '10', 'op1': '011', 'CRn': '1001', 'CRm': '1110', 'op2': '011'})
 * Transformation status: 33 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMOVSSET_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (!(pVCpu->cpum.GstCtx.Mdscr.u64 & RT_BIT_64(34)/*EnSPM*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMOVSSET_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(15)/*EnSPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
               == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = SPMOVSSET_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    }
    else
        *puDst = SPMOVSSET_EL0<UInt(AArch64.SPMSELR_EL0.SYSPMUSEL)>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (AArch64.MDSCR_EL1.EnSPM == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   !ELIsInHost(EL0)
    //              &&    (AArch64.SPMACCESSR_EL1)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMOVS == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMOVSSET_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMOVS == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMOVSSET_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMOVSSET_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMOVSSET_EL0<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * DBGVCR32_EL2 - OrderedDict({'op0': '10', 'op1': '100', 'CRn': '0000', 'CRm': '0111', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_DBGVCR32_EL2(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAa32El1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 1) == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseUndefined(pVCpu);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,4,0,7,0), "DBGVCR32_EL2", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!HaveAArch32EL(EL1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EffectiveHCR_EL2_NVx() IN ('xx1'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TDA == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TDA == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = DBGVCR32_EL2;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = DBGVCR32_EL2;
}


/**
 * BRBCR_EL2 - OrderedDict({'op0': '10', 'op1': '100', 'CRn': '1001', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_BRBCR_EL2(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fBrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 1) == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseUndefined(pVCpu);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,4,9,0,0), "BRBCR_EL2", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_BRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EffectiveHCR_EL2_NVx() IN ('xx1'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = BRBCR_EL2;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = BRBCR_EL2;
}


/**
 * SPMACCESSR_EL2 - OrderedDict({'op0': '10', 'op1': '100', 'CRn': '1001', 'CRm': '1101', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMACCESSR_EL2(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 1) == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseUndefined(pVCpu);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,4,9,13,3), "SPMACCESSR_EL2", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EffectiveHCR_EL2_NVx() IN ('xx1'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMACCESSR_EL2;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMACCESSR_EL2;
}


/**
 * BRBCR_EL12 - OrderedDict({'op0': '10', 'op1': '101', 'CRn': '1001', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_BRBCR_EL12(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fBrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x8e0, puDst);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 1) == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseUndefined(pVCpu);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(2,1,9,0,0), "BRBCR_EL1", puDst, uInstrEssence);
    return iemRaiseUndefined(pVCpu);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_BRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EffectiveHCR_EL2_NVx() == '101')
    //         X<t,0x40> = NVMem<0x8e0>;
    //     else if (EffectiveHCR_EL2_NVx() IN ('xx1'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //             Undefined()
    //         else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //             Undefined()
    //         else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE != '11' && AArch64.SCR_EL3.NS == '0')
    //             if (EL3SDDUndef())
    //                 Undefined()
    //             else
    //                 AArch64_SystemAccessTrap(EL3, 0x18)
    //         else if (HaveEL(EL3) && AArch64.MDCR_EL3.SBRBE IN 'x0' && AArch64.SCR_EL3.NS == '1')
    //             if (EL3SDDUndef())
    //                 Undefined()
    //             else
    //                 AArch64_SystemAccessTrap(EL3, 0x18)
    //         else
    //             X<t,0x40> = BRBCR_EL1;
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL3)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = BRBCR_EL1;
    //     else
    //         Undefined()
}


/**
 * SPMACCESSR_EL12 - OrderedDict({'op0': '10', 'op1': '101', 'CRn': '1001', 'CRm': '1101', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMACCESSR_EL12(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpmu)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x8e8, puDst);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 1) == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseUndefined(pVCpu);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(2,0,9,13,3),
                                     "SPMACCESSR_EL1",
                                     puDst,
                                     uInstrEssence);
    return iemRaiseUndefined(pVCpu);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EffectiveHCR_EL2_NVx() == '101')
    //         X<t,0x40> = NVMem<0x8e8>;
    //     else if (EffectiveHCR_EL2_NVx() IN ('xx1'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //             Undefined()
    //         else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //             if (EL3SDDUndef())
    //                 Undefined()
    //             else
    //                 AArch64_SystemAccessTrap(EL3, 0x18)
    //         else
    //             X<t,0x40> = SPMACCESSR_EL1;
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL3)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = SPMACCESSR_EL1;
    //     else
    //         Undefined()
}


/**
 * SPMACCESSR_EL3 - OrderedDict({'op0': '10', 'op1': '110', 'CRn': '1001', 'CRm': '1101', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMACCESSR_EL3(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    RT_NOREF(puDst);
    return iemRaiseUndefined(pVCpu);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPMU))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     Undefined()
    // else if (PSTATE.EL == EL2)
    //     Undefined()
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMACCESSR_EL3;
}


/**
 * SPMROOTCR_EL3 - OrderedDict({'op0': '10', 'op1': '110', 'CRn': '1001', 'CRm': '1110', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMROOTCR_EL3(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    RT_NOREF(puDst);
    return iemRaiseUndefined(pVCpu);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_RME) && IsFeatureImplemented(FEAT_SPMU)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     Undefined()
    // else if (PSTATE.EL == EL2)
    //     Undefined()
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMROOTCR_EL3<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * SPMSCR_EL1 - OrderedDict({'op0': '10', 'op1': '111', 'CRn': '1001', 'CRm': '1110', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPMSCR_EL1(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    RT_NOREF(puDst);
    return iemRaiseUndefined(pVCpu);
    /* -------- Original code specification: -------- */
    // if (!(HaveELUsingSecurityState(EL1, true) && IsFeatureImplemented(FEAT_SPMU)))
    //     Undefined()
    // else if (IsCurrentSecurityState(SS_NonSecure) || (IsFeatureImplemented(FEAT_RME) && IsCurrentSecurityState(SS_Realm)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nSPMSCR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.EnSPM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              &&    (AArch64.SPMACCESSR_EL2)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMSCR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              &&    (AArch64.SPMACCESSR_EL3)<[UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2 + 2 - 1:UInt(AArch64.SPMSELR_EL0.SYSPMUSEL) * 2]>
    //                 == '00')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SPMSCR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPMSCR_EL1<UInt(SPMSELR_EL0.SYSPMUSEL)>;
}


/**
 * MIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2)
            *puDst = pVCpu->cpum.GstCtx.VPidrEl2.u64;
        else
            *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,0,0));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,0,0));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.MIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled())
    //         X<t,0x40> = VPIDR_EL2;
    //     else
    //         X<t,0x40> = MIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = MIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MIDR_EL1;
}


/**
 * MPIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0000', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MPIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2)
            *puDst = pVCpu->cpum.GstCtx.VMpidrEl2.u64;
        else
            *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,0,5));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,0,5));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.MPIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled())
    //         X<t,0x40> = VMPIDR_EL2;
    //     else
    //         X<t,0x40> = MPIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = MPIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MPIDR_EL1;
}


/**
 * REVIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0000', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_REVIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(16)/*TID1*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,0,6));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,0,6));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TID1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.REVIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = REVIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = REVIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = REVIDR_EL1;
}


/**
 * ID_PFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_PFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,0));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,0));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_PFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_PFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_PFR0_EL1;
}


/**
 * ID_PFR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0001', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_PFR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,1));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,1));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_PFR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_PFR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_PFR1_EL1;
}


/**
 * ID_DFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0001', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_DFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,2));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,2));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_DFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_DFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_DFR0_EL1;
}


/**
 * ID_AFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0001', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,3));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,3));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AFR0_EL1;
}


/**
 * ID_MMFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0001', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_MMFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,4));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,4));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_MMFR0_EL1;
}


/**
 * ID_MMFR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0001', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_MMFR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,5));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,5));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_MMFR1_EL1;
}


/**
 * ID_MMFR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0001', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_MMFR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,6));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,6));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_MMFR2_EL1;
}


/**
 * ID_MMFR3_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0001', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_MMFR3_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,7));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,1,7));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR3_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR3_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_MMFR3_EL1;
}


/**
 * ID_ISAR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_ISAR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,0));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,0));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_ISAR0_EL1;
}


/**
 * ID_ISAR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_ISAR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,1));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,1));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_ISAR1_EL1;
}


/**
 * ID_ISAR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_ISAR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,2));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,2));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_ISAR2_EL1;
}


/**
 * ID_ISAR3_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_ISAR3_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,3));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,3));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR3_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR3_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_ISAR3_EL1;
}


/**
 * ID_ISAR4_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_ISAR4_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,4));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,4));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR4_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR4_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_ISAR4_EL1;
}


/**
 * ID_ISAR5_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_ISAR5_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,5));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,5));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR5_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR5_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_ISAR5_EL1;
}


/**
 * ID_MMFR4_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_MMFR4_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,6));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,6));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_MMFR4_EL1)
    //                  || ImpDefBool("ID_MMFR4_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR4_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR4_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_MMFR4_EL1;
}


/**
 * ID_ISAR6_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0010', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_ISAR6_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,7));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,2,7));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_ISAR6_EL1)
    //                  || ImpDefBool("ID_ISAR6_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR6_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_ISAR6_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_ISAR6_EL1;
}


/**
 * MVFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0011', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MVFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,0));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,0));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MVFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MVFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MVFR0_EL1;
}


/**
 * MVFR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0011', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MVFR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,1));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,1));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MVFR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MVFR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MVFR1_EL1;
}


/**
 * MVFR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0011', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MVFR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,2));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,2));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MVFR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MVFR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MVFR2_EL1;
}


/**
 * ID_PFR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0011', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_PFR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,4));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,4));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_PFR2_EL1)
    //                  || ImpDefBool("ID_PFR2_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_PFR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_PFR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_PFR2_EL1;
}


/**
 * ID_DFR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0011', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_DFR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,5));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,5));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_DFR1_EL1)
    //                  || ImpDefBool("ID_DFR1_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_DFR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_DFR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_DFR1_EL1;
}


/**
 * ID_MMFR5_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0011', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_MMFR5_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,6));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,3,6));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_MMFR5_EL1)
    //                  || ImpDefBool("ID_MMFR5_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR5_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_MMFR5_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_MMFR5_EL1;
}


/**
 * ID_AA64PFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0100', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64PFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,0));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,0));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64PFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64PFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64PFR0_EL1;
}


/**
 * ID_AA64PFR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0100', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64PFR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,1));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,1));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64PFR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64PFR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64PFR1_EL1;
}


/**
 * ID_AA64PFR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0100', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64PFR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,2));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,2));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64PFR2_EL1)
    //                  || ImpDefBool("ID_AA64PFR2_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64PFR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64PFR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64PFR2_EL1;
}


/**
 * ID_AA64ZFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0100', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64ZFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,4));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,4));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64ZFR0_EL1)
    //                  || ImpDefBool("ID_AA64ZFR0_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ZFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ZFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64ZFR0_EL1;
}


/**
 * ID_AA64SMFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0100', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64SMFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,5));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,5));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64SMFR0_EL1)
    //                  || ImpDefBool("ID_AA64SMFR0_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64SMFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64SMFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64SMFR0_EL1;
}


/**
 * ID_AA64FPFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0100', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64FPFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,7));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,4,7));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64FPFR0_EL1)
    //                  || ImpDefBool("ID_AA64FPFR0_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64FPFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64FPFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64FPFR0_EL1;
}


/**
 * ID_AA64DFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0101', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64DFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,0));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,0));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64DFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64DFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64DFR0_EL1;
}


/**
 * ID_AA64DFR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0101', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64DFR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,1));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,1));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64DFR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64DFR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64DFR1_EL1;
}


/**
 * ID_AA64DFR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0101', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64DFR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,2));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,2));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64DFR2_EL1)
    //                  || ImpDefBool("ID_AA64DFR2_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64DFR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64DFR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64DFR2_EL1;
}


/**
 * ID_AA64AFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0101', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64AFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,4));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,4));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64AFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64AFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64AFR0_EL1;
}


/**
 * ID_AA64AFR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0101', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64AFR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,5));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,5,5));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64AFR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64AFR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64AFR1_EL1;
}


/**
 * ID_AA64ISAR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0110', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64ISAR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,6,0));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,6,0));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ISAR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ISAR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64ISAR0_EL1;
}


/**
 * ID_AA64ISAR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0110', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64ISAR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,6,1));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,6,1));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ISAR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ISAR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64ISAR1_EL1;
}


/**
 * ID_AA64ISAR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0110', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64ISAR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,6,2));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,6,2));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64ISAR2_EL1)
    //                  || ImpDefBool("ID_AA64ISAR2_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ISAR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ISAR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64ISAR2_EL1;
}


/**
 * ID_AA64ISAR3_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0110', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64ISAR3_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,6,3));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,6,3));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64ISAR3_EL1)
    //                  || ImpDefBool("ID_AA64ISAR3_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ISAR3_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64ISAR3_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64ISAR3_EL1;
}


/**
 * ID_AA64MMFR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0111', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64MMFR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,0));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,0));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64MMFR0_EL1;
}


/**
 * ID_AA64MMFR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0111', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64MMFR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,1));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,1));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64MMFR1_EL1;
}


/**
 * ID_AA64MMFR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0111', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64MMFR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,2));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,2));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64MMFR2_EL1)
    //                  || ImpDefBool("ID_AA64MMFR2_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64MMFR2_EL1;
}


/**
 * ID_AA64MMFR3_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0111', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64MMFR3_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,3));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,3));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64MMFR3_EL1)
    //                  || ImpDefBool("ID_AA64MMFR3_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR3_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR3_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64MMFR3_EL1;
}


/**
 * ID_AA64MMFR4_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0000', 'CRm': '0111', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ID_AA64MMFR4_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(18)/*TID3*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,4));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,0,7,4));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && (   IsFeatureImplemented(FEAT_FGT)
    //                  || !IsZero(AArch64.ID_AA64MMFR4_EL1)
    //                  || ImpDefBool("ID_AA64MMFR4_EL1 trapped by HCR_EL2.TID3"))
    //              && AArch64.HCR_EL2.TID3 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR4_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID3 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ID_AA64MMFR4_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ID_AA64MMFR4_EL1;
}


/**
 * SCTLR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SCTLR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x110, puDst);
        *puDst = pVCpu->cpum.GstCtx.Sctlr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.SctlrEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Sctlr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.SCTLR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x110>;
    //     else
    //         X<t,0x40> = SCTLR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = SCTLR_EL2;
    //     else
    //         X<t,0x40> = SCTLR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SCTLR_EL1;
}


/**
 * ACTLR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ACTLR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(21)/*TACR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x118, puDst);
        *puDst = pVCpu->cpum.GstCtx.Actlr.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Actlr.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TACR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EffectiveHCR_EL2_NVx() IN ('1x1')
    //              && (!ImpDefBool("IMPLEMENTED_ACTLR_ELx accessor behavior") || EffectiveHCR_EL2_NVx() == '111'))
    //         X<t,0x40> = NVMem<0x118>;
    //     else
    //         X<t,0x40> = ACTLR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ImpDefBool("IMPLEMENTED_ACTLR_ELx accessor behavior") && ELIsInHost(EL2))
    //         X<t,0x40> = ACTLR_EL2;
    //     else
    //         X<t,0x40> = ACTLR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ACTLR_EL1;
}


/**
 * CPACR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CPACR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(31)/*TCPAC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x100, puDst);
        *puDst = pVCpu->cpum.GstCtx.Cpacr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.CptrEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Cpacr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TCPAC == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TCPAC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.CPACR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TCPAC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x100>;
    //     else
    //         X<t,0x40> = CPACR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TCPAC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TCPAC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = CPTR_EL2;
    //     else
    //         X<t,0x40> = CPACR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CPACR_EL1;
}


/**
 * SCTLR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0000', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SCTLR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSctlr2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x278, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,0,3), "SCTLR2_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,1,0,3), "SCTLR2_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,0,3), "SCTLR2_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SCTLR2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SCTLR2En == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.SCTLR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.SCTLR2En == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SCTLR2En == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x278>;
    //     else
    //         X<t,0x40> = SCTLR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SCTLR2En == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SCTLR2En == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = SCTLR2_EL2;
    //     else
    //         X<t,0x40> = SCTLR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SCTLR2_EL1;
}


/**
 * RGSR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0000', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_RGSR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMte2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(56)/*ATA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,0,5), "RGSR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,0,5), "RGSR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MTE2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ATA == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.ATA == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ATA == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = RGSR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ATA == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ATA == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = RGSR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = RGSR_EL1;
}


/**
 * GCR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0000', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_GCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMte2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(56)/*ATA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,0,6), "GCR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,0,6), "GCR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MTE2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ATA == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.ATA == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ATA == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = GCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ATA == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ATA == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = GCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = GCR_EL1;
}


/**
 * ZCR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ZCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSve)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if ((((pVCpu->cpum.GstCtx.Cpacr.u64 >> 16) & UINT32_C(0x3)/*ZEN*/) & 1) == 0)
            return iemRaiseSystemAccessTrapSve(pVCpu, 1);
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(8)/*TZ*/))
            return iemRaiseSystemAccessTrapSve(pVCpu, 2);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (((pVCpu->cpum.GstCtx.CptrEl2.u64 >> 16) & UINT32_C(0x3)/*ZEN*/) & 1) == 0)
            return iemRaiseSystemAccessTrapSve(pVCpu, 2);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x1e0, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,0), "ZCR_EL1", puDst, uInstrEssence);
    }
    if (   (!pGstFeats->fVhe || !pGstFeats->fEl2 || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(8)/*TZ*/))
        return iemRaiseSystemAccessTrapSve(pVCpu, 2);
    if (   pGstFeats->fVhe
        && pGstFeats->fEl2
        && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
        && (((pVCpu->cpum.GstCtx.CptrEl2.u64 >> 16) & UINT32_C(0x3)/*ZEN*/) & 1) == 0)
        return iemRaiseSystemAccessTrapSve(pVCpu, 2);
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,1,2,0), "ZCR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,0), "ZCR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SVE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.EZ == '0')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.ZEN IN 'x0')
    //         AArch64_SystemAccessTrap(EL1, 0x19)
    //     else if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CPTR_EL2.TZ == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x19)
    //     else if (ELIsInHost(EL2) && AArch64.CPTR_EL2.ZEN IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x19)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.EZ == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x19)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x1e0>;
    //     else
    //         X<t,0x40> = ZCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.EZ == '0')
    //         Undefined()
    //     else if (!ELIsInHost(EL2) && AArch64.CPTR_EL2.TZ == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x19)
    //     else if (ELIsInHost(EL2) && AArch64.CPTR_EL2.ZEN IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x19)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.EZ == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x19)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = ZCR_EL2;
    //     else
    //         X<t,0x40> = ZCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.EZ == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x19)
    //     else
    //         X<t,0x40> = ZCR_EL1;
}


/**
 * TRFCR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0010', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRFCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTrf)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(19)/*TTRF*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x880, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,1), "TRFCR_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,1,2,1), "TRFCR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,1), "TRFCR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TRF))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TTRF == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TTRF == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TTRF == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x880>;
    //     else
    //         X<t,0x40> = TRFCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TTRF == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TTRF == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = TRFCR_EL2;
    //     else
    //         X<t,0x40> = TRFCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TRFCR_EL1;
}


/**
 * TRCITECR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0010', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRCITECR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fIte || !pGstFeats->fTrcSr)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x888, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,3), "TRCITECR_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,1,2,3), "TRCITECR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,3), "TRCITECR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_ITE) && IsFeatureImplemented(FEAT_TRC_SR)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnITE == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nTRCITECR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnITE == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x888>;
    //     else
    //         X<t,0x40> = TRCITECR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnITE == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnITE == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = TRCITECR_EL2;
    //     else
    //         X<t,0x40> = TRCITECR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TRCITECR_EL1;
}


/**
 * SMPRI_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0010', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SMPRI_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSme)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,4), "SMPRI_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,4), "SMPRI_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SME))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.ESM == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nSMPRI_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.ESM == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SMPRI_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.ESM == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.ESM == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SMPRI_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.ESM == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SMPRI_EL1;
}


/**
 * SMCR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0010', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SMCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSme)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if ((((pVCpu->cpum.GstCtx.Cpacr.u64 >> 24) & UINT32_C(0x3)/*SMEN*/) & 1) == 0)
            return iemRaiseSystemAccessTrapSme(pVCpu, 1);
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(12)/*TSM*/))
            return iemRaiseSystemAccessTrapSme(pVCpu, 2);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (((pVCpu->cpum.GstCtx.CptrEl2.u64 >> 24) & UINT32_C(0x3)/*SMEN*/) & 1) == 0)
            return iemRaiseSystemAccessTrapSme(pVCpu, 2);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x1f0, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,6), "SMCR_EL1", puDst, uInstrEssence);
    }
    if (   (!pGstFeats->fVhe || !pGstFeats->fEl2 || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(12)/*TSM*/))
        return iemRaiseSystemAccessTrapSme(pVCpu, 2);
    if (   pGstFeats->fVhe
        && pGstFeats->fEl2
        && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
        && (((pVCpu->cpum.GstCtx.CptrEl2.u64 >> 24) & UINT32_C(0x3)/*SMEN*/) & 1) == 0)
        return iemRaiseSystemAccessTrapSme(pVCpu, 2);
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,1,2,6), "SMCR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,2,6), "SMCR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SME))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.ESM == '0')
    //         Undefined()
    //     else if (AArch64.CPACR_EL1.SMEN IN 'x0')
    //         AArch64_SystemAccessTrap(EL1, 0x1d)
    //     else if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CPTR_EL2.TSM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x1d)
    //     else if (ELIsInHost(EL2) && AArch64.CPTR_EL2.SMEN IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x1d)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.ESM == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x1d)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x1f0>;
    //     else
    //         X<t,0x40> = SMCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.ESM == '0')
    //         Undefined()
    //     else if (!ELIsInHost(EL2) && AArch64.CPTR_EL2.TSM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x1d)
    //     else if (ELIsInHost(EL2) && AArch64.CPTR_EL2.SMEN IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x1d)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.ESM == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x1d)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = SMCR_EL2;
    //     else
    //         X<t,0x40> = SMCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.CPTR_EL3.ESM == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x1d)
    //     else
    //         X<t,0x40> = SMCR_EL1;
}


/**
 * SCTLRMASK_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0100', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SCTLRMASK_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSrMask)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x318, puDst);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,4,0),
                                     "SCTLRMASK_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,1,4,0),
                                     "SCTLRMASK_EL2",
                                     puDst,
                                     uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,4,0), "SCTLRMASK_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SRMASK))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nSCTLRMASK_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.SRMASKEn == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x318>;
    //     else
    //         X<t,0x40> = SCTLRMASK_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = SCTLRMASK_EL2;
    //     else
    //         X<t,0x40> = SCTLRMASK_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SCTLRMASK_EL1;
}


/**
 * ACTLRMASK_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0100', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ACTLRMASK_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSrMask)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x340, puDst);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,4,1),
                                     "ACTLRMASK_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,4,1), "ACTLRMASK_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SRMASK))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nACTLRMASK_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.SRMASKEn == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   EffectiveHCR_EL2_NVx() IN ('1x1')
    //              && (!ImpDefBool("IMPLEMENTED_ACTLR_ELx accessor behavior") || EffectiveHCR_EL2_NVx() == '111'))
    //         X<t,0x40> = NVMem<0x340>;
    //     else
    //         X<t,0x40> = ACTLRMASK_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ImpDefBool("IMPLEMENTED_ACTLR_ELx accessor behavior") && ELIsInHost(EL2))
    //         X<t,0x40> = ACTLRMASK_EL2;
    //     else
    //         X<t,0x40> = ACTLRMASK_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ACTLRMASK_EL1;
}


/**
 * CPACRMASK_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0100', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CPACRMASK_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSrMask)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x320, puDst);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,4,2),
                                     "CPACRMASK_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,1,4,2), "CPTRMASK_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,4,2), "CPACRMASK_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SRMASK))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nCPACRMASK_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.SRMASKEn == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x320>;
    //     else
    //         X<t,0x40> = CPACRMASK_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = CPTRMASK_EL2;
    //     else
    //         X<t,0x40> = CPACRMASK_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CPACRMASK_EL1;
}


/**
 * SCTLR2MASK_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0100', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SCTLR2MASK_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSrMask)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x328, puDst);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,4,3),
                                     "SCTLR2MASK_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,1,4,3),
                                     "SCTLR2MASK_EL2",
                                     puDst,
                                     uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,4,3), "SCTLR2MASK_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SRMASK))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nSCTLR2MASK_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.SRMASKEn == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x328>;
    //     else
    //         X<t,0x40> = SCTLR2MASK_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = SCTLR2MASK_EL2;
    //     else
    //         X<t,0x40> = SCTLR2MASK_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SCTLR2MASK_EL1;
}


/**
 * CPACRALIAS_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0100', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CPACRALIAS_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(31)/*TCPAC*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x100, puDst);
        *puDst = pVCpu->cpum.GstCtx.Cpacr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.CptrEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Cpacr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TCPAC == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TCPAC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nCPACRALIAS_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TCPAC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x100>;
    //     else
    //         X<t,0x40> = CPACR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TCPAC == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TCPAC == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = CPTR_EL2;
    //     else
    //         X<t,0x40> = CPACR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CPACR_EL1;
}


/**
 * ACTLRALIAS_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0100', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ACTLRALIAS_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(21)/*TACR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x118, puDst);
        *puDst = pVCpu->cpum.GstCtx.Actlr.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Actlr.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TACR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nACTLRALIAS_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EffectiveHCR_EL2_NVx() IN ('1x1')
    //              && (!ImpDefBool("IMPLEMENTED_ACTLR_ELx accessor behavior") || EffectiveHCR_EL2_NVx() == '111'))
    //         X<t,0x40> = NVMem<0x118>;
    //     else
    //         X<t,0x40> = ACTLR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ImpDefBool("IMPLEMENTED_ACTLR_ELx accessor behavior") && ELIsInHost(EL2))
    //         X<t,0x40> = ACTLR_EL2;
    //     else
    //         X<t,0x40> = ACTLR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ACTLR_EL1;
}


/**
 * SCTLRALIAS_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0100', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SCTLRALIAS_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x110, puDst);
        *puDst = pVCpu->cpum.GstCtx.Sctlr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.SctlrEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Sctlr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nSCTLRALIAS_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x110>;
    //     else
    //         X<t,0x40> = SCTLR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = SCTLR_EL2;
    //     else
    //         X<t,0x40> = SCTLR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SCTLR_EL1;
}


/**
 * SCTLR2ALIAS_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0001', 'CRm': '0100', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SCTLR2ALIAS_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSctlr2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x278, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,0,3), "SCTLR2_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,1,0,3), "SCTLR2_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,1,0,3), "SCTLR2_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SCTLR2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SCTLR2En == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nSCTLRALIAS2_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.SCTLR2En == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SCTLR2En == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x278>;
    //     else
    //         X<t,0x40> = SCTLR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SCTLR2En == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SCTLR2En == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = SCTLR2_EL2;
    //     else
    //         X<t,0x40> = SCTLR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SCTLR2_EL1;
}


/**
 * MAIR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MAIR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x140, puDst);
        *puDst = pVCpu->cpum.GstCtx.Mair.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.MairEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Mair.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.MAIR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x140>;
    //     else
    //         X<t,0x40> = MAIR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = MAIR_EL2;
    //     else
    //         X<t,0x40> = MAIR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MAIR_EL1;
}


/**
 * MAIR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0010', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MAIR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAie)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x280, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,1), "MAIR2_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,10,1,1), "MAIR2_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,1), "MAIR2_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AIE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.AIEn == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nMAIR2_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.AIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x280>;
    //     else
    //         X<t,0x40> = MAIR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.AIEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.AIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = MAIR2_EL2;
    //     else
    //         X<t,0x40> = MAIR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MAIR2_EL1;
}


/**
 * PIRE0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0010', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PIRE0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fS1Pie)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x290, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,2), "PIRE0_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,10,2,2), "PIRE0_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,2), "PIRE0_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_S1PIE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nPIRE0_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x290>;
    //     else
    //         X<t,0x40> = PIRE0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = PIRE0_EL2;
    //     else
    //         X<t,0x40> = PIRE0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PIRE0_EL1;
}


/**
 * PIR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0010', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PIR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fS1Pie)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x2a0, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,3), "PIR_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,10,2,3), "PIR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,3), "PIR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_S1PIE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nPIR_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x2a0>;
    //     else
    //         X<t,0x40> = PIR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = PIR_EL2;
    //     else
    //         X<t,0x40> = PIR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PIR_EL1;
}


/**
 * POR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0010', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_POR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fS1Poe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x2a8, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,4), "POR_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,10,2,4), "POR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,4), "POR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_S1POE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nPOR_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x2a8>;
    //     else
    //         X<t,0x40> = POR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = POR_EL2;
    //     else
    //         X<t,0x40> = POR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = POR_EL1;
}


/**
 * S2POR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0010', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_S2POR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fS2Poe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x2b8, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,5), "S2POR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,2,5), "S2POR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_S2POE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nS2POR_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x2b8>;
    //     else
    //         X<t,0x40> = S2POR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = S2POR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = S2POR_EL1;
}


/**
 * AMAIR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0011', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMAIR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x148, puDst);
        *puDst = pVCpu->cpum.GstCtx.Amair.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,10,3,0),
                                         "AMAIR_EL2",
                                         puDst,
                                         uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Amair.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.AMAIR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x148>;
    //     else
    //         X<t,0x40> = AMAIR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = AMAIR_EL2;
    //     else
    //         X<t,0x40> = AMAIR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMAIR_EL1;
}


/**
 * AMAIR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0011', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMAIR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAie)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x288, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,3,1), "AMAIR2_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,10,3,1), "AMAIR2_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,3,1), "AMAIR2_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AIE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.AIEn == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nAMAIR2_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.AIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x288>;
    //     else
    //         X<t,0x40> = AMAIR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.AIEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.AIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = AMAIR2_EL2;
    //     else
    //         X<t,0x40> = AMAIR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMAIR2_EL1;
}


/**
 * LORSA_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0100', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_LORSA_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fLor)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(35)/*TLOR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,0), "LORSA_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,0), "LORSA_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_LOR))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TLOR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.LORSA_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LORSA_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LORSA_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else
    //         X<t,0x40> = LORSA_EL1;
}


/**
 * LOREA_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0100', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_LOREA_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fLor)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(35)/*TLOR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,1), "LOREA_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,1), "LOREA_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_LOR))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TLOR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.LOREA_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LOREA_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LOREA_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else
    //         X<t,0x40> = LOREA_EL1;
}


/**
 * LORN_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0100', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_LORN_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fLor)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(35)/*TLOR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,2), "LORN_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,2), "LORN_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_LOR))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TLOR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.LORN_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LORN_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LORN_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else
    //         X<t,0x40> = LORN_EL1;
}


/**
 * LORC_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0100', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_LORC_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fLor)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(35)/*TLOR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,3), "LORC_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,3), "LORC_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_LOR))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TLOR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.LORC_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LORC_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LORC_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.SCR_EL3.NS == '0')
    //         Undefined()
    //     else
    //         X<t,0x40> = LORC_EL1;
}


/**
 * MPAMIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0100', 'op2': '100'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MPAMIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMpam)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && AArch64.MPAMIDR_EL1.HAS_HCR == 1 && AArch64.MPAMHCR_EL2.TRAP_MPAMIDR_EL1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.MPAMIDR_EL1.HAS_TIDR == 1 && AArch64.MPAM2_EL2.TIDR == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,4), "MPAMIDR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,4), "MPAMIDR_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MPAM))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EL2Enabled() && AArch64.MPAMIDR_EL1.HAS_HCR == '1' && AArch64.MPAMHCR_EL2.TRAP_MPAMIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MPAMIDR_EL1.HAS_TIDR == '1' && AArch64.MPAM2_EL2.TIDR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = MPAMIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MPAMIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MPAMIDR_EL1;
}


/**
 * MPAMBWIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0100', 'op2': '101'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MPAMBWIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMpamPeBwCtrl)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && AArch64.MPAMBW2_EL2.nTRAP_MPAMBWIDR_EL1 == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,5));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,5));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MPAM_PE_BW_CTRL))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EL2Enabled() && AArch64.MPAMBW2_EL2.nTRAP_MPAMBWIDR_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = MPAMBWIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MPAMBWIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MPAMBWIDR_EL1;
}


/**
 * LORID_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0100', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_LORID_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fLor)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(35)/*TLOR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,7), "LORID_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,4,7), "LORID_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_LOR))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TLOR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.LORID_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LORID_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TLOR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TLOR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = LORID_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = LORID_EL1;
}


/**
 * MPAM1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0101', 'op2': '000'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MPAM1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMpam)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && AArch64.MPAM2_EL2.TRAPMPAM1EL1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x900, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,0), "MPAM1_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,10,5,0), "MPAM2_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,0), "MPAM1_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MPAM))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EL2Enabled() && AArch64.MPAM2_EL2.TRAPMPAM1EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x900>;
    //     else
    //         X<t,0x40> = MPAM1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = MPAM2_EL2;
    //     else
    //         X<t,0x40> = MPAM1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MPAM1_EL1;
}


/**
 * MPAM0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0101', 'op2': '001'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MPAM0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMpam)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && AArch64.MPAM2_EL2.TRAPMPAM0EL1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,1), "MPAM0_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,1), "MPAM0_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MPAM))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EL2Enabled() && AArch64.MPAM2_EL2.TRAPMPAM0EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = MPAM0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MPAM0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MPAM0_EL1;
}


/**
 * MPAMSM_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0101', 'op2': '011'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MPAMSM_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMpam || !pGstFeats->fSme)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && AArch64.MPAM2_EL2.EnMPAMSM == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,3), "MPAMSM_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,3), "MPAMSM_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_MPAM) && IsFeatureImplemented(FEAT_SME)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EL2Enabled() && AArch64.MPAM2_EL2.EnMPAMSM == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = MPAMSM_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MPAMSM_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MPAMSM_EL1;
}


/**
 * MPAMBW1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0101', 'op2': '100'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MPAMBW1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMpamPeBwCtrl)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && AArch64.MPAMBW2_EL2.nTRAP_MPAMBW1_EL1 == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x908, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,4), "MPAMBW1_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,10,5,4), "MPAMBW2_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,4), "MPAMBW1_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MPAM_PE_BW_CTRL))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EL2Enabled() && AArch64.MPAMBW2_EL2.nTRAP_MPAMBW1_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x908>;
    //     else
    //         X<t,0x40> = MPAMBW1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = MPAMBW2_EL2;
    //     else
    //         X<t,0x40> = MPAMBW1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MPAMBW1_EL1;
}


/**
 * MPAMBW0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0101', 'op2': '101'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MPAMBW0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMpamPeBwCtrl)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && AArch64.MPAMBW2_EL2.nTRAP_MPAMBW0_EL1 == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,5), "MPAMBW0_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,5), "MPAMBW0_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MPAM_PE_BW_CTRL))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EL2Enabled() && AArch64.MPAMBW2_EL2.nTRAP_MPAMBW0_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = MPAMBW0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MPAMBW0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MPAMBW0_EL1;
}


/**
 * MPAMBWSM_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1010', 'CRm': '0101', 'op2': '111'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_MPAMBWSM_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMpamPeBwCtrl || !pGstFeats->fSme)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && AArch64.MPAMBW2_EL2.nTRAP_MPAMBWSM_EL1 == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,7),
                                     "MPAMBWSM_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,10,5,7), "MPAMBWSM_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_MPAM_PE_BW_CTRL) && IsFeatureImplemented(FEAT_SME)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EL2Enabled() && AArch64.MPAMBW2_EL2.nTRAP_MPAMBWSM_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = MPAMBWSM_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MPAM3_EL3.TRAPLOWER == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MPAMBW3_EL3.nTRAPLOWER == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = MPAMBWSM_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = MPAMBWSM_EL1;
}


/**
 * VBAR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_VBAR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 3)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x250, puDst);
        *puDst = pVCpu->cpum.GstCtx.VBar.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.VBarEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.VBar.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EffectiveHCR_EL2_NVx() == '011')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.VBAR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x250>;
    //     else
    //         X<t,0x40> = VBAR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = VBAR_EL2;
    //     else
    //         X<t,0x40> = VBAR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = VBAR_EL1;
}


/**
 * RVBAR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_RVBAR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (pGstFeats->fEl2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1 && !pGstFeats->fEl2)
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,0,1), "RVBAR_EL1", puDst, uInstrEssence);
    return iemRaiseUndefined(pVCpu);
    /* -------- Original code specification: -------- */
    // if (!IsHighestEL(EL1))
    //     Undefined()
    // else if (PSTATE.EL == EL1 && IsHighestEL(EL1))
    //     X<t,0x40> = RVBAR_EL1;
    // else
    //     Undefined()
}


/**
 * RMR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_RMR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (pGstFeats->fEl2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1 && !pGstFeats->fEl2)
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,0,2), "RMR_EL1", puDst, uInstrEssence);
    return iemRaiseUndefined(pVCpu);
    /* -------- Original code specification: -------- */
    // if (!IsHighestEL(EL1))
    //     Undefined()
    // else if (PSTATE.EL == EL1 && IsHighestEL(EL1))
    //     X<t,0x40> = RMR_EL1;
    // else
    //     Undefined()
}


/**
 * ISR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '0001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ISR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,1,0), "ISR_EL1", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,1,0), "ISR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.ISR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = ISR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = ISR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ISR_EL1;
}


/**
 * DISR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '0001', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_DISR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRas)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !!(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(5)/*AMO*/))
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,12,1,1),
                                         "VDISR_EL2",
                                         puDst,
                                         uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,1,1), "DISR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,1,1), "DISR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RAS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && (   AArch64.HCR_EL2.AMO == '1'
    //             || (IsFeatureImplemented(FEAT_DoubleFault2) && IsHCRXEL2Enabled() && AArch64.HCRX_EL2.TMEA == '1')))
    //         X<t,0x40> = VDISR_EL2;
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_E3DSE) && AArch64.SCR_EL3.EnDSE == '1')
    //         X<t,0x40> = VDISR_EL3;
    //     else if (HaveEL(EL3) && !Halted() && AArch64.SCR_EL3.EA == '1')
    //         X<t,0x40> = Zeros(0x40);
    //     else
    //         X<t,0x40> = DISR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && IsFeatureImplemented(FEAT_E3DSE) && AArch64.SCR_EL3.EnDSE == '1')
    //         X<t,0x40> = VDISR_EL3;
    //     else if (HaveEL(EL3) && !Halted() && AArch64.SCR_EL3.EA == '1')
    //         X<t,0x40> = Zeros(0x40);
    //     else
    //         X<t,0x40> = DISR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = DISR_EL1;
}


/**
 * ICC_RPR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1011', 'op2': '011'})
 * Transformation status: 5 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_RPR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TC == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(3)/*FMO*/))
            *puDst = ICV_RPR_EL1;
        else if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(4)/*IMO*/))
            *puDst = ICV_RPR_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,11,3),
                                         "ICC_RPR_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,11,3),
                                     "ICC_RPR_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FMO == '1')
    //         X<t,0x40> = ICV_RPR_EL1;
    //     else if (EL2Enabled() && AArch64.HCR_EL2.IMO == '1')
    //         X<t,0x40> = ICV_RPR_EL1;
    //     else if (HaveEL(EL3) && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_RPR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_RPR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_RPR_EL1;
}


/**
 * ICC_IAR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1100', 'op2': '000'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_IAR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TALL1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(4)/*IMO*/))
            *puDst = ICV_IAR1_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,0),
                                         "ICC_IAR1_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,0),
                                     "ICC_IAR1_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TALL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.IMO == '1')
    //         X<t,0x40> = ICV_IAR1_EL1;
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_IAR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_IAR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_IAR1_EL1;
}


/**
 * ICC_HPPIR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1100', 'op2': '010'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_HPPIR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TALL1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(4)/*IMO*/))
            *puDst = ICV_HPPIR1_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,2),
                                         "ICC_HPPIR1_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,2),
                                     "ICC_HPPIR1_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TALL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.IMO == '1')
    //         X<t,0x40> = ICV_HPPIR1_EL1;
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_HPPIR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_HPPIR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_HPPIR1_EL1;
}


/**
 * ICC_BPR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1100', 'op2': '011'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_BPR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TALL1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(4)/*IMO*/))
            *puDst = ICV_BPR1_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,3),
                                         "ICC_BPR1_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,3),
                                     "ICC_BPR1_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TALL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.IMO == '1')
    //         X<t,0x40> = ICV_BPR1_EL1;
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3))
    //         if (AArch64.SCR_EL3.NS == '0')
    //             X<t,0x40> = ICC_BPR1_EL1_S;
    //         else
    //             X<t,0x40> = ICC_BPR1_EL1_NS;
    //     else
    //         X<t,0x40> = ICC_BPR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3))
    //         if (AArch64.SCR_EL3.NS == '0')
    //             X<t,0x40> = ICC_BPR1_EL1_S;
    //         else
    //             X<t,0x40> = ICC_BPR1_EL1_NS;
    //     else
    //         X<t,0x40> = ICC_BPR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (AArch64.SCR_EL3.NS == '0')
    //         X<t,0x40> = ICC_BPR1_EL1_S;
    //     else
    //         X<t,0x40> = ICC_BPR1_EL1_NS;
}


/**
 * ICC_CTLR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1100', 'op2': '100'})
 * Transformation status: 5 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_CTLR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TC == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(3)/*FMO*/))
            *puDst = ICV_CTLR_EL1;
        else if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(4)/*IMO*/))
            *puDst = ICV_CTLR_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,4),
                                         "ICC_CTLR_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,4),
                                     "ICC_CTLR_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FMO == '1')
    //         X<t,0x40> = ICV_CTLR_EL1;
    //     else if (EL2Enabled() && AArch64.HCR_EL2.IMO == '1')
    //         X<t,0x40> = ICV_CTLR_EL1;
    //     else if (HaveEL(EL3) && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3))
    //         if (AArch64.SCR_EL3.NS == '0')
    //             X<t,0x40> = ICC_CTLR_EL1_S;
    //         else
    //             X<t,0x40> = ICC_CTLR_EL1_NS;
    //     else
    //         X<t,0x40> = ICC_CTLR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3))
    //         if (AArch64.SCR_EL3.NS == '0')
    //             X<t,0x40> = ICC_CTLR_EL1_S;
    //         else
    //             X<t,0x40> = ICC_CTLR_EL1_NS;
    //     else
    //         X<t,0x40> = ICC_CTLR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (AArch64.SCR_EL3.NS == '0')
    //         X<t,0x40> = ICC_CTLR_EL1_S;
    //     else
    //         X<t,0x40> = ICC_CTLR_EL1_NS;
}


/**
 * ICC_SRE_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1100', 'op2': '101'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_SRE_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && AArch64.ICC_SRE_EL2.Enable == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,5),
                                     "ICC_SRE_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,5), "ICC_SRE_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.ICC_SRE_EL3.Enable == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.ICC_SRE_EL2.Enable == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.ICC_SRE_EL3.Enable == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3))
    //         if (AArch64.SCR_EL3.NS == '0')
    //             X<t,0x40> = ICC_SRE_EL1_S;
    //         else
    //             X<t,0x40> = ICC_SRE_EL1_NS;
    //     else
    //         X<t,0x40> = ICC_SRE_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.ICC_SRE_EL3.Enable == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.ICC_SRE_EL3.Enable == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3))
    //         if (AArch64.SCR_EL3.NS == '0')
    //             X<t,0x40> = ICC_SRE_EL1_S;
    //         else
    //             X<t,0x40> = ICC_SRE_EL1_NS;
    //     else
    //         X<t,0x40> = ICC_SRE_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.SCR_EL3.NS == '0')
    //         X<t,0x40> = ICC_SRE_EL1_S;
    //     else
    //         X<t,0x40> = ICC_SRE_EL1_NS;
}


/**
 * ICC_IGRPEN0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1100', 'op2': '110'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_IGRPEN0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TALL0 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(3)/*FMO*/))
            *puDst = ICV_IGRPEN0_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,6),
                                         "ICC_IGRPEN0_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,6),
                                     "ICC_IGRPEN0_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ICC_IGRPENn_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TALL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FMO == '1')
    //         X<t,0x40> = ICV_IGRPEN0_EL1;
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_IGRPEN0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_IGRPEN0_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_IGRPEN0_EL1;
}


/**
 * ICC_IGRPEN1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1100', 'op2': '111'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_IGRPEN1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TALL1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(4)/*IMO*/))
            *puDst = ICV_IGRPEN1_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,7),
                                         "ICC_IGRPEN1_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,12,7),
                                     "ICC_IGRPEN1_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ICC_IGRPENn_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TALL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.IMO == '1')
    //         X<t,0x40> = ICV_IGRPEN1_EL1;
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3))
    //         if (AArch64.SCR_EL3.NS == '0')
    //             X<t,0x40> = ICC_IGRPEN1_EL1_S;
    //         else
    //             X<t,0x40> = ICC_IGRPEN1_EL1_NS;
    //     else
    //         X<t,0x40> = ICC_IGRPEN1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3))
    //         if (AArch64.SCR_EL3.NS == '0')
    //             X<t,0x40> = ICC_IGRPEN1_EL1_S;
    //         else
    //             X<t,0x40> = ICC_IGRPEN1_EL1_NS;
    //     else
    //         X<t,0x40> = ICC_IGRPEN1_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (AArch64.SCR_EL3.NS == '0')
    //         X<t,0x40> = ICC_IGRPEN1_EL1_S;
    //     else
    //         X<t,0x40> = ICC_IGRPEN1_EL1_NS;
}


/**
 * ICC_IAR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1000', 'op2': '000'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_IAR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TALL0 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(3)/*FMO*/))
            *puDst = ICV_IAR0_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,8,0),
                                         "ICC_IAR0_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,8,0),
                                     "ICC_IAR0_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TALL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FMO == '1')
    //         X<t,0x40> = ICV_IAR0_EL1;
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_IAR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_IAR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_IAR0_EL1;
}


/**
 * ICC_HPPIR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1000', 'op2': '010'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_HPPIR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TALL0 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(3)/*FMO*/))
            *puDst = ICV_HPPIR0_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,8,2),
                                         "ICC_HPPIR0_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,8,2),
                                     "ICC_HPPIR0_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TALL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FMO == '1')
    //         X<t,0x40> = ICV_HPPIR0_EL1;
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_HPPIR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_HPPIR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_HPPIR0_EL1;
}


/**
 * ICC_BPR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1000', 'op2': '011'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_BPR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TALL0 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(3)/*FMO*/))
            *puDst = ICV_BPR0_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,8,3),
                                         "ICC_BPR0_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,8,3),
                                     "ICC_BPR0_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TALL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FMO == '1')
    //         X<t,0x40> = ICV_BPR0_EL1;
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_BPR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_BPR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_BPR0_EL1;
}


/**
 * ICC_NMIAR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1100', 'CRm': '1001', 'op2': '101'})
 * Transformation status: 4 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_NMIAR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3Nmi)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (!(pVCpu->cpum.GstCtx.Sctlr.u64 & RT_BIT_64(61)/*NMI*/))
            return iemRaiseUndefined(pVCpu);
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TALL1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(4)/*IMO*/))
            *puDst = ICV_NMIAR1_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,9,5),
                                         "ICC_NMIAR1_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (!(pVCpu->cpum.GstCtx.SctlrEl2.u64 & RT_BIT_64(61)/*NMI*/))
            return iemRaiseUndefined(pVCpu);
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,12,9,5),
                                     "ICC_NMIAR1_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3_NMI))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (AArch64.SCTLR_EL1.NMI == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TALL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.IMO == '1')
    //         X<t,0x40> = ICV_NMIAR1_EL1;
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_NMIAR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (AArch64.SCTLR_EL2.NMI == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.IRQ == '1')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.IRQ == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_NMIAR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.SCTLR_EL3.NMI == '0')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_NMIAR1_EL1;
}


/**
 * CONTEXTIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1101', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CONTEXTIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x108, puDst);
        *puDst = pVCpu->cpum.GstCtx.ContextIdr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,13,0,1),
                                         "CONTEXTIDR_EL2",
                                         puDst,
                                         uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.ContextIdr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.CONTEXTIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x108>;
    //     else
    //         X<t,0x40> = CONTEXTIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = CONTEXTIDR_EL2;
    //     else
    //         X<t,0x40> = CONTEXTIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CONTEXTIDR_EL1;
}


/**
 * RCWSMASK_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1101', 'CRm': '0000', 'op2': '011'})
 * Transformation status: 3 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_RCWSMASK_EL1(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fThe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    *puDst = RCWSMASK_EL1<[0x3f:0]>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_THE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.RCWMASKEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nRCWSMASK_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.RCWMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = RCWSMASK_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.RCWMASKEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.RCWMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = RCWSMASK_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = RCWSMASK_EL1<[0x3f:0]>;
}


/**
 * TPIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1101', 'CRm': '0000', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TPIDR_EL1(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
        *puDst = pVCpu->cpum.GstCtx.aTpIdr[1].u64;
    else
        *puDst = pVCpu->cpum.GstCtx.aTpIdr[1].u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.TPIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = TPIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = TPIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TPIDR_EL1;
}


/**
 * ACCDATA_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1101', 'CRm': '0000', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ACCDATA_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fLs64Accdata)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,13,0,5), "ACCDATA_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,13,0,5), "ACCDATA_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_LS64_ACCDATA))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ADEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nACCDATA_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ADEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ACCDATA_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ADEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ADEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ACCDATA_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ACCDATA_EL1;
}


/**
 * RCWMASK_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1101', 'CRm': '0000', 'op2': '110'})
 * Transformation status: 6 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_RCWMASK_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fThe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = RCWMASK_EL1<[0x3f:0]>;
    }
    else
        *puDst = RCWMASK_EL1<[0x3f:0]>;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_THE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.RCWMASKEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nRCWMASK_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.RCWMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = RCWMASK_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.RCWMASKEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.RCWMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = RCWMASK_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = RCWMASK_EL1<[0x3f:0]>;
}


/**
 * SCXTNUM_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1101', 'CRm': '0000', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SCXTNUM_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fCvs2_2 && !pGstFeats->fCsv21p2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 3)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(53)/*EnSCXT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x188, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,13,0,7), "SCXTNUM_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,13,0,7), "SCXTNUM_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,13,0,7), "SCXTNUM_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_CSV2_2) || IsFeatureImplemented(FEAT_CSV2_1p2)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.EnSCXT == '0')
    //         Undefined()
    //     else if (EffectiveHCR_EL2_NVx() == '011')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.EnSCXT == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.SCXTNUM_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.EnSCXT == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x188>;
    //     else
    //         X<t,0x40> = SCXTNUM_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.EnSCXT == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.EnSCXT == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = SCXTNUM_EL2;
    //     else
    //         X<t,0x40> = SCXTNUM_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SCXTNUM_EL1;
}


/**
 * CNTKCTL_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1110', 'CRm': '0001', 'op2': '000'})
 * Transformation status: 2 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTKCTL_EL1(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
        *puDst = pVCpu->cpum.GstCtx.CntKCtl.u64;
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = CNTHCTL_EL2_VHE(CNTHCTL_EL2);
        else
            *puDst = pVCpu->cpum.GstCtx.CntKCtl.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     X<t,0x40> = CNTKCTL_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = CNTHCTL_EL2_VHE(CNTHCTL_EL2);
    //     else
    //         X<t,0x40> = CNTKCTL_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CNTKCTL_EL1;
}


/**
 * TTBR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TTBR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x200, puDst);
        *puDst = pVCpu->cpum.GstCtx.Ttbr0.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.Ttbr0El2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Ttbr0.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.TTBR0_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x200>;
    //     else
    //         X<t,0x40> = TTBR0_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = TTBR0_EL2<[0x3f:0]>;
    //     else
    //         X<t,0x40> = TTBR0_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TTBR0_EL1<[0x3f:0]>;
}


/**
 * TTBR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TTBR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x210, puDst);
        *puDst = pVCpu->cpum.GstCtx.Ttbr1.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.Ttbr1El2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Ttbr1.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.TTBR1_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x210>;
    //     else
    //         X<t,0x40> = TTBR1_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = TTBR1_EL2<[0x3f:0]>;
    //     else
    //         X<t,0x40> = TTBR1_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TTBR1_EL1<[0x3f:0]>;
}


/**
 * TCR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x120, puDst);
        *puDst = pVCpu->cpum.GstCtx.Tcr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.TcrEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Tcr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.TCR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x120>;
    //     else
    //         X<t,0x40> = TCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = TCR_EL2;
    //     else
    //         X<t,0x40> = TCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TCR_EL1;
}


/**
 * TCR2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0000', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TCR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTcr2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x270, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,0,3), "TCR2_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,2,0,3), "TCR2_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,0,3), "TCR2_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TCR2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TCR2En == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.TCR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.TCR2En == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TCR2En == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x270>;
    //     else
    //         X<t,0x40> = TCR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TCR2En == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TCR2En == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = TCR2_EL2;
    //     else
    //         X<t,0x40> = TCR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TCR2_EL1;
}


/**
 * APIAKeyLo_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APIAKeyLo_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apia.Low.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apia.Low.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APIAKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APIAKeyLo_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APIAKeyLo_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APIAKeyLo_EL1;
}


/**
 * APIAKeyHi_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0001', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APIAKeyHi_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apia.High.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apia.High.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APIAKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APIAKeyHi_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APIAKeyHi_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APIAKeyHi_EL1;
}


/**
 * APIBKeyLo_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0001', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APIBKeyLo_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apib.Low.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apib.Low.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APIBKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APIBKeyLo_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APIBKeyLo_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APIBKeyLo_EL1;
}


/**
 * APIBKeyHi_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0001', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APIBKeyHi_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apib.High.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apib.High.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APIBKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APIBKeyHi_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APIBKeyHi_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APIBKeyHi_EL1;
}


/**
 * APDAKeyLo_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APDAKeyLo_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apda.Low.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apda.Low.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APDAKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APDAKeyLo_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APDAKeyLo_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APDAKeyLo_EL1;
}


/**
 * APDAKeyHi_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0010', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APDAKeyHi_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apda.High.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apda.High.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APDAKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APDAKeyHi_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APDAKeyHi_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APDAKeyHi_EL1;
}


/**
 * APDBKeyLo_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0010', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APDBKeyLo_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apdb.Low.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apdb.Low.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APDBKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APDBKeyLo_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APDBKeyLo_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APDBKeyLo_EL1;
}


/**
 * APDBKeyHi_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0010', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APDBKeyHi_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apdb.High.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apdb.High.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APDBKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APDBKeyHi_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APDBKeyHi_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APDBKeyHi_EL1;
}


/**
 * APGAKeyLo_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0011', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APGAKeyLo_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apga.Low.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apga.Low.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APGAKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APGAKeyLo_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APGAKeyLo_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APGAKeyLo_EL1;
}


/**
 * APGAKeyHi_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0011', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_APGAKeyHi_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPAuth)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(40)/*APK*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Apga.High.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Apga.High.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAuth))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.APK == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.APGAKey == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APGAKeyHi_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.APK == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.APK == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = APGAKeyHi_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = APGAKeyHi_EL1;
}


/**
 * GCSCR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0101', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_GCSCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGcs)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x8d0, puDst);
        *puDst = 0;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = 0;
        else
            *puDst = 0;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GCS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.GCSEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nGCS_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.GCSEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x8d0>;
    //     else
    //         X<t,0x40> = GCSCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.GCSEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.GCSEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = GCSCR_EL2;
    //     else
    //         X<t,0x40> = GCSCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = GCSCR_EL1;
}


/**
 * GCSPR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0101', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_GCSPR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGcs)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x8c0, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,5,1), "GCSPR_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,2,5,1), "GCSPR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,5,1), "GCSPR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GCS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.GCSEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nGCS_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.GCSEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x8c0>;
    //     else
    //         X<t,0x40> = GCSPR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.GCSEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.GCSEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = GCSPR_EL2;
    //     else
    //         X<t,0x40> = GCSPR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = GCSPR_EL1;
}


/**
 * GCSCRE0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0101', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_GCSCRE0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGcs)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = 0;
    }
    else
        *puDst = 0;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GCS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.GCSEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nGCS_EL0 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.GCSEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = GCSCRE0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.GCSEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.GCSEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = GCSCRE0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = GCSCRE0_EL1;
}


/**
 * TCRMASK_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0111', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TCRMASK_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSrMask)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x330, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,7,2), "TCRMASK_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,2,7,2), "TCRMASK_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,7,2), "TCRMASK_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SRMASK))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nTCRMASK_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.SRMASKEn == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x330>;
    //     else
    //         X<t,0x40> = TCRMASK_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = TCRMASK_EL2;
    //     else
    //         X<t,0x40> = TCRMASK_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TCRMASK_EL1;
}


/**
 * TCR2MASK_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0111', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TCR2MASK_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSrMask)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x338, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,7,3), "TCR2MASK_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,2,7,3), "TCR2MASK_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,7,3), "TCR2MASK_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SRMASK))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nTCR2MASK_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.SRMASKEn == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x338>;
    //     else
    //         X<t,0x40> = TCR2MASK_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.SRMASKEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.SRMASKEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = TCR2MASK_EL2;
    //     else
    //         X<t,0x40> = TCR2MASK_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TCR2MASK_EL1;
}


/**
 * TCRALIAS_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0111', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TCRALIAS_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x120, puDst);
        *puDst = pVCpu->cpum.GstCtx.Tcr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.TcrEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Tcr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nTCRALIAS_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x120>;
    //     else
    //         X<t,0x40> = TCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = TCR_EL2;
    //     else
    //         X<t,0x40> = TCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TCR_EL1;
}


/**
 * TCR2ALIAS_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0010', 'CRm': '0111', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TCR2ALIAS_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTcr2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x270, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,0,3), "TCR2_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,2,0,3), "TCR2_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,2,0,3), "TCR2_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TCR2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TCR2En == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nTCR2ALIAS_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && (!IsHCRXEL2Enabled() || AArch64.HCRX_EL2.TCR2En == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TCR2En == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x270>;
    //     else
    //         X<t,0x40> = TCR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TCR2En == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TCR2En == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = TCR2_EL2;
    //     else
    //         X<t,0x40> = TCR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TCR2_EL1;
}


/**
 * SPSR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPSR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 3)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x160, puDst);
        *puDst = pVCpu->cpum.GstCtx.Spsr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.SpsrEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Spsr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EffectiveHCR_EL2_NVx() == '011')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x160>;
    //     else
    //         X<t,0x40> = SPSR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = SPSR_EL2;
    //     else
    //         X<t,0x40> = SPSR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SPSR_EL1;
}


/**
 * ELR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ELR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 3)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x230, puDst);
        *puDst = pVCpu->cpum.GstCtx.Elr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.ElrEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Elr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EffectiveHCR_EL2_NVx() == '011')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x230>;
    //     else
    //         X<t,0x40> = ELR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = ELR_EL2;
    //     else
    //         X<t,0x40> = ELR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ELR_EL1;
}


/**
 * SP_EL0 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SP_EL0(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (!(pVCpu->cpum.GstCtx.fPState & UINT64_C(0x1)/*SP*/))
        return iemRaiseUndefined(pVCpu);
    *puDst = pVCpu->cpum.GstCtx.aSpReg[0].u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (PSTATE.SP == '0')
    //         Undefined()
    //     else
    //         X<t,0x40> = SP_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (PSTATE.SP == '0')
    //         Undefined()
    //     else
    //         X<t,0x40> = SP_EL0;
    // else if (PSTATE.EL == EL3)
    //     if (PSTATE.SP == '0')
    //         Undefined()
    //     else
    //         X<t,0x40> = SP_EL0;
}


/**
 * SPSel - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SPSel(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    *puDst = (pVCpu->cpum.GstCtx.fPState & UINT64_C(0x1)/*SP*/);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     X<t,0x40> = (Zeros(0x3f)):(PSTATE.SP);
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = (Zeros(0x3f)):(PSTATE.SP);
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = (Zeros(0x3f)):(PSTATE.SP);
}


/**
 * CurrentEL - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0010', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CurrentEL(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 1) == 1)
            *puDst = 8;
        else
            *puDst = (pVCpu->cpum.GstCtx.fPState & UINT64_C(0xc)/*EL*/);
    }
    else
        *puDst = (pVCpu->cpum.GstCtx.fPState & UINT64_C(0xc)/*EL*/);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EffectiveHCR_EL2_NVx() IN ('xx1'))
    //         X<t,0x40> = (Zeros(0x3c)):('10'):(Zeros(2));
    //     else
    //         X<t,0x40> = (Zeros(0x3c)):(PSTATE.EL):(Zeros(2));
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = (Zeros(0x3c)):(PSTATE.EL):(Zeros(2));
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = (Zeros(0x3c)):(PSTATE.EL):(Zeros(2));
}


/**
 * PAN - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0010', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PAN(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPan)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    *puDst = (pVCpu->cpum.GstCtx.fPState & UINT64_C(0x400000)/*PAN*/);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PAN))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     X<t,0x40> = (Zeros(0x29)):(PSTATE.PAN):(Zeros(0x16));
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = (Zeros(0x29)):(PSTATE.PAN):(Zeros(0x16));
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = (Zeros(0x29)):(PSTATE.PAN):(Zeros(0x16));
}


/**
 * UAO - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0010', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_UAO(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fUao)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    *puDst = (pVCpu->cpum.GstCtx.fPState & UINT64_C(0x800000)/*UAO*/);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_UAO))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     X<t,0x40> = (Zeros(0x28)):(PSTATE.UAO):(Zeros(0x17));
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = (Zeros(0x28)):(PSTATE.UAO):(Zeros(0x17));
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = (Zeros(0x28)):(PSTATE.UAO):(Zeros(0x17));
}


/**
 * ALLINT - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0011', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ALLINT(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fNmi)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    *puDst = (pVCpu->cpum.GstCtx.fPState & UINT64_C(0x2000)/*ALLINT*/);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_NMI))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     X<t,0x40> = (Zeros(0x32)):(PSTATE.ALLINT):(Zeros(0xd));
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = (Zeros(0x32)):(PSTATE.ALLINT):(Zeros(0xd));
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = (Zeros(0x32)):(PSTATE.ALLINT):(Zeros(0xd));
}


/**
 * PM - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0011', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PM(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEbep)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    *puDst = (pVCpu->cpum.GstCtx.fPState & UINT64_C(0x100000000)/*PM*/);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_EBEP))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     X<t,0x40> = (Zeros(0x1f)):(PSTATE.PM):(Zeros(0x20));
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = (Zeros(0x1f)):(PSTATE.PM):(Zeros(0x20));
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = (Zeros(0x1f)):(PSTATE.PM):(Zeros(0x20));
}


/**
 * ICC_PMR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0100', 'CRm': '0110', 'op2': '000'})
 * Transformation status: 5 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ICC_PMR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fGicV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (AArch64.ICC_SRE_EL1.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        if (pGstFeats->fEl2 && AArch64.ICH_HCR_EL2.TC == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(3)/*FMO*/))
            *puDst = ICV_PMR_EL1;
        else if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(4)/*IMO*/))
            *puDst = ICV_PMR_EL1;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,4,6,0),
                                         "ICC_PMR_EL1",
                                         puDst,
                                         uInstrEssence);
    }
    else
    {
        if (AArch64.ICC_SRE_EL2.SRE == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,4,6,0), "ICC_PMR_EL1", puDst, uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_GICv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL1.SRE == '0')
    //         AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.ICH_HCR_EL2.TC == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FMO == '1')
    //         X<t,0x40> = ICV_PMR_EL1;
    //     else if (EL2Enabled() && AArch64.HCR_EL2.IMO == '1')
    //         X<t,0x40> = ICV_PMR_EL1;
    //     else if (HaveEL(EL3) && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_PMR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         Undefined()
    //     else if (AArch64.ICC_SRE_EL2.SRE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && (AArch64.SCR_EL3.IRQ):(AArch64.SCR_EL3.FIQ) == '11')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_PMR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (AArch64.ICC_SRE_EL3.SRE == '0')
    //         AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ICC_PMR_EL1;
}


/**
 * AFSR0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AFSR0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x128, puDst);
        *puDst = pVCpu->cpum.GstCtx.Afsr0.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,5,1,0),
                                         "AFSR0_EL2",
                                         puDst,
                                         uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Afsr0.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.AFSR0_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x128>;
    //     else
    //         X<t,0x40> = AFSR0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = AFSR0_EL2;
    //     else
    //         X<t,0x40> = AFSR0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AFSR0_EL1;
}


/**
 * AFSR1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0001', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AFSR1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x130, puDst);
        *puDst = pVCpu->cpum.GstCtx.Afsr1.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,5,1,1),
                                         "AFSR1_EL2",
                                         puDst,
                                         uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Afsr1.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.AFSR1_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x130>;
    //     else
    //         X<t,0x40> = AFSR1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = AFSR1_EL2;
    //     else
    //         X<t,0x40> = AFSR1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AFSR1_EL1;
}


/**
 * ESR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ESR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x138, puDst);
        *puDst = pVCpu->cpum.GstCtx.Esr.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.EsrEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Esr.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ESR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x138>;
    //     else
    //         X<t,0x40> = ESR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = ESR_EL2;
    //     else
    //         X<t,0x40> = ESR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ESR_EL1;
}


/**
 * ERRIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0011', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERRIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRas)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,3,0));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,3,0));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RAS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERRIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERRIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERRIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERRIDR_EL1;
}


/**
 * ERRSELR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0011', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERRSELR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRas)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,3,1), "ERRSELR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,3,1), "ERRSELR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RAS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERRSELR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERRSELR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERRSELR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERRSELR_EL1;
}


/**
 * ERXGSR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0011', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXGSR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRasV2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,3,2), "ERXGSR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,3,2), "ERXGSR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RASv2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nERXGSR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXGSR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXGSR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXGSR_EL1;
}


/**
 * ERXFR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0100', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXFR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRas)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,0), "ERXFR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,0), "ERXFR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RAS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXFR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXFR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXFR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXFR_EL1;
}


/**
 * ERXCTLR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0100', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXCTLR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRas)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,1), "ERXCTLR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,1), "ERXCTLR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RAS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXCTLR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXCTLR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXCTLR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXCTLR_EL1;
}


/**
 * ERXSTATUS_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0100', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXSTATUS_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRas)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,2),
                                     "ERXSTATUS_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,2), "ERXSTATUS_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RAS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXSTATUS_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXSTATUS_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXSTATUS_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXSTATUS_EL1;
}


/**
 * ERXADDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0100', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXADDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRas)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,3), "ERXADDR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,3), "ERXADDR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RAS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXADDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXADDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXADDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXADDR_EL1;
}


/**
 * ERXPFGF_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0100', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXPFGF_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRasV1p1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(47)/*FIEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,4), "ERXPFGF_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,4), "ERXPFGF_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RASv1p1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIEN == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FIEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXPFGF_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIEN == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXPFGF_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIEN == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIEN == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXPFGF_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXPFGF_EL1;
}


/**
 * ERXPFGCTL_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0100', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXPFGCTL_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRasV1p1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(47)/*FIEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,5),
                                     "ERXPFGCTL_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,5), "ERXPFGCTL_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RASv1p1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIEN == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FIEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXPFGCTL_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIEN == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXPFGCTL_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIEN == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIEN == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXPFGCTL_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXPFGCTL_EL1;
}


/**
 * ERXPFGCDN_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0100', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXPFGCDN_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRasV1p1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(47)/*FIEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,6),
                                     "ERXPFGCDN_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,4,6), "ERXPFGCDN_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RASv1p1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIEN == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.FIEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXPFGCDN_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIEN == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXPFGCDN_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.FIEN == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.FIEN == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXPFGCDN_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXPFGCDN_EL1;
}


/**
 * ERXMISC0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0101', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXMISC0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRas)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,5,0), "ERXMISC0_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,5,0), "ERXMISC0_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RAS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXMISCn_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXMISC0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXMISC0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXMISC0_EL1;
}


/**
 * ERXMISC1_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0101', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXMISC1_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRas)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,5,1), "ERXMISC1_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,5,1), "ERXMISC1_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RAS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXMISCn_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXMISC1_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXMISC1_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXMISC1_EL1;
}


/**
 * ERXMISC2_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0101', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXMISC2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRasV1p1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,5,2), "ERXMISC2_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,5,2), "ERXMISC2_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RASv1p1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXMISCn_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXMISC2_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXMISC2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXMISC2_EL1;
}


/**
 * ERXMISC3_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0101', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_ERXMISC3_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fRasV1p1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(36)/*TERR*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,5,3), "ERXMISC3_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,5,3), "ERXMISC3_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_RASv1p1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TERR == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.ERXMISCn_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXMISC3_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.TERR == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.TERR == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = ERXMISC3_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = ERXMISC3_EL1;
}


/**
 * TFSR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0110', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TFSR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMte2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 3)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(56)/*ATA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x190, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,6,0), "TFSR_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,5,6,0), "TFSR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,6,0), "TFSR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MTE2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ATA == '0')
    //         Undefined()
    //     else if (EffectiveHCR_EL2_NVx() == '011')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.HCR_EL2.ATA == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ATA == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x190>;
    //     else
    //         X<t,0x40> = TFSR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ATA == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ATA == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = TFSR_EL2;
    //     else
    //         X<t,0x40> = TFSR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TFSR_EL1;
}


/**
 * TFSRE0_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0101', 'CRm': '0110', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TFSRE0_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMte2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(56)/*ATA*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,6,1), "TFSRE0_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,5,6,1), "TFSRE0_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MTE2))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ATA == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.ATA == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ATA == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = TFSRE0_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.ATA == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.ATA == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = TFSRE0_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TFSRE0_EL1;
}


/**
 * FAR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0110', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_FAR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x220, puDst);
        *puDst = pVCpu->cpum.GstCtx.Far.u64;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.FarEl2.u64;
        else
            *puDst = pVCpu->cpum.GstCtx.Far.u64;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.FAR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x220>;
    //     else
    //         X<t,0x40> = FAR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2))
    //         X<t,0x40> = FAR_EL2;
    //     else
    //         X<t,0x40> = FAR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = FAR_EL1;
}


/**
 * PFAR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0110', 'CRm': '0000', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PFAR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPfar)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x2d0, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,6,0,5), "PFAR_EL1", puDst, uInstrEssence);
    }
    if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,6,0,5), "PFAR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,6,0,5), "PFAR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PFAR))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PFAREn == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HFGRTR2_EL2.nPFAR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PFAREn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x2d0>;
    //     else
    //         X<t,0x40> = PFAR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PFAREn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PFAREn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = PFAR_EL2;
    //     else
    //         X<t,0x40> = PFAR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PFAR_EL1;
}


/**
 * PAR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '0111', 'CRm': '0100', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PAR_EL1(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
        *puDst = pVCpu->cpum.GstCtx.Par.u64;
    else
        *puDst = pVCpu->cpum.GstCtx.Par.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.PAR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = PAR_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = PAR_EL1<[0x3f:0]>;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PAR_EL1<[0x3f:0]>;
}


/**
 * PMBLIMITR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMBLIMITR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 12) & UINT32_C(0x3)/*E2PB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x800, puDst);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,0),
                                     "PMBLIMITR_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,0), "PMBLIMITR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMBLIMITR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2PB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x800>;
    //     else
    //         X<t,0x40> = PMBLIMITR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMBLIMITR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMBLIMITR_EL1;
}


/**
 * PMBPTR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1010', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMBPTR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 12) & UINT32_C(0x3)/*E2PB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x810, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,1), "PMBPTR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,1), "PMBPTR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMBPTR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2PB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x810>;
    //     else
    //         X<t,0x40> = PMBPTR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMBPTR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMBPTR_EL1;
}


/**
 * PMBSR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1010', 'op2': '011'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMBSR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 12) & UINT32_C(0x3)/*E2PB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x820, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,3), "PMBSR_EL1", puDst, uInstrEssence);
    }
    if (   EffectivePMSCR_EL2_EE() != 0
        && pGstFeats->fVhe
        && pGstFeats->fEl2
        && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,9,10,3), "PMBSR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,3), "PMBSR_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMBSR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2PB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   EffectiveHCR_EL2_NVx() IN ('1x1')
    //              && (EffectivePMSCR_EL2_EE() == '00' || AArch64.PMSCR_EL1.EE == '00' || EffectiveHCR_EL2_NVx() == '111'))
    //         X<t,0x40> = NVMem<0x820>;
    //     else
    //         X<t,0x40> = PMBSR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectivePMSCR_EL2_EE() != '00' && ELIsInHost(EL2))
    //         X<t,0x40> = PMBSR_EL2;
    //     else
    //         X<t,0x40> = PMBSR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMBSR_EL1;
}


/**
 * PMSDSFR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1010', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSDSFR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpeFds)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(14)/*TPMS*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x858, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,4), "PMSDSFR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,4), "PMSDSFR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE_FDS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMS3 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nPMSDSFR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPMS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMS3 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x858>;
    //     else
    //         X<t,0x40> = PMSDSFR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMS3 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMS3 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSDSFR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSDSFR_EL1;
}


/**
 * PMBMAR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1010', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMBMAR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpeNvm)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 12) & UINT32_C(0x3)/*E2PB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,5), "PMBMAR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,5), "PMBMAR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE_nVM))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMS4 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nPMBMAR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2PB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMS4 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMBMAR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMS4 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMS4 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMBMAR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMBMAR_EL1;
}


/**
 * PMBIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1010', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMBIDR_EL1(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,7));
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,10,7));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HDFGRTR_EL2.PMBIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = PMBIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = PMBIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMBIDR_EL1;
}


/**
 * TRBLIMITR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1011', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRBLIMITR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 24) & UINT32_C(0x3)/*E2TB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,0),
                                     "TRBLIMITR_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,0), "TRBLIMITR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRBLIMITR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2TB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBLIMITR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBLIMITR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBLIMITR_EL1;
}


/**
 * TRBPTR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1011', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRBPTR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 24) & UINT32_C(0x3)/*E2TB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,1), "TRBPTR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,1), "TRBPTR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRBPTR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2TB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBPTR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBPTR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBPTR_EL1;
}


/**
 * TRBBASER_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1011', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRBBASER_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 24) & UINT32_C(0x3)/*E2TB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,2),
                                     "TRBBASER_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,2), "TRBBASER_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRBBASER_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2TB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBBASER_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBBASER_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBBASER_EL1;
}


/**
 * TRBSR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1011', 'op2': '011'})
 * Transformation status: 3 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRBSR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 24) & UINT32_C(0x3)/*E2TB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7 && EffectiveTRFCR_EL2_EE() != 0 && AArch64.TRFCR_EL1.EE != 0)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x860, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,3), "TRBSR_EL1", puDst, uInstrEssence);
    }
    if (   EffectiveTRFCR_EL2_EE() != 0
        && pGstFeats->fVhe
        && pGstFeats->fEl2
        && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,9,11,3), "TRBSR_EL2", puDst, uInstrEssence);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,3), "TRBSR_EL1", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRBSR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2TB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111') && EffectiveTRFCR_EL2_EE() != '00' && AArch64.TRFCR_EL1.EE != '00')
    //         X<t,0x40> = NVMem<0x860>;
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBSR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else if (EffectiveTRFCR_EL2_EE() != '00' && ELIsInHost(EL2))
    //         X<t,0x40> = TRBSR_EL2;
    //     else
    //         X<t,0x40> = TRBSR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBSR_EL1;
}


/**
 * TRBMAR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1011', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRBMAR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 24) & UINT32_C(0x3)/*E2TB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,4), "TRBMAR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,4), "TRBMAR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRBMAR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2TB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBMAR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBMAR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBMAR_EL1;
}


/**
 * TRBMPAM_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1011', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRBMPAM_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTrbeMpam)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 24) & UINT32_C(0x3)/*E2TB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,5), "TRBMPAM_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,5), "TRBMPAM_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TRBE_MPAM))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnTB2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && EL3SDDUndefPriority()
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nTRBMPAM_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2TB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnTB2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBMPAM_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnTB2 == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnTB2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBMPAM_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBMPAM_EL1;
}


/**
 * TRBTRG_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1011', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRBTRG_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (((pVCpu->cpum.GstCtx.MdcrEl2.u64 >> 24) & UINT32_C(0x3)/*E2TB*/) & 1) == 0)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,6), "TRBTRG_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,6), "TRBTRG_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.TRBTRG_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.E2TB IN 'x0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBTRG_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //             || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSTB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSTB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSTBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBTRG_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBTRG_EL1;
}


/**
 * TRBIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1011', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TRBIDR_EL1(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fTrbe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,7));
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,11,7));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_TRBE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HDFGRTR_EL2.TRBIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     if (IsFeatureImplemented(FEAT_TRBE_EXT) && AArch64.OSLSR_EL1.OSLK == '0' && HaltingAllowed() && ext.EDSCR2.TTA == '1')
    //         Halt(DebugHalt_SoftwareAccess)
    //     else
    //         X<t,0x40> = TRBIDR_EL1;
}


/**
 * PMSSCR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1101', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSSCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPmuV3Ss)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,13,3), "PMSSCR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PMUv3_SS))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMSS == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nPMSSCR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMSS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSSCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMSS == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMSS == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSSCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSSCR_EL1;
}


/**
 * PMINTENSET_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1110', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMINTENSET_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPmuV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(6)/*TPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,1),
                                     "PMINTENSET_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,1), "PMINTENSET_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PMUv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMINTEN == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMINTENSET_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMINTENSET_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMINTENSET_EL1;
}


/**
 * PMINTENCLR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1110', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMINTENCLR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPmuV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(6)/*TPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,2),
                                     "PMINTENCLR_EL1",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,2), "PMINTENCLR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PMUv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMINTEN == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMINTENCLR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMINTENCLR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMINTENCLR_EL1;
}


/**
 * PMUACR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1110', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMUACR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPmuV3p9)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(6)/*TPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,4), "PMUACR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,4), "PMUACR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PMUv3p9))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nPMUACR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMUACR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMUACR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMUACR_EL1;
}


/**
 * PMECR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1110', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMECR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEbep && !pGstFeats->fPmuV3Ss)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(6)/*TPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,5), "PMECR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,5), "PMECR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_EBEP) || IsFeatureImplemented(FEAT_PMUv3_SS)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nPMECR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMECR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMECR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMECR_EL1;
}


/**
 * PMMIR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1110', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMMIR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPmuV3p4)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(6)/*TPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,6));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,6));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PMUv3p4))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMMIR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMMIR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMMIR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMMIR_EL1;
}


/**
 * PMIAR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1110', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMIAR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSebep)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(6)/*TPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,7), "PMIAR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,14,7), "PMIAR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SEBEP))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT2)
    //              && ((HaveEL(EL3) && AArch64.SCR_EL3.FGTEn2 == '0') || AArch64.HDFGRTR2_EL2.nPMIAR_EL1 == '0'))
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMIAR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPM2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPM2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMIAR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMIAR_EL1;
}


/**
 * PMSCR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1001', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(14)/*TPMS*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x828, puDst);
        *puDst = 0;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,4,9,9,0),
                                         "PMSCR_EL2",
                                         puDst,
                                         uInstrEssence);
        *puDst = 0;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMSCR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPMS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x828>;
    //     else
    //         X<t,0x40> = PMSCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (ELIsInHost(EL2))
    //         X<t,0x40> = PMSCR_EL2;
    //     else
    //         X<t,0x40> = PMSCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSCR_EL1;
}


/**
 * PMSNEVFR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1001', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSNEVFR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpeFnE)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(14)/*TPMS*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x850, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,1), "PMSNEVFR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,1), "PMSNEVFR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE_FnE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMSN == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.nPMSNEVFR_EL1 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPMS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMSN == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x850>;
    //     else
    //         X<t,0x40> = PMSNEVFR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.EnPMSN == '0')
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.EnPMSN == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSNEVFR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSNEVFR_EL1;
}


/**
 * PMSICR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1001', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSICR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(14)/*TPMS*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x838, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,2), "PMSICR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,2), "PMSICR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMSICR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPMS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x838>;
    //     else
    //         X<t,0x40> = PMSICR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSICR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSICR_EL1;
}


/**
 * PMSIRR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1001', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSIRR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(14)/*TPMS*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x840, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,3), "PMSIRR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,3), "PMSIRR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMSIRR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPMS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x840>;
    //     else
    //         X<t,0x40> = PMSIRR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSIRR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSIRR_EL1;
}


/**
 * PMSFCR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1001', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSFCR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(14)/*TPMS*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,4), "PMSFCR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,4), "PMSFCR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMSFCR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPMS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSFCR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSFCR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSFCR_EL1;
}


/**
 * PMSEVFR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1001', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSEVFR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(14)/*TPMS*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x830, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,5), "PMSEVFR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,5), "PMSEVFR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMSEVFR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPMS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x830>;
    //     else
    //         X<t,0x40> = PMSEVFR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSEVFR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSEVFR_EL1;
}


/**
 * PMSLATFR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1001', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSLATFR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(14)/*TPMS*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if ((iemGetEffHcrEl2NVx(pVCpu, pGstFeats) & 5) == 5)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x848, puDst);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,6), "PMSLATFR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,6), "PMSLATFR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMSLATFR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPMS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('1x1'))
    //         X<t,0x40> = NVMem<0x848>;
    //     else
    //         X<t,0x40> = PMSLATFR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSLATFR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSLATFR_EL1;
}


/**
 * PMSIDR_EL1 - OrderedDict({'op0': '11', 'op1': '000', 'CRn': '1001', 'CRm': '1001', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMSIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSpe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(14)/*TPMS*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,7));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,0,9,9,7));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SPE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMSIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPMS == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (   HaveEL(EL3)
    //         && EL3SDDUndefPriority()
    //         && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //             || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //             || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         Undefined()
    //     else if (   HaveEL(EL3)
    //              && (   AArch64.MDCR_EL3.NSPB<0> == '0'
    //                  || AArch64.MDCR_EL3.NSPB<1> != AArch64.SCR_EL3.NS
    //                  || (IsFeatureImplemented(FEAT_RME) && AArch64.MDCR_EL3.NSPBE != AArch64.SCR_EL3.NSE)))
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMSIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMSIDR_EL1;
}


/**
 * CCSIDR_EL1 - OrderedDict({'op0': '11', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CCSIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(17)/*TID2*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fEvt && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(49)/*TID4*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,0), "CCSIDR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,0), "CCSIDR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TID2 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && IsFeatureImplemented(FEAT_EVT) && AArch64.HCR_EL2.TID4 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.CCSIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = CCSIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = CCSIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CCSIDR_EL1;
}


/**
 * CLIDR_EL1 - OrderedDict({'op0': '11', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CLIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(17)/*TID2*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fEvt && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(49)/*TID4*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,1), "CLIDR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,1), "CLIDR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TID2 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && IsFeatureImplemented(FEAT_EVT) && AArch64.HCR_EL2.TID4 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.CLIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = CLIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = CLIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CLIDR_EL1;
}


/**
 * CCSIDR2_EL1 - OrderedDict({'op0': '11', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CCSIDR2_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fCcidx)
        UnimplementedIDRegister()
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(17)/*TID2*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fEvt && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(49)/*TID4*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,2), "CCSIDR2_EL1", puDst, uInstrEssence);
    }
    else
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,2), "CCSIDR2_EL1", puDst, uInstrEssence);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_CCIDX))
    //     UnimplementedIDRegister()
    // else if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TID2 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && IsFeatureImplemented(FEAT_EVT) && AArch64.HCR_EL2.TID4 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = CCSIDR2_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = CCSIDR2_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CCSIDR2_EL1;
}


/**
 * GMID_EL1 - OrderedDict({'op0': '11', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '100'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_GMID_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fMte2)
        UnimplementedIDRegister()
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(58)/*TID5*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,4));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,4));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_MTE2))
    //     UnimplementedIDRegister()
    // else if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID5 == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TID5 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID5 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = GMID_EL1;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID5 == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && IsFeatureImplemented(FEAT_IDTE3) && AArch64.SCR_EL3.TID5 == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = GMID_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = GMID_EL1;
}


/**
 * SMIDR_EL1 - OrderedDict({'op0': '11', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '110'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SMIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSme)
        UnimplementedIDRegister()
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(16)/*TID1*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,6));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,6));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SME))
    //     UnimplementedIDRegister()
    // else if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TID1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = SMIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = SMIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SMIDR_EL1;
}


/**
 * AIDR_EL1 - OrderedDict({'op0': '11', 'op1': '001', 'CRn': '0000', 'CRm': '0000', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AIDR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fIdst)
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        return iemRaiseUndefined(pVCpu);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(16)/*TID1*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,7), "AIDR_EL1", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,1,0,0,7), "AIDR_EL1", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (IsFeatureImplemented(FEAT_IDST))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else
    //         Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TID1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.AIDR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = AIDR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = AIDR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AIDR_EL1;
}


/**
 * CSSELR_EL1 - OrderedDict({'op0': '11', 'op1': '010', 'CRn': '0000', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CSSELR_EL1(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(17)/*TID2*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fEvt && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(49)/*TID4*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = pVCpu->cpum.GstCtx.Csselr.u64;
    }
    else
        *puDst = pVCpu->cpum.GstCtx.Csselr.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     Undefined()
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TID2 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && IsFeatureImplemented(FEAT_EVT) && AArch64.HCR_EL2.TID4 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.CSSELR_EL1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = CSSELR_EL1;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = CSSELR_EL1;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CSSELR_EL1;
}


/**
 * CTR_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '0000', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CTR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.Sctlr.u64 & RT_BIT_32(15)/*UCT*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(17)/*TID2*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.SctlrEl2.u64 & RT_BIT_32(15)/*UCT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,0,0,1));
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(17)/*TID2*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,0,0,1));
    }
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,0,0,1));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && AArch64.SCTLR_EL1.UCT == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL0) && AArch64.HCR_EL2.TID2 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.CTR_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.SCTLR_EL2.UCT == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = CTR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.HCR_EL2.TID2 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.CTR_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = CTR_EL0;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = CTR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CTR_EL0;
}


/**
 * DCZID_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '0000', 'CRm': '0000', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_DCZID_EL0(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,0,0,7));
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,0,0,7));
    else
        *puDst = iemCImplHlpGetIdSysReg(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,0,0,7));
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (   EL2Enabled()
    //         && !ELIsInHost(EL0)
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.DCZID_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = DCZID_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.DCZID_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = DCZID_EL0;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = DCZID_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = DCZID_EL0;
}


/**
 * POR_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1010', 'CRm': '0010', 'op2': '100'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_POR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fS1Poe)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.Cpacr.u64 & RT_BIT_32(29)/*E0POE*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(29)/*E0POE*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,10,2,4), "POR_EL0", puDst, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(30)/*TRVM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,10,2,4), "POR_EL0", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,10,2,4), "POR_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_S1POE))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (!ELIsInHost(EL0) && AArch64.CPACR_EL1.E0POE == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL0) && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nPOR_EL0 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.CPTR_EL2.E0POE == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = POR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.TRVM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nPOR_EL0 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = POR_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.PIEn == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.PIEn == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = POR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = POR_EL0;
}


/**
 * TPIDR_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TPIDR_EL0(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        *puDst = pVCpu->cpum.GstCtx.aTpIdr[0].u64;
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
        *puDst = pVCpu->cpum.GstCtx.aTpIdr[0].u64;
    else
        *puDst = pVCpu->cpum.GstCtx.aTpIdr[0].u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (   EL2Enabled()
    //         && !ELIsInHost(EL0)
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.TPIDR_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = TPIDR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.TPIDR_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = TPIDR_EL0;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = TPIDR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TPIDR_EL0;
}


/**
 * TPIDRRO_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0000', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TPIDRRO_EL0(PVMCPU pVCpu, uint64_t * puDst) RT_NOEXCEPT
{
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
        *puDst = pVCpu->cpum.GstCtx.TpIdrRoEl0.u64;
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
        *puDst = pVCpu->cpum.GstCtx.TpIdrRoEl0.u64;
    else
        *puDst = pVCpu->cpum.GstCtx.TpIdrRoEl0.u64;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (   EL2Enabled()
    //         && !ELIsInHost(EL0)
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.TPIDRRO_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = TPIDRRO_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (   EL2Enabled()
    //         && IsFeatureImplemented(FEAT_FGT)
    //         && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //         && AArch64.HFGRTR_EL2.TPIDRRO_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = TPIDRRO_EL0;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = TPIDRRO_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TPIDRRO_EL0;
}


/**
 * TPIDR2_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0000', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_TPIDR2_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fSme)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.Sctlr.u64 & RT_BIT_64(60)/*EnTP2*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.SctlrEl2.u64 & RT_BIT_64(60)/*EnTP2*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,0,5), "TPIDR2_EL0", puDst, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fFgt)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,0,5), "TPIDR2_EL0", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,0,5), "TPIDR2_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_SME))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.EnTP2 == '0')
    //         Undefined()
    //     else if (!ELIsInHost(EL0) && AArch64.SCTLR_EL1.EnTP2 == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.SCTLR_EL2.EnTP2 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nTPIDR2_EL0 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.EnTP2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = TPIDR2_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.EnTP2 == '0')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.nTPIDR2_EL0 == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.EnTP2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = TPIDR2_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.EnTP2 == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.EnTP2 == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = TPIDR2_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = TPIDR2_EL0;
}


/**
 * SCXTNUM_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0000', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_SCXTNUM_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fCvs2_2 && !pGstFeats->fCsv21p2)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && (pVCpu->cpum.GstCtx.Sctlr.u64 & RT_BIT_32(20)/*TSCXT*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(53)/*EnSCXT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && (pVCpu->cpum.GstCtx.SctlrEl2.u64 & RT_BIT_32(20)/*TSCXT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,0,7), "SCXTNUM_EL0", puDst, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(53)/*EnSCXT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,0,7), "SCXTNUM_EL0", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,0,7), "SCXTNUM_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!(IsFeatureImplemented(FEAT_CSV2_2) || IsFeatureImplemented(FEAT_CSV2_1p2)))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.EnSCXT == '0')
    //         Undefined()
    //     else if (!ELIsInHost(EL0) && AArch64.SCTLR_EL1.TSCXT == '1')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL0) && AArch64.HCR_EL2.EnSCXT == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.SCXTNUM_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.SCTLR_EL2.TSCXT == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.EnSCXT == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SCXTNUM_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.EnSCXT == '0')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.HCR_EL2.EnSCXT == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HFGRTR_EL2.SCXTNUM_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.EnSCXT == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SCXTNUM_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.SCR_EL3.EnSCXT == '0')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.SCR_EL3.EnSCXT == '0')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = SCXTNUM_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = SCXTNUM_EL0;
}


/**
 * AMCR_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMCR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAmuV1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,0), "AMCR_EL0", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,0), "AMCR_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AMUv1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (AArch64.AMUSERENR_EL0.EN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCR_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMCR_EL0;
}


/**
 * AMCFGR_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0010', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMCFGR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAmuV1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,1), "AMCFGR_EL0", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,1), "AMCFGR_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AMUv1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (AArch64.AMUSERENR_EL0.EN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCFGR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCFGR_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCFGR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMCFGR_EL0;
}


/**
 * AMCGCR_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0010', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMCGCR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAmuV1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,2), "AMCGCR_EL0", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,2), "AMCGCR_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AMUv1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (AArch64.AMUSERENR_EL0.EN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCGCR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCGCR_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCGCR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMCGCR_EL0;
}


/**
 * AMUSERENR_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0010', 'op2': '011'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMUSERENR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAmuV1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = 0;
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = 0;
    }
    else
        *puDst = 0;
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AMUv1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMUSERENR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMUSERENR_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMUSERENR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMUSERENR_EL0;
}


/**
 * AMCNTENCLR0_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0010', 'op2': '100'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMCNTENCLR0_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAmuV1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt && AArch64.HAFGRTR_EL2.AMCNTEN0 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,4),
                                     "AMCNTENCLR0_EL0",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,4), "AMCNTENCLR0_EL0", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AMUv1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (AArch64.AMUSERENR_EL0.EN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HAFGRTR_EL2.AMCNTEN0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENCLR0_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HAFGRTR_EL2.AMCNTEN0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENCLR0_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENCLR0_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMCNTENCLR0_EL0;
}


/**
 * AMCNTENSET0_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0010', 'op2': '101'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMCNTENSET0_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAmuV1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt && AArch64.HAFGRTR_EL2.AMCNTEN0 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,5),
                                     "AMCNTENSET0_EL0",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,5), "AMCNTENSET0_EL0", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AMUv1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (AArch64.AMUSERENR_EL0.EN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HAFGRTR_EL2.AMCNTEN0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENSET0_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HAFGRTR_EL2.AMCNTEN0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENSET0_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENSET0_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMCNTENSET0_EL0;
}


/**
 * AMCG1IDR_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0010', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMCG1IDR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAmuV1p1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,6),
                                     "AMCG1IDR_EL0",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,2,6), "AMCG1IDR_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AMUv1p1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (AArch64.AMUSERENR_EL0.EN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCG1IDR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCG1IDR_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCG1IDR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMCG1IDR_EL0;
}


/**
 * AMCNTENCLR1_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0011', 'op2': '000'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMCNTENCLR1_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAmuV1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt && AArch64.HAFGRTR_EL2.AMCNTEN1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,3,0),
                                     "AMCNTENCLR1_EL0",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,3,0), "AMCNTENCLR1_EL0", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AMUv1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (AArch64.AMUSERENR_EL0.EN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HAFGRTR_EL2.AMCNTEN1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENCLR1_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HAFGRTR_EL2.AMCNTEN1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENCLR1_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENCLR1_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMCNTENCLR1_EL0;
}


/**
 * AMCNTENSET1_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1101', 'CRm': '0011', 'op2': '001'})
 * Transformation status: 1 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_AMCNTENSET1_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fAmuV1)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
    }
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CptrEl2.u64 & RT_BIT_32(30)/*TAM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2 && pGstFeats->fFgt && AArch64.HAFGRTR_EL2.AMCNTEN1 == 1)
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,3,1),
                                     "AMCNTENSET1_EL0",
                                     puDst,
                                     uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,13,3,1), "AMCNTENSET1_EL0", puDst, uInstrEssence);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_AMUv1))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (AArch64.AMUSERENR_EL0.EN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HAFGRTR_EL2.AMCNTEN1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENSET1_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (EL2Enabled() && AArch64.CPTR_EL2.TAM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HAFGRTR_EL2.AMCNTEN1 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENSET1_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.CPTR_EL3.TAM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.CPTR_EL3.TAM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = AMCNTENSET1_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = AMCNTENSET1_EL0;
}


/**
 * CNTFRQ_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0000', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTFRQ_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.CntKCtl.u64 & UINT64_C(0x3) /*EL0PCTEN,EL0VCTEN*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & UINT64_C(0x3) /*EL0PCTEN,EL0VCTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,14,0,0), "CNTFRQ_EL0", puDst, uInstrEssence);
    }
    return iemCImplA64_mrs_novar(pVCpu, ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,14,0,0), "CNTFRQ_EL0", puDst, uInstrEssence);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && (AArch64.CNTKCTL_EL1.EL0PCTEN):(AArch64.CNTKCTL_EL1.EL0VCTEN) == '00')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (ELIsInHost(EL0) && (AArch64.CNTHCTL_EL2.EL0PCTEN):(AArch64.CNTHCTL_EL2.EL0VCTEN) == '00')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else
    //         X<t,0x40> = CNTFRQ_EL0;
    // else if (PSTATE.EL == EL1)
    //     X<t,0x40> = CNTFRQ_EL0;
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = CNTFRQ_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CNTFRQ_EL0;
}


/**
 * CNTPCT_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0000', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTPCT_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.CntKCtl.u64 & UINT32_C(1)/*EL0PCTEN*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & UINT32_C(1)/*EL1PCTEN_AT_00*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(10)/*EL1PCTEN_AT_10*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & UINT32_C(1)/*EL0PCTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & UINT32_C(1)/*EL1PCTEN_AT_00*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    else
        *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && AArch64.CNTKCTL_EL1.EL0PCTEN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL2) && AArch64.HCR_EL2.TGE == '0' && AArch64.CNTHCTL_EL2.EL1PCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL0PCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   IsFeatureImplemented(FEAT_ECV_POFF)
    //              && EL2Enabled()
    //              && SCR_EL3.ECVEn == '1'
    //              && CNTHCTL_EL2.ECV == '1'
    //              && !ELIsInHost(EL0))
    //         X<t,0x40> = PhysicalCountInt() - CNTPOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.CNTHCTL_EL2.EL1PCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (IsFeatureImplemented(FEAT_ECV_POFF) && EL2Enabled() && SCR_EL3.ECVEn == '1' && CNTHCTL_EL2.ECV == '1')
    //         X<t,0x40> = PhysicalCountInt() - CNTPOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PhysicalCountInt();
}


/**
 * CNTVCT_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0000', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTVCT_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.CntKCtl.u64 & RT_BIT_32(1)/*EL0VCTEN*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(1)/*EL0VCTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && (pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(14)/*EL1TVCT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)))
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu) - pVCpu->cpum.GstCtx.CntVOffEl2.u64;
        else
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(14)/*EL1TVCT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2)
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu) - pVCpu->cpum.GstCtx.CntVOffEl2.u64;
        else
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    else
    {
        if (   !pGstFeats->fVhe
            || !pGstFeats->fEl2
            || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu) - pVCpu->cpum.GstCtx.CntVOffEl2.u64;
        else
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && AArch64.CNTKCTL_EL1.EL0VCTEN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL0VCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL1TVCT == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL2) && (!EL2Enabled() || !ELIsInHost(EL0)))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.CNTHCTL_EL2.EL1TVCT == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL2))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL2)
    //     if (!ELIsInHost(EL2))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL3)
    //     if (HaveEL(EL2) && !ELUsingAArch32(EL2))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF_EL2;
    //     else if (HaveEL(EL2) && ELUsingAArch32(EL2))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
}


/**
 * CNTPCTSS_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0000', 'op2': '101'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTPCTSS_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEcv)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.CntKCtl.u64 & UINT32_C(1)/*EL0PCTEN*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & UINT32_C(1)/*EL1PCTEN_AT_00*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(10)/*EL1PCTEN_AT_10*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & UINT32_C(1)/*EL0PCTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & UINT32_C(1)/*EL1PCTEN_AT_00*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    else
        *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_ECV))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && AArch64.CNTKCTL_EL1.EL0PCTEN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL2) && AArch64.HCR_EL2.TGE == '0' && AArch64.CNTHCTL_EL2.EL1PCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL0PCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   IsFeatureImplemented(FEAT_ECV_POFF)
    //              && EL2Enabled()
    //              && SCR_EL3.ECVEn == '1'
    //              && CNTHCTL_EL2.ECV == '1'
    //              && !ELIsInHost(EL0))
    //         X<t,0x40> = PhysicalCountInt() - CNTPOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.CNTHCTL_EL2.EL1PCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (IsFeatureImplemented(FEAT_ECV_POFF) && EL2Enabled() && SCR_EL3.ECVEn == '1' && CNTHCTL_EL2.ECV == '1')
    //         X<t,0x40> = PhysicalCountInt() - CNTPOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL2)
    //     X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PhysicalCountInt();
}


/**
 * CNTVCTSS_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0000', 'op2': '110'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTVCTSS_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fEcv)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.CntKCtl.u64 & RT_BIT_32(1)/*EL0VCTEN*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(1)/*EL0VCTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && (pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(14)/*EL1TVCT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)))
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu) - pVCpu->cpum.GstCtx.CntVOffEl2.u64;
        else
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(14)/*EL1TVCT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2)
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu) - pVCpu->cpum.GstCtx.CntVOffEl2.u64;
        else
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    else
    {
        if (   !pGstFeats->fVhe
            || !pGstFeats->fEl2
            || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu) - pVCpu->cpum.GstCtx.CntVOffEl2.u64;
        else
            *puDst = iemCImplHlpGetPhysicalSystemTimerCount(pVCpu);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_ECV))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && AArch64.CNTKCTL_EL1.EL0VCTEN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL0VCTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL1TVCT == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL2) && (!EL2Enabled() || !ELIsInHost(EL0)))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && AArch64.CNTHCTL_EL2.EL1TVCT == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL2))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL2)
    //     if (!ELIsInHost(EL2))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF_EL2;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
    // else if (PSTATE.EL == EL3)
    //     if (HaveEL(EL2) && !ELUsingAArch32(EL2))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF_EL2;
    //     else if (HaveEL(EL2) && ELUsingAArch32(EL2))
    //         X<t,0x40> = PhysicalCountInt() - CNTVOFF;
    //     else
    //         X<t,0x40> = PhysicalCountInt();
}


/**
 * PMCCFILTR_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '1111', 'op2': '111'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_PMCCFILTR_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (!pGstFeats->fPmuV3)
        return iemRaiseUndefined(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   !(iemCImplHlpGetPmUserEnrEl0(pVCpu) & UINT32_C(1)/*EN*/)
            && (!pGstFeats->fPmuV3p9 || !(iemCImplHlpGetPmUserEnrEl0(pVCpu) & RT_BIT_32(4)/*UEN*/)))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(6)/*TPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fPmuV3p9
            && (iemCImplHlpGetPmUserEnrEl0(pVCpu) & RT_BIT_32(4)/*UEN*/)
            && !(iemCImplHlpGetPmUacrEl1(pVCpu) & RT_BIT_32(31)/*C*/))
            *puDst = 0;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,14,15,7),
                                         "PMCCFILTR_EL0",
                                         puDst,
                                         uInstrEssence);
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.MdcrEl2.u64 & RT_BIT_32(6)/*TPM*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,14,15,7),
                                     "PMCCFILTR_EL0",
                                     puDst,
                                     uInstrEssence);
    }
    else
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,14,15,7),
                                     "PMCCFILTR_EL0",
                                     puDst,
                                     uInstrEssence);
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (!IsFeatureImplemented(FEAT_PMUv3))
    //     Undefined()
    // else if (PSTATE.EL == EL0)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (AArch64.PMUSERENR_EL0.EN == '0' && (!IsFeatureImplemented(FEAT_PMUv3p9) || AArch64.PMUSERENR_EL0.UEN == '0'))
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (   EL2Enabled()
    //              && !ELIsInHost(EL0)
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMCCFILTR_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else if (IsFeatureImplemented(FEAT_PMUv3p9) && PMUSERENR_EL0.UEN == '1' && PMUACR_EL1.C == '0')
    //         X<t,0x40> = Zeros(0x40);
    //     else
    //         X<t,0x40> = PMCCFILTR_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (   EL2Enabled()
    //              && IsFeatureImplemented(FEAT_FGT)
    //              && (!HaveEL(EL3) || AArch64.SCR_EL3.FGTEn == '1')
    //              && AArch64.HDFGRTR_EL2.PMCCFILTR_EL0 == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && AArch64.MDCR_EL2.TPM == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMCCFILTR_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (HaveEL(EL3) && EL3SDDUndefPriority() && AArch64.MDCR_EL3.TPM == '1')
    //         Undefined()
    //     else if (HaveEL(EL3) && AArch64.MDCR_EL3.TPM == '1')
    //         if (EL3SDDUndef())
    //             Undefined()
    //         else
    //             AArch64_SystemAccessTrap(EL3, 0x18)
    //     else
    //         X<t,0x40> = PMCCFILTR_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = PMCCFILTR_EL0;
}


/**
 * CNTP_TVAL_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0010', 'op2': '000'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTP_TVAL_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.CntKCtl.u64 & RT_BIT_32(9)/*EL0PTEN*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(1)/*EL1PCEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(11)/*EL1PTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(9)/*EL0PTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
        {
            if (!(pVCpu->cpum.GstCtx.CntHpCtlEl2.u64 & UINT32_C(1)/*ENABLE*/))
                *puDst = 0;
            else
                *puDst = (uint64_t)(uint32_t)(pVCpu->cpum.GstCtx.CntHpCValEl2.u64 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu));
        }
        else
            *puDst = 0;
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(1)/*EL1PCEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(11)/*EL1PTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        *puDst = 0;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        {
            if (!(pVCpu->cpum.GstCtx.CntHpCtlEl2.u64 & UINT32_C(1)/*ENABLE*/))
                *puDst = 0;
            else
                *puDst = (uint64_t)(uint32_t)(pVCpu->cpum.GstCtx.CntHpCValEl2.u64 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu));
        }
        else
            *puDst = 0;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && AArch64.CNTKCTL_EL1.EL0PTEN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PCEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL2) && AArch64.HCR_EL2.TGE == '0' && AArch64.CNTHCTL_EL2.EL1PTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL0PTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && IsCurrentSecurityState(SS_Secure) && IsFeatureImplemented(FEAT_SEL2))
    //         if (CNTHPS_CTL_EL2.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTHPS_CVAL_EL2 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    //     else if (ELIsInHost(EL0) && !IsCurrentSecurityState(SS_Secure))
    //         if (CNTHP_CTL_EL2.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTHP_CVAL_EL2 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    //     else if (   IsFeatureImplemented(FEAT_ECV_POFF)
    //              && EL2Enabled()
    //              && SCR_EL3.ECVEn == '1'
    //              && CNTHCTL_EL2.ECV == '1'
    //              && !ELIsInHost(EL0))
    //         if (AArch64.CNTP_CTL_EL0.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTP_CVAL_EL0 - PhysicalCountInt() - CNTPOFF_EL2)<[0x1f:0]>, 0x40);
    //     else if (CNTP_CTL_EL0.ENABLE == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = ZeroExtend((CNTP_CVAL_EL0 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PCEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (   IsFeatureImplemented(FEAT_ECV_POFF)
    //              && EL2Enabled()
    //              && AArch64.SCR_EL3.ECVEn == '1'
    //              && AArch64.CNTHCTL_EL2.ECV == '1')
    //         if (AArch64.CNTP_CTL_EL0.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTP_CVAL_EL0 - PhysicalCountInt() - CNTPOFF_EL2)<[0x1f:0]>, 0x40);
    //     else if (CNTP_CTL_EL0.ENABLE == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = ZeroExtend((CNTP_CVAL_EL0 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2) && IsCurrentSecurityState(SS_Secure) && IsFeatureImplemented(FEAT_SEL2))
    //         if (CNTHPS_CTL_EL2.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTHPS_CVAL_EL2 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    //     else if (ELIsInHost(EL2) && !IsCurrentSecurityState(SS_Secure))
    //         if (CNTHP_CTL_EL2.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTHP_CVAL_EL2 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    //     else if (CNTP_CTL_EL0.ENABLE == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = ZeroExtend((CNTP_CVAL_EL0 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    // else if (PSTATE.EL == EL3)
    //     if (CNTP_CTL_EL0.ENABLE == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = ZeroExtend((CNTP_CVAL_EL0 - PhysicalCountInt())<[0x1f:0]>, 0x40);
}


/**
 * CNTP_CTL_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0010', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTP_CTL_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.CntKCtl.u64 & RT_BIT_32(9)/*EL0PTEN*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(1)/*EL1PCEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(11)/*EL1PTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(9)/*EL0PTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            *puDst = pVCpu->cpum.GstCtx.CntHpCtlEl2.u64;
        else
            *puDst = 0;
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(1)/*EL1PCEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(11)/*EL1PTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x180, puDst);
        *puDst = 0;
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.CntHpCtlEl2.u64;
        else
            *puDst = 0;
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && AArch64.CNTKCTL_EL1.EL0PTEN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PCEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL2) && AArch64.HCR_EL2.TGE == '0' && AArch64.CNTHCTL_EL2.EL1PTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL0PTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && IsCurrentSecurityState(SS_Secure) && IsFeatureImplemented(FEAT_SEL2))
    //         X<t,0x40> = CNTHPS_CTL_EL2;
    //     else if (ELIsInHost(EL0) && !IsCurrentSecurityState(SS_Secure))
    //         X<t,0x40> = CNTHP_CTL_EL2;
    //     else
    //         X<t,0x40> = CNTP_CTL_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PCEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x180>;
    //     else
    //         X<t,0x40> = CNTP_CTL_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2) && IsCurrentSecurityState(SS_Secure) && IsFeatureImplemented(FEAT_SEL2))
    //         X<t,0x40> = CNTHPS_CTL_EL2;
    //     else if (ELIsInHost(EL2) && !IsCurrentSecurityState(SS_Secure))
    //         X<t,0x40> = CNTHP_CTL_EL2;
    //     else
    //         X<t,0x40> = CNTP_CTL_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CNTP_CTL_EL0;
}


/**
 * CNTP_CVAL_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0010', 'op2': '010'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTP_CVAL_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.CntKCtl.u64 & RT_BIT_32(9)/*EL0PTEN*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(1)/*EL1PCEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(11)/*EL1PTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(9)/*EL0PTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            *puDst = pVCpu->cpum.GstCtx.CntHpCValEl2.u64;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,14,2,2),
                                         "CNTP_CVAL_EL0",
                                         puDst,
                                         uInstrEssence);
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(1)/*EL1PCEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(11)/*EL1PTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (iemGetEffHcrEl2NVx(pVCpu, pGstFeats) == 7)
            return iemCImplHlpNVMemReadU64(pVCpu, 0x178, puDst);
        return iemCImplA64_mrs_novar(pVCpu,
                                     ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,14,2,2),
                                     "CNTP_CVAL_EL0",
                                     puDst,
                                     uInstrEssence);
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
            *puDst = pVCpu->cpum.GstCtx.CntHpCValEl2.u64;
        else
            return iemCImplA64_mrs_novar(pVCpu,
                                         ARMV8_AARCH64_SYSREG_ID_CREATE(3,3,14,2,2),
                                         "CNTP_CVAL_EL0",
                                         puDst,
                                         uInstrEssence);
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && AArch64.CNTKCTL_EL1.EL0PTEN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PCEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL2) && AArch64.HCR_EL2.TGE == '0' && AArch64.CNTHCTL_EL2.EL1PTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL0PTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && IsCurrentSecurityState(SS_Secure) && IsFeatureImplemented(FEAT_SEL2))
    //         X<t,0x40> = CNTHPS_CVAL_EL2;
    //     else if (ELIsInHost(EL0) && !IsCurrentSecurityState(SS_Secure))
    //         X<t,0x40> = CNTHP_CVAL_EL2;
    //     else
    //         X<t,0x40> = CNTP_CVAL_EL0;
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && !ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PCEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL2) && AArch64.CNTHCTL_EL2.EL1PTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EffectiveHCR_EL2_NVx() IN ('111'))
    //         X<t,0x40> = NVMem<0x178>;
    //     else
    //         X<t,0x40> = CNTP_CVAL_EL0;
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2) && IsCurrentSecurityState(SS_Secure) && IsFeatureImplemented(FEAT_SEL2))
    //         X<t,0x40> = CNTHPS_CVAL_EL2;
    //     else if (ELIsInHost(EL2) && !IsCurrentSecurityState(SS_Secure))
    //         X<t,0x40> = CNTHP_CVAL_EL2;
    //     else
    //         X<t,0x40> = CNTP_CVAL_EL0;
    // else if (PSTATE.EL == EL3)
    //     X<t,0x40> = CNTP_CVAL_EL0;
}


/**
 * CNTV_TVAL_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0011', 'op2': '000'})
 * Transformation status: 10 - incomplete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTV_TVAL_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    RT_NOREF(pVCpu, puDst, uInstrEssence);
#ifdef IEM_SYSREG_TODO
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && !(pVCpu->cpum.GstCtx.CntKCtl.u64 & RT_BIT_32(8)/*EL0VTEN*/))
        {
            if (pGstFeats->fEl2 && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
                return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
            return iemRaiseSystemAccessTrap(pVCpu, 1, uInstrEssence);
        }
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)
            && !(pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(8)/*EL0VTEN*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fEl2
            && (   !pGstFeats->fVhe
                || !pGstFeats->fEl2
                || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
            && pGstFeats->fEcv
            && (pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(13)/*EL1TVT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (   pGstFeats->fVhe
            && pGstFeats->fEl2
            && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
            && (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/))
        {
            if (AArch64.CNTHV_CTL_EL2.ENABLE == 0)
                *puDst = 0;
            else
                *puDst = ZeroExtend((CNTHV_CVAL_EL2 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu))<[0x1f:0]>, 0x40);
        }
        else if (   pGstFeats->fEl2
                 && (   !pGstFeats->fVhe
                     || !pGstFeats->fEl2
                     || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/))
                     || !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_32(27)/*TGE*/)))
        {
            if (!(pVCpu->cpum.GstCtx.CntvCtlEl0 & UINT32_C(1)/*ENABLE*/))
                *puDst = 0;
            else
                *puDst = (uint64_t)(uint32_t)(pVCpu->cpum.GstCtx.CntvCValEl0 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu) - pVCpu->cpum.GstCtx.CntVOffEl2.u64);
        }
        else if (!(pVCpu->cpum.GstCtx.CntvCtlEl0 & UINT32_C(1)/*ENABLE*/))
            *puDst = 0;
        else
            *puDst = (uint64_t)(uint32_t)(pVCpu->cpum.GstCtx.CntvCValEl0 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu));
    }
    else if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 1)
    {
        if (pGstFeats->fEl2 && pGstFeats->fEcv && (pVCpu->cpum.GstCtx.CntHCtlEl2.u64 & RT_BIT_32(13)/*EL1TVT*/))
            return iemRaiseSystemAccessTrap(pVCpu, 2, uInstrEssence);
        if (pGstFeats->fEl2)
        {
            if (!(pVCpu->cpum.GstCtx.CntvCtlEl0 & UINT32_C(1)/*ENABLE*/))
                *puDst = 0;
            else
                *puDst = (uint64_t)(uint32_t)(pVCpu->cpum.GstCtx.CntvCValEl0 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu) - pVCpu->cpum.GstCtx.CntVOffEl2.u64);
        }
        else if (!(pVCpu->cpum.GstCtx.CntvCtlEl0 & UINT32_C(1)/*ENABLE*/))
            *puDst = 0;
        else
            *puDst = (uint64_t)(uint32_t)(pVCpu->cpum.GstCtx.CntvCValEl0 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu));
    }
    else
    {
        if (pGstFeats->fVhe && pGstFeats->fEl2 && (!pGstFeats->fE2H0 || (pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        {
            if (AArch64.CNTHV_CTL_EL2.ENABLE == 0)
                *puDst = 0;
            else
                *puDst = ZeroExtend((CNTHV_CVAL_EL2 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu))<[0x1f:0]>, 0x40);
        }
        else if (   !pGstFeats->fVhe
                 || !pGstFeats->fEl2
                 || (pGstFeats->fE2H0 && !(pVCpu->cpum.GstCtx.HcrEl2.u64 & RT_BIT_64(34)/*E2H*/)))
        {
            if (!(pVCpu->cpum.GstCtx.CntvCtlEl0 & UINT32_C(1)/*ENABLE*/))
                *puDst = 0;
            else
                *puDst = (uint64_t)(uint32_t)(pVCpu->cpum.GstCtx.CntvCValEl0 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu) - pVCpu->cpum.GstCtx.CntVOffEl2.u64);
        }
        else if (!(pVCpu->cpum.GstCtx.CntvCtlEl0 & UINT32_C(1)/*ENABLE*/))
            *puDst = 0;
        else
            *puDst = (uint64_t)(uint32_t)(pVCpu->cpum.GstCtx.CntvCValEl0 - iemCImplHlpGetPhysicalSystemTimerCount(pVCpu));
    }
    return iemRegPcA64IncAndFinishingClearingFlags(pVCpu, VINF_SUCCESS);
#endif
    return VERR_IEM_ASPECT_NOT_IMPLEMENTED;
    /* -------- Original code specification: -------- */
    // if (PSTATE.EL == EL0)
    //     if (!ELIsInHost(EL0) && AArch64.CNTKCTL_EL1.EL0VTEN == '0')
    //         if (EL2Enabled() && AArch64.HCR_EL2.TGE == '1')
    //             AArch64_SystemAccessTrap(EL2, 0x18)
    //         else
    //             AArch64_SystemAccessTrap(EL1, 0x18)
    //     else if (ELIsInHost(EL0) && AArch64.CNTHCTL_EL2.EL0VTEN == '0')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (EL2Enabled() && !ELIsInHost(EL0) && IsFeatureImplemented(FEAT_ECV) && AArch64.CNTHCTL_EL2.EL1TVT == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (ELIsInHost(EL0) && IsCurrentSecurityState(SS_Secure) && IsFeatureImplemented(FEAT_SEL2))
    //         if (CNTHVS_CTL_EL2.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTHVS_CVAL_EL2 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    //     else if (ELIsInHost(EL0) && !IsCurrentSecurityState(SS_Secure))
    //         if (CNTHV_CTL_EL2.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTHV_CVAL_EL2 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    //     else if (HaveEL(EL2) && !ELIsInHost(EL0))
    //         if (CNTV_CTL_EL0.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTV_CVAL_EL0 - PhysicalCountInt() - CNTVOFF_EL2)<[0x1f:0]>, 0x40);
    //     else if (CNTV_CTL_EL0.ENABLE == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = ZeroExtend((CNTV_CVAL_EL0 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    // else if (PSTATE.EL == EL1)
    //     if (EL2Enabled() && IsFeatureImplemented(FEAT_ECV) && AArch64.CNTHCTL_EL2.EL1TVT == '1')
    //         AArch64_SystemAccessTrap(EL2, 0x18)
    //     else if (HaveEL(EL2))
    //         if (CNTV_CTL_EL0.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTV_CVAL_EL0 - PhysicalCountInt() - CNTVOFF_EL2)<[0x1f:0]>, 0x40);
    //     else if (CNTV_CTL_EL0.ENABLE == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = ZeroExtend((CNTV_CVAL_EL0 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    // else if (PSTATE.EL == EL2)
    //     if (ELIsInHost(EL2) && IsCurrentSecurityState(SS_Secure) && IsFeatureImplemented(FEAT_SEL2))
    //         if (CNTHVS_CTL_EL2.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTHVS_CVAL_EL2 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    //     else if (ELIsInHost(EL2) && !IsCurrentSecurityState(SS_Secure))
    //         if (CNTHV_CTL_EL2.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTHV_CVAL_EL2 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    //     else if (!ELIsInHost(EL2))
    //         if (CNTV_CTL_EL0.ENABLE == '0')
    //             X<t,0x40> = (bits(0x40)) UNKNOWN;
    //         else
    //             X<t,0x40> = ZeroExtend((CNTV_CVAL_EL0 - PhysicalCountInt() - CNTVOFF_EL2)<[0x1f:0]>, 0x40);
    //     else if (CNTV_CTL_EL0.ENABLE == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else
    //         X<t,0x40> = ZeroExtend((CNTV_CVAL_EL0 - PhysicalCountInt())<[0x1f:0]>, 0x40);
    // else if (PSTATE.EL == EL3)
    //     if (CNTV_CTL_EL0.ENABLE == '0')
    //         X<t,0x40> = (bits(0x40)) UNKNOWN;
    //     else if (HaveEL(EL2) && !ELUsingAArch32(EL2))
    //         X<t,0x40> = ZeroExtend((CNTV_CVAL_EL0 - PhysicalCountInt() - CNTVOFF_EL2)<[0x1f:0]>, 0x40);
    //     else if (HaveEL(EL2) && ELUsingAArch32(EL2))
    //         X<t,0x40> = ZeroExtend((CNTV_CVAL_EL0 - PhysicalCountInt() - CNTVOFF)<[0x1f:0]>, 0x40);
    //     else
    //         X<t,0x40> = ZeroExtend((CNTV_CVAL_EL0 - PhysicalCountInt())<[0x1f:0]>, 0x40);
}


/**
 * CNTV_CTL_EL0 - OrderedDict({'op0': '11', 'op1': '011', 'CRn': '1110', 'CRm': '0011', 'op2': '001'})
 * Transformation status: 0 - complete
 */
static VBOXSTRICTRC iemCImplA64_mrs_CNTV_CTL_EL0(PVMCPU pVCpu, uint64_t * puDst, uint32_t uInstrEssence) RT_NOEXCEPT
{
    const CPUMFEATURESARMV8 * const pGstFeats = IEM_GET_GUEST_CPU_FEATURES(pVCpu);
    if (IEM_F_MODE_ARM_GET_EL(pVCpu->iem.s.fExec) == 0)
    {
        if (   (   !pGstFe