/*
 * Autogenerated by $Id: IEMAllIntprA64Tables-armv8.cpp 110928 2025-09-08 12:11:44Z knut.osmundsen@oracle.com $
 * from the open source v9Ap6-A specs, build 406 (5e0a212688c6bd7aee92394b6f5e491b4d0fee1d)
 * dated Sun Dec 15 22:18:44 2024 UTC.
 *
 * Do not edit!
 */

/*
 * Copyright (C) 2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */


#define LOG_GROUP LOG_GROUP_IEM
#define VMCPU_INCL_CPUM_GST_CTX
#include <iprt/asm.h> /* needed for Armv8A64ConvertImmRImmS2Mask32 and friends in iprt/armv8.h */
#include "IEMInternal.h"
#include <VBox/vmm/vm.h>
#include "VBox/err.h"

#include <iprt/armv8.h>

#include "IEMMc.h"
#include "IEMInline-armv8.h"

#include "IEMAllIntprA64Tables-armv8.h"
#include "IEMAllInstrA64Impl.h"


/** Invalid instruction decoder function. */
FNIEMOP_DEF_1(iemDecodeA64_Invalid, uint32_t, uOpcode)
{
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    RT_NOREF_PV(uOpcode);
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ac02000: ABS  <Wd>, <Wn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ABS_32_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ac02000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCssc /*FEAT_CSSC*/)
        {
            LogFlow(("%018x/%010x: ABS_32_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__ABS_32_dp_1src
            IEM_INSTR_IMPL_A64__ABS_32_dp_1src(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/dac02000: ABS  <Xd>, <Xn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ABS_64_dp_1src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCssc /*FEAT_CSSC*/)
    {
        LogFlow(("%018x/%010x: ABS_64_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__ABS_64_dp_1src
        IEM_INSTR_IMPL_A64__ABS_64_dp_1src(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf3ffc00/0e20b800: ABS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_ABS_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf3ffc00)) == UINT32_C(0x0e20b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: ABS_asimdmisc_R Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__ABS_asimdmisc_R
            IEM_INSTR_IMPL_A64__ABS_asimdmisc_R(Rd, Rn, size, Q);
#else
            RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ee0b800: ABS  D<d>, D<n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_ABS_asisdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ee0b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: ABS_asisdmisc_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__ABS_asisdmisc_R
            IEM_INSTR_IMPL_A64__ABS_asisdmisc_R(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3a000000: ADCS  <Wd>, <Wn>, <Wm>
   Instruction Set: A64  Groups: addsub_carry, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADCS_32_addsub_carry, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ADCS_32_addsub_carry Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADCS_32_addsub_carry
    IEM_INSTR_IMPL_A64__ADCS_32_addsub_carry(Rd, Rn, Rm);
#else
    RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe0fc00/ba000000: ADCS  <Xd>, <Xn>, <Xm>
   Instruction Set: A64  Groups: addsub_carry, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADCS_64_addsub_carry, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ADCS_64_addsub_carry Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADCS_64_addsub_carry
    IEM_INSTR_IMPL_A64__ADCS_64_addsub_carry(Rd, Rn, Rm);
#else
    RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe0fc00/1a000000: ADC  <Wd>, <Wn>, <Wm>
   Instruction Set: A64  Groups: addsub_carry, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADC_32_addsub_carry, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ADC_32_addsub_carry Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADC_32_addsub_carry
    IEM_INSTR_IMPL_A64__ADC_32_addsub_carry(Rd, Rn, Rm);
#else
    RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe0fc00/9a000000: ADC  <Xd>, <Xn>, <Xm>
   Instruction Set: A64  Groups: addsub_carry, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADC_64_addsub_carry, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ADC_64_addsub_carry Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADC_64_addsub_carry
    IEM_INSTR_IMPL_A64__ADC_64_addsub_carry(Rd, Rn, Rm);
#else
    RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffc0c000/91800000: ADDG  <Xd|SP>, <Xn|SP>, #<uimm6>, #<uimm4>
   Instruction Set: A64  Groups: addsub_immtags, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_ADDG_64_addsub_immtags, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm4       = (uOpcode >> 10) & 0x0000000f;
    uint32_t const imm6       = (uOpcode >> 16) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMte /*FEAT_MTE*/)
    {
        LogFlow(("%018x/%010x: ADDG_64_addsub_immtags Rd=%#x Rn=%#x imm4=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm4, imm6));
#ifdef IEM_INSTR_IMPL_A64__ADDG_64_addsub_immtags
        IEM_INSTR_IMPL_A64__ADDG_64_addsub_immtags(Rd, Rn, imm4, imm6);
#else
        RT_NOREF(Rd, Rn, imm4, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/0e204000: ADDHN2  <Vd>.<Tb>, <Vn>.<Ta>, <Vm>.<Ta>
   Instruction Set: A64  Groups: asimddiff, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_ADDHN_asimddiff_N, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: ADDHN_asimddiff_N Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__ADDHN_asimddiff_N
        IEM_INSTR_IMPL_A64__ADDHN_asimddiff_N(Rd, Rn, Rm, size, Q);
#else
        RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0e000/9a002000: ADDPT  <Xd|SP>, <Xn|SP>, <Xm>{, LSL #<amount>}
   Instruction Set: A64  Groups: addsub_pt, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADDPT_64_addsub_pt, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm3       = (uOpcode >> 10) & 0x00000007;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCpa /*FEAT_CPA*/)
    {
        LogFlow(("%018x/%010x: ADDPT_64_addsub_pt Rd=%#x Rn=%#x imm3=%u Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm3, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADDPT_64_addsub_pt
        IEM_INSTR_IMPL_A64__ADDPT_64_addsub_pt(Rd, Rn, imm3, Rm);
#else
        RT_NOREF(Rd, Rn, imm3, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/0e20bc00: ADDP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_ADDP_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf20fc00)) == UINT32_C(0x0e20bc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: ADDP_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__ADDP_asimdsame_only
            IEM_INSTR_IMPL_A64__ADDP_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
            RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ef1b800: ADDP  D<d>, <Vn>.2D
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_ADDP_asisdpair_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ef1b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: ADDP_asisdpair_only Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__ADDP_asisdpair_only
            IEM_INSTR_IMPL_A64__ADDP_asisdpair_only(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00000/2b200000: ADDS  <Wd>, <Wn|WSP>, <Wm>{, <extend>{ #<amount>}}
   Instruction Set: A64  Groups: addsub_ext, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADDS_32S_addsub_ext, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm3       = (uOpcode >> 10) & 0x00000007;
    uint32_t const option     = (uOpcode >> 13) & 0x00000007;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ADDS_32S_addsub_ext Rd=%#x Rn=%#x imm3=%u option=%u Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm3, option, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADDS_32S_addsub_ext
    IEM_INSTR_IMPL_A64__ADDS_32S_addsub_ext(Rd, Rn, imm3, option, Rm);
#else
    RT_NOREF(Rd, Rn, imm3, option, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff800000/31000000: ADDS  <Wd>, <Wn|WSP>, #<imm>{, <shift>}
   Instruction Set: A64  Groups: addsub_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_ADDS_32S_addsub_imm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm12      = (uOpcode >> 10) & 0x00000fff;
    uint32_t const sh         = (uOpcode >> 22) & 0x00000001;
    LogFlow(("%018x/%010x: ADDS_32S_addsub_imm Rd=%#x Rn=%#x imm12=%#x sh=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm12, sh));
#ifdef IEM_INSTR_IMPL_A64__ADDS_32S_addsub_imm
    IEM_INSTR_IMPL_A64__ADDS_32S_addsub_imm(Rd, Rn, imm12, sh);
#else
    RT_NOREF(Rd, Rn, imm12, sh, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/2b000000: ADDS  <Wd>, <Wn>, <Wm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: addsub_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADDS_32_addsub_shift, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xff200000)) == UINT32_C(0x2b000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
        LogFlow(("%018x/%010x: ADDS_32_addsub_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__ADDS_32_addsub_shift
        IEM_INSTR_IMPL_A64__ADDS_32_addsub_shift(Rd, Rn, imm6, Rm, shift);
#else
        RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00000/ab200000: ADDS  <Xd>, <Xn|SP>, <R><m>{, <extend>{ #<amount>}}
   Instruction Set: A64  Groups: addsub_ext, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADDS_64S_addsub_ext, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm3       = (uOpcode >> 10) & 0x00000007;
    uint32_t const option     = (uOpcode >> 13) & 0x00000007;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ADDS_64S_addsub_ext Rd=%#x Rn=%#x imm3=%u option=%u Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm3, option, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADDS_64S_addsub_ext
    IEM_INSTR_IMPL_A64__ADDS_64S_addsub_ext(Rd, Rn, imm3, option, Rm);
#else
    RT_NOREF(Rd, Rn, imm3, option, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff800000/b1000000: ADDS  <Xd>, <Xn|SP>, #<imm>{, <shift>}
   Instruction Set: A64  Groups: addsub_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_ADDS_64S_addsub_imm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm12      = (uOpcode >> 10) & 0x00000fff;
    uint32_t const sh         = (uOpcode >> 22) & 0x00000001;
    LogFlow(("%018x/%010x: ADDS_64S_addsub_imm Rd=%#x Rn=%#x imm12=%#x sh=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm12, sh));
#ifdef IEM_INSTR_IMPL_A64__ADDS_64S_addsub_imm
    IEM_INSTR_IMPL_A64__ADDS_64S_addsub_imm(Rd, Rn, imm12, sh);
#else
    RT_NOREF(Rd, Rn, imm12, sh, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/ab000000: ADDS  <Xd>, <Xn>, <Xm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: addsub_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADDS_64_addsub_shift, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xff200000)) == UINT32_C(0xab000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
        LogFlow(("%018x/%010x: ADDS_64_addsub_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__ADDS_64_addsub_shift
        IEM_INSTR_IMPL_A64__ADDS_64_addsub_shift(Rd, Rn, imm6, Rm, shift);
#else
        RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf3ffc00/0e31b800: ADDV  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdall, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_ADDV_asimdall_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf3ffc00)) == UINT32_C(0x0e31b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: ADDV_asimdall_only Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__ADDV_asimdall_only
            IEM_INSTR_IMPL_A64__ADDV_asimdall_only(Rd, Rn, size, Q);
#else
            RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00000/0b200000: ADD  <Wd|WSP>, <Wn|WSP>, <Wm>{, <extend>{ #<amount>}}
   Instruction Set: A64  Groups: addsub_ext, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADD_32_addsub_ext, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm3       = (uOpcode >> 10) & 0x00000007;
    uint32_t const option     = (uOpcode >> 13) & 0x00000007;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ADD_32_addsub_ext Rd=%#x Rn=%#x imm3=%u option=%u Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm3, option, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADD_32_addsub_ext
    IEM_INSTR_IMPL_A64__ADD_32_addsub_ext(Rd, Rn, imm3, option, Rm);
#else
    RT_NOREF(Rd, Rn, imm3, option, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff800000/11000000: ADD  <Wd|WSP>, <Wn|WSP>, #<imm>{, <shift>}
   Instruction Set: A64  Groups: addsub_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_ADD_32_addsub_imm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm12      = (uOpcode >> 10) & 0x00000fff;
    uint32_t const sh         = (uOpcode >> 22) & 0x00000001;
    LogFlow(("%018x/%010x: ADD_32_addsub_imm Rd=%#x Rn=%#x imm12=%#x sh=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm12, sh));
#ifdef IEM_INSTR_IMPL_A64__ADD_32_addsub_imm
    IEM_INSTR_IMPL_A64__ADD_32_addsub_imm(Rd, Rn, imm12, sh);
#else
    RT_NOREF(Rd, Rn, imm12, sh, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/0b000000: ADD  <Wd>, <Wn>, <Wm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: addsub_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADD_32_addsub_shift, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xff200000)) == UINT32_C(0x0b000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
        LogFlow(("%018x/%010x: ADD_32_addsub_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__ADD_32_addsub_shift
        IEM_INSTR_IMPL_A64__ADD_32_addsub_shift(Rd, Rn, imm6, Rm, shift);
#else
        RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00000/8b200000: ADD  <Xd|SP>, <Xn|SP>, <R><m>{, <extend>{ #<amount>}}
   Instruction Set: A64  Groups: addsub_ext, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADD_64_addsub_ext, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm3       = (uOpcode >> 10) & 0x00000007;
    uint32_t const option     = (uOpcode >> 13) & 0x00000007;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ADD_64_addsub_ext Rd=%#x Rn=%#x imm3=%u option=%u Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm3, option, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADD_64_addsub_ext
    IEM_INSTR_IMPL_A64__ADD_64_addsub_ext(Rd, Rn, imm3, option, Rm);
#else
    RT_NOREF(Rd, Rn, imm3, option, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff800000/91000000: ADD  <Xd|SP>, <Xn|SP>, #<imm>{, <shift>}
   Instruction Set: A64  Groups: addsub_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_ADD_64_addsub_imm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm12      = (uOpcode >> 10) & 0x00000fff;
    uint32_t const sh         = (uOpcode >> 22) & 0x00000001;
    LogFlow(("%018x/%010x: ADD_64_addsub_imm Rd=%#x Rn=%#x imm12=%#x sh=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm12, sh));
#ifdef IEM_INSTR_IMPL_A64__ADD_64_addsub_imm
    IEM_INSTR_IMPL_A64__ADD_64_addsub_imm(Rd, Rn, imm12, sh);
#else
    RT_NOREF(Rd, Rn, imm12, sh, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/8b000000: ADD  <Xd>, <Xn>, <Xm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: addsub_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ADD_64_addsub_shift, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xff200000)) == UINT32_C(0x8b000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
        LogFlow(("%018x/%010x: ADD_64_addsub_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__ADD_64_addsub_shift
        IEM_INSTR_IMPL_A64__ADD_64_addsub_shift(Rd, Rn, imm6, Rm, shift);
#else
        RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/0e208400: ADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_ADD_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: ADD_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__ADD_asimdsame_only
        IEM_INSTR_IMPL_A64__ADD_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
        RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/5ee08400: ADD  D<d>, D<n>, D<m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_ADD_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: ADD_asisdsame_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__ADD_asisdsame_only
        IEM_INSTR_IMPL_A64__ADD_asisdsame_only(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 9f000000/90000000: ADRP  <Xd>, <label>
   Instruction Set: A64  Groups: pcreladdr, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_ADRP_only_pcreladdr, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const immhi      = (uOpcode >>  5) & 0x0007ffff;
    uint32_t const immlo      = (uOpcode >> 29) & 0x00000003;
    LogFlow(("%018x/%010x: ADRP_only_pcreladdr Rd=%#x immhi=%#x immlo=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, immhi, immlo));
#ifdef IEM_INSTR_IMPL_A64__ADRP_only_pcreladdr
    IEM_INSTR_IMPL_A64__ADRP_only_pcreladdr(Rd, immhi, immlo);
#else
    RT_NOREF(Rd, immhi, immlo, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* 9f000000/10000000: ADR  <Xd>, <label>
   Instruction Set: A64  Groups: pcreladdr, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_ADR_only_pcreladdr, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const immhi      = (uOpcode >>  5) & 0x0007ffff;
    uint32_t const immlo      = (uOpcode >> 29) & 0x00000003;
    LogFlow(("%018x/%010x: ADR_only_pcreladdr Rd=%#x immhi=%#x immlo=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, immhi, immlo));
#ifdef IEM_INSTR_IMPL_A64__ADR_only_pcreladdr
    IEM_INSTR_IMPL_A64__ADR_only_pcreladdr(Rd, immhi, immlo);
#else
    RT_NOREF(Rd, immhi, immlo, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* fffffc00/4e285800: AESD  <Vd>.16B, <Vn>.16B
   Instruction Set: A64  Groups: cryptoaes, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_AESD_B_cryptoaes, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAes /*FEAT_AES*/)
    {
        LogFlow(("%018x/%010x: AESD_B_cryptoaes Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__AESD_B_cryptoaes
        IEM_INSTR_IMPL_A64__AESD_B_cryptoaes(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/4e284800: AESE  <Vd>.16B, <Vn>.16B
   Instruction Set: A64  Groups: cryptoaes, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_AESE_B_cryptoaes, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAes /*FEAT_AES*/)
    {
        LogFlow(("%018x/%010x: AESE_B_cryptoaes Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__AESE_B_cryptoaes
        IEM_INSTR_IMPL_A64__AESE_B_cryptoaes(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/4e287800: AESIMC  <Vd>.16B, <Vn>.16B
   Instruction Set: A64  Groups: cryptoaes, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_AESIMC_B_cryptoaes, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAes /*FEAT_AES*/)
    {
        LogFlow(("%018x/%010x: AESIMC_B_cryptoaes Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__AESIMC_B_cryptoaes
        IEM_INSTR_IMPL_A64__AESIMC_B_cryptoaes(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/4e286800: AESMC  <Vd>.16B, <Vn>.16B
   Instruction Set: A64  Groups: cryptoaes, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_AESMC_B_cryptoaes, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAes /*FEAT_AES*/)
    {
        LogFlow(("%018x/%010x: AESMC_B_cryptoaes Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__AESMC_B_cryptoaes
        IEM_INSTR_IMPL_A64__AESMC_B_cryptoaes(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc00000/72000000: ANDS  <Wd>, <Wn>, #<imm>
   Instruction Set: A64  Groups: log_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_ANDS_32S_log_imm, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc00000)) == UINT32_C(0x72000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
        uint32_t const immr       = (uOpcode >> 16) & 0x0000003f;
        LogFlow(("%018x/%010x: ANDS_32S_log_imm Rd=%#x Rn=%#x imms=%#x immr=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, immr));
#ifdef IEM_INSTR_IMPL_A64__ANDS_32S_log_imm
        IEM_INSTR_IMPL_A64__ANDS_32S_log_imm(Rd, Rn, imms, immr);
#else
        RT_NOREF(Rd, Rn, imms, immr, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff200000/6a000000: ANDS  <Wd>, <Wn>, <Wm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ANDS_32_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: ANDS_32_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__ANDS_32_log_shift
    IEM_INSTR_IMPL_A64__ANDS_32_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff800000/f2000000: ANDS  <Xd>, <Xn>, #<imm>
   Instruction Set: A64  Groups: log_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_ANDS_64S_log_imm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const immr       = (uOpcode >> 16) & 0x0000003f;
    uint32_t const N          = (uOpcode >> 22) & 0x00000001;
    LogFlow(("%018x/%010x: ANDS_64S_log_imm Rd=%#x Rn=%#x imms=%#x immr=%#x N=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, immr, N));
#ifdef IEM_INSTR_IMPL_A64__ANDS_64S_log_imm
    IEM_INSTR_IMPL_A64__ANDS_64S_log_imm(Rd, Rn, imms, immr, N);
#else
    RT_NOREF(Rd, Rn, imms, immr, N, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/ea000000: ANDS  <Xd>, <Xn>, <Xm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ANDS_64_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: ANDS_64_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__ANDS_64_log_shift
    IEM_INSTR_IMPL_A64__ANDS_64_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffc00000/12000000: AND  <Wd|WSP>, <Wn>, #<imm>
   Instruction Set: A64  Groups: log_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_AND_32_log_imm, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc00000)) == UINT32_C(0x12000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
        uint32_t const immr       = (uOpcode >> 16) & 0x0000003f;
        LogFlow(("%018x/%010x: AND_32_log_imm Rd=%#x Rn=%#x imms=%#x immr=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, immr));
#ifdef IEM_INSTR_IMPL_A64__AND_32_log_imm
        IEM_INSTR_IMPL_A64__AND_32_log_imm(Rd, Rn, imms, immr);
#else
        RT_NOREF(Rd, Rn, imms, immr, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff200000/0a000000: AND  <Wd>, <Wn>, <Wm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AND_32_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: AND_32_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__AND_32_log_shift
    IEM_INSTR_IMPL_A64__AND_32_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff800000/92000000: AND  <Xd|SP>, <Xn>, #<imm>
   Instruction Set: A64  Groups: log_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_AND_64_log_imm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const immr       = (uOpcode >> 16) & 0x0000003f;
    uint32_t const N          = (uOpcode >> 22) & 0x00000001;
    LogFlow(("%018x/%010x: AND_64_log_imm Rd=%#x Rn=%#x imms=%#x immr=%#x N=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, immr, N));
#ifdef IEM_INSTR_IMPL_A64__AND_64_log_imm
    IEM_INSTR_IMPL_A64__AND_64_log_imm(Rd, Rn, imms, immr, N);
#else
    RT_NOREF(Rd, Rn, imms, immr, N, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/8a000000: AND  <Xd>, <Xn>, <Xm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AND_64_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: AND_64_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__AND_64_log_shift
    IEM_INSTR_IMPL_A64__AND_64_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* bfe0fc00/0e201c00: AND  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_AND_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: AND_asimdsame_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__AND_asimdsame_only
        IEM_INSTR_IMPL_A64__AND_asimdsame_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ac02800: ASRV  <Wd>, <Wn>, <Wm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ASRV_32_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ASRV_32_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__ASRV_32_dp_2src
    IEM_INSTR_IMPL_A64__ASRV_32_dp_2src(Rd, Rn, Rm);
#else
    RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe0fc00/9ac02800: ASRV  <Xd>, <Xn>, <Xm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_ASRV_64_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: ASRV_64_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__ASRV_64_dp_2src
    IEM_INSTR_IMPL_A64__ASRV_64_dp_2src(Rd, Rn, Rm);
#else
    RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* fffffc00/dac11800: AUTDA  <Xd>, <Xn|SP>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTDA_64P_dp_1src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTDA_64P_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__AUTDA_64P_dp_1src
        IEM_INSTR_IMPL_A64__AUTDA_64P_dp_1src(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/dac11c00: AUTDB  <Xd>, <Xn|SP>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTDB_64P_dp_1src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTDB_64P_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__AUTDB_64P_dp_1src
        IEM_INSTR_IMPL_A64__AUTDB_64P_dp_1src(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffe0/dac13be0: AUTDZA  <Xd>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTDZA_64Z_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffffffe0)) == UINT32_C(0xdac13be0))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: AUTDZA_64Z_dp_1src Rd=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd));
#ifdef IEM_INSTR_IMPL_A64__AUTDZA_64Z_dp_1src
            IEM_INSTR_IMPL_A64__AUTDZA_64Z_dp_1src(Rd);
#else
            RT_NOREF(Rd, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffe0/dac13fe0: AUTDZB  <Xd>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTDZB_64Z_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffffffe0)) == UINT32_C(0xdac13fe0))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: AUTDZB_64Z_dp_1src Rd=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd));
#ifdef IEM_INSTR_IMPL_A64__AUTDZB_64Z_dp_1src
            IEM_INSTR_IMPL_A64__AUTDZB_64Z_dp_1src(Rd);
#else
            RT_NOREF(Rd, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/dac1bbfe: AUTIA171615
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTIA171615_64LR_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffffffff)) == UINT32_C(0xdac1bbfe))
    {
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuthLR /*FEAT_PAuth_LR*/)
        {
            LogFlow(("%018x/%010x: AUTIA171615_64LR_dp_1src\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__AUTIA171615_64LR_dp_1src
            IEM_INSTR_IMPL_A64__AUTIA171615_64LR_dp_1src();
#else
            RT_NOREF(pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d503219f: AUTIA1716
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_AUTIA1716_HI_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTIA1716_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__AUTIA1716_HI_hints
        IEM_INSTR_IMPL_A64__AUTIA1716_HI_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/dac1901e: AUTIASPPCR  <Xn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTIASPPCR_64LRR_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc1f)) == UINT32_C(0xdac1901e))
    {
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuthLR /*FEAT_PAuth_LR*/)
        {
            LogFlow(("%018x/%010x: AUTIASPPCR_64LRR_dp_1src Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__AUTIASPPCR_64LRR_dp_1src
            IEM_INSTR_IMPL_A64__AUTIASPPCR_64LRR_dp_1src(Rn);
#else
            RT_NOREF(Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0001f/f380001f: AUTIASPPC  <label>
   Instruction Set: A64  Groups: dp_1src_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_AUTIASPPC_only_dp_1src_imm, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0001f)) == UINT32_C(0xf380001f))
    {
        uint32_t const imm16      = (uOpcode >>  5) & 0x0000ffff;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuthLR /*FEAT_PAuth_LR*/)
        {
            LogFlow(("%018x/%010x: AUTIASPPC_only_dp_1src_imm imm16=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm16));
#ifdef IEM_INSTR_IMPL_A64__AUTIASPPC_only_dp_1src_imm
            IEM_INSTR_IMPL_A64__AUTIASPPC_only_dp_1src_imm(imm16);
#else
            RT_NOREF(imm16, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d50323bf: AUTIASP
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_AUTIASP_HI_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTIASP_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__AUTIASP_HI_hints
        IEM_INSTR_IMPL_A64__AUTIASP_HI_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d503239f: AUTIAZ
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_AUTIAZ_HI_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTIAZ_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__AUTIAZ_HI_hints
        IEM_INSTR_IMPL_A64__AUTIAZ_HI_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/dac11000: AUTIA  <Xd>, <Xn|SP>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTIA_64P_dp_1src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTIA_64P_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__AUTIA_64P_dp_1src
        IEM_INSTR_IMPL_A64__AUTIA_64P_dp_1src(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/dac1bffe: AUTIB171615
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTIB171615_64LR_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffffffff)) == UINT32_C(0xdac1bffe))
    {
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuthLR /*FEAT_PAuth_LR*/)
        {
            LogFlow(("%018x/%010x: AUTIB171615_64LR_dp_1src\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__AUTIB171615_64LR_dp_1src
            IEM_INSTR_IMPL_A64__AUTIB171615_64LR_dp_1src();
#else
            RT_NOREF(pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d50321df: AUTIB1716
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_AUTIB1716_HI_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTIB1716_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__AUTIB1716_HI_hints
        IEM_INSTR_IMPL_A64__AUTIB1716_HI_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/dac1941e: AUTIBSPPCR  <Xn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTIBSPPCR_64LRR_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc1f)) == UINT32_C(0xdac1941e))
    {
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuthLR /*FEAT_PAuth_LR*/)
        {
            LogFlow(("%018x/%010x: AUTIBSPPCR_64LRR_dp_1src Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__AUTIBSPPCR_64LRR_dp_1src
            IEM_INSTR_IMPL_A64__AUTIBSPPCR_64LRR_dp_1src(Rn);
#else
            RT_NOREF(Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0001f/f3a0001f: AUTIBSPPC  <label>
   Instruction Set: A64  Groups: dp_1src_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_AUTIBSPPC_only_dp_1src_imm, uint32_t, uOpcode)
{
    uint32_t const imm16      = (uOpcode >>  5) & 0x0000ffff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuthLR /*FEAT_PAuth_LR*/)
    {
        LogFlow(("%018x/%010x: AUTIBSPPC_only_dp_1src_imm imm16=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm16));
#ifdef IEM_INSTR_IMPL_A64__AUTIBSPPC_only_dp_1src_imm
        IEM_INSTR_IMPL_A64__AUTIBSPPC_only_dp_1src_imm(imm16);
#else
        RT_NOREF(imm16, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d50323ff: AUTIBSP
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_AUTIBSP_HI_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTIBSP_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__AUTIBSP_HI_hints
        IEM_INSTR_IMPL_A64__AUTIBSP_HI_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d50323df: AUTIBZ
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_AUTIBZ_HI_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTIBZ_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__AUTIBZ_HI_hints
        IEM_INSTR_IMPL_A64__AUTIBZ_HI_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/dac11400: AUTIB  <Xd>, <Xn|SP>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTIB_64P_dp_1src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
    {
        LogFlow(("%018x/%010x: AUTIB_64P_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__AUTIB_64P_dp_1src
        IEM_INSTR_IMPL_A64__AUTIB_64P_dp_1src(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffe0/dac133e0: AUTIZA  <Xd>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTIZA_64Z_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffffffe0)) == UINT32_C(0xdac133e0))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: AUTIZA_64Z_dp_1src Rd=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd));
#ifdef IEM_INSTR_IMPL_A64__AUTIZA_64Z_dp_1src
            IEM_INSTR_IMPL_A64__AUTIZA_64Z_dp_1src(Rd);
#else
            RT_NOREF(Rd, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffe0/dac137e0: AUTIZB  <Xd>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_AUTIZB_64Z_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffffffe0)) == UINT32_C(0xdac137e0))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: AUTIZB_64Z_dp_1src Rd=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd));
#ifdef IEM_INSTR_IMPL_A64__AUTIZB_64Z_dp_1src
            IEM_INSTR_IMPL_A64__AUTIZB_64Z_dp_1src(Rd);
#else
            RT_NOREF(Rd, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d500405f: AXFLAG
   Instruction Set: A64  Groups: pstate, control */
FNIEMOP_DEF_1(iemDecodeA64_AXFLAG_M_pstate, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFlagM2 /*FEAT_FlagM2*/)
    {
        LogFlow(("%018x/%010x: AXFLAG_M_pstate\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__AXFLAG_M_pstate
        IEM_INSTR_IMPL_A64__AXFLAG_M_pstate();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/ce200000: BCAX  <Vd>.16B, <Vn>.16B, <Vm>.16B, <Va>.16B
   Instruction Set: A64  Groups: crypto4, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BCAX_VVV16_crypto4, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe08000)) == UINT32_C(0xce200000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fSha3 /*FEAT_SHA3*/)
        {
            LogFlow(("%018x/%010x: BCAX_VVV16_crypto4 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__BCAX_VVV16_crypto4
            IEM_INSTR_IMPL_A64__BCAX_VVV16_crypto4(Rd, Rn, Ra, Rm);
#else
            RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff000010/54000010: BC.<cond>  <label>
   Instruction Set: A64  Groups: condbranch, control */
FNIEMOP_DEF_1(iemDecodeA64_BC_only_condbranch, uint32_t, uOpcode)
{
    uint32_t const cond       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const imm19      = (uOpcode >>  5) & 0x0007ffff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fHbc /*FEAT_HBC*/)
    {
        LogFlow(("%018x/%010x: BC_only_condbranch cond=%#x imm19=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, cond, imm19));
#ifdef IEM_INSTR_IMPL_A64__BC_only_condbranch
        IEM_INSTR_IMPL_A64__BC_only_condbranch(cond, imm19);
#else
        RT_NOREF(cond, imm19, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ea17800: BF1CVTL2  <Vd>.8H, <Vn>.<Ta>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BF1CVTL_asimdmisc_V, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8 /*FEAT_FP8*/)
    {
        LogFlow(("%018x/%010x: BF1CVTL_asimdmisc_V Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__BF1CVTL_asimdmisc_V
        IEM_INSTR_IMPL_A64__BF1CVTL_asimdmisc_V(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ee17800: BF2CVTL2  <Vd>.8H, <Vn>.<Ta>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BF2CVTL_asimdmisc_V, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8 /*FEAT_FP8*/)
    {
        LogFlow(("%018x/%010x: BF2CVTL_asimdmisc_V Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__BF2CVTL_asimdmisc_V
        IEM_INSTR_IMPL_A64__BF2CVTL_asimdmisc_V(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ea16800: BFCVTN2  <Vd>.<Ta>, <Vn>.4S
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BFCVTN_asimdmisc_4S, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fBf16 /*FEAT_BF16*/)
    {
        LogFlow(("%018x/%010x: BFCVTN_asimdmisc_4S Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__BFCVTN_asimdmisc_4S
        IEM_INSTR_IMPL_A64__BFCVTN_asimdmisc_4S(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e634000: BFCVT  <Hd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BFCVT_BS_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fBf16 /*FEAT_BF16*/)
    {
        LogFlow(("%018x/%010x: BFCVT_BS_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__BFCVT_BS_floatdp1
        IEM_INSTR_IMPL_A64__BFCVT_BS_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/0f40f000: BFDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.2H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BFDOT_asimdelem_E, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfc0f400)) == UINT32_C(0x0f40f000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fBf16 /*FEAT_BF16*/)
        {
            LogFlow(("%018x/%010x: BFDOT_asimdelem_E Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__BFDOT_asimdelem_E
            IEM_INSTR_IMPL_A64__BFDOT_asimdelem_E(Rd, Rn, H, Rm, M, L, Q);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e40fc00: BFDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BFDOT_asimdsame2_D, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e40fc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fBf16 /*FEAT_BF16*/)
        {
            LogFlow(("%018x/%010x: BFDOT_asimdsame2_D Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__BFDOT_asimdsame2_D
            IEM_INSTR_IMPL_A64__BFDOT_asimdsame2_D(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/0fc0f000: BFMLAL<bt>  <Vd>.4S, <Vn>.8H, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BFMLAL_asimdelem_F, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfc0f400)) == UINT32_C(0x0fc0f000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fBf16 /*FEAT_BF16*/)
        {
            LogFlow(("%018x/%010x: BFMLAL_asimdelem_F Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__BFMLAL_asimdelem_F
            IEM_INSTR_IMPL_A64__BFMLAL_asimdelem_F(Rd, Rn, H, Rm, M, L, Q);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ec0fc00: BFMLAL<bt>  <Vd>.4S, <Vn>.8H, <Vm>.8H
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BFMLAL_asimdsame2_F, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2ec0fc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fBf16 /*FEAT_BF16*/)
        {
            LogFlow(("%018x/%010x: BFMLAL_asimdsame2_F Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__BFMLAL_asimdsame2_F
            IEM_INSTR_IMPL_A64__BFMLAL_asimdsame2_F(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/6e40ec00: BFMMLA  <Vd>.4S, <Vn>.8H, <Vm>.8H
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BFMMLA_asimdsame2_E, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x6e40ec00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fBf16 /*FEAT_BF16*/)
        {
            LogFlow(("%018x/%010x: BFMMLA_asimdsame2_E Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__BFMMLA_asimdsame2_E
            IEM_INSTR_IMPL_A64__BFMMLA_asimdsame2_E(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc00000/33000000: BFM  <Wd>, <Wn>, #<immr>, #<imms>
   Instruction Set: A64  Groups: bitfield, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_BFM_32M_bitfield, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const immr       = (uOpcode >> 16) & 0x0000003f;
    LogFlow(("%018x/%010x: BFM_32M_bitfield Rd=%#x Rn=%#x imms=%#x immr=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, immr));
#ifdef IEM_INSTR_IMPL_A64__BFM_32M_bitfield
    IEM_INSTR_IMPL_A64__BFM_32M_bitfield(Rd, Rn, imms, immr);
#else
    RT_NOREF(Rd, Rn, imms, immr, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffc00000/b3400000: BFM  <Xd>, <Xn>, #<immr>, #<imms>
   Instruction Set: A64  Groups: bitfield, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_BFM_64M_bitfield, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const immr       = (uOpcode >> 16) & 0x0000003f;
    LogFlow(("%018x/%010x: BFM_64M_bitfield Rd=%#x Rn=%#x imms=%#x immr=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, immr));
#ifdef IEM_INSTR_IMPL_A64__BFM_64M_bitfield
    IEM_INSTR_IMPL_A64__BFM_64M_bitfield(Rd, Rn, imms, immr);
#else
    RT_NOREF(Rd, Rn, imms, immr, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/6a200000: BICS  <Wd>, <Wn>, <Wm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_BICS_32_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: BICS_32_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__BICS_32_log_shift
    IEM_INSTR_IMPL_A64__BICS_32_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/ea200000: BICS  <Xd>, <Xn>, <Xm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_BICS_64_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: BICS_64_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__BICS_64_log_shift
    IEM_INSTR_IMPL_A64__BICS_64_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/0a200000: BIC  <Wd>, <Wn>, <Wm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_BIC_32_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: BIC_32_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__BIC_32_log_shift
    IEM_INSTR_IMPL_A64__BIC_32_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/8a200000: BIC  <Xd>, <Xn>, <Xm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_BIC_64_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: BIC_64_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__BIC_64_log_shift
    IEM_INSTR_IMPL_A64__BIC_64_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* bff8dc00/2f009400: BIC  <Vd>.<T>, #<imm8>{, LSL #<amount>}
   Instruction Set: A64  Groups: asimdimm, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BIC_asimdimm_L_hl, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbff8dc00)) == UINT32_C(0x2f009400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const h          = (uOpcode >>  5) & 0x00000001;
        uint32_t const g          = (uOpcode >>  6) & 0x00000001;
        uint32_t const f          = (uOpcode >>  7) & 0x00000001;
        uint32_t const e          = (uOpcode >>  8) & 0x00000001;
        uint32_t const d          = (uOpcode >>  9) & 0x00000001;
        uint32_t const cmode      = (uOpcode >> 12) & 0x0000000f;
        uint32_t const c          = (uOpcode >> 16) & 0x00000001;
        uint32_t const b          = (uOpcode >> 17) & 0x00000001;
        uint32_t const a          = (uOpcode >> 18) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: BIC_asimdimm_L_hl Rd=%#x h=%u g=%u f=%u e=%u d=%u cmode=%#x c=%u b=%u a=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, h, g, f, e, d, cmode, c, b, a, Q));
#ifdef IEM_INSTR_IMPL_A64__BIC_asimdimm_L_hl
            IEM_INSTR_IMPL_A64__BIC_asimdimm_L_hl(Rd, h, g, f, e, d, cmode, c, b, a, Q);
#else
            RT_NOREF(Rd, h, g, f, e, d, cmode, c, b, a, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bff89c00/2f001400: BIC  <Vd>.<T>, #<imm8>{, LSL #<amount>}
   Instruction Set: A64  Groups: asimdimm, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BIC_asimdimm_L_sl, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const h          = (uOpcode >>  5) & 0x00000001;
    uint32_t const g          = (uOpcode >>  6) & 0x00000001;
    uint32_t const f          = (uOpcode >>  7) & 0x00000001;
    uint32_t const e          = (uOpcode >>  8) & 0x00000001;
    uint32_t const d          = (uOpcode >>  9) & 0x00000001;
    uint32_t const cmode      = (uOpcode >> 12) & 0x0000000f;
    uint32_t const c          = (uOpcode >> 16) & 0x00000001;
    uint32_t const b          = (uOpcode >> 17) & 0x00000001;
    uint32_t const a          = (uOpcode >> 18) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: BIC_asimdimm_L_sl Rd=%#x h=%u g=%u f=%u e=%u d=%u cmode=%#x c=%u b=%u a=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, h, g, f, e, d, cmode, c, b, a, Q));
#ifdef IEM_INSTR_IMPL_A64__BIC_asimdimm_L_sl
        IEM_INSTR_IMPL_A64__BIC_asimdimm_L_sl(Rd, h, g, f, e, d, cmode, c, b, a, Q);
#else
        RT_NOREF(Rd, h, g, f, e, d, cmode, c, b, a, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e601c00: BIC  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BIC_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0e601c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: BIC_asimdsame_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__BIC_asimdsame_only
            IEM_INSTR_IMPL_A64__BIC_asimdsame_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ee01c00: BIF  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BIF_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2ee01c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: BIF_asimdsame_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__BIF_asimdsame_only
            IEM_INSTR_IMPL_A64__BIF_asimdsame_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ea01c00: BIT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BIT_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: BIT_asimdsame_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__BIT_asimdsame_only
        IEM_INSTR_IMPL_A64__BIT_asimdsame_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/d63f081f: BLRAAZ  <Xn>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BLRAAZ_64_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc1f)) == UINT32_C(0xd63f081f))
    {
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: BLRAAZ_64_branch_reg Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__BLRAAZ_64_branch_reg
            IEM_INSTR_IMPL_A64__BLRAAZ_64_branch_reg(Rn);
#else
            RT_NOREF(Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/d73f0800: BLRAA  <Xn>, <Xm|SP>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BLRAA_64P_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xd73f0800))
    {
        uint32_t const Rm         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: BLRAA_64P_branch_reg Rm=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rm, Rn));
#ifdef IEM_INSTR_IMPL_A64__BLRAA_64P_branch_reg
            IEM_INSTR_IMPL_A64__BLRAA_64P_branch_reg(Rm, Rn);
#else
            RT_NOREF(Rm, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/d63f0c1f: BLRABZ  <Xn>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BLRABZ_64_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc1f)) == UINT32_C(0xd63f0c1f))
    {
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: BLRABZ_64_branch_reg Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__BLRABZ_64_branch_reg
            IEM_INSTR_IMPL_A64__BLRABZ_64_branch_reg(Rn);
#else
            RT_NOREF(Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/d73f0c00: BLRAB  <Xn>, <Xm|SP>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BLRAB_64P_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xd73f0c00))
    {
        uint32_t const Rm         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: BLRAB_64P_branch_reg Rm=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rm, Rn));
#ifdef IEM_INSTR_IMPL_A64__BLRAB_64P_branch_reg
            IEM_INSTR_IMPL_A64__BLRAB_64P_branch_reg(Rm, Rn);
#else
            RT_NOREF(Rm, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/d63f0000: BLR  <Xn>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BLR_64_branch_reg, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    LogFlow(("%018x/%010x: BLR_64_branch_reg Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__BLR_64_branch_reg
    IEM_INSTR_IMPL_A64__BLR_64_branch_reg(Rn);
#else
    RT_NOREF(Rn, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* fc000000/94000000: BL  <label>
   Instruction Set: A64  Groups: branch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_BL_only_branch_imm, uint32_t, uOpcode)
{
    uint32_t const imm26      = (uOpcode >>  0) & 0x03ffffff;
    LogFlow(("%018x/%010x: BL_only_branch_imm imm26=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm26));
#ifdef IEM_INSTR_IMPL_A64__BL_only_branch_imm
    IEM_INSTR_IMPL_A64__BL_only_branch_imm(imm26);
#else
    RT_NOREF(imm26, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* fffffc1f/d61f081f: BRAAZ  <Xn>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BRAAZ_64_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc1f)) == UINT32_C(0xd61f081f))
    {
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: BRAAZ_64_branch_reg Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__BRAAZ_64_branch_reg
            IEM_INSTR_IMPL_A64__BRAAZ_64_branch_reg(Rn);
#else
            RT_NOREF(Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/d71f0800: BRAA  <Xn>, <Xm|SP>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BRAA_64P_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xd71f0800))
    {
        uint32_t const Rm         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: BRAA_64P_branch_reg Rm=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rm, Rn));
#ifdef IEM_INSTR_IMPL_A64__BRAA_64P_branch_reg
            IEM_INSTR_IMPL_A64__BRAA_64P_branch_reg(Rm, Rn);
#else
            RT_NOREF(Rm, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/d61f0c1f: BRABZ  <Xn>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BRABZ_64_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc1f)) == UINT32_C(0xd61f0c1f))
    {
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: BRABZ_64_branch_reg Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__BRABZ_64_branch_reg
            IEM_INSTR_IMPL_A64__BRABZ_64_branch_reg(Rn);
#else
            RT_NOREF(Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/d71f0c00: BRAB  <Xn>, <Xm|SP>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BRAB_64P_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xd71f0c00))
    {
        uint32_t const Rm         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: BRAB_64P_branch_reg Rm=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rm, Rn));
#ifdef IEM_INSTR_IMPL_A64__BRAB_64P_branch_reg
            IEM_INSTR_IMPL_A64__BRAB_64P_branch_reg(Rm, Rn);
#else
            RT_NOREF(Rm, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0001f/d4200000: BRK  #<imm>
   Instruction Set: A64  Groups: exception, control */
FNIEMOP_DEF_1(iemDecodeA64_BRK_EX_exception, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0001f)) == UINT32_C(0xd4200000))
    {
        uint32_t const imm16      = (uOpcode >>  5) & 0x0000ffff;
        LogFlow(("%018x/%010x: BRK_EX_exception imm16=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm16));
#ifdef IEM_INSTR_IMPL_A64__BRK_EX_exception
        IEM_INSTR_IMPL_A64__BRK_EX_exception(imm16);
#else
        RT_NOREF(imm16, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/d61f0000: BR  <Xn>
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_BR_64_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc1f)) == UINT32_C(0xd61f0000))
    {
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: BR_64_branch_reg Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__BR_64_branch_reg
        IEM_INSTR_IMPL_A64__BR_64_branch_reg(Rn);
#else
        RT_NOREF(Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e601c00: BSL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_BSL_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e601c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: BSL_asimdsame_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__BSL_asimdsame_only
            IEM_INSTR_IMPL_A64__BSL_asimdsame_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffff1f/d503241f: BTI{  <targets>}
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_BTI_HB_hints, uint32_t, uOpcode)
{
    uint32_t const op2        = (uOpcode >>  5) & 0x00000007;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fBti /*FEAT_BTI*/ && (op2 & 1) == 0)
    {
        LogFlow(("%018x/%010x: BTI_HB_hints op2=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, op2));
#ifdef IEM_INSTR_IMPL_A64__BTI_HB_hints
        IEM_INSTR_IMPL_A64__BTI_HB_hints(op2);
#else
        RT_NOREF(op2, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fc000000/14000000: B  <label>
   Instruction Set: A64  Groups: branch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_B_only_branch_imm, uint32_t, uOpcode)
{
    uint32_t const imm26      = (uOpcode >>  0) & 0x03ffffff;
    LogFlow(("%018x/%010x: B_only_branch_imm imm26=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm26));
#ifdef IEM_INSTR_IMPL_A64__B_only_branch_imm
    IEM_INSTR_IMPL_A64__B_only_branch_imm(imm26);
#else
    RT_NOREF(imm26, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff000010/54000000: B.<cond>  <label>
   Instruction Set: A64  Groups: condbranch, control */
FNIEMOP_DEF_1(iemDecodeA64_B_only_condbranch, uint32_t, uOpcode)
{
    uint32_t const cond       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const imm19      = (uOpcode >>  5) & 0x0007ffff;
    LogFlow(("%018x/%010x: B_only_condbranch cond=%#x imm19=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, cond, imm19));
#ifdef IEM_INSTR_IMPL_A64__B_only_condbranch
    IEM_INSTR_IMPL_A64__B_only_condbranch(cond, imm19);
#else
    RT_NOREF(cond, imm19, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe0fc00/08e07c00: CASAB  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASAB_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASAB_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASAB_C32_comswap
        IEM_INSTR_IMPL_A64__CASAB_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/48e07c00: CASAH  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASAH_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASAH_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASAH_C32_comswap
        IEM_INSTR_IMPL_A64__CASAH_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/08e0fc00: CASALB  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASALB_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASALB_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASALB_C32_comswap
        IEM_INSTR_IMPL_A64__CASALB_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/48e0fc00: CASALH  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASALH_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASALH_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASALH_C32_comswap
        IEM_INSTR_IMPL_A64__CASALH_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/c9c0fc00: CASALT  <Xs>, <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASALT_C64_comswap_unpriv, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
    {
        LogFlow(("%018x/%010x: CASALT_C64_comswap_unpriv Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASALT_C64_comswap_unpriv
        IEM_INSTR_IMPL_A64__CASALT_C64_comswap_unpriv(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/88e0fc00: CASAL  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASAL_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASAL_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASAL_C32_comswap
        IEM_INSTR_IMPL_A64__CASAL_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/c8e0fc00: CASAL  <Xs>, <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASAL_C64_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASAL_C64_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASAL_C64_comswap
        IEM_INSTR_IMPL_A64__CASAL_C64_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/c9c07c00: CASAT  <Xs>, <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASAT_C64_comswap_unpriv, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
    {
        LogFlow(("%018x/%010x: CASAT_C64_comswap_unpriv Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASAT_C64_comswap_unpriv
        IEM_INSTR_IMPL_A64__CASAT_C64_comswap_unpriv(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/88e07c00: CASA  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASA_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASA_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASA_C32_comswap
        IEM_INSTR_IMPL_A64__CASA_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/c8e07c00: CASA  <Xs>, <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASA_C64_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASA_C64_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASA_C64_comswap
        IEM_INSTR_IMPL_A64__CASA_C64_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/08a07c00: CASB  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASB_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASB_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASB_C32_comswap
        IEM_INSTR_IMPL_A64__CASB_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/48a07c00: CASH  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASH_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASH_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASH_C32_comswap
        IEM_INSTR_IMPL_A64__CASH_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/08a0fc00: CASLB  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASLB_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASLB_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASLB_C32_comswap
        IEM_INSTR_IMPL_A64__CASLB_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/48a0fc00: CASLH  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASLH_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASLH_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASLH_C32_comswap
        IEM_INSTR_IMPL_A64__CASLH_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/c980fc00: CASLT  <Xs>, <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASLT_C64_comswap_unpriv, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
    {
        LogFlow(("%018x/%010x: CASLT_C64_comswap_unpriv Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASLT_C64_comswap_unpriv
        IEM_INSTR_IMPL_A64__CASLT_C64_comswap_unpriv(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/88a0fc00: CASL  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASL_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASL_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASL_C32_comswap
        IEM_INSTR_IMPL_A64__CASL_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/c8a0fc00: CASL  <Xs>, <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASL_C64_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASL_C64_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASL_C64_comswap
        IEM_INSTR_IMPL_A64__CASL_C64_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/49c0fc00: CASPALT  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPALT_CP64_comswappr_unpriv, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
    {
        LogFlow(("%018x/%010x: CASPALT_CP64_comswappr_unpriv Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPALT_CP64_comswappr_unpriv
        IEM_INSTR_IMPL_A64__CASPALT_CP64_comswappr_unpriv(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/0860fc00: CASPAL  <Ws>, <W(s+1)>, <Wt>, <W(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPAL_CP32_comswappr, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASPAL_CP32_comswappr Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPAL_CP32_comswappr
        IEM_INSTR_IMPL_A64__CASPAL_CP32_comswappr(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/4860fc00: CASPAL  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPAL_CP64_comswappr, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x4860fc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
        {
            LogFlow(("%018x/%010x: CASPAL_CP64_comswappr Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPAL_CP64_comswappr
            IEM_INSTR_IMPL_A64__CASPAL_CP64_comswappr(Rt, Rn, Rs);
#else
            RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/49c07c00: CASPAT  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPAT_CP64_comswappr_unpriv, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
    {
        LogFlow(("%018x/%010x: CASPAT_CP64_comswappr_unpriv Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPAT_CP64_comswappr_unpriv
        IEM_INSTR_IMPL_A64__CASPAT_CP64_comswappr_unpriv(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/08607c00: CASPA  <Ws>, <W(s+1)>, <Wt>, <W(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPA_CP32_comswappr, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASPA_CP32_comswappr Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPA_CP32_comswappr
        IEM_INSTR_IMPL_A64__CASPA_CP32_comswappr(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/48607c00: CASPA  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPA_CP64_comswappr, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x48607c00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
        {
            LogFlow(("%018x/%010x: CASPA_CP64_comswappr Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPA_CP64_comswappr
            IEM_INSTR_IMPL_A64__CASPA_CP64_comswappr(Rt, Rn, Rs);
#else
            RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/4980fc00: CASPLT  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPLT_CP64_comswappr_unpriv, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
    {
        LogFlow(("%018x/%010x: CASPLT_CP64_comswappr_unpriv Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPLT_CP64_comswappr_unpriv
        IEM_INSTR_IMPL_A64__CASPLT_CP64_comswappr_unpriv(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/0820fc00: CASPL  <Ws>, <W(s+1)>, <Wt>, <W(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPL_CP32_comswappr, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASPL_CP32_comswappr Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPL_CP32_comswappr
        IEM_INSTR_IMPL_A64__CASPL_CP32_comswappr(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/4820fc00: CASPL  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPL_CP64_comswappr, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x4820fc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
        {
            LogFlow(("%018x/%010x: CASPL_CP64_comswappr Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPL_CP64_comswappr
            IEM_INSTR_IMPL_A64__CASPL_CP64_comswappr(Rt, Rn, Rs);
#else
            RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/49807c00: CASPT  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASPT_CP64_comswappr_unpriv, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
    {
        LogFlow(("%018x/%010x: CASPT_CP64_comswappr_unpriv Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASPT_CP64_comswappr_unpriv
        IEM_INSTR_IMPL_A64__CASPT_CP64_comswappr_unpriv(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/08207c00: CASP  <Ws>, <W(s+1)>, <Wt>, <W(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASP_CP32_comswappr, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CASP_CP32_comswappr Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASP_CP32_comswappr
        IEM_INSTR_IMPL_A64__CASP_CP32_comswappr(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/48207c00: CASP  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswappr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CASP_CP64_comswappr, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x48207c00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
        {
            LogFlow(("%018x/%010x: CASP_CP64_comswappr Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CASP_CP64_comswappr
            IEM_INSTR_IMPL_A64__CASP_CP64_comswappr(Rt, Rn, Rs);
#else
            RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/c9807c00: CAST  <Xs>, <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CAST_C64_comswap_unpriv, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
    {
        LogFlow(("%018x/%010x: CAST_C64_comswap_unpriv Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CAST_C64_comswap_unpriv
        IEM_INSTR_IMPL_A64__CAST_C64_comswap_unpriv(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/88a07c00: CAS  <Ws>, <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CAS_C32_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CAS_C32_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CAS_C32_comswap
        IEM_INSTR_IMPL_A64__CAS_C32_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/c8a07c00: CAS  <Xs>, <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: comswap, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CAS_C64_comswap, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: CAS_C64_comswap Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__CAS_C64_comswap
        IEM_INSTR_IMPL_A64__CAS_C64_comswap(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74c08000: CBBEQ  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBBEQ_8_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBBEQ_8_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBBEQ_8_regs
        IEM_INSTR_IMPL_A64__CBBEQ_8_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74208000: CBBGE  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBBGE_8_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBBGE_8_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBBGE_8_regs
        IEM_INSTR_IMPL_A64__CBBGE_8_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74008000: CBBGT  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBBGT_8_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBBGT_8_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBBGT_8_regs
        IEM_INSTR_IMPL_A64__CBBGT_8_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74408000: CBBHI  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBBHI_8_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBBHI_8_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBBHI_8_regs
        IEM_INSTR_IMPL_A64__CBBHI_8_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74608000: CBBHS  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBBHS_8_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBBHS_8_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBBHS_8_regs
        IEM_INSTR_IMPL_A64__CBBHS_8_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74e08000: CBBNE  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBBNE_8_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBBNE_8_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBBNE_8_regs
        IEM_INSTR_IMPL_A64__CBBNE_8_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/75c00000: CBEQ  <Wt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBEQ_32_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBEQ_32_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBEQ_32_imm
        IEM_INSTR_IMPL_A64__CBEQ_32_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74c00000: CBEQ  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBEQ_32_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBEQ_32_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBEQ_32_regs
        IEM_INSTR_IMPL_A64__CBEQ_32_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/f5c00000: CBEQ  <Xt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBEQ_64_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBEQ_64_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBEQ_64_imm
        IEM_INSTR_IMPL_A64__CBEQ_64_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/f4c00000: CBEQ  <Xt>, <Xm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBEQ_64_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBEQ_64_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBEQ_64_regs
        IEM_INSTR_IMPL_A64__CBEQ_64_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74200000: CBGE  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBGE_32_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBGE_32_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBGE_32_regs
        IEM_INSTR_IMPL_A64__CBGE_32_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/f4200000: CBGE  <Xt>, <Xm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBGE_64_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBGE_64_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBGE_64_regs
        IEM_INSTR_IMPL_A64__CBGE_64_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/75000000: CBGT  <Wt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBGT_32_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBGT_32_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBGT_32_imm
        IEM_INSTR_IMPL_A64__CBGT_32_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74000000: CBGT  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBGT_32_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBGT_32_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBGT_32_regs
        IEM_INSTR_IMPL_A64__CBGT_32_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/f5000000: CBGT  <Xt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBGT_64_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBGT_64_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBGT_64_imm
        IEM_INSTR_IMPL_A64__CBGT_64_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/f4000000: CBGT  <Xt>, <Xm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBGT_64_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBGT_64_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBGT_64_regs
        IEM_INSTR_IMPL_A64__CBGT_64_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74c0c000: CBHEQ  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHEQ_16_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHEQ_16_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHEQ_16_regs
        IEM_INSTR_IMPL_A64__CBHEQ_16_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/7420c000: CBHGE  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHGE_16_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHGE_16_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHGE_16_regs
        IEM_INSTR_IMPL_A64__CBHGE_16_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/7400c000: CBHGT  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHGT_16_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHGT_16_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHGT_16_regs
        IEM_INSTR_IMPL_A64__CBHGT_16_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/7440c000: CBHHI  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHHI_16_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHHI_16_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHHI_16_regs
        IEM_INSTR_IMPL_A64__CBHHI_16_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/7460c000: CBHHS  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHHS_16_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHHS_16_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHHS_16_regs
        IEM_INSTR_IMPL_A64__CBHHS_16_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/75400000: CBHI  <Wt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHI_32_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHI_32_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBHI_32_imm
        IEM_INSTR_IMPL_A64__CBHI_32_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74400000: CBHI  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHI_32_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHI_32_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHI_32_regs
        IEM_INSTR_IMPL_A64__CBHI_32_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/f5400000: CBHI  <Xt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHI_64_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHI_64_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBHI_64_imm
        IEM_INSTR_IMPL_A64__CBHI_64_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/f4400000: CBHI  <Xt>, <Xm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHI_64_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHI_64_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHI_64_regs
        IEM_INSTR_IMPL_A64__CBHI_64_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74e0c000: CBHNE  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs2, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHNE_16_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHNE_16_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHNE_16_regs
        IEM_INSTR_IMPL_A64__CBHNE_16_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74600000: CBHS  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHS_32_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHS_32_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHS_32_regs
        IEM_INSTR_IMPL_A64__CBHS_32_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/f4600000: CBHS  <Xt>, <Xm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBHS_64_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBHS_64_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBHS_64_regs
        IEM_INSTR_IMPL_A64__CBHS_64_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/75600000: CBLO  <Wt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBLO_32_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBLO_32_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBLO_32_imm
        IEM_INSTR_IMPL_A64__CBLO_32_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/f5600000: CBLO  <Xt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBLO_64_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBLO_64_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBLO_64_imm
        IEM_INSTR_IMPL_A64__CBLO_64_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/75200000: CBLT  <Wt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBLT_32_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBLT_32_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBLT_32_imm
        IEM_INSTR_IMPL_A64__CBLT_32_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/f5200000: CBLT  <Xt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBLT_64_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBLT_64_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBLT_64_imm
        IEM_INSTR_IMPL_A64__CBLT_64_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/75e00000: CBNE  <Wt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBNE_32_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBNE_32_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBNE_32_imm
        IEM_INSTR_IMPL_A64__CBNE_32_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/74e00000: CBNE  <Wt>, <Wm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBNE_32_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBNE_32_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBNE_32_regs
        IEM_INSTR_IMPL_A64__CBNE_32_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe04000/f5e00000: CBNE  <Xt>, #<imm>, <label>
   Instruction Set: A64  Groups: compbranch_imm, control */
FNIEMOP_DEF_1(iemDecodeA64_CBNE_64_imm, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const imm6       = (uOpcode >> 15) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBNE_64_imm Rt=%#x imm9=%#x imm6=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, imm6));
#ifdef IEM_INSTR_IMPL_A64__CBNE_64_imm
        IEM_INSTR_IMPL_A64__CBNE_64_imm(Rt, imm9, imm6);
#else
        RT_NOREF(Rt, imm9, imm6, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0c000/f4e00000: CBNE  <Xt>, <Xm>, <label>
   Instruction Set: A64  Groups: compbranch_regs, control */
FNIEMOP_DEF_1(iemDecodeA64_CBNE_64_regs, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >>  5) & 0x000001ff;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCmpBr /*FEAT_CMPBR*/)
    {
        LogFlow(("%018x/%010x: CBNE_64_regs Rt=%#x imm9=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm9, Rm));
#ifdef IEM_INSTR_IMPL_A64__CBNE_64_regs
        IEM_INSTR_IMPL_A64__CBNE_64_regs(Rt, imm9, Rm);
#else
        RT_NOREF(Rt, imm9, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff000000/35000000: CBNZ  <Wt>, <label>
   Instruction Set: A64  Groups: compbranch, control */
FNIEMOP_DEF_1(iemDecodeA64_CBNZ_32_compbranch, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm19      = (uOpcode >>  5) & 0x0007ffff;
    LogFlow(("%018x/%010x: CBNZ_32_compbranch Rt=%#x imm19=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm19));
#ifdef IEM_INSTR_IMPL_A64__CBNZ_32_compbranch
    IEM_INSTR_IMPL_A64__CBNZ_32_compbranch(Rt, imm19);
#else
    RT_NOREF(Rt, imm19, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff000000/b5000000: CBNZ  <Xt>, <label>
   Instruction Set: A64  Groups: compbranch, control */
FNIEMOP_DEF_1(iemDecodeA64_CBNZ_64_compbranch, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm19      = (uOpcode >>  5) & 0x0007ffff;
    LogFlow(("%018x/%010x: CBNZ_64_compbranch Rt=%#x imm19=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm19));
#ifdef IEM_INSTR_IMPL_A64__CBNZ_64_compbranch
    IEM_INSTR_IMPL_A64__CBNZ_64_compbranch(Rt, imm19);
#else
    RT_NOREF(Rt, imm19, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff000000/34000000: CBZ  <Wt>, <label>
   Instruction Set: A64  Groups: compbranch, control */
FNIEMOP_DEF_1(iemDecodeA64_CBZ_32_compbranch, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm19      = (uOpcode >>  5) & 0x0007ffff;
    LogFlow(("%018x/%010x: CBZ_32_compbranch Rt=%#x imm19=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm19));
#ifdef IEM_INSTR_IMPL_A64__CBZ_32_compbranch
    IEM_INSTR_IMPL_A64__CBZ_32_compbranch(Rt, imm19);
#else
    RT_NOREF(Rt, imm19, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff000000/b4000000: CBZ  <Xt>, <label>
   Instruction Set: A64  Groups: compbranch, control */
FNIEMOP_DEF_1(iemDecodeA64_CBZ_64_compbranch, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm19      = (uOpcode >>  5) & 0x0007ffff;
    LogFlow(("%018x/%010x: CBZ_64_compbranch Rt=%#x imm19=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, imm19));
#ifdef IEM_INSTR_IMPL_A64__CBZ_64_compbranch
    IEM_INSTR_IMPL_A64__CBZ_64_compbranch(Rt, imm19);
#else
    RT_NOREF(Rt, imm19, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c10/3a400800: CCMN  <Wn>, #<imm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: condcmp_imm, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CCMN_32_condcmp_imm, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe00c10)) == UINT32_C(0x3a400800))
    {
        uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
        uint32_t const imm5       = (uOpcode >> 16) & 0x0000001f;
        LogFlow(("%018x/%010x: CCMN_32_condcmp_imm nzcv=%#x Rn=%#x cond=%#x imm5=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, imm5));
#ifdef IEM_INSTR_IMPL_A64__CCMN_32_condcmp_imm
        IEM_INSTR_IMPL_A64__CCMN_32_condcmp_imm(nzcv, Rn, cond, imm5);
#else
        RT_NOREF(nzcv, Rn, cond, imm5, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/3a400000: CCMN  <Wn>, <Wm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: condcmp_reg, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CCMN_32_condcmp_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe00c10)) == UINT32_C(0x3a400000))
    {
        uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        LogFlow(("%018x/%010x: CCMN_32_condcmp_reg nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CCMN_32_condcmp_reg
        IEM_INSTR_IMPL_A64__CCMN_32_condcmp_reg(nzcv, Rn, cond, Rm);
#else
        RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/ba400800: CCMN  <Xn>, #<imm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: condcmp_imm, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CCMN_64_condcmp_imm, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const imm5       = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CCMN_64_condcmp_imm nzcv=%#x Rn=%#x cond=%#x imm5=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, imm5));
#ifdef IEM_INSTR_IMPL_A64__CCMN_64_condcmp_imm
    IEM_INSTR_IMPL_A64__CCMN_64_condcmp_imm(nzcv, Rn, cond, imm5);
#else
    RT_NOREF(nzcv, Rn, cond, imm5, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c10/ba400000: CCMN  <Xn>, <Xm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: condcmp_reg, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CCMN_64_condcmp_reg, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CCMN_64_condcmp_reg nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CCMN_64_condcmp_reg
    IEM_INSTR_IMPL_A64__CCMN_64_condcmp_reg(nzcv, Rn, cond, Rm);
#else
    RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c10/7a400800: CCMP  <Wn>, #<imm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: condcmp_imm, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CCMP_32_condcmp_imm, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe00c10)) == UINT32_C(0x7a400800))
    {
        uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
        uint32_t const imm5       = (uOpcode >> 16) & 0x0000001f;
        LogFlow(("%018x/%010x: CCMP_32_condcmp_imm nzcv=%#x Rn=%#x cond=%#x imm5=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, imm5));
#ifdef IEM_INSTR_IMPL_A64__CCMP_32_condcmp_imm
        IEM_INSTR_IMPL_A64__CCMP_32_condcmp_imm(nzcv, Rn, cond, imm5);
#else
        RT_NOREF(nzcv, Rn, cond, imm5, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/7a400000: CCMP  <Wn>, <Wm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: condcmp_reg, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CCMP_32_condcmp_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe00c10)) == UINT32_C(0x7a400000))
    {
        uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        LogFlow(("%018x/%010x: CCMP_32_condcmp_reg nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CCMP_32_condcmp_reg
        IEM_INSTR_IMPL_A64__CCMP_32_condcmp_reg(nzcv, Rn, cond, Rm);
#else
        RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/fa400800: CCMP  <Xn>, #<imm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: condcmp_imm, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CCMP_64_condcmp_imm, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const imm5       = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CCMP_64_condcmp_imm nzcv=%#x Rn=%#x cond=%#x imm5=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, imm5));
#ifdef IEM_INSTR_IMPL_A64__CCMP_64_condcmp_imm
    IEM_INSTR_IMPL_A64__CCMP_64_condcmp_imm(nzcv, Rn, cond, imm5);
#else
    RT_NOREF(nzcv, Rn, cond, imm5, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c10/fa400000: CCMP  <Xn>, <Xm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: condcmp_reg, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CCMP_64_condcmp_reg, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CCMP_64_condcmp_reg nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CCMP_64_condcmp_reg
    IEM_INSTR_IMPL_A64__CCMP_64_condcmp_reg(nzcv, Rn, cond, Rm);
#else
    RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffffffff/d500401f: CFINV
   Instruction Set: A64  Groups: pstate, control */
FNIEMOP_DEF_1(iemDecodeA64_CFINV_M_pstate, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFlagM /*FEAT_FlagM*/)
    {
        LogFlow(("%018x/%010x: CFINV_M_pstate\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__CFINV_M_pstate
        IEM_INSTR_IMPL_A64__CFINV_M_pstate();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d503251f: CHKFEAT  X16
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_CHKFEAT_HF_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fChk /*FEAT_CHK*/)
    {
        LogFlow(("%018x/%010x: CHKFEAT_HF_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__CHKFEAT_HF_hints
        IEM_INSTR_IMPL_A64__CHKFEAT_HF_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d50322df: CLRBHB
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_CLRBHB_HI_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fClrBhb /*FEAT_CLRBHB*/)
    {
        LogFlow(("%018x/%010x: CLRBHB_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__CLRBHB_HI_hints
        IEM_INSTR_IMPL_A64__CLRBHB_HI_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffff0ff/d503305f: CLREX{  #<imm>}
   Instruction Set: A64  Groups: barriers, control */
FNIEMOP_DEF_1(iemDecodeA64_CLREX_BN_barriers, uint32_t, uOpcode)
{
    uint32_t const CRm        = (uOpcode >>  8) & 0x0000000f;
    LogFlow(("%018x/%010x: CLREX_BN_barriers CRm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, CRm));
#ifdef IEM_INSTR_IMPL_A64__CLREX_BN_barriers
    IEM_INSTR_IMPL_A64__CLREX_BN_barriers(CRm);
#else
    RT_NOREF(CRm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* fffffc00/5ac01400: CLS  <Wd>, <Wn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CLS_32_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ac01400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: CLS_32_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CLS_32_dp_1src
        IEM_INSTR_IMPL_A64__CLS_32_dp_1src(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/dac01400: CLS  <Xd>, <Xn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CLS_64_dp_1src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    LogFlow(("%018x/%010x: CLS_64_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CLS_64_dp_1src
    IEM_INSTR_IMPL_A64__CLS_64_dp_1src(Rd, Rn);
#else
    RT_NOREF(Rd, Rn, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* bf3ffc00/0e204800: CLS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CLS_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CLS_asimdmisc_R Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CLS_asimdmisc_R
        IEM_INSTR_IMPL_A64__CLS_asimdmisc_R(Rd, Rn, size, Q);
#else
        RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ac01000: CLZ  <Wd>, <Wn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CLZ_32_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ac01000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: CLZ_32_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CLZ_32_dp_1src
        IEM_INSTR_IMPL_A64__CLZ_32_dp_1src(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/dac01000: CLZ  <Xd>, <Xn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CLZ_64_dp_1src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    LogFlow(("%018x/%010x: CLZ_64_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CLZ_64_dp_1src
    IEM_INSTR_IMPL_A64__CLZ_64_dp_1src(Rd, Rn);
#else
    RT_NOREF(Rd, Rn, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* bf3ffc00/2e204800: CLZ  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CLZ_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CLZ_asimdmisc_R Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CLZ_asimdmisc_R
        IEM_INSTR_IMPL_A64__CLZ_asimdmisc_R(Rd, Rn, size, Q);
#else
        RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf3ffc00/0e209800: CMEQ  <Vd>.<T>, <Vn>.<T>, #0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMEQ_asimdmisc_Z, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMEQ_asimdmisc_Z Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMEQ_asimdmisc_Z
        IEM_INSTR_IMPL_A64__CMEQ_asimdmisc_Z(Rd, Rn, size, Q);
#else
        RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/2e208c00: CMEQ  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMEQ_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMEQ_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMEQ_asimdsame_only
        IEM_INSTR_IMPL_A64__CMEQ_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
        RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ee09800: CMEQ  D<d>, D<n>, #0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMEQ_asisdmisc_Z, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ee09800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: CMEQ_asisdmisc_Z Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CMEQ_asisdmisc_Z
            IEM_INSTR_IMPL_A64__CMEQ_asisdmisc_Z(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/7ee08c00: CMEQ  D<d>, D<n>, D<m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMEQ_asisdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x7ee08c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: CMEQ_asisdsame_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CMEQ_asisdsame_only
            IEM_INSTR_IMPL_A64__CMEQ_asisdsame_only(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf3ffc00/2e208800: CMGE  <Vd>.<T>, <Vn>.<T>, #0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMGE_asimdmisc_Z, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf3ffc00)) == UINT32_C(0x2e208800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: CMGE_asimdmisc_Z Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMGE_asimdmisc_Z
            IEM_INSTR_IMPL_A64__CMGE_asimdmisc_Z(Rd, Rn, size, Q);
#else
            RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/0e203c00: CMGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMGE_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMGE_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMGE_asimdsame_only
        IEM_INSTR_IMPL_A64__CMGE_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
        RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7ee08800: CMGE  D<d>, D<n>, #0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMGE_asisdmisc_Z, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x7ee08800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: CMGE_asisdmisc_Z Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CMGE_asisdmisc_Z
            IEM_INSTR_IMPL_A64__CMGE_asisdmisc_Z(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/5ee03c00: CMGE  D<d>, D<n>, D<m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMGE_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMGE_asisdsame_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CMGE_asisdsame_only
        IEM_INSTR_IMPL_A64__CMGE_asisdsame_only(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf3ffc00/0e208800: CMGT  <Vd>.<T>, <Vn>.<T>, #0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMGT_asimdmisc_Z, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMGT_asimdmisc_Z Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMGT_asimdmisc_Z
        IEM_INSTR_IMPL_A64__CMGT_asimdmisc_Z(Rd, Rn, size, Q);
#else
        RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/0e203400: CMGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMGT_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMGT_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMGT_asimdsame_only
        IEM_INSTR_IMPL_A64__CMGT_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
        RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ee08800: CMGT  D<d>, D<n>, #0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMGT_asisdmisc_Z, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ee08800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: CMGT_asisdmisc_Z Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CMGT_asisdmisc_Z
            IEM_INSTR_IMPL_A64__CMGT_asisdmisc_Z(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/5ee03400: CMGT  D<d>, D<n>, D<m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMGT_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMGT_asisdsame_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CMGT_asisdsame_only
        IEM_INSTR_IMPL_A64__CMGT_asisdsame_only(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/2e203400: CMHI  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMHI_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMHI_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMHI_asimdsame_only
        IEM_INSTR_IMPL_A64__CMHI_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
        RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/7ee03400: CMHI  D<d>, D<n>, D<m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMHI_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMHI_asisdsame_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CMHI_asisdsame_only
        IEM_INSTR_IMPL_A64__CMHI_asisdsame_only(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/2e203c00: CMHS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMHS_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMHS_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMHS_asimdsame_only
        IEM_INSTR_IMPL_A64__CMHS_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
        RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/7ee03c00: CMHS  D<d>, D<n>, D<m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMHS_asisdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x7ee03c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: CMHS_asisdsame_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CMHS_asisdsame_only
            IEM_INSTR_IMPL_A64__CMHS_asisdsame_only(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf3ffc00/2e209800: CMLE  <Vd>.<T>, <Vn>.<T>, #0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMLE_asimdmisc_Z, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMLE_asimdmisc_Z Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMLE_asimdmisc_Z
        IEM_INSTR_IMPL_A64__CMLE_asimdmisc_Z(Rd, Rn, size, Q);
#else
        RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7ee09800: CMLE  D<d>, D<n>, #0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMLE_asisdmisc_Z, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x7ee09800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: CMLE_asisdmisc_Z Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CMLE_asisdmisc_Z
            IEM_INSTR_IMPL_A64__CMLE_asisdmisc_Z(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf3ffc00/0e20a800: CMLT  <Vd>.<T>, <Vn>.<T>, #0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMLT_asimdmisc_Z, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMLT_asimdmisc_Z Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMLT_asimdmisc_Z
        IEM_INSTR_IMPL_A64__CMLT_asimdmisc_Z(Rd, Rn, size, Q);
#else
        RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ee0a800: CMLT  D<d>, D<n>, #0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMLT_asisdmisc_Z, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMLT_asisdmisc_Z Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CMLT_asisdmisc_Z
        IEM_INSTR_IMPL_A64__CMLT_asisdmisc_Z(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/0e208c00: CMTST  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMTST_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 22) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMTST_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CMTST_asimdsame_only
        IEM_INSTR_IMPL_A64__CMTST_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
        RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/5ee08c00: CMTST  D<d>, D<n>, D<m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CMTST_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: CMTST_asisdsame_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CMTST_asisdsame_only
        IEM_INSTR_IMPL_A64__CMTST_asisdsame_only(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ac01c00: CNT  <Wd>, <Wn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CNT_32_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ac01c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCssc /*FEAT_CSSC*/)
        {
            LogFlow(("%018x/%010x: CNT_32_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CNT_32_dp_1src
            IEM_INSTR_IMPL_A64__CNT_32_dp_1src(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/dac01c00: CNT  <Xd>, <Xn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CNT_64_dp_1src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCssc /*FEAT_CSSC*/)
    {
        LogFlow(("%018x/%010x: CNT_64_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CNT_64_dp_1src
        IEM_INSTR_IMPL_A64__CNT_64_dp_1src(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf3ffc00/0e205800: CNT  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_CNT_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf3ffc00)) == UINT32_C(0x0e205800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: CNT_asimdmisc_R Rd=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__CNT_asimdmisc_R
            IEM_INSTR_IMPL_A64__CNT_asimdmisc_R(Rd, Rn, size, Q);
#else
            RT_NOREF(Rd, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d80c400: CPYEN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYEN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYEN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYEN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYEN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d808400: CPYERN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYERN_CPY_memcms, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0x3fe0fc00)) == UINT32_C(0x1d808400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
        {
            LogFlow(("%018x/%010x: CPYERN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYERN_CPY_memcms
            IEM_INSTR_IMPL_A64__CPYERN_CPY_memcms(Rd, Rn, Rs, sz);
#else
            RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d80e400: CPYERTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYERTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYERTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYERTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYERTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d80a400: CPYERTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYERTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYERTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYERTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYERTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d806400: CPYERTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYERTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYERTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYERTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYERTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d802400: CPYERT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYERT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYERT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYERT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYERT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d80f400: CPYETN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYETN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYETN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYETN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYETN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d80b400: CPYETRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYETRN_CPY_memcms, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0x3fe0fc00)) == UINT32_C(0x1d80b400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
        {
            LogFlow(("%018x/%010x: CPYETRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYETRN_CPY_memcms
            IEM_INSTR_IMPL_A64__CPYETRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
            RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d807400: CPYETWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYETWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYETWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYETWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYETWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d803400: CPYET  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYET_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYET_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYET_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYET_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d804400: CPYEWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYEWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYEWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYEWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYEWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d80d400: CPYEWTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYEWTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYEWTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYEWTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYEWTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d809400: CPYEWTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYEWTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYEWTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYEWTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYEWTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d805400: CPYEWTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYEWTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYEWTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYEWTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYEWTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d801400: CPYEWT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYEWT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYEWT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYEWT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYEWT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d800400: CPYE  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYE_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYE_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYE_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYE_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1980c400: CPYFEN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFEN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFEN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFEN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFEN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19808400: CPYFERN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFERN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFERN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFERN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFERN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1980e400: CPYFERTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFERTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFERTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFERTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFERTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1980a400: CPYFERTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFERTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFERTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFERTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFERTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19806400: CPYFERTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFERTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFERTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFERTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFERTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19802400: CPYFERT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFERT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFERT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFERT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFERT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1980f400: CPYFETN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFETN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFETN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFETN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFETN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1980b400: CPYFETRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFETRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFETRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFETRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFETRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19807400: CPYFETWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFETWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFETWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFETWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFETWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19803400: CPYFET  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFET_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFET_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFET_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFET_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19804400: CPYFEWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFEWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFEWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFEWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFEWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1980d400: CPYFEWTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFEWTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFEWTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFEWTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFEWTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19809400: CPYFEWTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFEWTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFEWTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFEWTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFEWTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19805400: CPYFEWTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFEWTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFEWTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFEWTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFEWTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19801400: CPYFEWT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFEWT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFEWT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFEWT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFEWT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19800400: CPYFE  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFE_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFE_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFE_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFE_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1940c400: CPYFMN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19408400: CPYFMRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1940e400: CPYFMRTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMRTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMRTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMRTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMRTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1940a400: CPYFMRTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMRTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMRTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMRTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMRTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19406400: CPYFMRTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMRTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMRTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMRTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMRTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19402400: CPYFMRT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMRT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMRT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMRT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMRT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1940f400: CPYFMTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1940b400: CPYFMTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19407400: CPYFMTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19403400: CPYFMT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19404400: CPYFMWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1940d400: CPYFMWTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMWTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMWTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMWTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMWTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19409400: CPYFMWTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMWTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMWTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMWTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMWTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19405400: CPYFMWTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMWTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMWTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMWTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMWTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19401400: CPYFMWT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFMWT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFMWT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFMWT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFMWT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19400400: CPYFM  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFM_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFM_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFM_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFM_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1900c400: CPYFPN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19008400: CPYFPRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1900e400: CPYFPRTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPRTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPRTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPRTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPRTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1900a400: CPYFPRTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPRTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPRTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPRTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPRTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19006400: CPYFPRTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPRTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPRTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPRTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPRTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19002400: CPYFPRT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPRT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPRT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPRT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPRT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1900f400: CPYFPTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1900b400: CPYFPTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19007400: CPYFPTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19003400: CPYFPT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19004400: CPYFPWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1900d400: CPYFPWTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPWTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPWTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPWTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPWTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19009400: CPYFPWTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPWTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPWTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPWTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPWTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19005400: CPYFPWTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPWTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPWTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPWTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPWTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19001400: CPYFPWT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFPWT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFPWT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFPWT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFPWT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/19000400: CPYFP  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYFP_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYFP_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYFP_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYFP_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d40c400: CPYMN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d408400: CPYMRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d40e400: CPYMRTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMRTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMRTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMRTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMRTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d40a400: CPYMRTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMRTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMRTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMRTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMRTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d406400: CPYMRTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMRTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMRTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMRTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMRTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d402400: CPYMRT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMRT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMRT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMRT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMRT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d40f400: CPYMTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d40b400: CPYMTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d407400: CPYMTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d403400: CPYMT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d404400: CPYMWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d40d400: CPYMWTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMWTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMWTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMWTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMWTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d409400: CPYMWTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMWTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMWTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMWTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMWTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d405400: CPYMWTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMWTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMWTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMWTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMWTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d401400: CPYMWT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYMWT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYMWT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYMWT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYMWT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d400400: CPYM  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYM_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYM_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYM_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYM_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d00c400: CPYPN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d008400: CPYPRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d00e400: CPYPRTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPRTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPRTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPRTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPRTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d00a400: CPYPRTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPRTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPRTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPRTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPRTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d006400: CPYPRTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPRTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPRTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPRTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPRTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d002400: CPYPRT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPRT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPRT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPRT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPRT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d00f400: CPYPTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d00b400: CPYPTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d007400: CPYPTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d003400: CPYPT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d004400: CPYPWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d00d400: CPYPWTN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPWTN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPWTN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPWTN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPWTN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d009400: CPYPWTRN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPWTRN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPWTRN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPWTRN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPWTRN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d005400: CPYPWTWN  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPWTWN_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPWTWN_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPWTWN_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPWTWN_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d001400: CPYPWT  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYPWT_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYPWT_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYPWT_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYPWT_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* 3fe0fc00/1d000400: CPYP  [<Xd>]!, [<Xs>]!, <Xn>!
   Instruction Set: A64  Groups: memcms, ldst */
FNIEMOP_DEF_1(iemDecodeA64_CPYP_CPY_memcms, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 30) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMops /*FEAT_MOPS*/)
    {
        LogFlow(("%018x/%010x: CPYP_CPY_memcms Rd=%#x Rn=%#x Rs=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rs, sz));
#ifdef IEM_INSTR_IMPL_A64__CPYP_CPY_memcms
        IEM_INSTR_IMPL_A64__CPYP_CPY_memcms(Rd, Rn, Rs, sz);
#else
        RT_NOREF(Rd, Rn, Rs, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ac04000: CRC32B  <Wd>, <Wn>, <Wm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CRC32B_32C_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCrc32 /*FEAT_CRC32*/)
    {
        LogFlow(("%018x/%010x: CRC32B_32C_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CRC32B_32C_dp_2src
        IEM_INSTR_IMPL_A64__CRC32B_32C_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ac05000: CRC32CB  <Wd>, <Wn>, <Wm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CRC32CB_32C_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCrc32 /*FEAT_CRC32*/)
    {
        LogFlow(("%018x/%010x: CRC32CB_32C_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CRC32CB_32C_dp_2src
        IEM_INSTR_IMPL_A64__CRC32CB_32C_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ac05400: CRC32CH  <Wd>, <Wn>, <Wm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CRC32CH_32C_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCrc32 /*FEAT_CRC32*/)
    {
        LogFlow(("%018x/%010x: CRC32CH_32C_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CRC32CH_32C_dp_2src
        IEM_INSTR_IMPL_A64__CRC32CH_32C_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ac05800: CRC32CW  <Wd>, <Wn>, <Wm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CRC32CW_32C_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCrc32 /*FEAT_CRC32*/)
    {
        LogFlow(("%018x/%010x: CRC32CW_32C_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CRC32CW_32C_dp_2src
        IEM_INSTR_IMPL_A64__CRC32CW_32C_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/9ac05c00: CRC32CX  <Wd>, <Wn>, <Xm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CRC32CX_64C_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCrc32 /*FEAT_CRC32*/)
    {
        LogFlow(("%018x/%010x: CRC32CX_64C_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CRC32CX_64C_dp_2src
        IEM_INSTR_IMPL_A64__CRC32CX_64C_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ac04400: CRC32H  <Wd>, <Wn>, <Wm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CRC32H_32C_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCrc32 /*FEAT_CRC32*/)
    {
        LogFlow(("%018x/%010x: CRC32H_32C_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CRC32H_32C_dp_2src
        IEM_INSTR_IMPL_A64__CRC32H_32C_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ac04800: CRC32W  <Wd>, <Wn>, <Wm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CRC32W_32C_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCrc32 /*FEAT_CRC32*/)
    {
        LogFlow(("%018x/%010x: CRC32W_32C_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CRC32W_32C_dp_2src
        IEM_INSTR_IMPL_A64__CRC32W_32C_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/9ac04c00: CRC32X  <Wd>, <Wn>, <Xm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CRC32X_64C_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCrc32 /*FEAT_CRC32*/)
    {
        LogFlow(("%018x/%010x: CRC32X_64C_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__CRC32X_64C_dp_2src
        IEM_INSTR_IMPL_A64__CRC32X_64C_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d503229f: CSDB
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_CSDB_HI_hints, uint32_t, uOpcode)
{
    LogFlow(("%018x/%010x: CSDB_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__CSDB_HI_hints
    IEM_INSTR_IMPL_A64__CSDB_HI_hints();
#else
    RT_NOREF(pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c00/1a800000: CSEL  <Wd>, <Wn>, <Wm>, <cond>
   Instruction Set: A64  Groups: condsel, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CSEL_32_condsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CSEL_32_condsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CSEL_32_condsel
    IEM_INSTR_IMPL_A64__CSEL_32_condsel(Rd, Rn, cond, Rm);
#else
    RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c00/9a800000: CSEL  <Xd>, <Xn>, <Xm>, <cond>
   Instruction Set: A64  Groups: condsel, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CSEL_64_condsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CSEL_64_condsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CSEL_64_condsel
    IEM_INSTR_IMPL_A64__CSEL_64_condsel(Rd, Rn, cond, Rm);
#else
    RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c00/1a800400: CSINC  <Wd>, <Wn>, <Wm>, <cond>
   Instruction Set: A64  Groups: condsel, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CSINC_32_condsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CSINC_32_condsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CSINC_32_condsel
    IEM_INSTR_IMPL_A64__CSINC_32_condsel(Rd, Rn, cond, Rm);
#else
    RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c00/9a800400: CSINC  <Xd>, <Xn>, <Xm>, <cond>
   Instruction Set: A64  Groups: condsel, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CSINC_64_condsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CSINC_64_condsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CSINC_64_condsel
    IEM_INSTR_IMPL_A64__CSINC_64_condsel(Rd, Rn, cond, Rm);
#else
    RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c00/5a800000: CSINV  <Wd>, <Wn>, <Wm>, <cond>
   Instruction Set: A64  Groups: condsel, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CSINV_32_condsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CSINV_32_condsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CSINV_32_condsel
    IEM_INSTR_IMPL_A64__CSINV_32_condsel(Rd, Rn, cond, Rm);
#else
    RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c00/da800000: CSINV  <Xd>, <Xn>, <Xm>, <cond>
   Instruction Set: A64  Groups: condsel, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CSINV_64_condsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CSINV_64_condsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CSINV_64_condsel
    IEM_INSTR_IMPL_A64__CSINV_64_condsel(Rd, Rn, cond, Rm);
#else
    RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c00/5a800400: CSNEG  <Wd>, <Wn>, <Wm>, <cond>
   Instruction Set: A64  Groups: condsel, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CSNEG_32_condsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CSNEG_32_condsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CSNEG_32_condsel
    IEM_INSTR_IMPL_A64__CSNEG_32_condsel(Rd, Rn, cond, Rm);
#else
    RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00c00/da800400: CSNEG  <Xd>, <Xn>, <Xm>, <cond>
   Instruction Set: A64  Groups: condsel, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CSNEG_64_condsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: CSNEG_64_condsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__CSNEG_64_condsel
    IEM_INSTR_IMPL_A64__CSNEG_64_condsel(Rd, Rn, cond, Rm);
#else
    RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* fffffc00/5ac01800: CTZ  <Wd>, <Wn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CTZ_32_dp_1src, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ac01800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCssc /*FEAT_CSSC*/)
        {
            LogFlow(("%018x/%010x: CTZ_32_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CTZ_32_dp_1src
            IEM_INSTR_IMPL_A64__CTZ_32_dp_1src(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/dac01800: CTZ  <Xd>, <Xn>
   Instruction Set: A64  Groups: dp_1src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_CTZ_64_dp_1src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fCssc /*FEAT_CSSC*/)
    {
        LogFlow(("%018x/%010x: CTZ_64_dp_1src Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__CTZ_64_dp_1src
        IEM_INSTR_IMPL_A64__CTZ_64_dp_1src(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0001f/d4a00001: DCPS1{  #<imm>}
   Instruction Set: A64  Groups: exception, control */
FNIEMOP_DEF_1(iemDecodeA64_DCPS1_DC_exception, uint32_t, uOpcode)
{
    uint32_t const imm16      = (uOpcode >>  5) & 0x0000ffff;
    LogFlow(("%018x/%010x: DCPS1_DC_exception imm16=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm16));
#ifdef IEM_INSTR_IMPL_A64__DCPS1_DC_exception
    IEM_INSTR_IMPL_A64__DCPS1_DC_exception(imm16);
#else
    RT_NOREF(imm16, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe0001f/d4a00002: DCPS2{  #<imm>}
   Instruction Set: A64  Groups: exception, control */
FNIEMOP_DEF_1(iemDecodeA64_DCPS2_DC_exception, uint32_t, uOpcode)
{
    uint32_t const imm16      = (uOpcode >>  5) & 0x0000ffff;
    LogFlow(("%018x/%010x: DCPS2_DC_exception imm16=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm16));
#ifdef IEM_INSTR_IMPL_A64__DCPS2_DC_exception
    IEM_INSTR_IMPL_A64__DCPS2_DC_exception(imm16);
#else
    RT_NOREF(imm16, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe0001f/d4a00003: DCPS3{  #<imm>}
   Instruction Set: A64  Groups: exception, control */
FNIEMOP_DEF_1(iemDecodeA64_DCPS3_DC_exception, uint32_t, uOpcode)
{
    uint32_t const imm16      = (uOpcode >>  5) & 0x0000ffff;
    LogFlow(("%018x/%010x: DCPS3_DC_exception imm16=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm16));
#ifdef IEM_INSTR_IMPL_A64__DCPS3_DC_exception
    IEM_INSTR_IMPL_A64__DCPS3_DC_exception(imm16);
#else
    RT_NOREF(imm16, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffffffff/d50320df: DGH
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_DGH_HI_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fDgh /*FEAT_DGH*/)
    {
        LogFlow(("%018x/%010x: DGH_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__DGH_HI_hints
        IEM_INSTR_IMPL_A64__DGH_HI_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffff0ff/d50330bf: DMB  {<option> | #<imm>}
   Instruction Set: A64  Groups: barriers, control */
FNIEMOP_DEF_1(iemDecodeA64_DMB_BO_barriers, uint32_t, uOpcode)
{
    uint32_t const CRm        = (uOpcode >>  8) & 0x0000000f;
    LogFlow(("%018x/%010x: DMB_BO_barriers CRm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, CRm));
#ifdef IEM_INSTR_IMPL_A64__DMB_BO_barriers
    IEM_INSTR_IMPL_A64__DMB_BO_barriers(CRm);
#else
    RT_NOREF(CRm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffffffff/d6bf03e0: DRPS
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_DRPS_64E_branch_reg, uint32_t, uOpcode)
{
    LogFlow(("%018x/%010x: DRPS_64E_branch_reg\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__DRPS_64E_branch_reg
    IEM_INSTR_IMPL_A64__DRPS_64E_branch_reg();
#else
    RT_NOREF(pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* fffff0ff/d503309f: DSB  {<option> | #<imm>}
   Instruction Set: A64  Groups: barriers, control */
FNIEMOP_DEF_1(iemDecodeA64_DSB_BO_barriers, uint32_t, uOpcode)
{
    uint32_t const CRm        = (uOpcode >>  8) & 0x0000000f;
    LogFlow(("%018x/%010x: DSB_BO_barriers CRm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, CRm));
#ifdef IEM_INSTR_IMPL_A64__DSB_BO_barriers
    IEM_INSTR_IMPL_A64__DSB_BO_barriers(CRm);
#else
    RT_NOREF(CRm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* fffff3ff/d503323f: DSB  <option>nXS
   Instruction Set: A64  Groups: barriers, control */
FNIEMOP_DEF_1(iemDecodeA64_DSB_BOn_barriers, uint32_t, uOpcode)
{
    uint32_t const imm2       = (uOpcode >> 10) & 0x00000003;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fXs /*FEAT_XS*/)
    {
        LogFlow(("%018x/%010x: DSB_BOn_barriers imm2=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm2));
#ifdef IEM_INSTR_IMPL_A64__DSB_BOn_barriers
        IEM_INSTR_IMPL_A64__DSB_BOn_barriers(imm2);
#else
        RT_NOREF(imm2, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e000c00: DUP  <Vd>.<T>, <R><n>
   Instruction Set: A64  Groups: asimdins, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_DUP_asimdins_DR_r, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm5       = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: DUP_asimdins_DR_r Rd=%#x Rn=%#x imm5=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm5, Q));
#ifdef IEM_INSTR_IMPL_A64__DUP_asimdins_DR_r
        IEM_INSTR_IMPL_A64__DUP_asimdins_DR_r(Rd, Rn, imm5, Q);
#else
        RT_NOREF(Rd, Rn, imm5, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e000400: DUP  <Vd>.<T>, <Vn>.<Ts>[<index>]
   Instruction Set: A64  Groups: asimdins, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_DUP_asimdins_DV_v, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm5       = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: DUP_asimdins_DV_v Rd=%#x Rn=%#x imm5=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm5, Q));
#ifdef IEM_INSTR_IMPL_A64__DUP_asimdins_DV_v
        IEM_INSTR_IMPL_A64__DUP_asimdins_DV_v(Rd, Rn, imm5, Q);
#else
        RT_NOREF(Rd, Rn, imm5, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/5e000400: DUP  <V><d>, <Vn>.<T>[<index>]
   Instruction Set: A64  Groups: asisdone, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_DUP_asisdone_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x5e000400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imm5       = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: DUP_asisdone_only Rd=%#x Rn=%#x imm5=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm5));
#ifdef IEM_INSTR_IMPL_A64__DUP_asisdone_only
            IEM_INSTR_IMPL_A64__DUP_asisdone_only(Rd, Rn, imm5);
#else
            RT_NOREF(Rd, Rn, imm5, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff200000/4a200000: EON  <Wd>, <Wn>, <Wm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_EON_32_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: EON_32_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__EON_32_log_shift
    IEM_INSTR_IMPL_A64__EON_32_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/ca200000: EON  <Xd>, <Xn>, <Xm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_EON_64_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: EON_64_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__EON_64_log_shift
    IEM_INSTR_IMPL_A64__EON_64_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe08000/ce000000: EOR3  <Vd>.16B, <Vn>.16B, <Vm>.16B, <Va>.16B
   Instruction Set: A64  Groups: crypto4, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_EOR3_VVV16_crypto4, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe08000)) == UINT32_C(0xce000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fSha3 /*FEAT_SHA3*/)
        {
            LogFlow(("%018x/%010x: EOR3_VVV16_crypto4 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__EOR3_VVV16_crypto4
            IEM_INSTR_IMPL_A64__EOR3_VVV16_crypto4(Rd, Rn, Ra, Rm);
#else
            RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc00000/52000000: EOR  <Wd|WSP>, <Wn>, #<imm>
   Instruction Set: A64  Groups: log_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_EOR_32_log_imm, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc00000)) == UINT32_C(0x52000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
        uint32_t const immr       = (uOpcode >> 16) & 0x0000003f;
        LogFlow(("%018x/%010x: EOR_32_log_imm Rd=%#x Rn=%#x imms=%#x immr=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, immr));
#ifdef IEM_INSTR_IMPL_A64__EOR_32_log_imm
        IEM_INSTR_IMPL_A64__EOR_32_log_imm(Rd, Rn, imms, immr);
#else
        RT_NOREF(Rd, Rn, imms, immr, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff200000/4a000000: EOR  <Wd>, <Wn>, <Wm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_EOR_32_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: EOR_32_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__EOR_32_log_shift
    IEM_INSTR_IMPL_A64__EOR_32_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff800000/d2000000: EOR  <Xd|SP>, <Xn>, #<imm>
   Instruction Set: A64  Groups: log_imm, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_EOR_64_log_imm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const immr       = (uOpcode >> 16) & 0x0000003f;
    uint32_t const N          = (uOpcode >> 22) & 0x00000001;
    LogFlow(("%018x/%010x: EOR_64_log_imm Rd=%#x Rn=%#x imms=%#x immr=%#x N=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, immr, N));
#ifdef IEM_INSTR_IMPL_A64__EOR_64_log_imm
    IEM_INSTR_IMPL_A64__EOR_64_log_imm(Rd, Rn, imms, immr, N);
#else
    RT_NOREF(Rd, Rn, imms, immr, N, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ff200000/ca000000: EOR  <Xd>, <Xn>, <Xm>{, <shift> #<amount>}
   Instruction Set: A64  Groups: log_shift, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_EOR_64_log_shift, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm6       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const shift      = (uOpcode >> 22) & 0x00000003;
    LogFlow(("%018x/%010x: EOR_64_log_shift Rd=%#x Rn=%#x imm6=%#x Rm=%#x shift=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm6, Rm, shift));
#ifdef IEM_INSTR_IMPL_A64__EOR_64_log_shift
    IEM_INSTR_IMPL_A64__EOR_64_log_shift(Rd, Rn, imm6, Rm, shift);
#else
    RT_NOREF(Rd, Rn, imm6, Rm, shift, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* bfe0fc00/2e201c00: EOR  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_EOR_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e201c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: EOR_asimdsame_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__EOR_asimdsame_only
            IEM_INSTR_IMPL_A64__EOR_asimdsame_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d69f0bff: ERETAA
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_ERETAA_64E_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffffffff)) == UINT32_C(0xd69f0bff))
    {
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: ERETAA_64E_branch_reg\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__ERETAA_64E_branch_reg
            IEM_INSTR_IMPL_A64__ERETAA_64E_branch_reg();
#else
            RT_NOREF(pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d69f0fff: ERETAB
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_ERETAB_64E_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffffffff)) == UINT32_C(0xd69f0fff))
    {
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fPAuth /*FEAT_PAuth*/)
        {
            LogFlow(("%018x/%010x: ERETAB_64E_branch_reg\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__ERETAB_64E_branch_reg
            IEM_INSTR_IMPL_A64__ERETAB_64E_branch_reg();
#else
            RT_NOREF(pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d69f03e0: ERET
   Instruction Set: A64  Groups: branch_reg, control */
FNIEMOP_DEF_1(iemDecodeA64_ERET_64E_branch_reg, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffffffff)) == UINT32_C(0xd69f03e0))
    {
        LogFlow(("%018x/%010x: ERET_64E_branch_reg\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__ERET_64E_branch_reg
        IEM_INSTR_IMPL_A64__ERET_64E_branch_reg();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d503221f: ESB
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_ESB_HI_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fRas /*FEAT_RAS*/)
    {
        LogFlow(("%018x/%010x: ESB_HI_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__ESB_HI_hints
        IEM_INSTR_IMPL_A64__ESB_HI_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/13800000: EXTR  <Wd>, <Wn>, <Wm>, #<lsb>
   Instruction Set: A64  Groups: extract, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_EXTR_32_extract, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    LogFlow(("%018x/%010x: EXTR_32_extract Rd=%#x Rn=%#x imms=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, Rm));
#ifdef IEM_INSTR_IMPL_A64__EXTR_32_extract
    IEM_INSTR_IMPL_A64__EXTR_32_extract(Rd, Rn, imms, Rm);
#else
    RT_NOREF(Rd, Rn, imms, Rm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe00000/93c00000: EXTR  <Xd>, <Xn>, <Xm>, #<lsb>
   Instruction Set: A64  Groups: extract, dpimm */
FNIEMOP_DEF_1(iemDecodeA64_EXTR_64_extract, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe00000)) == UINT32_C(0x93c00000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imms       = (uOpcode >> 10) & 0x0000003f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        LogFlow(("%018x/%010x: EXTR_64_extract Rd=%#x Rn=%#x imms=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imms, Rm));
#ifdef IEM_INSTR_IMPL_A64__EXTR_64_extract
        IEM_INSTR_IMPL_A64__EXTR_64_extract(Rd, Rn, imms, Rm);
#else
        RT_NOREF(Rd, Rn, imms, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe08400/2e000000: EXT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>, #<index>
   Instruction Set: A64  Groups: asimdext, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_EXT_asimdext_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe08400)) == UINT32_C(0x2e000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imm4       = (uOpcode >> 11) & 0x0000000f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: EXT_asimdext_only Rd=%#x Rn=%#x imm4=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm4, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__EXT_asimdext_only
            IEM_INSTR_IMPL_A64__EXT_asimdext_only(Rd, Rn, imm4, Rm, Q);
#else
            RT_NOREF(Rd, Rn, imm4, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2e217800: F1CVTL2  <Vd>.8H, <Vn>.<Ta>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_F1CVTL_asimdmisc_V, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8 /*FEAT_FP8*/)
    {
        LogFlow(("%018x/%010x: F1CVTL_asimdmisc_V Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__F1CVTL_asimdmisc_V
        IEM_INSTR_IMPL_A64__F1CVTL_asimdmisc_V(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2e617800: F2CVTL2  <Vd>.8H, <Vn>.<Ta>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_F2CVTL_asimdmisc_V, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8 /*FEAT_FP8*/)
    {
        LogFlow(("%018x/%010x: F2CVTL_asimdmisc_V Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__F2CVTL_asimdmisc_V
        IEM_INSTR_IMPL_A64__F2CVTL_asimdmisc_V(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2ea0d400: FABD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FABD_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FABD_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FABD_asimdsame_only
        IEM_INSTR_IMPL_A64__FABD_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ec01400: FABD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FABD_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2ec01400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FABD_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FABD_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FABD_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffa0fc00/7ea0d400: FABD  <V><d>, <V><n>, <V><m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FABD_asisdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffa0fc00)) == UINT32_C(0x7ea0d400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FABD_asisdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz));
#ifdef IEM_INSTR_IMPL_A64__FABD_asisdsame_only
            IEM_INSTR_IMPL_A64__FABD_asisdsame_only(Rd, Rn, Rm, sz);
#else
            RT_NOREF(Rd, Rn, Rm, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/7ec01400: FABD  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: asisdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FABD_asisdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x7ec01400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FABD_asisdsamefp16_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FABD_asisdsamefp16_only
            IEM_INSTR_IMPL_A64__FABD_asisdsamefp16_only(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e60c000: FABS  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FABS_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FABS_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FABS_D_floatdp1
        IEM_INSTR_IMPL_A64__FABS_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee0c000: FABS  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FABS_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FABS_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FABS_H_floatdp1
        IEM_INSTR_IMPL_A64__FABS_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e20c000: FABS  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FABS_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FABS_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FABS_S_floatdp1
        IEM_INSTR_IMPL_A64__FABS_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0ea0f800: FABS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FABS_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FABS_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FABS_asimdmisc_R
        IEM_INSTR_IMPL_A64__FABS_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ef8f800: FABS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FABS_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FABS_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FABS_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FABS_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2e20ec00: FACGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FACGE_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x2e20ec00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FACGE_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FACGE_asimdsame_only
            IEM_INSTR_IMPL_A64__FACGE_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e402c00: FACGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FACGE_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e402c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FACGE_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FACGE_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FACGE_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffa0fc00/7e20ec00: FACGE  <V><d>, <V><n>, <V><m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FACGE_asisdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffa0fc00)) == UINT32_C(0x7e20ec00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FACGE_asisdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz));
#ifdef IEM_INSTR_IMPL_A64__FACGE_asisdsame_only
            IEM_INSTR_IMPL_A64__FACGE_asisdsame_only(Rd, Rn, Rm, sz);
#else
            RT_NOREF(Rd, Rn, Rm, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/7e402c00: FACGE  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: asisdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FACGE_asisdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x7e402c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FACGE_asisdsamefp16_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FACGE_asisdsamefp16_only
            IEM_INSTR_IMPL_A64__FACGE_asisdsamefp16_only(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2ea0ec00: FACGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FACGT_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x2ea0ec00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FACGT_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FACGT_asimdsame_only
            IEM_INSTR_IMPL_A64__FACGT_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ec02c00: FACGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FACGT_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2ec02c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FACGT_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FACGT_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FACGT_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffa0fc00/7ea0ec00: FACGT  <V><d>, <V><n>, <V><m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FACGT_asisdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffa0fc00)) == UINT32_C(0x7ea0ec00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FACGT_asisdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz));
#ifdef IEM_INSTR_IMPL_A64__FACGT_asisdsame_only
            IEM_INSTR_IMPL_A64__FACGT_asisdsame_only(Rd, Rn, Rm, sz);
#else
            RT_NOREF(Rd, Rn, Rm, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/7ec02c00: FACGT  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: asisdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FACGT_asisdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x7ec02c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FACGT_asisdsamefp16_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FACGT_asisdsamefp16_only
            IEM_INSTR_IMPL_A64__FACGT_asisdsamefp16_only(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2e20d400: FADDP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FADDP_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x2e20d400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FADDP_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FADDP_asimdsame_only
            IEM_INSTR_IMPL_A64__FADDP_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e401400: FADDP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FADDP_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e401400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FADDP_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FADDP_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FADDP_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5e30d800: FADDP  H<d>, <Vn>.2H
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FADDP_asisdpair_only_H, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5e30d800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FADDP_asisdpair_only_H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FADDP_asisdpair_only_H
            IEM_INSTR_IMPL_A64__FADDP_asisdpair_only_H(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7e30d800: FADDP  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FADDP_asisdpair_only_SD, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffbffc00)) == UINT32_C(0x7e30d800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FADDP_asisdpair_only_SD Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FADDP_asisdpair_only_SD
            IEM_INSTR_IMPL_A64__FADDP_asisdpair_only_SD(Rd, Rn, sz);
#else
            RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e602800: FADD  <Dd>, <Dn>, <Dm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FADD_D_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e602800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FADD_D_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FADD_D_floatdp2
            IEM_INSTR_IMPL_A64__FADD_D_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ee02800: FADD  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FADD_H_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1ee02800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FADD_H_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FADD_H_floatdp2
            IEM_INSTR_IMPL_A64__FADD_H_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e202800: FADD  <Sd>, <Sn>, <Sm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FADD_S_floatdp2, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FADD_S_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FADD_S_floatdp2
        IEM_INSTR_IMPL_A64__FADD_S_floatdp2(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0e20d400: FADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FADD_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x0e20d400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FADD_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FADD_asimdsame_only
            IEM_INSTR_IMPL_A64__FADD_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e401400: FADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FADD_asimdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FADD_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FADD_asimdsamefp16_only
        IEM_INSTR_IMPL_A64__FADD_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/0e20dc00: FAMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FAMAX_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf20fc00)) == UINT32_C(0x0e20dc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFaMinMax /*FEAT_FAMINMAX*/
            && (size & 2) == 2)
        {
            LogFlow(("%018x/%010x: FAMAX_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__FAMAX_asimdsame_only
            IEM_INSTR_IMPL_A64__FAMAX_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
            RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0ec01c00: FAMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FAMAX_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0ec01c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFaMinMax /*FEAT_FAMINMAX*/)
        {
            LogFlow(("%018x/%010x: FAMAX_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FAMAX_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FAMAX_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/2e20dc00: FAMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FAMIN_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf20fc00)) == UINT32_C(0x2e20dc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFaMinMax /*FEAT_FAMINMAX*/
            && (size & 2) == 2)
        {
            LogFlow(("%018x/%010x: FAMIN_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__FAMIN_asimdsame_only
            IEM_INSTR_IMPL_A64__FAMIN_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
            RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ec01c00: FAMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FAMIN_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2ec01c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFaMinMax /*FEAT_FAMINMAX*/)
        {
            LogFlow(("%018x/%010x: FAMIN_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FAMIN_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FAMIN_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20ec00/2e00e400: FCADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>, #<rotate>
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCADD_asimdsame2_C, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf20ec00)) == UINT32_C(0x2e00e400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const rot        = (uOpcode >> 12) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFcma /*FEAT_FCMA*/)
        {
            LogFlow(("%018x/%010x: FCADD_asimdsame2_C Rd=%#x Rn=%#x rot=%u Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, rot, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__FCADD_asimdsame2_C
            IEM_INSTR_IMPL_A64__FCADD_asimdsame2_C(Rd, Rn, rot, Rm, size, Q);
#else
            RT_NOREF(Rd, Rn, rot, Rm, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/1e600410: FCCMPE  <Dn>, <Dm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: floatccmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCCMPE_D_floatccmp, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCCMPE_D_floatccmp nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCCMPE_D_floatccmp
        IEM_INSTR_IMPL_A64__FCCMPE_D_floatccmp(nzcv, Rn, cond, Rm);
#else
        RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/1ee00410: FCCMPE  <Hn>, <Hm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: floatccmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCCMPE_H_floatccmp, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCCMPE_H_floatccmp nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCCMPE_H_floatccmp
        IEM_INSTR_IMPL_A64__FCCMPE_H_floatccmp(nzcv, Rn, cond, Rm);
#else
        RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/1e200410: FCCMPE  <Sn>, <Sm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: floatccmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCCMPE_S_floatccmp, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCCMPE_S_floatccmp nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCCMPE_S_floatccmp
        IEM_INSTR_IMPL_A64__FCCMPE_S_floatccmp(nzcv, Rn, cond, Rm);
#else
        RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/1e600400: FCCMP  <Dn>, <Dm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: floatccmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCCMP_D_floatccmp, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCCMP_D_floatccmp nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCCMP_D_floatccmp
        IEM_INSTR_IMPL_A64__FCCMP_D_floatccmp(nzcv, Rn, cond, Rm);
#else
        RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/1ee00400: FCCMP  <Hn>, <Hm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: floatccmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCCMP_H_floatccmp, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCCMP_H_floatccmp nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCCMP_H_floatccmp
        IEM_INSTR_IMPL_A64__FCCMP_H_floatccmp(nzcv, Rn, cond, Rm);
#else
        RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c10/1e200400: FCCMP  <Sn>, <Sm>, #<nzcv>, <cond>
   Instruction Set: A64  Groups: floatccmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCCMP_S_floatccmp, uint32_t, uOpcode)
{
    uint32_t const nzcv       = (uOpcode >>  0) & 0x0000000f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCCMP_S_floatccmp nzcv=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, nzcv, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCCMP_S_floatccmp
        IEM_INSTR_IMPL_A64__FCCMP_S_floatccmp(nzcv, Rn, cond, Rm);
#else
        RT_NOREF(nzcv, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0ea0d800: FCMEQ  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMEQ_asimdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMEQ_asimdmisc_FZ Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMEQ_asimdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMEQ_asimdmisc_FZ(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ef8d800: FCMEQ  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMEQ_asimdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMEQ_asimdmiscfp16_FZ Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMEQ_asimdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMEQ_asimdmiscfp16_FZ(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0e20e400: FCMEQ  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMEQ_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMEQ_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMEQ_asimdsame_only
        IEM_INSTR_IMPL_A64__FCMEQ_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e402400: FCMEQ  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMEQ_asimdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMEQ_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMEQ_asimdsamefp16_only
        IEM_INSTR_IMPL_A64__FCMEQ_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5ea0d800: FCMEQ  <V><d>, <V><n>, #0.0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMEQ_asisdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMEQ_asisdmisc_FZ Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCMEQ_asisdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMEQ_asisdmisc_FZ(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ef8d800: FCMEQ  <Hd>, <Hn>, #0.0
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMEQ_asisdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMEQ_asisdmiscfp16_FZ Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMEQ_asisdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMEQ_asisdmiscfp16_FZ(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffa0fc00/5e20e400: FCMEQ  <V><d>, <V><n>, <V><m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMEQ_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMEQ_asisdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz));
#ifdef IEM_INSTR_IMPL_A64__FCMEQ_asisdsame_only
        IEM_INSTR_IMPL_A64__FCMEQ_asisdsame_only(Rd, Rn, Rm, sz);
#else
        RT_NOREF(Rd, Rn, Rm, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/5e402400: FCMEQ  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: asisdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMEQ_asisdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMEQ_asisdsamefp16_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCMEQ_asisdsamefp16_only
        IEM_INSTR_IMPL_A64__FCMEQ_asisdsamefp16_only(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2ea0c800: FCMGE  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGE_asimdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMGE_asimdmisc_FZ Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMGE_asimdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMGE_asimdmisc_FZ(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ef8c800: FCMGE  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGE_asimdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMGE_asimdmiscfp16_FZ Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMGE_asimdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMGE_asimdmiscfp16_FZ(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2e20e400: FCMGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGE_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMGE_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMGE_asimdsame_only
        IEM_INSTR_IMPL_A64__FCMGE_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e402400: FCMGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGE_asimdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMGE_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMGE_asimdsamefp16_only
        IEM_INSTR_IMPL_A64__FCMGE_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7ea0c800: FCMGE  <V><d>, <V><n>, #0.0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGE_asisdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMGE_asisdmisc_FZ Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCMGE_asisdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMGE_asisdmisc_FZ(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7ef8c800: FCMGE  <Hd>, <Hn>, #0.0
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGE_asisdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMGE_asisdmiscfp16_FZ Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMGE_asisdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMGE_asisdmiscfp16_FZ(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffa0fc00/7e20e400: FCMGE  <V><d>, <V><n>, <V><m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGE_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMGE_asisdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz));
#ifdef IEM_INSTR_IMPL_A64__FCMGE_asisdsame_only
        IEM_INSTR_IMPL_A64__FCMGE_asisdsame_only(Rd, Rn, Rm, sz);
#else
        RT_NOREF(Rd, Rn, Rm, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/7e402400: FCMGE  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: asisdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGE_asisdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMGE_asisdsamefp16_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCMGE_asisdsamefp16_only
        IEM_INSTR_IMPL_A64__FCMGE_asisdsamefp16_only(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0ea0c800: FCMGT  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGT_asimdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMGT_asimdmisc_FZ Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMGT_asimdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMGT_asimdmisc_FZ(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ef8c800: FCMGT  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGT_asimdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMGT_asimdmiscfp16_FZ Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMGT_asimdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMGT_asimdmiscfp16_FZ(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2ea0e400: FCMGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGT_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x2ea0e400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCMGT_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMGT_asimdsame_only
            IEM_INSTR_IMPL_A64__FCMGT_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ec02400: FCMGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGT_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2ec02400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCMGT_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMGT_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FCMGT_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5ea0c800: FCMGT  <V><d>, <V><n>, #0.0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGT_asisdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMGT_asisdmisc_FZ Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCMGT_asisdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMGT_asisdmisc_FZ(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ef8c800: FCMGT  <Hd>, <Hn>, #0.0
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGT_asisdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMGT_asisdmiscfp16_FZ Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMGT_asisdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMGT_asisdmiscfp16_FZ(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffa0fc00/7ea0e400: FCMGT  <V><d>, <V><n>, <V><m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGT_asisdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffa0fc00)) == UINT32_C(0x7ea0e400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCMGT_asisdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz));
#ifdef IEM_INSTR_IMPL_A64__FCMGT_asisdsame_only
            IEM_INSTR_IMPL_A64__FCMGT_asisdsame_only(Rd, Rn, Rm, sz);
#else
            RT_NOREF(Rd, Rn, Rm, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/7ec02400: FCMGT  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: asisdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMGT_asisdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x7ec02400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCMGT_asisdsamefp16_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCMGT_asisdsamefp16_only
            IEM_INSTR_IMPL_A64__FCMGT_asisdsamefp16_only(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf009400/2f001000: FCMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>], #<rotate>
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLA_advsimd_elt, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf009400)) == UINT32_C(0x2f001000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const rot        = (uOpcode >> 13) & 0x00000003;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFcma /*FEAT_FCMA*/)
        {
            LogFlow(("%018x/%010x: FCMLA_advsimd_elt Rd=%#x Rn=%#x H=%u rot=%u Rm=%#x M=%u L=%u size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, rot, Rm, M, L, size, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMLA_advsimd_elt
            IEM_INSTR_IMPL_A64__FCMLA_advsimd_elt(Rd, Rn, H, rot, Rm, M, L, size, Q);
#else
            RT_NOREF(Rd, Rn, H, rot, Rm, M, L, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20e400/2e00c400: FCMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>, #<rotate>
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLA_asimdsame2_C, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf20e400)) == UINT32_C(0x2e00c400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const rot        = (uOpcode >> 11) & 0x00000003;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFcma /*FEAT_FCMA*/)
        {
            LogFlow(("%018x/%010x: FCMLA_asimdsame2_C Rd=%#x Rn=%#x rot=%u Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, rot, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMLA_asimdsame2_C
            IEM_INSTR_IMPL_A64__FCMLA_asimdsame2_C(Rd, Rn, rot, Rm, size, Q);
#else
            RT_NOREF(Rd, Rn, rot, Rm, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2ea0d800: FCMLE  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLE_asimdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMLE_asimdmisc_FZ Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMLE_asimdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMLE_asimdmisc_FZ(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ef8d800: FCMLE  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLE_asimdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMLE_asimdmiscfp16_FZ Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMLE_asimdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMLE_asimdmiscfp16_FZ(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7ea0d800: FCMLE  <V><d>, <V><n>, #0.0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLE_asisdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMLE_asisdmisc_FZ Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCMLE_asisdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMLE_asisdmisc_FZ(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7ef8d800: FCMLE  <Hd>, <Hn>, #0.0
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLE_asisdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMLE_asisdmiscfp16_FZ Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMLE_asisdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMLE_asisdmiscfp16_FZ(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0ea0e800: FCMLT  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLT_asimdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMLT_asimdmisc_FZ Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMLT_asimdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMLT_asimdmisc_FZ(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ef8e800: FCMLT  <Vd>.<T>, <Vn>.<T>, #0.0
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLT_asimdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMLT_asimdmiscfp16_FZ Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCMLT_asimdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMLT_asimdmiscfp16_FZ(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5ea0e800: FCMLT  <V><d>, <V><n>, #0.0
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLT_asisdmisc_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCMLT_asisdmisc_FZ Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCMLT_asisdmisc_FZ
        IEM_INSTR_IMPL_A64__FCMLT_asisdmisc_FZ(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ef8e800: FCMLT  <Hd>, <Hn>, #0.0
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMLT_asisdmiscfp16_FZ, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMLT_asisdmiscfp16_FZ Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMLT_asisdmiscfp16_FZ
        IEM_INSTR_IMPL_A64__FCMLT_asisdmiscfp16_FZ(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/1e602018: FCMPE  <Dn>, #0.0
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMPE_DZ_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCMPE_DZ_floatcmp Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMPE_DZ_floatcmp
        IEM_INSTR_IMPL_A64__FCMPE_DZ_floatcmp(Rn);
#else
        RT_NOREF(Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc1f/1e602010: FCMPE  <Dn>, <Dm>
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMPE_D_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCMPE_D_floatcmp Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCMPE_D_floatcmp
        IEM_INSTR_IMPL_A64__FCMPE_D_floatcmp(Rn, Rm);
#else
        RT_NOREF(Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/1ee02018: FCMPE  <Hn>, #0.0
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMPE_HZ_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMPE_HZ_floatcmp Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMPE_HZ_floatcmp
        IEM_INSTR_IMPL_A64__FCMPE_HZ_floatcmp(Rn);
#else
        RT_NOREF(Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc1f/1ee02010: FCMPE  <Hn>, <Hm>
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMPE_H_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMPE_H_floatcmp Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCMPE_H_floatcmp
        IEM_INSTR_IMPL_A64__FCMPE_H_floatcmp(Rn, Rm);
#else
        RT_NOREF(Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/1e202018: FCMPE  <Sn>, #0.0
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMPE_SZ_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCMPE_SZ_floatcmp Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMPE_SZ_floatcmp
        IEM_INSTR_IMPL_A64__FCMPE_SZ_floatcmp(Rn);
#else
        RT_NOREF(Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc1f/1e202010: FCMPE  <Sn>, <Sm>
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMPE_S_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCMPE_S_floatcmp Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCMPE_S_floatcmp
        IEM_INSTR_IMPL_A64__FCMPE_S_floatcmp(Rn, Rm);
#else
        RT_NOREF(Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/1e602008: FCMP  <Dn>, #0.0
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMP_DZ_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCMP_DZ_floatcmp Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMP_DZ_floatcmp
        IEM_INSTR_IMPL_A64__FCMP_DZ_floatcmp(Rn);
#else
        RT_NOREF(Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc1f/1e602000: FCMP  <Dn>, <Dm>
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMP_D_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCMP_D_floatcmp Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCMP_D_floatcmp
        IEM_INSTR_IMPL_A64__FCMP_D_floatcmp(Rn, Rm);
#else
        RT_NOREF(Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/1ee02008: FCMP  <Hn>, #0.0
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMP_HZ_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMP_HZ_floatcmp Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMP_HZ_floatcmp
        IEM_INSTR_IMPL_A64__FCMP_HZ_floatcmp(Rn);
#else
        RT_NOREF(Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc1f/1ee02000: FCMP  <Hn>, <Hm>
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMP_H_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCMP_H_floatcmp Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCMP_H_floatcmp
        IEM_INSTR_IMPL_A64__FCMP_H_floatcmp(Rn, Rm);
#else
        RT_NOREF(Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc1f/1e202008: FCMP  <Sn>, #0.0
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMP_SZ_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCMP_SZ_floatcmp Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCMP_SZ_floatcmp
        IEM_INSTR_IMPL_A64__FCMP_SZ_floatcmp(Rn);
#else
        RT_NOREF(Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc1f/1e202000: FCMP  <Sn>, <Sm>
   Instruction Set: A64  Groups: floatcmp, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCMP_S_floatcmp, uint32_t, uOpcode)
{
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCMP_S_floatcmp Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCMP_S_floatcmp
        IEM_INSTR_IMPL_A64__FCMP_S_floatcmp(Rn, Rm);
#else
        RT_NOREF(Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/1e600c00: FCSEL  <Dd>, <Dn>, <Dm>, <cond>
   Instruction Set: A64  Groups: floatsel, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCSEL_D_floatsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCSEL_D_floatsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCSEL_D_floatsel
        IEM_INSTR_IMPL_A64__FCSEL_D_floatsel(Rd, Rn, cond, Rm);
#else
        RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/1ee00c00: FCSEL  <Hd>, <Hn>, <Hm>, <cond>
   Instruction Set: A64  Groups: floatsel, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCSEL_H_floatsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCSEL_H_floatsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCSEL_H_floatsel
        IEM_INSTR_IMPL_A64__FCSEL_H_floatsel(Rd, Rn, cond, Rm);
#else
        RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/1e200c00: FCSEL  <Sd>, <Sn>, <Sm>, <cond>
   Instruction Set: A64  Groups: floatsel, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCSEL_S_floatsel, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const cond       = (uOpcode >> 12) & 0x0000000f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCSEL_S_floatsel Rd=%#x Rn=%#x cond=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, cond, Rm));
#ifdef IEM_INSTR_IMPL_A64__FCSEL_S_floatsel
        IEM_INSTR_IMPL_A64__FCSEL_S_floatsel(Rd, Rn, cond, Rm);
#else
        RT_NOREF(Rd, Rn, cond, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e640000: FCVTAS  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTAS_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee40000: FCVTAS  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTAS_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e240000: FCVTAS  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTAS_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e640000: FCVTAS  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTAS_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ee40000: FCVTAS  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTAS_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e240000: FCVTAS  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTAS_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0e21c800: FCVTAS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_asimdmisc_R
        IEM_INSTR_IMPL_A64__FCVTAS_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0e79c800: FCVTAS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTAS_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5e21c800: FCVTAS  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_asisdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffbffc00)) == UINT32_C(0x5e21c800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCVTAS_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_asisdmisc_R
            IEM_INSTR_IMPL_A64__FCVTAS_asisdmisc_R(Rd, Rn, sz);
#else
            RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5e79c800: FCVTAS  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_asisdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5e79c800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCVTAS_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_asisdmiscfp16_R
            IEM_INSTR_IMPL_A64__FCVTAS_asisdmiscfp16_R(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e7a0000: FCVTAS  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_sisd_32D, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_sisd_32D
        IEM_INSTR_IMPL_A64__FCVTAS_sisd_32D(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1efa0000: FCVTAS  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTAS_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9efa0000: FCVTAS  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTAS_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e3a0000: FCVTAS  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAS_sisd_64S, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTAS_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAS_sisd_64S
        IEM_INSTR_IMPL_A64__FCVTAS_sisd_64S(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e650000: FCVTAU  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTAU_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee50000: FCVTAU  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTAU_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e250000: FCVTAU  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTAU_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e650000: FCVTAU  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTAU_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ee50000: FCVTAU  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTAU_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e250000: FCVTAU  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTAU_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2e21c800: FCVTAU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x2e21c800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCVTAU_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_asimdmisc_R
            IEM_INSTR_IMPL_A64__FCVTAU_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2e79c800: FCVTAU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_asimdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffffc00)) == UINT32_C(0x2e79c800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCVTAU_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_asimdmiscfp16_R
            IEM_INSTR_IMPL_A64__FCVTAU_asimdmiscfp16_R(Rd, Rn, Q);
#else
            RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7e21c800: FCVTAU  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_asisdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffbffc00)) == UINT32_C(0x7e21c800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCVTAU_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_asisdmisc_R
            IEM_INSTR_IMPL_A64__FCVTAU_asisdmisc_R(Rd, Rn, sz);
#else
            RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7e79c800: FCVTAU  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_asisdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x7e79c800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCVTAU_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_asisdmiscfp16_R
            IEM_INSTR_IMPL_A64__FCVTAU_asisdmiscfp16_R(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e7b0000: FCVTAU  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_sisd_32D, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_sisd_32D
        IEM_INSTR_IMPL_A64__FCVTAU_sisd_32D(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1efb0000: FCVTAU  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTAU_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9efb0000: FCVTAU  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTAU_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e3b0000: FCVTAU  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTAU_sisd_64S, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTAU_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTAU_sisd_64S
        IEM_INSTR_IMPL_A64__FCVTAU_sisd_64S(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0e217800: FCVTL2  <Vd>.<Ta>, <Vn>.<Tb>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTL_asimdmisc_L, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTL_asimdmisc_L Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTL_asimdmisc_L
        IEM_INSTR_IMPL_A64__FCVTL_asimdmisc_L(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e700000: FCVTMS  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTMS_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef00000: FCVTMS  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTMS_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e300000: FCVTMS  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTMS_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e700000: FCVTMS  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTMS_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef00000: FCVTMS  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTMS_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e300000: FCVTMS  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTMS_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0e21b800: FCVTMS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_asimdmisc_R
        IEM_INSTR_IMPL_A64__FCVTMS_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0e79b800: FCVTMS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTMS_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5e21b800: FCVTMS  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_asisdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_asisdmisc_R
        IEM_INSTR_IMPL_A64__FCVTMS_asisdmisc_R(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5e79b800: FCVTMS  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_asisdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_asisdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTMS_asisdmiscfp16_R(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e740000: FCVTMS  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_sisd_32D, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_sisd_32D
        IEM_INSTR_IMPL_A64__FCVTMS_sisd_32D(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef40000: FCVTMS  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTMS_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef40000: FCVTMS  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTMS_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e340000: FCVTMS  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMS_sisd_64S, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTMS_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMS_sisd_64S
        IEM_INSTR_IMPL_A64__FCVTMS_sisd_64S(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e710000: FCVTMU  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTMU_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef10000: FCVTMU  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTMU_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e310000: FCVTMU  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTMU_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e710000: FCVTMU  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTMU_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef10000: FCVTMU  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTMU_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e310000: FCVTMU  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTMU_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2e21b800: FCVTMU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_asimdmisc_R
        IEM_INSTR_IMPL_A64__FCVTMU_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2e79b800: FCVTMU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTMU_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7e21b800: FCVTMU  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_asisdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_asisdmisc_R
        IEM_INSTR_IMPL_A64__FCVTMU_asisdmisc_R(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7e79b800: FCVTMU  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_asisdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_asisdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTMU_asisdmiscfp16_R(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e750000: FCVTMU  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_sisd_32D, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_sisd_32D
        IEM_INSTR_IMPL_A64__FCVTMU_sisd_32D(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef50000: FCVTMU  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTMU_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef50000: FCVTMU  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTMU_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e350000: FCVTMU  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTMU_sisd_64S, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTMU_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTMU_sisd_64S
        IEM_INSTR_IMPL_A64__FCVTMU_sisd_64S(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e600000: FCVTNS  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTNS_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee00000: FCVTNS  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTNS_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e200000: FCVTNS  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTNS_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e600000: FCVTNS  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTNS_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ee00000: FCVTNS  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTNS_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e200000: FCVTNS  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTNS_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0e21a800: FCVTNS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x0e21a800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCVTNS_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_asimdmisc_R
            IEM_INSTR_IMPL_A64__FCVTNS_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0e79a800: FCVTNS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_asimdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffffc00)) == UINT32_C(0x0e79a800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCVTNS_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_asimdmiscfp16_R
            IEM_INSTR_IMPL_A64__FCVTNS_asimdmiscfp16_R(Rd, Rn, Q);
#else
            RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5e21a800: FCVTNS  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_asisdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_asisdmisc_R
        IEM_INSTR_IMPL_A64__FCVTNS_asisdmisc_R(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5e79a800: FCVTNS  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_asisdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_asisdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTNS_asisdmiscfp16_R(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e6a0000: FCVTNS  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_sisd_32D, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_sisd_32D
        IEM_INSTR_IMPL_A64__FCVTNS_sisd_32D(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1eea0000: FCVTNS  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTNS_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9eea0000: FCVTNS  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTNS_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e2a0000: FCVTNS  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNS_sisd_64S, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTNS_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNS_sisd_64S
        IEM_INSTR_IMPL_A64__FCVTNS_sisd_64S(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e610000: FCVTNU  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTNU_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee10000: FCVTNU  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTNU_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e210000: FCVTNU  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTNU_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e610000: FCVTNU  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTNU_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ee10000: FCVTNU  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTNU_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e210000: FCVTNU  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTNU_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2e21a800: FCVTNU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_asimdmisc_R
        IEM_INSTR_IMPL_A64__FCVTNU_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2e79a800: FCVTNU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTNU_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7e21a800: FCVTNU  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_asisdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_asisdmisc_R
        IEM_INSTR_IMPL_A64__FCVTNU_asisdmisc_R(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7e79a800: FCVTNU  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_asisdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_asisdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTNU_asisdmiscfp16_R(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e6b0000: FCVTNU  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_sisd_32D, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_sisd_32D
        IEM_INSTR_IMPL_A64__FCVTNU_sisd_32D(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1eeb0000: FCVTNU  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTNU_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9eeb0000: FCVTNU  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTNU_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e2b0000: FCVTNU  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTNU_sisd_64S, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTNU_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTNU_sisd_64S
        IEM_INSTR_IMPL_A64__FCVTNU_sisd_64S(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0e216800: FCVTN2  <Vd>.<Tb>, <Vn>.<Ta>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTN_asimdmisc_N, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTN_asimdmisc_N Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTN_asimdmisc_N
        IEM_INSTR_IMPL_A64__FCVTN_asimdmisc_N(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e40f400: FCVTN  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTN_asimdsame2_D, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0e40f400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8 /*FEAT_FP8*/)
        {
            LogFlow(("%018x/%010x: FCVTN_asimdsame2_D Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTN_asimdsame2_D
            IEM_INSTR_IMPL_A64__FCVTN_asimdsame2_D(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e00f400: FCVTN2  <Vd>.<Ta>, <Vn>.4S, <Vm>.4S
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTN_asimdsame2_H, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0e00f400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8 /*FEAT_FP8*/)
        {
            LogFlow(("%018x/%010x: FCVTN_asimdsame2_H Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTN_asimdsame2_H
            IEM_INSTR_IMPL_A64__FCVTN_asimdsame2_H(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e680000: FCVTPS  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTPS_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee80000: FCVTPS  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTPS_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e280000: FCVTPS  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTPS_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e680000: FCVTPS  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTPS_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ee80000: FCVTPS  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTPS_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e280000: FCVTPS  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTPS_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0ea1a800: FCVTPS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_asimdmisc_R
        IEM_INSTR_IMPL_A64__FCVTPS_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ef9a800: FCVTPS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTPS_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5ea1a800: FCVTPS  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_asisdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_asisdmisc_R
        IEM_INSTR_IMPL_A64__FCVTPS_asisdmisc_R(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ef9a800: FCVTPS  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_asisdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_asisdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTPS_asisdmiscfp16_R(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e720000: FCVTPS  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_sisd_32D, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_sisd_32D
        IEM_INSTR_IMPL_A64__FCVTPS_sisd_32D(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef20000: FCVTPS  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTPS_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef20000: FCVTPS  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTPS_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e320000: FCVTPS  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPS_sisd_64S, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTPS_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPS_sisd_64S
        IEM_INSTR_IMPL_A64__FCVTPS_sisd_64S(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e690000: FCVTPU  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTPU_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee90000: FCVTPU  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTPU_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e290000: FCVTPU  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTPU_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e690000: FCVTPU  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTPU_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ee90000: FCVTPU  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTPU_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e290000: FCVTPU  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTPU_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2ea1a800: FCVTPU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_asimdmisc_R
        IEM_INSTR_IMPL_A64__FCVTPU_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ef9a800: FCVTPU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTPU_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7ea1a800: FCVTPU  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_asisdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_asisdmisc_R
        IEM_INSTR_IMPL_A64__FCVTPU_asisdmisc_R(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7ef9a800: FCVTPU  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_asisdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_asisdmiscfp16_R
        IEM_INSTR_IMPL_A64__FCVTPU_asisdmiscfp16_R(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e730000: FCVTPU  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_sisd_32D, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_sisd_32D
        IEM_INSTR_IMPL_A64__FCVTPU_sisd_32D(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef30000: FCVTPU  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTPU_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef30000: FCVTPU  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTPU_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e330000: FCVTPU  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTPU_sisd_64S, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTPU_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTPU_sisd_64S
        IEM_INSTR_IMPL_A64__FCVTPU_sisd_64S(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2e616800: FCVTXN2  <Vd>.<Tb>, <Vn>.2D
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTXN_asimdmisc_N, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FCVTXN_asimdmisc_N Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTXN_asimdmisc_N
        IEM_INSTR_IMPL_A64__FCVTXN_asimdmisc_N(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7e616800: FCVTXN  S<d>, D<n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTXN_asisdmisc_N, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x7e616800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCVTXN_asisdmisc_N Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTXN_asisdmisc_N
            IEM_INSTR_IMPL_A64__FCVTXN_asisdmisc_N(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/1e580000: FCVTZS  <Wd>, <Dn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_32D_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_32D_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_32D_float2fix
        IEM_INSTR_IMPL_A64__FCVTZS_32D_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e780000: FCVTZS  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTZS_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/1ed80000: FCVTZS  <Wd>, <Hn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_32H_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_32H_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_32H_float2fix
        IEM_INSTR_IMPL_A64__FCVTZS_32H_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef80000: FCVTZS  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTZS_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/1e180000: FCVTZS  <Wd>, <Sn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_32S_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_32S_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_32S_float2fix
        IEM_INSTR_IMPL_A64__FCVTZS_32S_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e380000: FCVTZS  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTZS_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/9e580000: FCVTZS  <Xd>, <Dn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_64D_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_64D_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_64D_float2fix
        IEM_INSTR_IMPL_A64__FCVTZS_64D_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e780000: FCVTZS  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTZS_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/9ed80000: FCVTZS  <Xd>, <Hn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_64H_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_64H_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_64H_float2fix
        IEM_INSTR_IMPL_A64__FCVTZS_64H_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef80000: FCVTZS  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTZS_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/9e180000: FCVTZS  <Xd>, <Sn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_64S_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_64S_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_64S_float2fix
        IEM_INSTR_IMPL_A64__FCVTZS_64S_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e380000: FCVTZS  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTZS_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0ea1b800: FCVTZS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x0ea1b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCVTZS_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_asimdmisc_R
            IEM_INSTR_IMPL_A64__FCVTZS_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ef9b800: FCVTZS  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_asimdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffffc00)) == UINT32_C(0x0ef9b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCVTZS_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_asimdmiscfp16_R
            IEM_INSTR_IMPL_A64__FCVTZS_asimdmiscfp16_R(Rd, Rn, Q);
#else
            RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf80fc00/0f00fc00: FCVTZS  <Vd>.<T>, <Vn>.<T>, #<fbits>
   Instruction Set: A64  Groups: asimdshf, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_asimdshf_C, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const immb       = (uOpcode >> 16) & 0x00000007;
    uint32_t const immh       = (uOpcode >> 19) & 0x0000000f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && immh != 0)
    {
        LogFlow(("%018x/%010x: FCVTZS_asimdshf_C Rd=%#x Rn=%#x immb=%u immh=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, immb, immh, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_asimdshf_C
        IEM_INSTR_IMPL_A64__FCVTZS_asimdshf_C(Rd, Rn, immb, immh, Q);
#else
        RT_NOREF(Rd, Rn, immb, immh, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5ea1b800: FCVTZS  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_asisdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffbffc00)) == UINT32_C(0x5ea1b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCVTZS_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_asisdmisc_R
            IEM_INSTR_IMPL_A64__FCVTZS_asisdmisc_R(Rd, Rn, sz);
#else
            RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ef9b800: FCVTZS  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_asisdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5ef9b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCVTZS_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_asisdmiscfp16_R
            IEM_INSTR_IMPL_A64__FCVTZS_asisdmiscfp16_R(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff80fc00/5f00fc00: FCVTZS  <V><d>, <V><n>, #<fbits>
   Instruction Set: A64  Groups: asisdshf, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_asisdshf_C, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const immb       = (uOpcode >> 16) & 0x00000007;
    uint32_t const immh       = (uOpcode >> 19) & 0x0000000f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && immh != 0)
    {
        LogFlow(("%018x/%010x: FCVTZS_asisdshf_C Rd=%#x Rn=%#x immb=%u immh=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, immb, immh));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_asisdshf_C
        IEM_INSTR_IMPL_A64__FCVTZS_asisdshf_C(Rd, Rn, immb, immh);
#else
        RT_NOREF(Rd, Rn, immb, immh, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e760000: FCVTZS  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_sisd_32D, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_sisd_32D
        IEM_INSTR_IMPL_A64__FCVTZS_sisd_32D(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef60000: FCVTZS  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTZS_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef60000: FCVTZS  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTZS_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTZS_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e360000: FCVTZS  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZS_sisd_64S, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x9e360000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
        {
            LogFlow(("%018x/%010x: FCVTZS_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZS_sisd_64S
            IEM_INSTR_IMPL_A64__FCVTZS_sisd_64S(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/1e590000: FCVTZU  <Wd>, <Dn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_32D_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_32D_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_32D_float2fix
        IEM_INSTR_IMPL_A64__FCVTZU_32D_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e790000: FCVTZU  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_32D_float2int
        IEM_INSTR_IMPL_A64__FCVTZU_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/1ed90000: FCVTZU  <Wd>, <Hn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_32H_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_32H_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_32H_float2fix
        IEM_INSTR_IMPL_A64__FCVTZU_32H_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef90000: FCVTZU  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_32H_float2int
        IEM_INSTR_IMPL_A64__FCVTZU_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/1e190000: FCVTZU  <Wd>, <Sn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_32S_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_32S_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_32S_float2fix
        IEM_INSTR_IMPL_A64__FCVTZU_32S_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e390000: FCVTZU  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_32S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_32S_float2int
        IEM_INSTR_IMPL_A64__FCVTZU_32S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/9e590000: FCVTZU  <Xd>, <Dn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_64D_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_64D_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_64D_float2fix
        IEM_INSTR_IMPL_A64__FCVTZU_64D_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e790000: FCVTZU  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_64D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_64D_float2int
        IEM_INSTR_IMPL_A64__FCVTZU_64D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/9ed90000: FCVTZU  <Xd>, <Hn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_64H_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_64H_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_64H_float2fix
        IEM_INSTR_IMPL_A64__FCVTZU_64H_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef90000: FCVTZU  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_64H_float2int
        IEM_INSTR_IMPL_A64__FCVTZU_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff0000/9e190000: FCVTZU  <Xd>, <Sn>, #<fbits>
   Instruction Set: A64  Groups: float2fix, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_64S_float2fix, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const scale      = (uOpcode >> 10) & 0x0000003f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_64S_float2fix Rd=%#x Rn=%#x scale=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, scale));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_64S_float2fix
        IEM_INSTR_IMPL_A64__FCVTZU_64S_float2fix(Rd, Rn, scale);
#else
        RT_NOREF(Rd, Rn, scale, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e390000: FCVTZU  <Xd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_64S_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_64S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_64S_float2int
        IEM_INSTR_IMPL_A64__FCVTZU_64S_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2ea1b800: FCVTZU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x2ea1b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCVTZU_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_asimdmisc_R
            IEM_INSTR_IMPL_A64__FCVTZU_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ef9b800: FCVTZU  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_asimdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffffc00)) == UINT32_C(0x2ef9b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCVTZU_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_asimdmiscfp16_R
            IEM_INSTR_IMPL_A64__FCVTZU_asimdmiscfp16_R(Rd, Rn, Q);
#else
            RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf80fc00/2f00fc00: FCVTZU  <Vd>.<T>, <Vn>.<T>, #<fbits>
   Instruction Set: A64  Groups: asimdshf, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_asimdshf_C, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const immb       = (uOpcode >> 16) & 0x00000007;
    uint32_t const immh       = (uOpcode >> 19) & 0x0000000f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && immh != 0)
    {
        LogFlow(("%018x/%010x: FCVTZU_asimdshf_C Rd=%#x Rn=%#x immb=%u immh=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, immb, immh, Q));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_asimdshf_C
        IEM_INSTR_IMPL_A64__FCVTZU_asimdshf_C(Rd, Rn, immb, immh, Q);
#else
        RT_NOREF(Rd, Rn, immb, immh, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7ea1b800: FCVTZU  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_asisdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffbffc00)) == UINT32_C(0x7ea1b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FCVTZU_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_asisdmisc_R
            IEM_INSTR_IMPL_A64__FCVTZU_asisdmisc_R(Rd, Rn, sz);
#else
            RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7ef9b800: FCVTZU  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_asisdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x7ef9b800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FCVTZU_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_asisdmiscfp16_R
            IEM_INSTR_IMPL_A64__FCVTZU_asisdmiscfp16_R(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff80fc00/7f00fc00: FCVTZU  <V><d>, <V><n>, #<fbits>
   Instruction Set: A64  Groups: asisdshf, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_asisdshf_C, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xff80fc00)) == UINT32_C(0x7f00fc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const immb       = (uOpcode >> 16) & 0x00000007;
        uint32_t const immh       = (uOpcode >> 19) & 0x0000000f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && immh != 0)
        {
            LogFlow(("%018x/%010x: FCVTZU_asisdshf_C Rd=%#x Rn=%#x immb=%u immh=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, immb, immh));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_asisdshf_C
            IEM_INSTR_IMPL_A64__FCVTZU_asisdshf_C(Rd, Rn, immb, immh);
#else
            RT_NOREF(Rd, Rn, immb, immh, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e770000: FCVTZU  <Sd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_sisd_32D, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x1e770000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
        {
            LogFlow(("%018x/%010x: FCVTZU_sisd_32D Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_sisd_32D
            IEM_INSTR_IMPL_A64__FCVTZU_sisd_32D(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ef70000: FCVTZU  <Sd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_sisd_32H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_sisd_32H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_sisd_32H
        IEM_INSTR_IMPL_A64__FCVTZU_sisd_32H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ef70000: FCVTZU  <Dd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_sisd_64H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
    {
        LogFlow(("%018x/%010x: FCVTZU_sisd_64H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_sisd_64H
        IEM_INSTR_IMPL_A64__FCVTZU_sisd_64H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e370000: FCVTZU  <Dd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVTZU_sisd_64S, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x9e370000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFpRcvt /*FEAT_FPRCVT*/)
        {
            LogFlow(("%018x/%010x: FCVTZU_sisd_64S Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVTZU_sisd_64S
            IEM_INSTR_IMPL_A64__FCVTZU_sisd_64S(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee2c000: FCVT  <Dd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVT_DH_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVT_DH_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVT_DH_floatdp1
        IEM_INSTR_IMPL_A64__FCVT_DH_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e22c000: FCVT  <Dd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVT_DS_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVT_DS_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVT_DS_floatdp1
        IEM_INSTR_IMPL_A64__FCVT_DS_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e63c000: FCVT  <Hd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVT_HD_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVT_HD_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVT_HD_floatdp1
        IEM_INSTR_IMPL_A64__FCVT_HD_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e23c000: FCVT  <Hd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVT_HS_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVT_HS_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVT_HS_floatdp1
        IEM_INSTR_IMPL_A64__FCVT_HS_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e624000: FCVT  <Sd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVT_SD_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVT_SD_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVT_SD_floatdp1
        IEM_INSTR_IMPL_A64__FCVT_SD_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee24000: FCVT  <Sd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FCVT_SH_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FCVT_SH_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FCVT_SH_floatdp1
        IEM_INSTR_IMPL_A64__FCVT_SH_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e601800: FDIV  <Dd>, <Dn>, <Dm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FDIV_D_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e601800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FDIV_D_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FDIV_D_floatdp2
            IEM_INSTR_IMPL_A64__FDIV_D_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ee01800: FDIV  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FDIV_H_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1ee01800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FDIV_H_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FDIV_H_floatdp2
            IEM_INSTR_IMPL_A64__FDIV_H_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e201800: FDIV  <Sd>, <Sn>, <Sm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FDIV_S_floatdp2, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FDIV_S_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FDIV_S_floatdp2
        IEM_INSTR_IMPL_A64__FDIV_S_floatdp2(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2e20fc00: FDIV  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FDIV_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FDIV_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FDIV_asimdsame_only
        IEM_INSTR_IMPL_A64__FDIV_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e403c00: FDIV  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FDIV_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e403c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FDIV_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FDIV_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FDIV_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/0f000000: FDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.4B[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FDOT_asimdelem_D, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfc0f400)) == UINT32_C(0x0f000000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Dot4 /*FEAT_FP8DOT4*/)
        {
            LogFlow(("%018x/%010x: FDOT_asimdelem_D Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FDOT_asimdelem_D
            IEM_INSTR_IMPL_A64__FDOT_asimdelem_D(Rd, Rn, H, Rm, M, L, Q);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/0f400000: FDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.2B[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FDOT_asimdelem_G, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfc0f400)) == UINT32_C(0x0f400000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Dot2 /*FEAT_FP8DOT2*/)
        {
            LogFlow(("%018x/%010x: FDOT_asimdelem_G Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FDOT_asimdelem_G
            IEM_INSTR_IMPL_A64__FDOT_asimdelem_G(Rd, Rn, H, Rm, M, L, Q);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e40fc00: FDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FDOT_asimdsame2_D, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0e40fc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Dot2 /*FEAT_FP8DOT2*/)
        {
            LogFlow(("%018x/%010x: FDOT_asimdsame2_D Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FDOT_asimdsame2_D
            IEM_INSTR_IMPL_A64__FDOT_asimdsame2_D(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e00fc00: FDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FDOT_asimdsame2_DD, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0e00fc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Dot4 /*FEAT_FP8DOT4*/)
        {
            LogFlow(("%018x/%010x: FDOT_asimdsame2_DD Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FDOT_asimdsame2_DD
            IEM_INSTR_IMPL_A64__FDOT_asimdsame2_DD(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e7e0000: FJCVTZS  <Wd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FJCVTZS_32D_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fJscvt /*FEAT_JSCVT*/)
    {
        LogFlow(("%018x/%010x: FJCVTZS_32D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FJCVTZS_32D_float2int
        IEM_INSTR_IMPL_A64__FJCVTZS_32D_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1f400000: FMADD  <Dd>, <Dn>, <Dm>, <Da>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMADD_D_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMADD_D_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMADD_D_floatdp3
        IEM_INSTR_IMPL_A64__FMADD_D_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1fc00000: FMADD  <Hd>, <Hn>, <Hm>, <Ha>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMADD_H_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMADD_H_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMADD_H_floatdp3
        IEM_INSTR_IMPL_A64__FMADD_H_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1f000000: FMADD  <Sd>, <Sn>, <Sm>, <Sa>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMADD_S_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMADD_S_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMADD_S_floatdp3
        IEM_INSTR_IMPL_A64__FMADD_S_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2e20c400: FMAXNMP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNMP_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x2e20c400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMAXNMP_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAXNMP_asimdsame_only
            IEM_INSTR_IMPL_A64__FMAXNMP_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e400400: FMAXNMP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNMP_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e400400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMAXNMP_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAXNMP_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FMAXNMP_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5e30c800: FMAXNMP  H<d>, <Vn>.2H
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNMP_asisdpair_only_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMAXNMP_asisdpair_only_H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMAXNMP_asisdpair_only_H
        IEM_INSTR_IMPL_A64__FMAXNMP_asisdpair_only_H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7e30c800: FMAXNMP  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNMP_asisdpair_only_SD, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffbffc00)) == UINT32_C(0x7e30c800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMAXNMP_asisdpair_only_SD Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FMAXNMP_asisdpair_only_SD
            IEM_INSTR_IMPL_A64__FMAXNMP_asisdpair_only_SD(Rd, Rn, sz);
#else
            RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0e30c800: FMAXNMV  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdall, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNMV_asimdall_only_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMAXNMV_asimdall_only_H Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAXNMV_asimdall_only_H
        IEM_INSTR_IMPL_A64__FMAXNMV_asimdall_only_H(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/6e30c800: FMAXNMV  S<d>, <Vn>.4S
   Instruction Set: A64  Groups: asimdall, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNMV_asimdall_only_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMAXNMV_asimdall_only_SD Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMAXNMV_asimdall_only_SD
        IEM_INSTR_IMPL_A64__FMAXNMV_asimdall_only_SD(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e606800: FMAXNM  <Dd>, <Dn>, <Dm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNM_D_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e606800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMAXNM_D_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMAXNM_D_floatdp2
            IEM_INSTR_IMPL_A64__FMAXNM_D_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ee06800: FMAXNM  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNM_H_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1ee06800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMAXNM_H_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMAXNM_H_floatdp2
            IEM_INSTR_IMPL_A64__FMAXNM_H_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e206800: FMAXNM  <Sd>, <Sn>, <Sm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNM_S_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e206800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMAXNM_S_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMAXNM_S_floatdp2
            IEM_INSTR_IMPL_A64__FMAXNM_S_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0e20c400: FMAXNM  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNM_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMAXNM_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAXNM_asimdsame_only
        IEM_INSTR_IMPL_A64__FMAXNM_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e400400: FMAXNM  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXNM_asimdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMAXNM_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAXNM_asimdsamefp16_only
        IEM_INSTR_IMPL_A64__FMAXNM_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2e20f400: FMAXP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXP_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x2e20f400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMAXP_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAXP_asimdsame_only
            IEM_INSTR_IMPL_A64__FMAXP_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e403400: FMAXP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXP_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e403400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMAXP_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAXP_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FMAXP_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5e30f800: FMAXP  H<d>, <Vn>.2H
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXP_asisdpair_only_H, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x5e30f800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMAXP_asisdpair_only_H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMAXP_asisdpair_only_H
            IEM_INSTR_IMPL_A64__FMAXP_asisdpair_only_H(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7e30f800: FMAXP  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXP_asisdpair_only_SD, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffbffc00)) == UINT32_C(0x7e30f800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMAXP_asisdpair_only_SD Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FMAXP_asisdpair_only_SD
            IEM_INSTR_IMPL_A64__FMAXP_asisdpair_only_SD(Rd, Rn, sz);
#else
            RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0e30f800: FMAXV  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdall, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXV_asimdall_only_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMAXV_asimdall_only_H Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAXV_asimdall_only_H
        IEM_INSTR_IMPL_A64__FMAXV_asimdall_only_H(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/6e30f800: FMAXV  S<d>, <Vn>.4S
   Instruction Set: A64  Groups: asimdall, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAXV_asimdall_only_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMAXV_asimdall_only_SD Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMAXV_asimdall_only_SD
        IEM_INSTR_IMPL_A64__FMAXV_asimdall_only_SD(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e604800: FMAX  <Dd>, <Dn>, <Dm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAX_D_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e604800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMAX_D_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMAX_D_floatdp2
            IEM_INSTR_IMPL_A64__FMAX_D_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ee04800: FMAX  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAX_H_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1ee04800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMAX_H_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMAX_H_floatdp2
            IEM_INSTR_IMPL_A64__FMAX_H_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e204800: FMAX  <Sd>, <Sn>, <Sm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAX_S_floatdp2, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMAX_S_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMAX_S_floatdp2
        IEM_INSTR_IMPL_A64__FMAX_S_floatdp2(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0e20f400: FMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAX_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x0e20f400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMAX_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAX_asimdsame_only
            IEM_INSTR_IMPL_A64__FMAX_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e403400: FMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMAX_asimdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMAX_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMAX_asimdsamefp16_only
        IEM_INSTR_IMPL_A64__FMAX_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2ea0c400: FMINNMP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNMP_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x2ea0c400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMINNMP_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMINNMP_asimdsame_only
            IEM_INSTR_IMPL_A64__FMINNMP_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ec00400: FMINNMP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNMP_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2ec00400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMINNMP_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMINNMP_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FMINNMP_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5eb0c800: FMINNMP  H<d>, <Vn>.2H
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNMP_asisdpair_only_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMINNMP_asisdpair_only_H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMINNMP_asisdpair_only_H
        IEM_INSTR_IMPL_A64__FMINNMP_asisdpair_only_H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7eb0c800: FMINNMP  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNMP_asisdpair_only_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMINNMP_asisdpair_only_SD Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FMINNMP_asisdpair_only_SD
        IEM_INSTR_IMPL_A64__FMINNMP_asisdpair_only_SD(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0eb0c800: FMINNMV  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdall, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNMV_asimdall_only_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMINNMV_asimdall_only_H Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FMINNMV_asimdall_only_H
        IEM_INSTR_IMPL_A64__FMINNMV_asimdall_only_H(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/6eb0c800: FMINNMV  S<d>, <Vn>.4S
   Instruction Set: A64  Groups: asimdall, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNMV_asimdall_only_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMINNMV_asimdall_only_SD Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMINNMV_asimdall_only_SD
        IEM_INSTR_IMPL_A64__FMINNMV_asimdall_only_SD(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e607800: FMINNM  <Dd>, <Dn>, <Dm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNM_D_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e607800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMINNM_D_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMINNM_D_floatdp2
            IEM_INSTR_IMPL_A64__FMINNM_D_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ee07800: FMINNM  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNM_H_floatdp2, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMINNM_H_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMINNM_H_floatdp2
        IEM_INSTR_IMPL_A64__FMINNM_H_floatdp2(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e207800: FMINNM  <Sd>, <Sn>, <Sm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNM_S_floatdp2, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMINNM_S_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMINNM_S_floatdp2
        IEM_INSTR_IMPL_A64__FMINNM_S_floatdp2(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0ea0c400: FMINNM  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNM_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x0ea0c400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMINNM_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMINNM_asimdsame_only
            IEM_INSTR_IMPL_A64__FMINNM_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0ec00400: FMINNM  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINNM_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0ec00400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMINNM_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMINNM_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FMINNM_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2ea0f400: FMINP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINP_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x2ea0f400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMINP_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMINP_asimdsame_only
            IEM_INSTR_IMPL_A64__FMINP_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ec03400: FMINP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINP_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2ec03400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMINP_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMINP_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FMINP_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5eb0f800: FMINP  H<d>, <Vn>.2H
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINP_asisdpair_only_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMINP_asisdpair_only_H Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMINP_asisdpair_only_H
        IEM_INSTR_IMPL_A64__FMINP_asisdpair_only_H(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7eb0f800: FMINP  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asisdpair, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINP_asisdpair_only_SD, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffbffc00)) == UINT32_C(0x7eb0f800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMINP_asisdpair_only_SD Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FMINP_asisdpair_only_SD
            IEM_INSTR_IMPL_A64__FMINP_asisdpair_only_SD(Rd, Rn, sz);
#else
            RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0eb0f800: FMINV  <V><d>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdall, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINV_asimdall_only_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMINV_asimdall_only_H Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FMINV_asimdall_only_H
        IEM_INSTR_IMPL_A64__FMINV_asimdall_only_H(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/6eb0f800: FMINV  S<d>, <Vn>.4S
   Instruction Set: A64  Groups: asimdall, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMINV_asimdall_only_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMINV_asimdall_only_SD Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMINV_asimdall_only_SD
        IEM_INSTR_IMPL_A64__FMINV_asimdall_only_SD(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e605800: FMIN  <Dd>, <Dn>, <Dm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMIN_D_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e605800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMIN_D_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMIN_D_floatdp2
            IEM_INSTR_IMPL_A64__FMIN_D_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ee05800: FMIN  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMIN_H_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1ee05800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMIN_H_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMIN_H_floatdp2
            IEM_INSTR_IMPL_A64__FMIN_H_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e205800: FMIN  <Sd>, <Sn>, <Sm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMIN_S_floatdp2, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMIN_S_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMIN_S_floatdp2
        IEM_INSTR_IMPL_A64__FMIN_S_floatdp2(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0ea0f400: FMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMIN_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x0ea0f400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMIN_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMIN_asimdsame_only
            IEM_INSTR_IMPL_A64__FMIN_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0ec03400: FMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMIN_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0ec03400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMIN_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMIN_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FMIN_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/2f808000: FMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLAL2_asimdelem_LH, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFhm /*FEAT_FHM*/)
    {
        LogFlow(("%018x/%010x: FMLAL2_asimdelem_LH Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLAL2_asimdelem_LH
        IEM_INSTR_IMPL_A64__FMLAL2_asimdelem_LH(Rd, Rn, H, Rm, M, L, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e20cc00: FMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLAL2_asimdsame_F, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e20cc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFhm /*FEAT_FHM*/)
        {
            LogFlow(("%018x/%010x: FMLAL2_asimdsame_F Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLAL2_asimdsame_F
            IEM_INSTR_IMPL_A64__FMLAL2_asimdsame_F(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/0fc00000: FMLALB  <Vd>.8H, <Vn>.16B, <Vm>.B[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALB_asimdelem_H, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc0f400)) == UINT32_C(0x0fc00000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALB_asimdelem_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMLALB_asimdelem_H
            IEM_INSTR_IMPL_A64__FMLALB_asimdelem_H(Rd, Rn, H, Rm, M, L);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/0ec0fc00: FMLALB  <Vd>.8H, <Vn>.16B, <Vm>.16B
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALB_asimdsame2_J, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x0ec0fc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALB_asimdsame2_J Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMLALB_asimdsame2_J
            IEM_INSTR_IMPL_A64__FMLALB_asimdsame2_J(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/2f008000: FMLALLBB  <Vd>.4S, <Vn>.16B, <Vm>.B[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALLBB_asimdelem_J, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc0f400)) == UINT32_C(0x2f008000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALLBB_asimdelem_J Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMLALLBB_asimdelem_J
            IEM_INSTR_IMPL_A64__FMLALLBB_asimdelem_J(Rd, Rn, H, Rm, M, L);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/0e00c400: FMLALLBB  <Vd>.4S, <Vn>.16B, <Vm>.16B
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALLBB_asimdsame2_G, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x0e00c400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALLBB_asimdsame2_G Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMLALLBB_asimdsame2_G
            IEM_INSTR_IMPL_A64__FMLALLBB_asimdsame2_G(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/2f408000: FMLALLBT  <Vd>.4S, <Vn>.16B, <Vm>.B[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALLBT_asimdelem_J, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc0f400)) == UINT32_C(0x2f408000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALLBT_asimdelem_J Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMLALLBT_asimdelem_J
            IEM_INSTR_IMPL_A64__FMLALLBT_asimdelem_J(Rd, Rn, H, Rm, M, L);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/0e40c400: FMLALLBT  <Vd>.4S, <Vn>.16B, <Vm>.16B
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALLBT_asimdsame2_G, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x0e40c400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALLBT_asimdsame2_G Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMLALLBT_asimdsame2_G
            IEM_INSTR_IMPL_A64__FMLALLBT_asimdsame2_G(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/6f008000: FMLALLTB  <Vd>.4S, <Vn>.16B, <Vm>.B[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALLTB_asimdelem_J, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc0f400)) == UINT32_C(0x6f008000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALLTB_asimdelem_J Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMLALLTB_asimdelem_J
            IEM_INSTR_IMPL_A64__FMLALLTB_asimdelem_J(Rd, Rn, H, Rm, M, L);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/4e00c400: FMLALLTB  <Vd>.4S, <Vn>.16B, <Vm>.16B
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALLTB_asimdsame2_G, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x4e00c400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALLTB_asimdsame2_G Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMLALLTB_asimdsame2_G
            IEM_INSTR_IMPL_A64__FMLALLTB_asimdsame2_G(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/6f408000: FMLALLTT  <Vd>.4S, <Vn>.16B, <Vm>.B[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALLTT_asimdelem_J, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc0f400)) == UINT32_C(0x6f408000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALLTT_asimdelem_J Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMLALLTT_asimdelem_J
            IEM_INSTR_IMPL_A64__FMLALLTT_asimdelem_J(Rd, Rn, H, Rm, M, L);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/4e40c400: FMLALLTT  <Vd>.4S, <Vn>.16B, <Vm>.16B
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALLTT_asimdsame2_G, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x4e40c400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALLTT_asimdsame2_G Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMLALLTT_asimdsame2_G
            IEM_INSTR_IMPL_A64__FMLALLTT_asimdsame2_G(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/4fc00000: FMLALT  <Vd>.8H, <Vn>.16B, <Vm>.B[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALT_asimdelem_H, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc0f400)) == UINT32_C(0x4fc00000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALT_asimdelem_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMLALT_asimdelem_H
            IEM_INSTR_IMPL_A64__FMLALT_asimdelem_H(Rd, Rn, H, Rm, M, L);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/4ec0fc00: FMLALT  <Vd>.8H, <Vn>.16B, <Vm>.16B
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLALT_asimdsame2_J, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x4ec0fc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8Fma /*FEAT_FP8FMA*/)
        {
            LogFlow(("%018x/%010x: FMLALT_asimdsame2_J Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMLALT_asimdsame2_J
            IEM_INSTR_IMPL_A64__FMLALT_asimdsame2_J(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/0f800000: FMLAL  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLAL_asimdelem_LH, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFhm /*FEAT_FHM*/)
    {
        LogFlow(("%018x/%010x: FMLAL_asimdelem_LH Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLAL_asimdelem_LH
        IEM_INSTR_IMPL_A64__FMLAL_asimdelem_LH(Rd, Rn, H, Rm, M, L, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e20ec00: FMLAL  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLAL_asimdsame_F, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0e20ec00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFhm /*FEAT_FHM*/)
        {
            LogFlow(("%018x/%010x: FMLAL_asimdsame_F Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLAL_asimdsame_F
            IEM_INSTR_IMPL_A64__FMLAL_asimdsame_F(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/0f001000: FMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLA_asimdelem_RH_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMLA_asimdelem_RH_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLA_asimdelem_RH_H
        IEM_INSTR_IMPL_A64__FMLA_asimdelem_RH_H(Rd, Rn, H, Rm, M, L, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf80f400/0f801000: FMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLA_asimdelem_R_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMLA_asimdelem_R_SD Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLA_asimdelem_R_SD
        IEM_INSTR_IMPL_A64__FMLA_asimdelem_R_SD(Rd, Rn, H, Rm, M, L, sz, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0e20cc00: FMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLA_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x0e20cc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMLA_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLA_asimdsame_only
            IEM_INSTR_IMPL_A64__FMLA_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e400c00: FMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLA_asimdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMLA_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLA_asimdsamefp16_only
        IEM_INSTR_IMPL_A64__FMLA_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/5f001000: FMLA  <Hd>, <Hn>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asisdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLA_asisdelem_RH_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMLA_asisdelem_RH_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMLA_asisdelem_RH_H
        IEM_INSTR_IMPL_A64__FMLA_asisdelem_RH_H(Rd, Rn, H, Rm, M, L);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff80f400/5f801000: FMLA  <V><d>, <V><n>, <Vm>.<Ts>[<index>]
   Instruction Set: A64  Groups: asisdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLA_asisdelem_R_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMLA_asisdelem_R_SD Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, sz));
#ifdef IEM_INSTR_IMPL_A64__FMLA_asisdelem_R_SD
        IEM_INSTR_IMPL_A64__FMLA_asisdelem_R_SD(Rd, Rn, H, Rm, M, L, sz);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/2f80c000: FMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLSL2_asimdelem_LH, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfc0f400)) == UINT32_C(0x2f80c000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFhm /*FEAT_FHM*/)
        {
            LogFlow(("%018x/%010x: FMLSL2_asimdelem_LH Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLSL2_asimdelem_LH
            IEM_INSTR_IMPL_A64__FMLSL2_asimdelem_LH(Rd, Rn, H, Rm, M, L, Q);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ea0cc00: FMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLSL2_asimdsame_F, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFhm /*FEAT_FHM*/)
    {
        LogFlow(("%018x/%010x: FMLSL2_asimdsame_F Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLSL2_asimdsame_F
        IEM_INSTR_IMPL_A64__FMLSL2_asimdsame_F(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/0f804000: FMLSL  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLSL_asimdelem_LH, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFhm /*FEAT_FHM*/)
    {
        LogFlow(("%018x/%010x: FMLSL_asimdelem_LH Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLSL_asimdelem_LH
        IEM_INSTR_IMPL_A64__FMLSL_asimdelem_LH(Rd, Rn, H, Rm, M, L, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0ea0ec00: FMLSL  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLSL_asimdsame_F, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0ea0ec00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFhm /*FEAT_FHM*/)
        {
            LogFlow(("%018x/%010x: FMLSL_asimdsame_F Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLSL_asimdsame_F
            IEM_INSTR_IMPL_A64__FMLSL_asimdsame_F(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/0f005000: FMLS  <Vd>.<T>, <Vn>.<T>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLS_asimdelem_RH_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMLS_asimdelem_RH_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLS_asimdelem_RH_H
        IEM_INSTR_IMPL_A64__FMLS_asimdelem_RH_H(Rd, Rn, H, Rm, M, L, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf80f400/0f805000: FMLS  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLS_asimdelem_R_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMLS_asimdelem_R_SD Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLS_asimdelem_R_SD
        IEM_INSTR_IMPL_A64__FMLS_asimdelem_R_SD(Rd, Rn, H, Rm, M, L, sz, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0ea0cc00: FMLS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLS_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfa0fc00)) == UINT32_C(0x0ea0cc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMLS_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLS_asimdsame_only
            IEM_INSTR_IMPL_A64__FMLS_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
            RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0ec00c00: FMLS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLS_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0ec00c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMLS_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMLS_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FMLS_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/5f005000: FMLS  <Hd>, <Hn>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asisdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLS_asisdelem_RH_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMLS_asisdelem_RH_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMLS_asisdelem_RH_H
        IEM_INSTR_IMPL_A64__FMLS_asisdelem_RH_H(Rd, Rn, H, Rm, M, L);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff80f400/5f805000: FMLS  <V><d>, <V><n>, <Vm>.<Ts>[<index>]
   Instruction Set: A64  Groups: asisdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMLS_asisdelem_R_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMLS_asisdelem_R_SD Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, sz));
#ifdef IEM_INSTR_IMPL_A64__FMLS_asisdelem_R_SD
        IEM_INSTR_IMPL_A64__FMLS_asisdelem_R_SD(Rd, Rn, H, Rm, M, L, sz);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/6e00ec00: FMMLA  <Vd>.8H, <Vn>.16B, <Vm>.16B
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMMLA_asimd_FP8FP16, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x6e00ec00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fF8F16mm /*FEAT_F8F16MM*/)
        {
            LogFlow(("%018x/%010x: FMMLA_asimd_FP8FP16 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMMLA_asimd_FP8FP16
            IEM_INSTR_IMPL_A64__FMMLA_asimd_FP8FP16(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/6e80ec00: FMMLA  <Vd>.4S, <Vn>.16B, <Vm>.16B
   Instruction Set: A64  Groups: asimdsame2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMMLA_asimd_FP8FP32, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x6e80ec00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fF8F32mm /*FEAT_F8F32MM*/)
        {
            LogFlow(("%018x/%010x: FMMLA_asimd_FP8FP32 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMMLA_asimd_FP8FP32
            IEM_INSTR_IMPL_A64__FMMLA_asimd_FP8FP32(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee60000: FMOV  <Wd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_32H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMOV_32H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_32H_float2int
        IEM_INSTR_IMPL_A64__FMOV_32H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e260000: FMOV  <Wd>, <Sn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_32S_float2int, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x1e260000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMOV_32S_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_32S_float2int
            IEM_INSTR_IMPL_A64__FMOV_32S_float2int(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e660000: FMOV  <Xd>, <Dn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_64D_float2int, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x9e660000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMOV_64D_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_64D_float2int
            IEM_INSTR_IMPL_A64__FMOV_64D_float2int(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ee60000: FMOV  <Xd>, <Hn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_64H_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMOV_64H_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_64H_float2int
        IEM_INSTR_IMPL_A64__FMOV_64H_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9eae0000: FMOV  <Xd>, <Vn>.D[1]
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_64VX_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMOV_64VX_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_64VX_float2int
        IEM_INSTR_IMPL_A64__FMOV_64VX_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9e670000: FMOV  <Dd>, <Xn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_D64_float2int, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x9e670000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMOV_D64_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_D64_float2int
            IEM_INSTR_IMPL_A64__FMOV_D64_float2int(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e604000: FMOV  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMOV_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_D_floatdp1
        IEM_INSTR_IMPL_A64__FMOV_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe01fe0/1e601000: FMOV  <Dd>, #<imm>
   Instruction Set: A64  Groups: floatimm, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_D_floatimm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm8       = (uOpcode >> 13) & 0x000000ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMOV_D_floatimm Rd=%#x imm8=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, imm8));
#ifdef IEM_INSTR_IMPL_A64__FMOV_D_floatimm
        IEM_INSTR_IMPL_A64__FMOV_D_floatimm(Rd, imm8);
#else
        RT_NOREF(Rd, imm8, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee70000: FMOV  <Hd>, <Wn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_H32_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMOV_H32_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_H32_float2int
        IEM_INSTR_IMPL_A64__FMOV_H32_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9ee70000: FMOV  <Hd>, <Xn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_H64_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMOV_H64_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_H64_float2int
        IEM_INSTR_IMPL_A64__FMOV_H64_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee04000: FMOV  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMOV_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_H_floatdp1
        IEM_INSTR_IMPL_A64__FMOV_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe01fe0/1ee01000: FMOV  <Hd>, #<imm>
   Instruction Set: A64  Groups: floatimm, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_H_floatimm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm8       = (uOpcode >> 13) & 0x000000ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMOV_H_floatimm Rd=%#x imm8=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, imm8));
#ifdef IEM_INSTR_IMPL_A64__FMOV_H_floatimm
        IEM_INSTR_IMPL_A64__FMOV_H_floatimm(Rd, imm8);
#else
        RT_NOREF(Rd, imm8, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e270000: FMOV  <Sd>, <Wn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_S32_float2int, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x1e270000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMOV_S32_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_S32_float2int
            IEM_INSTR_IMPL_A64__FMOV_S32_float2int(Rd, Rn);
#else
            RT_NOREF(Rd, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e204000: FMOV  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMOV_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_S_floatdp1
        IEM_INSTR_IMPL_A64__FMOV_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe01fe0/1e201000: FMOV  <Sd>, #<imm>
   Instruction Set: A64  Groups: floatimm, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_S_floatimm, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const imm8       = (uOpcode >> 13) & 0x000000ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMOV_S_floatimm Rd=%#x imm8=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, imm8));
#ifdef IEM_INSTR_IMPL_A64__FMOV_S_floatimm
        IEM_INSTR_IMPL_A64__FMOV_S_floatimm(Rd, imm8);
#else
        RT_NOREF(Rd, imm8, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/9eaf0000: FMOV  <Vd>.D[1], <Xn>
   Instruction Set: A64  Groups: float2int, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_V64I_float2int, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMOV_V64I_float2int Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FMOV_V64I_float2int
        IEM_INSTR_IMPL_A64__FMOV_V64I_float2int(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fff8fc00/6f00f400: FMOV  <Vd>.2D, #<imm>
   Instruction Set: A64  Groups: asimdimm, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_asimdimm_D2_d, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfff8fc00)) == UINT32_C(0x6f00f400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const h          = (uOpcode >>  5) & 0x00000001;
        uint32_t const g          = (uOpcode >>  6) & 0x00000001;
        uint32_t const f          = (uOpcode >>  7) & 0x00000001;
        uint32_t const e          = (uOpcode >>  8) & 0x00000001;
        uint32_t const d          = (uOpcode >>  9) & 0x00000001;
        uint32_t const c          = (uOpcode >> 16) & 0x00000001;
        uint32_t const b          = (uOpcode >> 17) & 0x00000001;
        uint32_t const a          = (uOpcode >> 18) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMOV_asimdimm_D2_d Rd=%#x h=%u g=%u f=%u e=%u d=%u c=%u b=%u a=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, h, g, f, e, d, c, b, a));
#ifdef IEM_INSTR_IMPL_A64__FMOV_asimdimm_D2_d
            IEM_INSTR_IMPL_A64__FMOV_asimdimm_D2_d(Rd, h, g, f, e, d, c, b, a);
#else
            RT_NOREF(Rd, h, g, f, e, d, c, b, a, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bff8fc00/0f00fc00: FMOV  <Vd>.<T>, #<imm>
   Instruction Set: A64  Groups: asimdimm, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_asimdimm_H_h, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const h          = (uOpcode >>  5) & 0x00000001;
    uint32_t const g          = (uOpcode >>  6) & 0x00000001;
    uint32_t const f          = (uOpcode >>  7) & 0x00000001;
    uint32_t const e          = (uOpcode >>  8) & 0x00000001;
    uint32_t const d          = (uOpcode >>  9) & 0x00000001;
    uint32_t const c          = (uOpcode >> 16) & 0x00000001;
    uint32_t const b          = (uOpcode >> 17) & 0x00000001;
    uint32_t const a          = (uOpcode >> 18) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMOV_asimdimm_H_h Rd=%#x h=%u g=%u f=%u e=%u d=%u c=%u b=%u a=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, h, g, f, e, d, c, b, a, Q));
#ifdef IEM_INSTR_IMPL_A64__FMOV_asimdimm_H_h
        IEM_INSTR_IMPL_A64__FMOV_asimdimm_H_h(Rd, h, g, f, e, d, c, b, a, Q);
#else
        RT_NOREF(Rd, h, g, f, e, d, c, b, a, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bff8fc00/0f00f400: FMOV  <Vd>.<T>, #<imm>
   Instruction Set: A64  Groups: asimdimm, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMOV_asimdimm_S_s, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbff8fc00)) == UINT32_C(0x0f00f400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const h          = (uOpcode >>  5) & 0x00000001;
        uint32_t const g          = (uOpcode >>  6) & 0x00000001;
        uint32_t const f          = (uOpcode >>  7) & 0x00000001;
        uint32_t const e          = (uOpcode >>  8) & 0x00000001;
        uint32_t const d          = (uOpcode >>  9) & 0x00000001;
        uint32_t const c          = (uOpcode >> 16) & 0x00000001;
        uint32_t const b          = (uOpcode >> 17) & 0x00000001;
        uint32_t const a          = (uOpcode >> 18) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMOV_asimdimm_S_s Rd=%#x h=%u g=%u f=%u e=%u d=%u c=%u b=%u a=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, h, g, f, e, d, c, b, a, Q));
#ifdef IEM_INSTR_IMPL_A64__FMOV_asimdimm_S_s
            IEM_INSTR_IMPL_A64__FMOV_asimdimm_S_s(Rd, h, g, f, e, d, c, b, a, Q);
#else
            RT_NOREF(Rd, h, g, f, e, d, c, b, a, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1f408000: FMSUB  <Dd>, <Dn>, <Dm>, <Da>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMSUB_D_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMSUB_D_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMSUB_D_floatdp3
        IEM_INSTR_IMPL_A64__FMSUB_D_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1fc08000: FMSUB  <Hd>, <Hn>, <Hm>, <Ha>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMSUB_H_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMSUB_H_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMSUB_H_floatdp3
        IEM_INSTR_IMPL_A64__FMSUB_H_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1f008000: FMSUB  <Sd>, <Sn>, <Sm>, <Sa>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMSUB_S_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMSUB_S_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMSUB_S_floatdp3
        IEM_INSTR_IMPL_A64__FMSUB_S_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/2f009000: FMULX  <Vd>.<T>, <Vn>.<T>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMULX_asimdelem_RH_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMULX_asimdelem_RH_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FMULX_asimdelem_RH_H
        IEM_INSTR_IMPL_A64__FMULX_asimdelem_RH_H(Rd, Rn, H, Rm, M, L, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf80f400/2f809000: FMULX  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMULX_asimdelem_R_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMULX_asimdelem_R_SD Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMULX_asimdelem_R_SD
        IEM_INSTR_IMPL_A64__FMULX_asimdelem_R_SD(Rd, Rn, H, Rm, M, L, sz, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0e20dc00: FMULX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMULX_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMULX_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMULX_asimdsame_only
        IEM_INSTR_IMPL_A64__FMULX_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e401c00: FMULX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMULX_asimdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMULX_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMULX_asimdsamefp16_only
        IEM_INSTR_IMPL_A64__FMULX_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/7f009000: FMULX  <Hd>, <Hn>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asisdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMULX_asisdelem_RH_H, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffc0f400)) == UINT32_C(0x7f009000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMULX_asisdelem_RH_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMULX_asisdelem_RH_H
            IEM_INSTR_IMPL_A64__FMULX_asisdelem_RH_H(Rd, Rn, H, Rm, M, L);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff80f400/7f809000: FMULX  <V><d>, <V><n>, <Vm>.<Ts>[<index>]
   Instruction Set: A64  Groups: asisdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMULX_asisdelem_R_SD, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xff80f400)) == UINT32_C(0x7f809000))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const H          = (uOpcode >> 11) & 0x00000001;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
        uint32_t const M          = (uOpcode >> 20) & 0x00000001;
        uint32_t const L          = (uOpcode >> 21) & 0x00000001;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FMULX_asisdelem_R_SD Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, sz));
#ifdef IEM_INSTR_IMPL_A64__FMULX_asisdelem_R_SD
            IEM_INSTR_IMPL_A64__FMULX_asisdelem_R_SD(Rd, Rn, H, Rm, M, L, sz);
#else
            RT_NOREF(Rd, Rn, H, Rm, M, L, sz, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffa0fc00/5e20dc00: FMULX  <V><d>, <V><n>, <V><m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMULX_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMULX_asisdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz));
#ifdef IEM_INSTR_IMPL_A64__FMULX_asisdsame_only
        IEM_INSTR_IMPL_A64__FMULX_asisdsame_only(Rd, Rn, Rm, sz);
#else
        RT_NOREF(Rd, Rn, Rm, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/5e401c00: FMULX  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: asisdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMULX_asisdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x5e401c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMULX_asisdsamefp16_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMULX_asisdsamefp16_only
            IEM_INSTR_IMPL_A64__FMULX_asisdsamefp16_only(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e600800: FMUL  <Dd>, <Dn>, <Dm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMUL_D_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e600800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FMUL_D_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMUL_D_floatdp2
            IEM_INSTR_IMPL_A64__FMUL_D_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ee00800: FMUL  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMUL_H_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1ee00800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMUL_H_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMUL_H_floatdp2
            IEM_INSTR_IMPL_A64__FMUL_H_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e200800: FMUL  <Sd>, <Sn>, <Sm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMUL_S_floatdp2, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FMUL_S_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FMUL_S_floatdp2
        IEM_INSTR_IMPL_A64__FMUL_S_floatdp2(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfc0f400/0f009000: FMUL  <Vd>.<T>, <Vn>.<T>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMUL_asimdelem_RH_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMUL_asimdelem_RH_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, Q));
#ifdef IEM_INSTR_IMPL_A64__FMUL_asimdelem_RH_H
        IEM_INSTR_IMPL_A64__FMUL_asimdelem_RH_H(Rd, Rn, H, Rm, M, L, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf80f400/0f809000: FMUL  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]
   Instruction Set: A64  Groups: asimdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMUL_asimdelem_R_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMUL_asimdelem_R_SD Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMUL_asimdelem_R_SD
        IEM_INSTR_IMPL_A64__FMUL_asimdelem_R_SD(Rd, Rn, H, Rm, M, L, sz, Q);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/2e20dc00: FMUL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMUL_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMUL_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FMUL_asimdsame_only
        IEM_INSTR_IMPL_A64__FMUL_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2e401c00: FMUL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMUL_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2e401c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FMUL_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FMUL_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FMUL_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffc0f400/5f009000: FMUL  <Hd>, <Hn>, <Vm>.H[<index>]
   Instruction Set: A64  Groups: asisdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMUL_asisdelem_RH_H, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FMUL_asisdelem_RH_H Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L));
#ifdef IEM_INSTR_IMPL_A64__FMUL_asisdelem_RH_H
        IEM_INSTR_IMPL_A64__FMUL_asisdelem_RH_H(Rd, Rn, H, Rm, M, L);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ff80f400/5f809000: FMUL  <V><d>, <V><n>, <Vm>.<Ts>[<index>]
   Instruction Set: A64  Groups: asisdelem, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FMUL_asisdelem_R_SD, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const H          = (uOpcode >> 11) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000000f;
    uint32_t const M          = (uOpcode >> 20) & 0x00000001;
    uint32_t const L          = (uOpcode >> 21) & 0x00000001;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FMUL_asisdelem_R_SD Rd=%#x Rn=%#x H=%u Rm=%#x M=%u L=%u sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, H, Rm, M, L, sz));
#ifdef IEM_INSTR_IMPL_A64__FMUL_asisdelem_R_SD
        IEM_INSTR_IMPL_A64__FMUL_asisdelem_R_SD(Rd, Rn, H, Rm, M, L, sz);
#else
        RT_NOREF(Rd, Rn, H, Rm, M, L, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e614000: FNEG  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNEG_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FNEG_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FNEG_D_floatdp1
        IEM_INSTR_IMPL_A64__FNEG_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee14000: FNEG  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNEG_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FNEG_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FNEG_H_floatdp1
        IEM_INSTR_IMPL_A64__FNEG_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e214000: FNEG  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNEG_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FNEG_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FNEG_S_floatdp1
        IEM_INSTR_IMPL_A64__FNEG_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2ea0f800: FNEG  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNEG_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FNEG_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FNEG_asimdmisc_R
        IEM_INSTR_IMPL_A64__FNEG_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ef8f800: FNEG  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNEG_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FNEG_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FNEG_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FNEG_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1f600000: FNMADD  <Dd>, <Dn>, <Dm>, <Da>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNMADD_D_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FNMADD_D_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FNMADD_D_floatdp3
        IEM_INSTR_IMPL_A64__FNMADD_D_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1fe00000: FNMADD  <Hd>, <Hn>, <Hm>, <Ha>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNMADD_H_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FNMADD_H_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FNMADD_H_floatdp3
        IEM_INSTR_IMPL_A64__FNMADD_H_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1f200000: FNMADD  <Sd>, <Sn>, <Sm>, <Sa>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNMADD_S_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FNMADD_S_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FNMADD_S_floatdp3
        IEM_INSTR_IMPL_A64__FNMADD_S_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1f608000: FNMSUB  <Dd>, <Dn>, <Dm>, <Da>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNMSUB_D_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FNMSUB_D_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FNMSUB_D_floatdp3
        IEM_INSTR_IMPL_A64__FNMSUB_D_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1fe08000: FNMSUB  <Hd>, <Hn>, <Hm>, <Ha>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNMSUB_H_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FNMSUB_H_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FNMSUB_H_floatdp3
        IEM_INSTR_IMPL_A64__FNMSUB_H_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08000/1f208000: FNMSUB  <Sd>, <Sn>, <Sm>, <Sa>
   Instruction Set: A64  Groups: floatdp3, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNMSUB_S_floatdp3, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Ra         = (uOpcode >> 10) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FNMSUB_S_floatdp3 Rd=%#x Rn=%#x Ra=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Ra, Rm));
#ifdef IEM_INSTR_IMPL_A64__FNMSUB_S_floatdp3
        IEM_INSTR_IMPL_A64__FNMSUB_S_floatdp3(Rd, Rn, Ra, Rm);
#else
        RT_NOREF(Rd, Rn, Ra, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e608800: FNMUL  <Dd>, <Dn>, <Dm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNMUL_D_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e608800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FNMUL_D_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FNMUL_D_floatdp2
            IEM_INSTR_IMPL_A64__FNMUL_D_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ee08800: FNMUL  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNMUL_H_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1ee08800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FNMUL_H_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FNMUL_H_floatdp2
            IEM_INSTR_IMPL_A64__FNMUL_H_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e208800: FNMUL  <Sd>, <Sn>, <Sm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FNMUL_S_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e208800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FNMUL_S_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FNMUL_S_floatdp2
            IEM_INSTR_IMPL_A64__FNMUL_S_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0ea1d800: FRECPE  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPE_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRECPE_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRECPE_asimdmisc_R
        IEM_INSTR_IMPL_A64__FRECPE_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ef9d800: FRECPE  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPE_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRECPE_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FRECPE_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRECPE_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5ea1d800: FRECPE  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPE_asisdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRECPE_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FRECPE_asisdmisc_R
        IEM_INSTR_IMPL_A64__FRECPE_asisdmisc_R(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ef9d800: FRECPE  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPE_asisdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRECPE_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRECPE_asisdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRECPE_asisdmiscfp16_R(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0e20fc00: FRECPS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPS_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRECPS_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRECPS_asimdsame_only
        IEM_INSTR_IMPL_A64__FRECPS_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0e403c00: FRECPS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPS_asimdsamefp16_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRECPS_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FRECPS_asimdsamefp16_only
        IEM_INSTR_IMPL_A64__FRECPS_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
        RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffa0fc00/5e20fc00: FRECPS  <V><d>, <V><n>, <V><m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPS_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRECPS_asisdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz));
#ifdef IEM_INSTR_IMPL_A64__FRECPS_asisdsame_only
        IEM_INSTR_IMPL_A64__FRECPS_asisdsame_only(Rd, Rn, Rm, sz);
#else
        RT_NOREF(Rd, Rn, Rm, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/5e403c00: FRECPS  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: asisdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPS_asisdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x5e403c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FRECPS_asisdsamefp16_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FRECPS_asisdsamefp16_only
            IEM_INSTR_IMPL_A64__FRECPS_asisdsamefp16_only(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/5ea1f800: FRECPX  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPX_asisdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRECPX_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FRECPX_asisdmisc_R
        IEM_INSTR_IMPL_A64__FRECPX_asisdmisc_R(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/5ef9f800: FRECPX  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRECPX_asisdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRECPX_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRECPX_asisdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRECPX_asisdmiscfp16_R(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e68c000: FRINT32X  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT32X_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
    {
        LogFlow(("%018x/%010x: FRINT32X_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINT32X_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINT32X_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e28c000: FRINT32X  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT32X_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
    {
        LogFlow(("%018x/%010x: FRINT32X_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINT32X_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINT32X_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2e21e800: FRINT32X  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT32X_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x2e21e800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
        {
            LogFlow(("%018x/%010x: FRINT32X_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINT32X_asimdmisc_R
            IEM_INSTR_IMPL_A64__FRINT32X_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e684000: FRINT32Z  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT32Z_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
    {
        LogFlow(("%018x/%010x: FRINT32Z_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINT32Z_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINT32Z_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e284000: FRINT32Z  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT32Z_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
    {
        LogFlow(("%018x/%010x: FRINT32Z_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINT32Z_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINT32Z_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0e21e800: FRINT32Z  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT32Z_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x0e21e800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
        {
            LogFlow(("%018x/%010x: FRINT32Z_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINT32Z_asimdmisc_R
            IEM_INSTR_IMPL_A64__FRINT32Z_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e69c000: FRINT64X  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT64X_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
    {
        LogFlow(("%018x/%010x: FRINT64X_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINT64X_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINT64X_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e29c000: FRINT64X  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT64X_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
    {
        LogFlow(("%018x/%010x: FRINT64X_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINT64X_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINT64X_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2e21f800: FRINT64X  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT64X_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x2e21f800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
        {
            LogFlow(("%018x/%010x: FRINT64X_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINT64X_asimdmisc_R
            IEM_INSTR_IMPL_A64__FRINT64X_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e694000: FRINT64Z  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT64Z_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
    {
        LogFlow(("%018x/%010x: FRINT64Z_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINT64Z_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINT64Z_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e294000: FRINT64Z  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT64Z_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
    {
        LogFlow(("%018x/%010x: FRINT64Z_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINT64Z_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINT64Z_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0e21f800: FRINT64Z  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINT64Z_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x0e21f800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFrintts /*FEAT_FRINTTS*/)
        {
            LogFlow(("%018x/%010x: FRINT64Z_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINT64Z_asimdmisc_R
            IEM_INSTR_IMPL_A64__FRINT64Z_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e664000: FRINTA  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTA_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTA_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTA_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINTA_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee64000: FRINTA  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTA_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTA_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTA_H_floatdp1
        IEM_INSTR_IMPL_A64__FRINTA_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e264000: FRINTA  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTA_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTA_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTA_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINTA_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2e218800: FRINTA  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTA_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRINTA_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTA_asimdmisc_R
        IEM_INSTR_IMPL_A64__FRINTA_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2e798800: FRINTA  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTA_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTA_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTA_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRINTA_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e67c000: FRINTI  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTI_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTI_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTI_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINTI_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee7c000: FRINTI  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTI_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTI_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTI_H_floatdp1
        IEM_INSTR_IMPL_A64__FRINTI_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e27c000: FRINTI  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTI_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTI_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTI_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINTI_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2ea19800: FRINTI  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTI_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRINTI_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTI_asimdmisc_R
        IEM_INSTR_IMPL_A64__FRINTI_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ef99800: FRINTI  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTI_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTI_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTI_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRINTI_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e654000: FRINTM  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTM_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTM_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTM_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINTM_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee54000: FRINTM  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTM_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTM_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTM_H_floatdp1
        IEM_INSTR_IMPL_A64__FRINTM_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e254000: FRINTM  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTM_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTM_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTM_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINTM_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0e219800: FRINTM  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTM_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x0e219800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FRINTM_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTM_asimdmisc_R
            IEM_INSTR_IMPL_A64__FRINTM_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0e799800: FRINTM  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTM_asimdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffffc00)) == UINT32_C(0x0e799800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FRINTM_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTM_asimdmiscfp16_R
            IEM_INSTR_IMPL_A64__FRINTM_asimdmiscfp16_R(Rd, Rn, Q);
#else
            RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e644000: FRINTN  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTN_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTN_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTN_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINTN_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee44000: FRINTN  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTN_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTN_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTN_H_floatdp1
        IEM_INSTR_IMPL_A64__FRINTN_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e244000: FRINTN  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTN_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTN_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTN_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINTN_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0e218800: FRINTN  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTN_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRINTN_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTN_asimdmisc_R
        IEM_INSTR_IMPL_A64__FRINTN_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0e798800: FRINTN  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTN_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTN_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTN_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRINTN_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e64c000: FRINTP  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTP_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTP_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTP_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINTP_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee4c000: FRINTP  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTP_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTP_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTP_H_floatdp1
        IEM_INSTR_IMPL_A64__FRINTP_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e24c000: FRINTP  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTP_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTP_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTP_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINTP_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0ea18800: FRINTP  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTP_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRINTP_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTP_asimdmisc_R
        IEM_INSTR_IMPL_A64__FRINTP_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ef98800: FRINTP  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTP_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTP_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTP_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRINTP_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e674000: FRINTX  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTX_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTX_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTX_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINTX_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee74000: FRINTX  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTX_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTX_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTX_H_floatdp1
        IEM_INSTR_IMPL_A64__FRINTX_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e274000: FRINTX  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTX_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTX_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTX_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINTX_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2e219800: FRINTX  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTX_asimdmisc_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfbffc00)) == UINT32_C(0x2e219800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: FRINTX_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTX_asimdmisc_R
            IEM_INSTR_IMPL_A64__FRINTX_asimdmisc_R(Rd, Rn, sz, Q);
#else
            RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2e799800: FRINTX  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTX_asimdmiscfp16_R, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffffc00)) == UINT32_C(0x2e799800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FRINTX_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTX_asimdmiscfp16_R
            IEM_INSTR_IMPL_A64__FRINTX_asimdmiscfp16_R(Rd, Rn, Q);
#else
            RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e65c000: FRINTZ  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTZ_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTZ_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTZ_D_floatdp1
        IEM_INSTR_IMPL_A64__FRINTZ_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee5c000: FRINTZ  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTZ_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTZ_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTZ_H_floatdp1
        IEM_INSTR_IMPL_A64__FRINTZ_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e25c000: FRINTZ  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTZ_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FRINTZ_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRINTZ_S_floatdp1
        IEM_INSTR_IMPL_A64__FRINTZ_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/0ea19800: FRINTZ  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTZ_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRINTZ_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTZ_asimdmisc_R
        IEM_INSTR_IMPL_A64__FRINTZ_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ef99800: FRINTZ  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRINTZ_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRINTZ_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FRINTZ_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRINTZ_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2ea1d800: FRSQRTE  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRSQRTE_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRSQRTE_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRSQRTE_asimdmisc_R
        IEM_INSTR_IMPL_A64__FRSQRTE_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ef9d800: FRSQRTE  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRSQRTE_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRSQRTE_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FRSQRTE_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRSQRTE_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffbffc00/7ea1d800: FRSQRTE  <V><d>, <V><n>
   Instruction Set: A64  Groups: asisdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRSQRTE_asisdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRSQRTE_asisdmisc_R Rd=%#x Rn=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz));
#ifdef IEM_INSTR_IMPL_A64__FRSQRTE_asisdmisc_R
        IEM_INSTR_IMPL_A64__FRSQRTE_asisdmisc_R(Rd, Rn, sz);
#else
        RT_NOREF(Rd, Rn, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/7ef9d800: FRSQRTE  <Hd>, <Hn>
   Instruction Set: A64  Groups: asisdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRSQRTE_asisdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FRSQRTE_asisdmiscfp16_R Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FRSQRTE_asisdmiscfp16_R
        IEM_INSTR_IMPL_A64__FRSQRTE_asisdmiscfp16_R(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0ea0fc00: FRSQRTS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRSQRTS_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRSQRTS_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FRSQRTS_asimdsame_only
        IEM_INSTR_IMPL_A64__FRSQRTS_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0ec03c00: FRSQRTS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRSQRTS_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0ec03c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FRSQRTS_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FRSQRTS_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FRSQRTS_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffa0fc00/5ea0fc00: FRSQRTS  <V><d>, <V><n>, <V><m>
   Instruction Set: A64  Groups: asisdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRSQRTS_asisdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FRSQRTS_asisdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz));
#ifdef IEM_INSTR_IMPL_A64__FRSQRTS_asisdsame_only
        IEM_INSTR_IMPL_A64__FRSQRTS_asisdsame_only(Rd, Rn, Rm, sz);
#else
        RT_NOREF(Rd, Rn, Rm, sz, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/5ec03c00: FRSQRTS  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: asisdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FRSQRTS_asisdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x5ec03c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FRSQRTS_asisdsamefp16_only Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FRSQRTS_asisdsamefp16_only
            IEM_INSTR_IMPL_A64__FRSQRTS_asisdsamefp16_only(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bf20fc00/2e20fc00: FSCALE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSCALE_asimdsame_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbf20fc00)) == UINT32_C(0x2e20fc00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 22) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8 /*FEAT_FP8*/ && (size & 2) == 2)
        {
            LogFlow(("%018x/%010x: FSCALE_asimdsame_only Rd=%#x Rn=%#x Rm=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, size, Q));
#ifdef IEM_INSTR_IMPL_A64__FSCALE_asimdsame_only
            IEM_INSTR_IMPL_A64__FSCALE_asimdsame_only(Rd, Rn, Rm, size, Q);
#else
            RT_NOREF(Rd, Rn, Rm, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/2ec03c00: FSCALE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSCALE_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x2ec03c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp8 /*FEAT_FP8*/)
        {
            LogFlow(("%018x/%010x: FSCALE_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FSCALE_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FSCALE_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e61c000: FSQRT  <Dd>, <Dn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSQRT_D_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FSQRT_D_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FSQRT_D_floatdp1
        IEM_INSTR_IMPL_A64__FSQRT_D_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1ee1c000: FSQRT  <Hd>, <Hn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSQRT_H_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FSQRT_H_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FSQRT_H_floatdp1
        IEM_INSTR_IMPL_A64__FSQRT_H_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/1e21c000: FSQRT  <Sd>, <Sn>
   Instruction Set: A64  Groups: floatdp1, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSQRT_S_floatdp1, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FSQRT_S_floatdp1 Rd=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn));
#ifdef IEM_INSTR_IMPL_A64__FSQRT_S_floatdp1
        IEM_INSTR_IMPL_A64__FSQRT_S_floatdp1(Rd, Rn);
#else
        RT_NOREF(Rd, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfbffc00/2ea1f800: FSQRT  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmisc, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSQRT_asimdmisc_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FSQRT_asimdmisc_R Rd=%#x Rn=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FSQRT_asimdmisc_R
        IEM_INSTR_IMPL_A64__FSQRT_asimdmisc_R(Rd, Rn, sz, Q);
#else
        RT_NOREF(Rd, Rn, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/2ef9f800: FSQRT  <Vd>.<T>, <Vn>.<T>
   Instruction Set: A64  Groups: asimdmiscfp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSQRT_asimdmiscfp16_R, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FSQRT_asimdmiscfp16_R Rd=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__FSQRT_asimdmiscfp16_R
        IEM_INSTR_IMPL_A64__FSQRT_asimdmiscfp16_R(Rd, Rn, Q);
#else
        RT_NOREF(Rd, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e603800: FSUB  <Dd>, <Dn>, <Dm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSUB_D_floatdp2, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
    {
        LogFlow(("%018x/%010x: FSUB_D_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FSUB_D_floatdp2
        IEM_INSTR_IMPL_A64__FSUB_D_floatdp2(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1ee03800: FSUB  <Hd>, <Hn>, <Hm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSUB_H_floatdp2, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
    {
        LogFlow(("%018x/%010x: FSUB_H_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FSUB_H_floatdp2
        IEM_INSTR_IMPL_A64__FSUB_H_floatdp2(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/1e203800: FSUB  <Sd>, <Sn>, <Sm>
   Instruction Set: A64  Groups: floatdp2, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSUB_S_floatdp2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x1e203800))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/)
        {
            LogFlow(("%018x/%010x: FSUB_S_floatdp2 Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__FSUB_S_floatdp2
            IEM_INSTR_IMPL_A64__FSUB_S_floatdp2(Rd, Rn, Rm);
#else
            RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfa0fc00/0ea0d400: FSUB  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsame, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSUB_asimdsame_only, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const sz         = (uOpcode >> 22) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: FSUB_asimdsame_only Rd=%#x Rn=%#x Rm=%#x sz=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, sz, Q));
#ifdef IEM_INSTR_IMPL_A64__FSUB_asimdsame_only
        IEM_INSTR_IMPL_A64__FSUB_asimdsame_only(Rd, Rn, Rm, sz, Q);
#else
        RT_NOREF(Rd, Rn, Rm, sz, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0ec01400: FSUB  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>
   Instruction Set: A64  Groups: asimdsamefp16, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_FSUB_asimdsamefp16_only, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfe0fc00)) == UINT32_C(0x0ec01400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
            && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp16 /*FEAT_FP16*/)
        {
            LogFlow(("%018x/%010x: FSUB_asimdsamefp16_only Rd=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__FSUB_asimdsamefp16_only
            IEM_INSTR_IMPL_A64__FSUB_asimdsamefp16_only(Rd, Rn, Rm, Q);
#else
            RT_NOREF(Rd, Rn, Rm, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffffffff/d503227f: GCSB  DSYNC
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_GCSB_HD_hints, uint32_t, uOpcode)
{
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fGcs /*FEAT_GCS*/)
    {
        LogFlow(("%018x/%010x: GCSB_HD_hints\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode));
#ifdef IEM_INSTR_IMPL_A64__GCSB_HD_hints
        IEM_INSTR_IMPL_A64__GCSB_HD_hints();
#else
        RT_NOREF(pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/d91f0c00: GCSSTR  <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: ldst_gcs, ldst */
FNIEMOP_DEF_1(iemDecodeA64_GCSSTR_64_ldst_gcs, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xd91f0c00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fGcs /*FEAT_GCS*/)
        {
            LogFlow(("%018x/%010x: GCSSTR_64_ldst_gcs Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__GCSSTR_64_ldst_gcs
            IEM_INSTR_IMPL_A64__GCSSTR_64_ldst_gcs(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/d91f1c00: GCSSTTR  <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: ldst_gcs, ldst */
FNIEMOP_DEF_1(iemDecodeA64_GCSSTTR_64_ldst_gcs, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xd91f1c00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fGcs /*FEAT_GCS*/)
        {
            LogFlow(("%018x/%010x: GCSSTTR_64_ldst_gcs Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__GCSSTTR_64_ldst_gcs
            IEM_INSTR_IMPL_A64__GCSSTTR_64_ldst_gcs(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/9ac01400: GMI  <Xd>, <Xn|SP>, <Xm>
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_GMI_64G_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMte /*FEAT_MTE*/)
    {
        LogFlow(("%018x/%010x: GMI_64G_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__GMI_64G_dp_2src
        IEM_INSTR_IMPL_A64__GMI_64G_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffff01f/d503201f: HINT  #<imm>
   Instruction Set: A64  Groups: hints, control */
FNIEMOP_DEF_1(iemDecodeA64_HINT_HM_hints, uint32_t, uOpcode)
{
    uint32_t const op2        = (uOpcode >>  5) & 0x00000007;
    uint32_t const CRm        = (uOpcode >>  8) & 0x0000000f;
    LogFlow(("%018x/%010x: HINT_HM_hints op2=%u CRm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, op2, CRm));
#ifdef IEM_INSTR_IMPL_A64__HINT_HM_hints
    IEM_INSTR_IMPL_A64__HINT_HM_hints(op2, CRm);
#else
    RT_NOREF(op2, CRm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe0001f/d4400000: HLT  #<imm>
   Instruction Set: A64  Groups: exception, control */
FNIEMOP_DEF_1(iemDecodeA64_HLT_EX_exception, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0001f)) == UINT32_C(0xd4400000))
    {
        uint32_t const imm16      = (uOpcode >>  5) & 0x0000ffff;
        LogFlow(("%018x/%010x: HLT_EX_exception imm16=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm16));
#ifdef IEM_INSTR_IMPL_A64__HLT_EX_exception
        IEM_INSTR_IMPL_A64__HLT_EX_exception(imm16);
#else
        RT_NOREF(imm16, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0001f/d4000002: HVC  #<imm>
   Instruction Set: A64  Groups: exception, control */
FNIEMOP_DEF_1(iemDecodeA64_HVC_EX_exception, uint32_t, uOpcode)
{
    uint32_t const imm16      = (uOpcode >>  5) & 0x0000ffff;
    LogFlow(("%018x/%010x: HVC_EX_exception imm16=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, imm16));
#ifdef IEM_INSTR_IMPL_A64__HVC_EX_exception
    IEM_INSTR_IMPL_A64__HVC_EX_exception(imm16);
#else
    RT_NOREF(imm16, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffe0fc00/4e001c00: INS  <Vd>.<Ts>[<index>], <R><n>
   Instruction Set: A64  Groups: asimdins, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_INS_asimdins_IR_r, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x4e001c00))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imm5       = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: INS_asimdins_IR_r Rd=%#x Rn=%#x imm5=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm5));
#ifdef IEM_INSTR_IMPL_A64__INS_asimdins_IR_r
            IEM_INSTR_IMPL_A64__INS_asimdins_IR_r(Rd, Rn, imm5);
#else
            RT_NOREF(Rd, Rn, imm5, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe08400/6e000400: INS  <Vd>.<Ts>[<index1>], <Vn>.<Ts>[<index2>]
   Instruction Set: A64  Groups: asimdins, simd_dp */
FNIEMOP_DEF_1(iemDecodeA64_INS_asimdins_IV_v, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe08400)) == UINT32_C(0x6e000400))
    {
        uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const imm4       = (uOpcode >> 11) & 0x0000000f;
        uint32_t const imm5       = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: INS_asimdins_IV_v Rd=%#x Rn=%#x imm4=%#x imm5=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, imm4, imm5));
#ifdef IEM_INSTR_IMPL_A64__INS_asimdins_IV_v
            IEM_INSTR_IMPL_A64__INS_asimdins_IV_v(Rd, Rn, imm4, imm5);
#else
            RT_NOREF(Rd, Rn, imm4, imm5, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/9ac01000: IRG  <Xd|SP>, <Xn|SP>{, <Xm>}
   Instruction Set: A64  Groups: dp_2src, dpreg */
FNIEMOP_DEF_1(iemDecodeA64_IRG_64I_dp_2src, uint32_t, uOpcode)
{
    uint32_t const Rd         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fMte /*FEAT_MTE*/)
    {
        LogFlow(("%018x/%010x: IRG_64I_dp_2src Rd=%#x Rn=%#x Rm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rd, Rn, Rm));
#ifdef IEM_INSTR_IMPL_A64__IRG_64I_dp_2src
        IEM_INSTR_IMPL_A64__IRG_64I_dp_2src(Rd, Rn, Rm);
#else
        RT_NOREF(Rd, Rn, Rm, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffff0ff/d50330df: ISB{  <option> |   #<imm>}
   Instruction Set: A64  Groups: barriers, control */
FNIEMOP_DEF_1(iemDecodeA64_ISB_BI_barriers, uint32_t, uOpcode)
{
    uint32_t const CRm        = (uOpcode >>  8) & 0x0000000f;
    LogFlow(("%018x/%010x: ISB_BI_barriers CRm=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, CRm));
#ifdef IEM_INSTR_IMPL_A64__ISB_BI_barriers
    IEM_INSTR_IMPL_A64__ISB_BI_barriers(CRm);
#else
    RT_NOREF(CRm, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* bffff000/0d40c000: LD1R  { <Vt>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1R_asisdlso_R1, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0d40c000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD1R_asisdlso_R1 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1R_asisdlso_R1
            IEM_INSTR_IMPL_A64__LD1R_asisdlso_R1(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0ddfc000: LD1R  { <Vt>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1R_asisdlsop_R1_i, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1R_asisdlsop_R1_i Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1R_asisdlsop_R1_i
        IEM_INSTR_IMPL_A64__LD1R_asisdlsop_R1_i(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0dc0c000: LD1R  { <Vt>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1R_asisdlsop_RX1_r, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD1R_asisdlsop_RX1_r Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1R_asisdlsop_RX1_r
        IEM_INSTR_IMPL_A64__LD1R_asisdlsop_RX1_r(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0c407000: LD1  { <Vt>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlse, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlse_R1_1v, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0c407000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD1_asisdlse_R1_1v Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlse_R1_1v
            IEM_INSTR_IMPL_A64__LD1_asisdlse_R1_1v(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0c40a000: LD1  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlse, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlse_R2_2v, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0c40a000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD1_asisdlse_R2_2v Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlse_R2_2v
            IEM_INSTR_IMPL_A64__LD1_asisdlse_R2_2v(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0c406000: LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlse, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlse_R3_3v, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0c406000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD1_asisdlse_R3_3v Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlse_R3_3v
            IEM_INSTR_IMPL_A64__LD1_asisdlse_R3_3v(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0c402000: LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlse, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlse_R4_4v, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0c402000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD1_asisdlse_R4_4v Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlse_R4_4v
            IEM_INSTR_IMPL_A64__LD1_asisdlse_R4_4v(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0cdf7000: LD1  { <Vt>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsep_I1_i1, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsep_I1_i1 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsep_I1_i1
        IEM_INSTR_IMPL_A64__LD1_asisdlsep_I1_i1(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0cdfa000: LD1  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsep_I2_i2, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsep_I2_i2 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsep_I2_i2
        IEM_INSTR_IMPL_A64__LD1_asisdlsep_I2_i2(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0cdf6000: LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsep_I3_i3, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsep_I3_i3 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsep_I3_i3
        IEM_INSTR_IMPL_A64__LD1_asisdlsep_I3_i3(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0cdf2000: LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsep_I4_i4, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsep_I4_i4 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsep_I4_i4
        IEM_INSTR_IMPL_A64__LD1_asisdlsep_I4_i4(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0cc07000: LD1  { <Vt>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsep_R1_r1, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsep_R1_r1 Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsep_R1_r1
        IEM_INSTR_IMPL_A64__LD1_asisdlsep_R1_r1(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0cc0a000: LD1  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsep_R2_r2, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsep_R2_r2 Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsep_R2_r2
        IEM_INSTR_IMPL_A64__LD1_asisdlsep_R2_r2(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0cc06000: LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsep_R3_r3, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsep_R3_r3 Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsep_R3_r3
        IEM_INSTR_IMPL_A64__LD1_asisdlsep_R3_r3(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0cc02000: LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsep_R4_r4, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsep_R4_r4 Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsep_R4_r4
        IEM_INSTR_IMPL_A64__LD1_asisdlsep_R4_r4(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe000/0d400000: LD1  { <Vt>.B }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlso_B1_1b, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffe000)) == UINT32_C(0x0d400000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD1_asisdlso_B1_1b Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlso_B1_1b
            IEM_INSTR_IMPL_A64__LD1_asisdlso_B1_1b(Rt, Rn, size, S, Q);
#else
            RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0d408400: LD1  { <Vt>.D }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlso_D1_1d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1_asisdlso_D1_1d Rt=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlso_D1_1d
        IEM_INSTR_IMPL_A64__LD1_asisdlso_D1_1d(Rt, Rn, Q);
#else
        RT_NOREF(Rt, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe400/0d404000: LD1  { <Vt>.H }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlso_H1_1h, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffe400)) == UINT32_C(0x0d404000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD1_asisdlso_H1_1h Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlso_H1_1h
            IEM_INSTR_IMPL_A64__LD1_asisdlso_H1_1h(Rt, Rn, size, S, Q);
#else
            RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffec00/0d408000: LD1  { <Vt>.S }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlso_S1_1s, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffec00)) == UINT32_C(0x0d408000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD1_asisdlso_S1_1s Rt=%#x Rn=%#x S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlso_S1_1s
            IEM_INSTR_IMPL_A64__LD1_asisdlso_S1_1s(Rt, Rn, S, Q);
#else
            RT_NOREF(Rt, Rn, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe000/0ddf0000: LD1  { <Vt>.B }[<index>], [<Xn|SP>], #1
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsop_B1_i1b, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsop_B1_i1b Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsop_B1_i1b
        IEM_INSTR_IMPL_A64__LD1_asisdlsop_B1_i1b(Rt, Rn, size, S, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0e000/0dc00000: LD1  { <Vt>.B }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsop_BX1_r1b, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsop_BX1_r1b Rt=%#x Rn=%#x size=%u S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsop_BX1_r1b
        IEM_INSTR_IMPL_A64__LD1_asisdlsop_BX1_r1b(Rt, Rn, size, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ddf8400: LD1  { <Vt>.D }[<index>], [<Xn|SP>], #8
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsop_D1_i1d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsop_D1_i1d Rt=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsop_D1_i1d
        IEM_INSTR_IMPL_A64__LD1_asisdlsop_D1_i1d(Rt, Rn, Q);
#else
        RT_NOREF(Rt, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0dc08400: LD1  { <Vt>.D }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsop_DX1_r1d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsop_DX1_r1d Rt=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsop_DX1_r1d
        IEM_INSTR_IMPL_A64__LD1_asisdlsop_DX1_r1d(Rt, Rn, Rm, Q);
#else
        RT_NOREF(Rt, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe400/0ddf4000: LD1  { <Vt>.H }[<index>], [<Xn|SP>], #2
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsop_H1_i1h, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsop_H1_i1h Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsop_H1_i1h
        IEM_INSTR_IMPL_A64__LD1_asisdlsop_H1_i1h(Rt, Rn, size, S, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0e400/0dc04000: LD1  { <Vt>.H }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsop_HX1_r1h, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsop_HX1_r1h Rt=%#x Rn=%#x size=%u S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsop_HX1_r1h
        IEM_INSTR_IMPL_A64__LD1_asisdlsop_HX1_r1h(Rt, Rn, size, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffec00/0ddf8000: LD1  { <Vt>.S }[<index>], [<Xn|SP>], #4
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsop_S1_i1s, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsop_S1_i1s Rt=%#x Rn=%#x S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsop_S1_i1s
        IEM_INSTR_IMPL_A64__LD1_asisdlsop_S1_i1s(Rt, Rn, S, Q);
#else
        RT_NOREF(Rt, Rn, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0ec00/0dc08000: LD1  { <Vt>.S }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD1_asisdlsop_SX1_r1s, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD1_asisdlsop_SX1_r1s Rt=%#x Rn=%#x S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD1_asisdlsop_SX1_r1s
        IEM_INSTR_IMPL_A64__LD1_asisdlsop_SX1_r1s(Rt, Rn, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0d60c000: LD2R  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2R_asisdlso_R2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0d60c000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD2R_asisdlso_R2 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2R_asisdlso_R2
            IEM_INSTR_IMPL_A64__LD2R_asisdlso_R2(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0dffc000: LD2R  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2R_asisdlsop_R2_i, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD2R_asisdlsop_R2_i Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2R_asisdlsop_R2_i
        IEM_INSTR_IMPL_A64__LD2R_asisdlsop_R2_i(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0de0c000: LD2R  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2R_asisdlsop_RX2_r, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD2R_asisdlsop_RX2_r Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2R_asisdlsop_RX2_r
        IEM_INSTR_IMPL_A64__LD2R_asisdlsop_RX2_r(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0c408000: LD2  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlse, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlse_R2, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0c408000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD2_asisdlse_R2 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlse_R2
            IEM_INSTR_IMPL_A64__LD2_asisdlse_R2(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0cdf8000: LD2  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsep_I2_i, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsep_I2_i Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsep_I2_i
        IEM_INSTR_IMPL_A64__LD2_asisdlsep_I2_i(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0cc08000: LD2  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsep_R2_r, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsep_R2_r Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsep_R2_r
        IEM_INSTR_IMPL_A64__LD2_asisdlsep_R2_r(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe000/0d600000: LD2  { <Vt>.B, <Vt2>.B }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlso_B2_2b, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffe000)) == UINT32_C(0x0d600000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD2_asisdlso_B2_2b Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlso_B2_2b
            IEM_INSTR_IMPL_A64__LD2_asisdlso_B2_2b(Rt, Rn, size, S, Q);
#else
            RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0d608400: LD2  { <Vt>.D, <Vt2>.D }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlso_D2_2d, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffffc00)) == UINT32_C(0x0d608400))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD2_asisdlso_D2_2d Rt=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlso_D2_2d
            IEM_INSTR_IMPL_A64__LD2_asisdlso_D2_2d(Rt, Rn, Q);
#else
            RT_NOREF(Rt, Rn, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe400/0d604000: LD2  { <Vt>.H, <Vt2>.H }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlso_H2_2h, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffe400)) == UINT32_C(0x0d604000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD2_asisdlso_H2_2h Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlso_H2_2h
            IEM_INSTR_IMPL_A64__LD2_asisdlso_H2_2h(Rt, Rn, size, S, Q);
#else
            RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffec00/0d608000: LD2  { <Vt>.S, <Vt2>.S }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlso_S2_2s, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffec00)) == UINT32_C(0x0d608000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD2_asisdlso_S2_2s Rt=%#x Rn=%#x S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlso_S2_2s
            IEM_INSTR_IMPL_A64__LD2_asisdlso_S2_2s(Rt, Rn, S, Q);
#else
            RT_NOREF(Rt, Rn, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe000/0dff0000: LD2  { <Vt>.B, <Vt2>.B }[<index>], [<Xn|SP>], #2
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsop_B2_i2b, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsop_B2_i2b Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsop_B2_i2b
        IEM_INSTR_IMPL_A64__LD2_asisdlsop_B2_i2b(Rt, Rn, size, S, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0e000/0de00000: LD2  { <Vt>.B, <Vt2>.B }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsop_BX2_r2b, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsop_BX2_r2b Rt=%#x Rn=%#x size=%u S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsop_BX2_r2b
        IEM_INSTR_IMPL_A64__LD2_asisdlsop_BX2_r2b(Rt, Rn, size, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0dff8400: LD2  { <Vt>.D, <Vt2>.D }[<index>], [<Xn|SP>], #16
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsop_D2_i2d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsop_D2_i2d Rt=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsop_D2_i2d
        IEM_INSTR_IMPL_A64__LD2_asisdlsop_D2_i2d(Rt, Rn, Q);
#else
        RT_NOREF(Rt, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0de08400: LD2  { <Vt>.D, <Vt2>.D }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsop_DX2_r2d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsop_DX2_r2d Rt=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsop_DX2_r2d
        IEM_INSTR_IMPL_A64__LD2_asisdlsop_DX2_r2d(Rt, Rn, Rm, Q);
#else
        RT_NOREF(Rt, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe400/0dff4000: LD2  { <Vt>.H, <Vt2>.H }[<index>], [<Xn|SP>], #4
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsop_H2_i2h, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsop_H2_i2h Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsop_H2_i2h
        IEM_INSTR_IMPL_A64__LD2_asisdlsop_H2_i2h(Rt, Rn, size, S, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0e400/0de04000: LD2  { <Vt>.H, <Vt2>.H }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsop_HX2_r2h, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsop_HX2_r2h Rt=%#x Rn=%#x size=%u S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsop_HX2_r2h
        IEM_INSTR_IMPL_A64__LD2_asisdlsop_HX2_r2h(Rt, Rn, size, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffec00/0dff8000: LD2  { <Vt>.S, <Vt2>.S }[<index>], [<Xn|SP>], #8
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsop_S2_i2s, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsop_S2_i2s Rt=%#x Rn=%#x S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsop_S2_i2s
        IEM_INSTR_IMPL_A64__LD2_asisdlsop_S2_i2s(Rt, Rn, S, Q);
#else
        RT_NOREF(Rt, Rn, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0ec00/0de08000: LD2  { <Vt>.S, <Vt2>.S }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD2_asisdlsop_SX2_r2s, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD2_asisdlsop_SX2_r2s Rt=%#x Rn=%#x S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD2_asisdlsop_SX2_r2s
        IEM_INSTR_IMPL_A64__LD2_asisdlsop_SX2_r2s(Rt, Rn, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0d40e000: LD3R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3R_asisdlso_R3, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0d40e000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD3R_asisdlso_R3 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3R_asisdlso_R3
            IEM_INSTR_IMPL_A64__LD3R_asisdlso_R3(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0ddfe000: LD3R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3R_asisdlsop_R3_i, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD3R_asisdlsop_R3_i Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3R_asisdlsop_R3_i
        IEM_INSTR_IMPL_A64__LD3R_asisdlsop_R3_i(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0dc0e000: LD3R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3R_asisdlsop_RX3_r, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD3R_asisdlsop_RX3_r Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3R_asisdlsop_RX3_r
        IEM_INSTR_IMPL_A64__LD3R_asisdlsop_RX3_r(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0c404000: LD3  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlse, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlse_R3, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0c404000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD3_asisdlse_R3 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlse_R3
            IEM_INSTR_IMPL_A64__LD3_asisdlse_R3(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0cdf4000: LD3  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsep_I3_i, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsep_I3_i Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsep_I3_i
        IEM_INSTR_IMPL_A64__LD3_asisdlsep_I3_i(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0cc04000: LD3  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsep_R3_r, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsep_R3_r Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsep_R3_r
        IEM_INSTR_IMPL_A64__LD3_asisdlsep_R3_r(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe000/0d402000: LD3  { <Vt>.B, <Vt2>.B, <Vt3>.B }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlso_B3_3b, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffe000)) == UINT32_C(0x0d402000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD3_asisdlso_B3_3b Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlso_B3_3b
            IEM_INSTR_IMPL_A64__LD3_asisdlso_B3_3b(Rt, Rn, size, S, Q);
#else
            RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0d40a400: LD3  { <Vt>.D, <Vt2>.D, <Vt3>.D }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlso_D3_3d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD3_asisdlso_D3_3d Rt=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlso_D3_3d
        IEM_INSTR_IMPL_A64__LD3_asisdlso_D3_3d(Rt, Rn, Q);
#else
        RT_NOREF(Rt, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe400/0d406000: LD3  { <Vt>.H, <Vt2>.H, <Vt3>.H }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlso_H3_3h, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffe400)) == UINT32_C(0x0d406000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD3_asisdlso_H3_3h Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlso_H3_3h
            IEM_INSTR_IMPL_A64__LD3_asisdlso_H3_3h(Rt, Rn, size, S, Q);
#else
            RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffec00/0d40a000: LD3  { <Vt>.S, <Vt2>.S, <Vt3>.S }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlso_S3_3s, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD3_asisdlso_S3_3s Rt=%#x Rn=%#x S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlso_S3_3s
        IEM_INSTR_IMPL_A64__LD3_asisdlso_S3_3s(Rt, Rn, S, Q);
#else
        RT_NOREF(Rt, Rn, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe000/0ddf2000: LD3  { <Vt>.B, <Vt2>.B, <Vt3>.B }[<index>], [<Xn|SP>], #3
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsop_B3_i3b, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsop_B3_i3b Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsop_B3_i3b
        IEM_INSTR_IMPL_A64__LD3_asisdlsop_B3_i3b(Rt, Rn, size, S, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0e000/0dc02000: LD3  { <Vt>.B, <Vt2>.B, <Vt3>.B }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsop_BX3_r3b, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsop_BX3_r3b Rt=%#x Rn=%#x size=%u S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsop_BX3_r3b
        IEM_INSTR_IMPL_A64__LD3_asisdlsop_BX3_r3b(Rt, Rn, size, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0ddfa400: LD3  { <Vt>.D, <Vt2>.D, <Vt3>.D }[<index>], [<Xn|SP>], #24
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsop_D3_i3d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsop_D3_i3d Rt=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsop_D3_i3d
        IEM_INSTR_IMPL_A64__LD3_asisdlsop_D3_i3d(Rt, Rn, Q);
#else
        RT_NOREF(Rt, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0dc0a400: LD3  { <Vt>.D, <Vt2>.D, <Vt3>.D }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsop_DX3_r3d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsop_DX3_r3d Rt=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsop_DX3_r3d
        IEM_INSTR_IMPL_A64__LD3_asisdlsop_DX3_r3d(Rt, Rn, Rm, Q);
#else
        RT_NOREF(Rt, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe400/0ddf6000: LD3  { <Vt>.H, <Vt2>.H, <Vt3>.H }[<index>], [<Xn|SP>], #6
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsop_H3_i3h, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsop_H3_i3h Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsop_H3_i3h
        IEM_INSTR_IMPL_A64__LD3_asisdlsop_H3_i3h(Rt, Rn, size, S, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0e400/0dc06000: LD3  { <Vt>.H, <Vt2>.H, <Vt3>.H }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsop_HX3_r3h, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsop_HX3_r3h Rt=%#x Rn=%#x size=%u S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsop_HX3_r3h
        IEM_INSTR_IMPL_A64__LD3_asisdlsop_HX3_r3h(Rt, Rn, size, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffec00/0ddfa000: LD3  { <Vt>.S, <Vt2>.S, <Vt3>.S }[<index>], [<Xn|SP>], #12
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsop_S3_i3s, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsop_S3_i3s Rt=%#x Rn=%#x S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsop_S3_i3s
        IEM_INSTR_IMPL_A64__LD3_asisdlsop_S3_i3s(Rt, Rn, S, Q);
#else
        RT_NOREF(Rt, Rn, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0ec00/0dc0a000: LD3  { <Vt>.S, <Vt2>.S, <Vt3>.S }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD3_asisdlsop_SX3_r3s, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD3_asisdlsop_SX3_r3s Rt=%#x Rn=%#x S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD3_asisdlsop_SX3_r3s
        IEM_INSTR_IMPL_A64__LD3_asisdlsop_SX3_r3s(Rt, Rn, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0d60e000: LD4R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4R_asisdlso_R4, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0d60e000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD4R_asisdlso_R4 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4R_asisdlso_R4
            IEM_INSTR_IMPL_A64__LD4R_asisdlso_R4(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0dffe000: LD4R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4R_asisdlsop_R4_i, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD4R_asisdlsop_R4_i Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4R_asisdlsop_R4_i
        IEM_INSTR_IMPL_A64__LD4R_asisdlsop_R4_i(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0de0e000: LD4R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4R_asisdlsop_RX4_r, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD4R_asisdlsop_RX4_r Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4R_asisdlsop_RX4_r
        IEM_INSTR_IMPL_A64__LD4R_asisdlsop_RX4_r(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0c400000: LD4  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlse, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlse_R4, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffff000)) == UINT32_C(0x0c400000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD4_asisdlse_R4 Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlse_R4
            IEM_INSTR_IMPL_A64__LD4_asisdlse_R4(Rt, Rn, size, Q);
#else
            RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffff000/0cdf0000: LD4  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsep_I4_i, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsep_I4_i Rt=%#x Rn=%#x size=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsep_I4_i
        IEM_INSTR_IMPL_A64__LD4_asisdlsep_I4_i(Rt, Rn, size, Q);
#else
        RT_NOREF(Rt, Rn, size, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0f000/0cc00000: LD4  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsep, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsep_R4_r, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsep_R4_r Rt=%#x Rn=%#x size=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsep_R4_r
        IEM_INSTR_IMPL_A64__LD4_asisdlsep_R4_r(Rt, Rn, size, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe000/0d602000: LD4  { <Vt>.B, <Vt2>.B, <Vt3>.B, <Vt4>.B }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlso_B4_4b, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffe000)) == UINT32_C(0x0d602000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD4_asisdlso_B4_4b Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlso_B4_4b
            IEM_INSTR_IMPL_A64__LD4_asisdlso_B4_4b(Rt, Rn, size, S, Q);
#else
            RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0d60a400: LD4  { <Vt>.D, <Vt2>.D, <Vt3>.D, <Vt4>.D }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlso_D4_4d, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbffffc00)) == UINT32_C(0x0d60a400))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD4_asisdlso_D4_4d Rt=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlso_D4_4d
            IEM_INSTR_IMPL_A64__LD4_asisdlso_D4_4d(Rt, Rn, Q);
#else
            RT_NOREF(Rt, Rn, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe400/0d606000: LD4  { <Vt>.H, <Vt2>.H, <Vt3>.H, <Vt4>.H }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlso_H4_4h, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffe400)) == UINT32_C(0x0d606000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const size       = (uOpcode >> 10) & 0x00000003;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD4_asisdlso_H4_4h Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlso_H4_4h
            IEM_INSTR_IMPL_A64__LD4_asisdlso_H4_4h(Rt, Rn, size, S, Q);
#else
            RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffec00/0d60a000: LD4  { <Vt>.S, <Vt2>.S, <Vt3>.S, <Vt4>.S }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlso_S4_4s, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xbfffec00)) == UINT32_C(0x0d60a000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const S          = (uOpcode >> 12) & 0x00000001;
        uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
        {
            LogFlow(("%018x/%010x: LD4_asisdlso_S4_4s Rt=%#x Rn=%#x S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlso_S4_4s
            IEM_INSTR_IMPL_A64__LD4_asisdlso_S4_4s(Rt, Rn, S, Q);
#else
            RT_NOREF(Rt, Rn, S, Q, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe000/0dff2000: LD4  { <Vt>.B, <Vt2>.B, <Vt3>.B, <Vt4>.B }[<index>], [<Xn|SP>], #4
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsop_B4_i4b, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsop_B4_i4b Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsop_B4_i4b
        IEM_INSTR_IMPL_A64__LD4_asisdlsop_B4_i4b(Rt, Rn, size, S, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0e000/0de02000: LD4  { <Vt>.B, <Vt2>.B, <Vt3>.B, <Vt4>.B }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsop_BX4_r4b, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsop_BX4_r4b Rt=%#x Rn=%#x size=%u S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsop_BX4_r4b
        IEM_INSTR_IMPL_A64__LD4_asisdlsop_BX4_r4b(Rt, Rn, size, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0dffa400: LD4  { <Vt>.D, <Vt2>.D, <Vt3>.D, <Vt4>.D }[<index>], [<Xn|SP>], #32
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsop_D4_i4d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsop_D4_i4d Rt=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsop_D4_i4d
        IEM_INSTR_IMPL_A64__LD4_asisdlsop_D4_i4d(Rt, Rn, Q);
#else
        RT_NOREF(Rt, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0fc00/0de0a400: LD4  { <Vt>.D, <Vt2>.D, <Vt3>.D, <Vt4>.D }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsop_DX4_r4d, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsop_DX4_r4d Rt=%#x Rn=%#x Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsop_DX4_r4d
        IEM_INSTR_IMPL_A64__LD4_asisdlsop_DX4_r4d(Rt, Rn, Rm, Q);
#else
        RT_NOREF(Rt, Rn, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffe400/0dff6000: LD4  { <Vt>.H, <Vt2>.H, <Vt3>.H, <Vt4>.H }[<index>], [<Xn|SP>], #8
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsop_H4_i4h, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsop_H4_i4h Rt=%#x Rn=%#x size=%u S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsop_H4_i4h
        IEM_INSTR_IMPL_A64__LD4_asisdlsop_H4_i4h(Rt, Rn, size, S, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0e400/0de06000: LD4  { <Vt>.H, <Vt2>.H, <Vt3>.H, <Vt4>.H }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsop_HX4_r4h, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const size       = (uOpcode >> 10) & 0x00000003;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsop_HX4_r4h Rt=%#x Rn=%#x size=%u S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, size, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsop_HX4_r4h
        IEM_INSTR_IMPL_A64__LD4_asisdlsop_HX4_r4h(Rt, Rn, size, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, size, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfffec00/0dffa000: LD4  { <Vt>.S, <Vt2>.S, <Vt3>.S, <Vt4>.S }[<index>], [<Xn|SP>], #16
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsop_S4_i4s, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsop_S4_i4s Rt=%#x Rn=%#x S=%u Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsop_S4_i4s
        IEM_INSTR_IMPL_A64__LD4_asisdlsop_S4_i4s(Rt, Rn, S, Q);
#else
        RT_NOREF(Rt, Rn, S, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bfe0ec00/0de0a000: LD4  { <Vt>.S, <Vt2>.S, <Vt3>.S, <Vt4>.S }[<index>], [<Xn|SP>], <Xm>
   Instruction Set: A64  Groups: asisdlsop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD4_asisdlsop_SX4_r4s, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const S          = (uOpcode >> 12) & 0x00000001;
    uint32_t const Rm         = (uOpcode >> 16) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/ && Rm != 0x1f)
    {
        LogFlow(("%018x/%010x: LD4_asisdlsop_SX4_r4s Rt=%#x Rn=%#x S=%u Rm=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, S, Rm, Q));
#ifdef IEM_INSTR_IMPL_A64__LD4_asisdlsop_SX4_r4s
        IEM_INSTR_IMPL_A64__LD4_asisdlsop_SX4_r4s(Rt, Rn, S, Rm, Q);
#else
        RT_NOREF(Rt, Rn, S, Rm, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/f83fd000: LD64B  <Xt>, [<Xn|SP>{ , #0}]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LD64B_64L_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLs64 /*FEAT_LS64*/)
    {
        LogFlow(("%018x/%010x: LD64B_64L_memop Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LD64B_64L_memop
        IEM_INSTR_IMPL_A64__LD64B_64L_memop(Rt, Rn);
#else
        RT_NOREF(Rt, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38a00000: LDADDAB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDAB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDAB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDAB_32_memop
        IEM_INSTR_IMPL_A64__LDADDAB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78a00000: LDADDAH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDAH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDAH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDAH_32_memop
        IEM_INSTR_IMPL_A64__LDADDAH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38e00000: LDADDALB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDALB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDALB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDALB_32_memop
        IEM_INSTR_IMPL_A64__LDADDALB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78e00000: LDADDALH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDALH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDALH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDALH_32_memop
        IEM_INSTR_IMPL_A64__LDADDALH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/b8e00000: LDADDAL  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDAL_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDAL_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDAL_32_memop
        IEM_INSTR_IMPL_A64__LDADDAL_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/f8e00000: LDADDAL  <Xs>, <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDAL_64_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDAL_64_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDAL_64_memop
        IEM_INSTR_IMPL_A64__LDADDAL_64_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/b8a00000: LDADDA  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDA_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDA_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDA_32_memop
        IEM_INSTR_IMPL_A64__LDADDA_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/f8a00000: LDADDA  <Xs>, <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDA_64_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDA_64_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDA_64_memop
        IEM_INSTR_IMPL_A64__LDADDA_64_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38200000: LDADDB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDB_32_memop
        IEM_INSTR_IMPL_A64__LDADDB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78200000: LDADDH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDH_32_memop
        IEM_INSTR_IMPL_A64__LDADDH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38600000: LDADDLB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDLB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDLB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDLB_32_memop
        IEM_INSTR_IMPL_A64__LDADDLB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78600000: LDADDLH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDLH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDLH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDLH_32_memop
        IEM_INSTR_IMPL_A64__LDADDLH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/b8600000: LDADDL  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDL_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDL_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDL_32_memop
        IEM_INSTR_IMPL_A64__LDADDL_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/f8600000: LDADDL  <Xs>, <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADDL_64_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADDL_64_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADDL_64_memop
        IEM_INSTR_IMPL_A64__LDADDL_64_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/b8200000: LDADD  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADD_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADD_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADD_32_memop
        IEM_INSTR_IMPL_A64__LDADD_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/f8200000: LDADD  <Xs>, <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDADD_64_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDADD_64_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDADD_64_memop
        IEM_INSTR_IMPL_A64__LDADD_64_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* bffffc00/0d418400: LDAP1  { <Vt>.D }[<index>], [<Xn|SP>]
   Instruction Set: A64  Groups: asisdlso, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAP1_asisdlso_D1, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Q          = (uOpcode >> 30) & 0x00000001;
    if (   IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fAdvSimd /*FEAT_AdvSIMD*/
        && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc3 /*FEAT_LRCPC3*/)
    {
        LogFlow(("%018x/%010x: LDAP1_asisdlso_D1 Rt=%#x Rn=%#x Q=%u\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Q));
#ifdef IEM_INSTR_IMPL_A64__LDAP1_asisdlso_D1
        IEM_INSTR_IMPL_A64__LDAP1_asisdlso_D1(Rt, Rn, Q);
#else
        RT_NOREF(Rt, Rn, Q, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/38bfc000: LDAPRB  <Wt>, [<Xn|SP>{ , #0}]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPRB_32L_memop, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x38bfc000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc /*FEAT_LRCPC*/)
        {
            LogFlow(("%018x/%010x: LDAPRB_32L_memop Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAPRB_32L_memop
            IEM_INSTR_IMPL_A64__LDAPRB_32L_memop(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/78bfc000: LDAPRH  <Wt>, [<Xn|SP>{ , #0}]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPRH_32L_memop, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x78bfc000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc /*FEAT_LRCPC*/)
        {
            LogFlow(("%018x/%010x: LDAPRH_32L_memop Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAPRH_32L_memop
            IEM_INSTR_IMPL_A64__LDAPRH_32L_memop(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/99c00800: LDAPR  <Wt>, [<Xn|SP>], #4
   Instruction Set: A64  Groups: ldapstl_writeback, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPR_32L_ldapstl_writeback, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x99c00800))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc3 /*FEAT_LRCPC3*/)
        {
            LogFlow(("%018x/%010x: LDAPR_32L_ldapstl_writeback Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAPR_32L_ldapstl_writeback
            IEM_INSTR_IMPL_A64__LDAPR_32L_ldapstl_writeback(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/b8bfc000: LDAPR  <Wt>, [<Xn|SP>{ , #0}]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPR_32L_memop, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xb8bfc000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc /*FEAT_LRCPC*/)
        {
            LogFlow(("%018x/%010x: LDAPR_32L_memop Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAPR_32L_memop
            IEM_INSTR_IMPL_A64__LDAPR_32L_memop(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/d9c00800: LDAPR  <Xt>, [<Xn|SP>], #8
   Instruction Set: A64  Groups: ldapstl_writeback, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPR_64L_ldapstl_writeback, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xd9c00800))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc3 /*FEAT_LRCPC3*/)
        {
            LogFlow(("%018x/%010x: LDAPR_64L_ldapstl_writeback Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAPR_64L_ldapstl_writeback
            IEM_INSTR_IMPL_A64__LDAPR_64L_ldapstl_writeback(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/f8bfc000: LDAPR  <Xt>, [<Xn|SP>{ , #0}]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPR_64L_memop, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xf8bfc000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc /*FEAT_LRCPC*/)
        {
            LogFlow(("%018x/%010x: LDAPR_64L_memop Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAPR_64L_memop
            IEM_INSTR_IMPL_A64__LDAPR_64L_memop(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/19400000: LDAPURB  <Wt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_unscaled, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPURB_32_ldapstl_unscaled, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc2 /*FEAT_LRCPC2*/)
    {
        LogFlow(("%018x/%010x: LDAPURB_32_ldapstl_unscaled Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPURB_32_ldapstl_unscaled
        IEM_INSTR_IMPL_A64__LDAPURB_32_ldapstl_unscaled(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/59400000: LDAPURH  <Wt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_unscaled, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPURH_32_ldapstl_unscaled, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc2 /*FEAT_LRCPC2*/)
    {
        LogFlow(("%018x/%010x: LDAPURH_32_ldapstl_unscaled Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPURH_32_ldapstl_unscaled
        IEM_INSTR_IMPL_A64__LDAPURH_32_ldapstl_unscaled(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/19c00000: LDAPURSB  <Wt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_unscaled, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPURSB_32_ldapstl_unscaled, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc2 /*FEAT_LRCPC2*/)
    {
        LogFlow(("%018x/%010x: LDAPURSB_32_ldapstl_unscaled Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPURSB_32_ldapstl_unscaled
        IEM_INSTR_IMPL_A64__LDAPURSB_32_ldapstl_unscaled(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/19800000: LDAPURSB  <Xt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_unscaled, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPURSB_64_ldapstl_unscaled, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc2 /*FEAT_LRCPC2*/)
    {
        LogFlow(("%018x/%010x: LDAPURSB_64_ldapstl_unscaled Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPURSB_64_ldapstl_unscaled
        IEM_INSTR_IMPL_A64__LDAPURSB_64_ldapstl_unscaled(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/59c00000: LDAPURSH  <Wt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_unscaled, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPURSH_32_ldapstl_unscaled, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc2 /*FEAT_LRCPC2*/)
    {
        LogFlow(("%018x/%010x: LDAPURSH_32_ldapstl_unscaled Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPURSH_32_ldapstl_unscaled
        IEM_INSTR_IMPL_A64__LDAPURSH_32_ldapstl_unscaled(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/59800000: LDAPURSH  <Xt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_unscaled, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPURSH_64_ldapstl_unscaled, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc2 /*FEAT_LRCPC2*/)
    {
        LogFlow(("%018x/%010x: LDAPURSH_64_ldapstl_unscaled Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPURSH_64_ldapstl_unscaled
        IEM_INSTR_IMPL_A64__LDAPURSH_64_ldapstl_unscaled(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/99800000: LDAPURSW  <Xt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_unscaled, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPURSW_64_ldapstl_unscaled, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc2 /*FEAT_LRCPC2*/)
    {
        LogFlow(("%018x/%010x: LDAPURSW_64_ldapstl_unscaled Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPURSW_64_ldapstl_unscaled
        IEM_INSTR_IMPL_A64__LDAPURSW_64_ldapstl_unscaled(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/99400000: LDAPUR  <Wt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_unscaled, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPUR_32_ldapstl_unscaled, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc2 /*FEAT_LRCPC2*/)
    {
        LogFlow(("%018x/%010x: LDAPUR_32_ldapstl_unscaled Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPUR_32_ldapstl_unscaled
        IEM_INSTR_IMPL_A64__LDAPUR_32_ldapstl_unscaled(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/d9400000: LDAPUR  <Xt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_unscaled, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPUR_64_ldapstl_unscaled, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc2 /*FEAT_LRCPC2*/)
    {
        LogFlow(("%018x/%010x: LDAPUR_64_ldapstl_unscaled Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPUR_64_ldapstl_unscaled
        IEM_INSTR_IMPL_A64__LDAPUR_64_ldapstl_unscaled(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/1d400800: LDAPUR  <Bt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_simd, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPUR_B_ldapstl_simd, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc3 /*FEAT_LRCPC3*/)
    {
        LogFlow(("%018x/%010x: LDAPUR_B_ldapstl_simd Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPUR_B_ldapstl_simd
        IEM_INSTR_IMPL_A64__LDAPUR_B_ldapstl_simd(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/dd400800: LDAPUR  <Dt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_simd, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPUR_D_ldapstl_simd, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc3 /*FEAT_LRCPC3*/)
    {
        LogFlow(("%018x/%010x: LDAPUR_D_ldapstl_simd Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPUR_D_ldapstl_simd
        IEM_INSTR_IMPL_A64__LDAPUR_D_ldapstl_simd(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/5d400800: LDAPUR  <Ht>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_simd, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPUR_H_ldapstl_simd, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc3 /*FEAT_LRCPC3*/)
    {
        LogFlow(("%018x/%010x: LDAPUR_H_ldapstl_simd Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPUR_H_ldapstl_simd
        IEM_INSTR_IMPL_A64__LDAPUR_H_ldapstl_simd(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/1dc00800: LDAPUR  <Qt>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_simd, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPUR_Q_ldapstl_simd, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc3 /*FEAT_LRCPC3*/)
    {
        LogFlow(("%018x/%010x: LDAPUR_Q_ldapstl_simd Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPUR_Q_ldapstl_simd
        IEM_INSTR_IMPL_A64__LDAPUR_Q_ldapstl_simd(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe00c00/9d400800: LDAPUR  <St>, [<Xn|SP>{, #<simm>}]
   Instruction Set: A64  Groups: ldapstl_simd, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAPUR_S_ldapstl_simd, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const imm9       = (uOpcode >> 12) & 0x000001ff;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fFp /*FEAT_FP*/ && IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLrcpc3 /*FEAT_LRCPC3*/)
    {
        LogFlow(("%018x/%010x: LDAPUR_S_ldapstl_simd Rt=%#x Rn=%#x imm9=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, imm9));
#ifdef IEM_INSTR_IMPL_A64__LDAPUR_S_ldapstl_simd
        IEM_INSTR_IMPL_A64__LDAPUR_S_ldapstl_simd(Rt, Rn, imm9);
#else
        RT_NOREF(Rt, Rn, imm9, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/08dffc00: LDARB  <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstord, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDARB_LR32_ldstord, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x08dffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: LDARB_LR32_ldstord Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDARB_LR32_ldstord
        IEM_INSTR_IMPL_A64__LDARB_LR32_ldstord(Rt, Rn);
#else
        RT_NOREF(Rt, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/48dffc00: LDARH  <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstord, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDARH_LR32_ldstord, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x48dffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: LDARH_LR32_ldstord Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDARH_LR32_ldstord
        IEM_INSTR_IMPL_A64__LDARH_LR32_ldstord(Rt, Rn);
#else
        RT_NOREF(Rt, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/88dffc00: LDAR  <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstord, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAR_LR32_ldstord, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x88dffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: LDAR_LR32_ldstord Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAR_LR32_ldstord
        IEM_INSTR_IMPL_A64__LDAR_LR32_ldstord(Rt, Rn);
#else
        RT_NOREF(Rt, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/c8dffc00: LDAR  <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstord, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAR_LR64_ldstord, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xc8dffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: LDAR_LR64_ldstord Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAR_LR64_ldstord
        IEM_INSTR_IMPL_A64__LDAR_LR64_ldstord(Rt, Rn);
#else
        RT_NOREF(Rt, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/895ffc00: LDATXR  <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstexclr_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDATXR_LR32_ldstexclr_unpriv, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x895ffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
        {
            LogFlow(("%018x/%010x: LDATXR_LR32_ldstexclr_unpriv Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDATXR_LR32_ldstexclr_unpriv
            IEM_INSTR_IMPL_A64__LDATXR_LR32_ldstexclr_unpriv(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/c95ffc00: LDATXR  <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstexclr_unpriv, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDATXR_LR64_ldstexclr_unpriv, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xc95ffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsui /*FEAT_LSUI*/)
        {
            LogFlow(("%018x/%010x: LDATXR_LR64_ldstexclr_unpriv Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDATXR_LR64_ldstexclr_unpriv
            IEM_INSTR_IMPL_A64__LDATXR_LR64_ldstexclr_unpriv(Rt, Rn);
#else
            RT_NOREF(Rt, Rn, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffff8000/887f8000: LDAXP  <Wt1>, <Wt2>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstexclp, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAXP_LP32_ldstexclp, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rt2        = (uOpcode >> 10) & 0x0000001f;
    LogFlow(("%018x/%010x: LDAXP_LP32_ldstexclp Rt=%#x Rn=%#x Rt2=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rt2));
#ifdef IEM_INSTR_IMPL_A64__LDAXP_LP32_ldstexclp
    IEM_INSTR_IMPL_A64__LDAXP_LP32_ldstexclp(Rt, Rn, Rt2);
#else
    RT_NOREF(Rt, Rn, Rt2, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* ffff8000/c87f8000: LDAXP  <Xt1>, <Xt2>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstexclp, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAXP_LP64_ldstexclp, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rt2        = (uOpcode >> 10) & 0x0000001f;
    LogFlow(("%018x/%010x: LDAXP_LP64_ldstexclp Rt=%#x Rn=%#x Rt2=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rt2));
#ifdef IEM_INSTR_IMPL_A64__LDAXP_LP64_ldstexclp
    IEM_INSTR_IMPL_A64__LDAXP_LP64_ldstexclp(Rt, Rn, Rt2);
#else
    RT_NOREF(Rt, Rn, Rt2, pVCpu, uOpcode);
    return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
}

/* fffffc00/085ffc00: LDAXRB  <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstexclr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAXRB_LR32_ldstexclr, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x085ffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: LDAXRB_LR32_ldstexclr Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAXRB_LR32_ldstexclr
        IEM_INSTR_IMPL_A64__LDAXRB_LR32_ldstexclr(Rt, Rn);
#else
        RT_NOREF(Rt, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/485ffc00: LDAXRH  <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstexclr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAXRH_LR32_ldstexclr, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x485ffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: LDAXRH_LR32_ldstexclr Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAXRH_LR32_ldstexclr
        IEM_INSTR_IMPL_A64__LDAXRH_LR32_ldstexclr(Rt, Rn);
#else
        RT_NOREF(Rt, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/885ffc00: LDAXR  <Wt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstexclr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAXR_LR32_ldstexclr, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0x885ffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: LDAXR_LR32_ldstexclr Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAXR_LR32_ldstexclr
        IEM_INSTR_IMPL_A64__LDAXR_LR32_ldstexclr(Rt, Rn);
#else
        RT_NOREF(Rt, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* fffffc00/c85ffc00: LDAXR  <Xt>, [<Xn|SP>{, #0}]
   Instruction Set: A64  Groups: ldstexclr, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDAXR_LR64_ldstexclr, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xfffffc00)) == UINT32_C(0xc85ffc00))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        LogFlow(("%018x/%010x: LDAXR_LR64_ldstexclr Rt=%#x Rn=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn));
#ifdef IEM_INSTR_IMPL_A64__LDAXR_LR64_ldstexclr
        IEM_INSTR_IMPL_A64__LDAXR_LR64_ldstexclr(Rt, Rn);
#else
        RT_NOREF(Rt, Rn, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ce00000: LDBFADDAL  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFADDAL_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFADDAL_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFADDAL_16
        IEM_INSTR_IMPL_A64__LDBFADDAL_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ca00000: LDBFADDA  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFADDA_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFADDA_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFADDA_16
        IEM_INSTR_IMPL_A64__LDBFADDA_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c600000: LDBFADDL  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFADDL_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFADDL_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFADDL_16
        IEM_INSTR_IMPL_A64__LDBFADDL_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c200000: LDBFADD  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFADD_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFADD_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFADD_16
        IEM_INSTR_IMPL_A64__LDBFADD_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ce04000: LDBFMAXAL  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMAXAL_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMAXAL_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMAXAL_16
        IEM_INSTR_IMPL_A64__LDBFMAXAL_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ca04000: LDBFMAXA  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMAXA_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMAXA_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMAXA_16
        IEM_INSTR_IMPL_A64__LDBFMAXA_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c604000: LDBFMAXL  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMAXL_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMAXL_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMAXL_16
        IEM_INSTR_IMPL_A64__LDBFMAXL_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ce06000: LDBFMAXNMAL  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMAXNMAL_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMAXNMAL_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMAXNMAL_16
        IEM_INSTR_IMPL_A64__LDBFMAXNMAL_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ca06000: LDBFMAXNMA  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMAXNMA_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMAXNMA_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMAXNMA_16
        IEM_INSTR_IMPL_A64__LDBFMAXNMA_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c606000: LDBFMAXNML  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMAXNML_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMAXNML_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMAXNML_16
        IEM_INSTR_IMPL_A64__LDBFMAXNML_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c206000: LDBFMAXNM  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMAXNM_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMAXNM_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMAXNM_16
        IEM_INSTR_IMPL_A64__LDBFMAXNM_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c204000: LDBFMAX  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMAX_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMAX_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMAX_16
        IEM_INSTR_IMPL_A64__LDBFMAX_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ce05000: LDBFMINAL  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMINAL_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMINAL_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMINAL_16
        IEM_INSTR_IMPL_A64__LDBFMINAL_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ca05000: LDBFMINA  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMINA_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMINA_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMINA_16
        IEM_INSTR_IMPL_A64__LDBFMINA_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c605000: LDBFMINL  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMINL_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMINL_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMINL_16
        IEM_INSTR_IMPL_A64__LDBFMINL_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ce07000: LDBFMINNMAL  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMINNMAL_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMINNMAL_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMINNMAL_16
        IEM_INSTR_IMPL_A64__LDBFMINNMAL_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3ca07000: LDBFMINNMA  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMINNMA_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMINNMA_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMINNMA_16
        IEM_INSTR_IMPL_A64__LDBFMINNMA_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c607000: LDBFMINNML  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMINNML_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMINNML_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMINNML_16
        IEM_INSTR_IMPL_A64__LDBFMINNML_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c207000: LDBFMINNM  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMINNM_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMINNM_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMINNM_16
        IEM_INSTR_IMPL_A64__LDBFMINNM_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/3c205000: LDBFMIN  <Hs>, <Ht>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDBFMIN_16, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLsfe /*FEAT_LSFE*/)
    {
        LogFlow(("%018x/%010x: LDBFMIN_16 Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDBFMIN_16
        IEM_INSTR_IMPL_A64__LDBFMIN_16(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38a01000: LDCLRAB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRAB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRAB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRAB_32_memop
        IEM_INSTR_IMPL_A64__LDCLRAB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78a01000: LDCLRAH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRAH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRAH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRAH_32_memop
        IEM_INSTR_IMPL_A64__LDCLRAH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38e01000: LDCLRALB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRALB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRALB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRALB_32_memop
        IEM_INSTR_IMPL_A64__LDCLRALB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78e01000: LDCLRALH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRALH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRALH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRALH_32_memop
        IEM_INSTR_IMPL_A64__LDCLRALH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/b8e01000: LDCLRAL  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRAL_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRAL_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRAL_32_memop
        IEM_INSTR_IMPL_A64__LDCLRAL_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/f8e01000: LDCLRAL  <Xs>, <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRAL_64_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRAL_64_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRAL_64_memop
        IEM_INSTR_IMPL_A64__LDCLRAL_64_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/b8a01000: LDCLRA  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRA_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRA_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRA_32_memop
        IEM_INSTR_IMPL_A64__LDCLRA_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/f8a01000: LDCLRA  <Xs>, <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRA_64_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRA_64_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRA_64_memop
        IEM_INSTR_IMPL_A64__LDCLRA_64_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38201000: LDCLRB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRB_32_memop
        IEM_INSTR_IMPL_A64__LDCLRB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78201000: LDCLRH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRH_32_memop
        IEM_INSTR_IMPL_A64__LDCLRH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38601000: LDCLRLB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRLB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRLB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRLB_32_memop
        IEM_INSTR_IMPL_A64__LDCLRLB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78601000: LDCLRLH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRLH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRLH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRLH_32_memop
        IEM_INSTR_IMPL_A64__LDCLRLH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/b8601000: LDCLRL  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRL_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRL_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRL_32_memop
        IEM_INSTR_IMPL_A64__LDCLRL_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/f8601000: LDCLRL  <Xs>, <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRL_64_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLRL_64_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLRL_64_memop
        IEM_INSTR_IMPL_A64__LDCLRL_64_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/19e01000: LDCLRPAL  <Xt1>, <Xt2>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop_128, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRPAL_128_memop_128, uint32_t, uOpcode)
{
    if ((uOpcode & UINT32_C(0xffe0fc00)) == UINT32_C(0x19e01000))
    {
        uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
        uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
        uint32_t const Rt2        = (uOpcode >> 16) & 0x0000001f;
        if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse128 /*FEAT_LSE128*/)
        {
            LogFlow(("%018x/%010x: LDCLRPAL_128_memop_128 Rt=%#x Rn=%#x Rt2=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rt2));
#ifdef IEM_INSTR_IMPL_A64__LDCLRPAL_128_memop_128
            IEM_INSTR_IMPL_A64__LDCLRPAL_128_memop_128(Rt, Rn, Rt2);
#else
            RT_NOREF(Rt, Rn, Rt2, pVCpu, uOpcode);
            return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
        }
        Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
        IEMOP_RAISE_INVALID_OPCODE_RET();
    }
    Log(("Invalid instruction %#x at %x\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/19a01000: LDCLRPA  <Xt1>, <Xt2>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop_128, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRPA_128_memop_128, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rt2        = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse128 /*FEAT_LSE128*/)
    {
        LogFlow(("%018x/%010x: LDCLRPA_128_memop_128 Rt=%#x Rn=%#x Rt2=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rt2));
#ifdef IEM_INSTR_IMPL_A64__LDCLRPA_128_memop_128
        IEM_INSTR_IMPL_A64__LDCLRPA_128_memop_128(Rt, Rn, Rt2);
#else
        RT_NOREF(Rt, Rn, Rt2, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/19601000: LDCLRPL  <Xt1>, <Xt2>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop_128, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRPL_128_memop_128, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rt2        = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse128 /*FEAT_LSE128*/)
    {
        LogFlow(("%018x/%010x: LDCLRPL_128_memop_128 Rt=%#x Rn=%#x Rt2=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rt2));
#ifdef IEM_INSTR_IMPL_A64__LDCLRPL_128_memop_128
        IEM_INSTR_IMPL_A64__LDCLRPL_128_memop_128(Rt, Rn, Rt2);
#else
        RT_NOREF(Rt, Rn, Rt2, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/19201000: LDCLRP  <Xt1>, <Xt2>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop_128, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLRP_128_memop_128, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rt2        = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse128 /*FEAT_LSE128*/)
    {
        LogFlow(("%018x/%010x: LDCLRP_128_memop_128 Rt=%#x Rn=%#x Rt2=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rt2));
#ifdef IEM_INSTR_IMPL_A64__LDCLRP_128_memop_128
        IEM_INSTR_IMPL_A64__LDCLRP_128_memop_128(Rt, Rn, Rt2);
#else
        RT_NOREF(Rt, Rn, Rt2, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/b8201000: LDCLR  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLR_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLR_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLR_32_memop
        IEM_INSTR_IMPL_A64__LDCLR_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/f8201000: LDCLR  <Xs>, <Xt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDCLR_64_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDCLR_64_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDCLR_64_memop
        IEM_INSTR_IMPL_A64__LDCLR_64_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38a02000: LDEORAB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDEORAB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDEORAB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDEORAB_32_memop
        IEM_INSTR_IMPL_A64__LDEORAB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78a02000: LDEORAH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDEORAH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDEORAH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDEORAH_32_memop
        IEM_INSTR_IMPL_A64__LDEORAH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/38e02000: LDEORALB  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDEORALB_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDEORALB_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDEORALB_32_memop
        IEM_INSTR_IMPL_A64__LDEORALB_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/78e02000: LDEORALH  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDEORALH_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDEORALH_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDEORALH_32_memop
        IEM_INSTR_IMPL_A64__LDEORALH_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/b8e02000: LDEORAL  <Ws>, <Wt>, [<Xn|SP>]
   Instruction Set: A64  Groups: memop, ldst */
FNIEMOP_DEF_1(iemDecodeA64_LDEORAL_32_memop, uint32_t, uOpcode)
{
    uint32_t const Rt         = (uOpcode >>  0) & 0x0000001f;
    uint32_t const Rn         = (uOpcode >>  5) & 0x0000001f;
    uint32_t const Rs         = (uOpcode >> 16) & 0x0000001f;
    if (IEM_GET_GUEST_CPU_FEATURES(pVCpu)->fLse /*FEAT_LSE*/)
    {
        LogFlow(("%018x/%010x: LDEORAL_32_memop Rt=%#x Rn=%#x Rs=%#x\n", pVCpu->cpum.GstCtx.Pc.u64, uOpcode, Rt, Rn, Rs));
#ifdef IEM_INSTR_IMPL_A64__LDEORAL_32_memop
        IEM_INSTR_IMPL_A64__LDEORAL_32_memop(Rt, Rn, Rs);
#else
        RT_NOREF(Rt, Rn, Rs, pVCpu, uOpcode);
        return VERR_IEM_INSTR_NOT_IMPLEMENTED;
#endif
    }
    Log(("Invalid instruction %#x at %x (cond)\n", uOpcode, pVCpu->cpum.GstCtx.Pc.u64));
    IEMOP_RAISE_INVALID_OPCODE_RET();
}

/* ffe0fc00/f8e02000: LDEORAL  <Xs>, <Xt>, [<Xn|SP>]
   Instruction Set: 