/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.List;
import java.util.UUID;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.TileComponentFrequency;
import net.minecraft.nbt.CompoundTag;

public interface IFrequencyHandler {
    public TileComponentFrequency getFrequencyComponent();

    default public <FREQ extends Frequency> FREQ getFrequency(FrequencyType<FREQ> type) {
        return this.getFrequencyComponent().getFrequency(type);
    }

    default public void setFrequency(FrequencyType<?> type, CompoundTag frequencyCompound) {
        Frequency.FrequencyIdentity freq = Frequency.FrequencyIdentity.load(type, frequencyCompound);
        if (freq != null && frequencyCompound.m_128403_("owner")) {
            this.setFrequency(type, freq, frequencyCompound.m_128342_("owner"));
        }
    }

    default public void setFrequency(FrequencyType<?> type, Frequency.FrequencyIdentity data, UUID player) {
        this.getFrequencyComponent().setFrequencyFromData(type, data, player);
    }

    default public void removeFrequency(FrequencyType<?> type, Frequency.FrequencyIdentity data, UUID player) {
        this.getFrequencyComponent().removeFrequencyFromData(type, data, player);
    }

    default public <FREQ extends Frequency> List<FREQ> getPublicCache(FrequencyType<FREQ> type) {
        return this.getFrequencyComponent().getPublicCache(type);
    }

    default public <FREQ extends Frequency> List<FREQ> getPrivateCache(FrequencyType<FREQ> type) {
        return this.getFrequencyComponent().getPrivateCache(type);
    }
}

