/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.api.MekanismAPI;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkEvent;

public class PacketGuiSetFrequency<FREQ extends Frequency>
implements IMekanismPacket {
    private final FrequencyType<FREQ> type;
    private final FrequencyUpdate updateType;
    private final Frequency.FrequencyIdentity data;
    private final BlockPos tilePosition;
    private final InteractionHand currentHand;

    private PacketGuiSetFrequency(FrequencyUpdate updateType, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, BlockPos tilePosition, InteractionHand currentHand) {
        this.updateType = updateType;
        this.type = type;
        this.data = data;
        this.tilePosition = tilePosition;
        this.currentHand = currentHand;
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequency<FREQ> create(FrequencyUpdate updateType, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, BlockPos tilePosition) {
        return new PacketGuiSetFrequency<FREQ>(updateType, type, data, tilePosition, null);
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequency<FREQ> create(FrequencyUpdate updateType, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, InteractionHand currentHand) {
        return new PacketGuiSetFrequency<FREQ>(updateType, type, data, null, currentHand);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        if (this.updateType.isTile()) {
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)player.f_19853_, this.tilePosition);
            if (tile instanceof IFrequencyHandler) {
                IFrequencyHandler frequencyHandler = (IFrequencyHandler)tile;
                if (MekanismAPI.getSecurityUtils().canAccess((Player)player, (ICapabilityProvider)tile)) {
                    if (this.updateType == FrequencyUpdate.SET_TILE) {
                        frequencyHandler.setFrequency(this.type, this.data, player.m_20148_());
                    } else if (this.updateType == FrequencyUpdate.REMOVE_TILE) {
                        frequencyHandler.removeFrequency(this.type, this.data, player.m_20148_());
                    }
                }
            }
        } else {
            Item item;
            ItemStack stack = player.m_21120_(this.currentHand);
            if (MekanismAPI.getSecurityUtils().canAccess((Player)player, (ICapabilityProvider)stack) && (item = stack.m_41720_()) instanceof IFrequencyItem) {
                Frequency.FrequencyIdentity current;
                IFrequencyItem item2 = (IFrequencyItem)item;
                FrequencyManager<FREQ> manager = this.type.getManager(this.data, player.m_20148_());
                if (this.updateType == FrequencyUpdate.SET_ITEM) {
                    item2.setFrequency(stack, (Frequency)manager.getOrCreateFrequency(this.data, player.m_20148_()));
                } else if (this.updateType == FrequencyUpdate.REMOVE_ITEM && manager.remove(this.data.key(), player.m_20148_()) && (current = item2.getFrequencyIdentity(stack)) != null && current.equals(this.data)) {
                    item2.setFrequency(stack, null);
                }
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.updateType);
        this.type.write(buffer);
        this.type.getIdentitySerializer().write(buffer, this.data);
        if (this.updateType.isTile()) {
            buffer.m_130064_(this.tilePosition);
        } else {
            buffer.m_130068_((Enum)this.currentHand);
        }
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequency<FREQ> decode(FriendlyByteBuf buffer) {
        FrequencyUpdate updateType = (FrequencyUpdate)buffer.m_130066_(FrequencyUpdate.class);
        FrequencyType type = FrequencyType.load(buffer);
        Frequency.FrequencyIdentity data = type.getIdentitySerializer().read(buffer);
        BlockPos pos = updateType.isTile() ? buffer.m_130135_() : null;
        InteractionHand hand = updateType.isTile() ? null : (InteractionHand)buffer.m_130066_(InteractionHand.class);
        return new PacketGuiSetFrequency(updateType, type, data, pos, hand);
    }

    public static enum FrequencyUpdate {
        SET_TILE,
        SET_ITEM,
        REMOVE_TILE,
        REMOVE_ITEM;


        boolean isTile() {
            return this == SET_TILE || this == REMOVE_TILE;
        }
    }
}

