/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class DepotRenderer
extends SafeBlockEntityRenderer<DepotBlockEntity> {
    public DepotRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(DepotBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        DepotRenderer.renderItemsOf(be, partialTicks, ms, buffer, light, overlay, be.depotBehaviour);
    }

    public static void renderItemsOf(SmartBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, DepotBehaviour depotBehaviour) {
        TransportedItemStack transported = depotBehaviour.heldItem;
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        Vec3 itemPosition = VecHelper.getCenterOf((Vec3i)be.m_58899_());
        ms.m_85836_();
        ms.m_85837_(0.5, 0.9375, 0.5);
        if (transported != null) {
            depotBehaviour.incoming.add(transported);
        }
        for (TransportedItemStack tis : depotBehaviour.incoming) {
            ms.m_85836_();
            msr.nudge(0);
            float offset = Mth.m_14179_((float)partialTicks, (float)tis.prevBeltPosition, (float)tis.beltPosition);
            float sideOffset = Mth.m_14179_((float)partialTicks, (float)tis.prevSideOffset, (float)tis.sideOffset);
            if (tis.insertedFrom.m_122434_().m_122479_()) {
                boolean alongX;
                Vec3 offsetVec = Vec3.m_82528_((Vec3i)tis.insertedFrom.m_122424_().m_122436_()).m_82490_((double)(0.5f - offset));
                ms.m_85837_(offsetVec.f_82479_, offsetVec.f_82480_, offsetVec.f_82481_);
                boolean bl = alongX = tis.insertedFrom.m_122427_().m_122434_() == Direction.Axis.X;
                if (!alongX) {
                    sideOffset *= -1.0f;
                }
                ms.m_85837_(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)sideOffset);
            }
            ItemStack itemStack = tis.stack;
            int angle = tis.angle;
            Random r = new Random(0L);
            DepotRenderer.renderItem(ms, buffer, light, overlay, itemStack, angle, r, itemPosition);
            ms.m_85849_();
        }
        if (transported != null) {
            depotBehaviour.incoming.remove(transported);
        }
        for (int i = 0; i < depotBehaviour.processingOutputBuffer.getSlots(); ++i) {
            ItemStack stack = depotBehaviour.processingOutputBuffer.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ms.m_85836_();
            msr.nudge(i);
            boolean renderUpright = BeltHelper.isItemUpright(stack);
            msr.rotateY((double)(45.0f * (float)i));
            ms.m_85837_((double)0.35f, 0.0, 0.0);
            if (renderUpright) {
                msr.rotateY((double)(-(45.0f * (float)i)));
            }
            Random r = new Random(i + 1);
            int angle = (int)(360.0f * r.nextFloat());
            DepotRenderer.renderItem(ms, buffer, light, overlay, stack, renderUpright ? angle + 90 : angle, r, itemPosition);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public static void renderItem(PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack itemStack, int angle, Random r, Vec3 itemPosition) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        int count = Mth.m_14173_((int)itemStack.m_41613_()) / 2;
        boolean renderUpright = BeltHelper.isItemUpright(itemStack);
        boolean blockItem = itemRenderer.m_174264_(itemStack, null, null, 0).m_7539_();
        ms.m_85836_();
        msr.rotateY((double)angle);
        if (renderUpright) {
            Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
            if (renderViewEntity != null) {
                Vec3 positionVec = renderViewEntity.m_20182_();
                Vec3 vectorForOffset = itemPosition;
                Vec3 diff = vectorForOffset.m_82546_(positionVec);
                float yRot = (float)(Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_) + Math.PI);
                ms.m_85845_(Vector3f.f_122225_.m_122270_(yRot));
            }
            ms.m_85837_(0.0, 0.09375, -0.0625);
        }
        for (int i = 0; i <= count; ++i) {
            ms.m_85836_();
            if (blockItem) {
                ms.m_85837_((double)(r.nextFloat() * 0.0625f * (float)i), 0.0, (double)(r.nextFloat() * 0.0625f * (float)i));
            }
            ms.m_85841_(0.5f, 0.5f, 0.5f);
            if (!blockItem && !renderUpright) {
                ms.m_85837_(0.0, -0.1875, 0.0);
                msr.rotateX(90.0);
            }
            itemRenderer.m_174269_(itemStack, ItemTransforms.TransformType.FIXED, light, overlay, ms, buffer, 0);
            ms.m_85849_();
            if (!renderUpright) {
                if (!blockItem) {
                    msr.rotateY(10.0);
                }
                ms.m_85837_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                continue;
            }
            ms.m_85837_(0.0, 0.0, -0.0625);
        }
        ms.m_85849_();
    }
}

