/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import novamachina.exnihilosequentia.client.render.UVLocation;
import novamachina.exnihilosequentia.client.render.VertexLocation;
import novamachina.exnihilosequentia.common.blockentity.IFluidContainer;
import novamachina.exnihilosequentia.common.utility.Color;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModBlockRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());

    protected AbstractModBlockRenderer() {
    }

    @Nonnull
    public static BlockState getStateFromItemStack(@Nonnull ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            try {
                return block.m_49966_();
            }
            catch (Exception exception) {
                return block.m_49966_();
            }
        }
        return Blocks.f_50016_.m_49966_();
    }

    protected void add(@Nonnull VertexConsumer renderer, @Nonnull PoseStack stack, @Nonnull VertexLocation vertexLocation, @Nonnull UVLocation uvLocation, @Nonnull Color color, int combinedLight) {
        renderer.m_85982_(stack.m_85850_().m_85861_(), vertexLocation.getX(), vertexLocation.getY(), vertexLocation.getZ()).m_85950_(color.r, color.g, color.b, color.a).m_7421_(uvLocation.getU(), uvLocation.getV()).m_85969_(combinedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    @Nonnull
    protected String resolveTexture(@Nonnull String path) {
        if ("cactus".equals(path)) {
            return "cactus_top";
        }
        return path;
    }

    protected void renderFluid(@NotNull IFluidContainer tileEntity, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLightIn, @Nullable ResourceLocation fluidTexture, @NotNull Color fluidColor, UVLocation location) {
        if (fluidTexture != null) {
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTexture);
            float fillAmount = 0.75f * tileEntity.getFluidProportion() - 0.005f;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            this.add(builder, matrixStack, new VertexLocation(location.getU(), 0.25f + fillAmount, location.getV()), new UVLocation(sprite.m_118409_(), sprite.m_118412_()), fluidColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(location.getV(), 0.25f + fillAmount, location.getV()), new UVLocation(sprite.m_118410_(), sprite.m_118412_()), fluidColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(location.getV(), 0.25f + fillAmount, location.getU()), new UVLocation(sprite.m_118410_(), sprite.m_118411_()), fluidColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(location.getU(), 0.25f + fillAmount, location.getU()), new UVLocation(sprite.m_118409_(), sprite.m_118411_()), fluidColor, combinedLightIn);
            matrixStack.m_85849_();
        }
    }
}

