/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.model.data.ModelData;
import novamachina.exnihilosequentia.client.render.AbstractModBlockRenderer;
import novamachina.exnihilosequentia.client.util.LiquidBlockVertexConsumer;
import novamachina.exnihilosequentia.common.blockentity.barrel.AbstractBarrelEntity;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.jetbrains.annotations.NotNull;

public class BarrelRender
extends AbstractModBlockRenderer<AbstractBarrelEntity> {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());

    public BarrelRender(@Nonnull BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public static void register(@Nonnull BlockEntityType<? extends AbstractBarrelEntity> tileEntityType) {
        logger.debug("Register barrel renderer");
        BlockEntityRenderers.m_173590_(tileEntityType, BarrelRender::new);
    }

    public void render(@Nonnull AbstractBarrelEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        this.renderFluid(matrixStack, buffer, tileEntity);
        this.renderInventory(matrixStack, buffer, combinedLightIn, combinedOverlayIn, tileEntity);
        this.renderSolid(tileEntity, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    private void renderSolid(@NotNull AbstractBarrelEntity tileEntity, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntity.getSolidAmount() > 0) {
            BlockState state = Blocks.f_50050_.m_49966_();
            matrixStack.m_85836_();
            float fillAmount = Math.min(tileEntity.getSolidProportion(), 1.0f) - 0.0625f;
            matrixStack.m_85837_(0.125, 0.0625, 0.125);
            matrixStack.m_85841_(0.75f, fillAmount, 0.75f);
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            blockRenderer.renderSingleBlock(state, matrixStack, buffer, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.m_110457_());
            matrixStack.m_85849_();
        }
    }

    private void renderFluid(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, AbstractBarrelEntity tileEntity) {
        if (tileEntity.getFluidAmount() > 0) {
            BlockState state = tileEntity.getFluid().m_76145_().m_76188_();
            matrixStack.m_85836_();
            float fillAmount = Math.min(tileEntity.getFluidProportion(), 1.0f);
            matrixStack.m_85837_(0.125, 0.0625, 0.125);
            matrixStack.m_85841_(0.75f, fillAmount, 0.75f);
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            blockRenderer.m_234363_(tileEntity.m_58899_(), (BlockAndTintGetter)tileEntity.m_58904_(), (VertexConsumer)new LiquidBlockVertexConsumer(buffer.m_6299_(ItemBlockRenderTypes.m_109287_((FluidState)tileEntity.getFluid().m_76145_())), matrixStack, tileEntity.m_58899_()), state, tileEntity.getFluid().m_76145_());
            matrixStack.m_85849_();
        }
    }

    private void renderInventory(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn, AbstractBarrelEntity tileEntity) {
        if (tileEntity.getInventoryBlock() != ItemStack.f_41583_) {
            BlockState state = BarrelRender.getStateFromItemStack(tileEntity.getInventoryBlock());
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.125, 0.0625, 0.125);
            matrixStack.m_85841_(0.75f, 0.9375f, 0.75f);
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            blockRenderer.renderSingleBlock(state, matrixStack, buffer, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.m_110457_());
            matrixStack.m_85849_();
        }
    }
}

