/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity.crucible;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import novamachina.exnihilosequentia.common.blockentity.crucible.CrucibleTypeEnum;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;

public class MeltableItemHandler
extends ItemStackHandler {
    private boolean crucibleHasRoom = true;
    @Nullable
    private CrucibleTypeEnum type;

    public MeltableItemHandler(@Nonnull CrucibleTypeEnum crucibleType) {
        super(1);
        this.type = crucibleType;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.crucibleHasRoom) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public void setCrucibleHasRoom(boolean crucibleHasRoom) {
        this.crucibleHasRoom = crucibleHasRoom;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.type == null) {
            return false;
        }
        return ExNihiloRegistries.CRUCIBLE_REGISTRY.isMeltableByItemStack(stack, this.type.getLevel());
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return 3;
    }

    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128379_("hasRoom", this.crucibleHasRoom);
        if (this.type != null) {
            nbt.m_128359_("type", this.type.getName());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.crucibleHasRoom = nbt.m_128471_("hasRoom");
        this.type = CrucibleTypeEnum.getTypeByName(nbt.m_128461_("type"));
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }
}

