/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.common.crafting.fluiditem.FluidItemRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;

public class FluidItemTransformRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());
    @Nonnull
    private final List<FluidItemRecipe> recipeList = new ArrayList<FluidItemRecipe>();
    @Nonnull
    private final Item empty = ItemStack.f_41583_.m_41720_();
    @Nonnull
    private final Map<FluidStack, Map<Item, Item>> itemResultCache = new HashMap<FluidStack, Map<Item, Item>>();

    public boolean isValidRecipe(@Nonnull Fluid fluid, @Nonnull Item input) {
        return this.getResult(fluid, input) != this.empty;
    }

    @Nonnull
    public ItemLike getResult(@Nonnull Fluid fluid, @Nonnull Item input) {
        return (ItemLike)this.itemResultCache.computeIfAbsent(new FluidStack(fluid, 1000), k -> new HashMap()).computeIfAbsent(input, k -> this.recipeList.stream().filter(fluidItemRecipe -> fluidItemRecipe.validInputs(fluid, input)).findFirst().map(FluidItemRecipe::m_8043_).map(ItemStack::m_41720_).orElse(this.empty));
    }

    @Nonnull
    public List<FluidItemRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipes(@Nonnull List<FluidItemRecipe> recipes) {
        logger.debug("Fluid Item Transform Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.itemResultCache.clear();
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.itemResultCache.clear();
    }
}

