/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.common.blocks.cloth.BalloonBlockEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.math.Vector4f;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BalloonCallbacks
implements BlockCallback<Key> {
    public static final BalloonCallbacks INSTANCE = new BalloonCallbacks();
    private static final Key INVALID = new Key(0, DyeColor.BLACK, DyeColor.PURPLE);

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        if (!(blockEntity instanceof BalloonBlockEntity)) {
            return this.getDefaultKey();
        }
        BalloonBlockEntity balloon = (BalloonBlockEntity)blockEntity;
        return new Key(balloon.style, balloon.colour0, balloon.colour1);
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public Vector4f getRenderColor(Key key, String group, String material, ShaderCase shaderCase, Vector4f original) {
        if (shaderCase != null) {
            return original;
        }
        if (key.style() == 0) {
            if (group.startsWith("balloon1_")) {
                return Utils.vec4fFromDye(key.color1());
            }
            if (group.startsWith("balloon0_")) {
                return Utils.vec4fFromDye(key.color0());
            }
        } else {
            if (group.endsWith("_1")) {
                return Utils.vec4fFromDye(key.color1());
            }
            if (group.endsWith("_0")) {
                return Utils.vec4fFromDye(key.color0());
            }
        }
        return original;
    }

    public record Key(int style, DyeColor color0, DyeColor color1) {
    }
}

