/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.bottlingmachine;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class BottlingMachineRecipeCategory
extends IERecipeCategory<BottlingMachineRecipe> {
    private final IDrawableStatic tankOverlay;

    public BottlingMachineRecipeCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.BOTTLING_MACHINE, "block.immersiveengineering.bottling_machine");
        this.setBackground(helper.createBlankDrawable(120, 56));
        this.setIcon(helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(IEBlocks.Multiblocks.BOTTLING_MACHINE)));
        this.tankOverlay = helper.drawableBuilder(new ResourceLocation("immersiveengineering", "textures/gui/fermenter.png"), 177, 31, 20, 51).addPadding(-2, 2, -2, 2).build();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BottlingMachineRecipe recipe, IFocusGroup focuses) {
        int inLength = recipe.inputs.length;
        int yStart = 29 - Math.min(inLength, 3) * 9;
        for (int i = 0; i < inLength; ++i) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, yStart + i * 18).addItemStacks(recipe.inputs[i].getMatchingStackList())).setBackground((IDrawable)JEIHelper.slotDrawable, -1, -1);
        }
        List outputs = (List)recipe.output.get();
        yStart = 29 - Math.min(outputs.size(), 3) * 9;
        for (int i = 0; i < outputs.size(); ++i) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 101, yStart + i * 18).addItemStack((ItemStack)outputs.get(i))).setBackground((IDrawable)JEIHelper.slotDrawable, -1, -1);
        }
        int tankSize = Math.max(1000, recipe.fluidInput.getAmount());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 24, 2).setFluidRenderer((long)tankSize, false, 16, 52).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.fluidInput.getMatchingFluidStacks())).addTooltipCallback(JEIHelper.fluidTooltipCallback);
    }

    public void draw(BottlingMachineRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack transform, double mouseX, double mouseY) {
        GuiHelper.drawSlot(24, 20, 16, 52, transform);
        transform.m_85836_();
        transform.m_85841_(3.0f, 3.0f, 1.0f);
        this.getIcon().draw(transform, 14, 0);
        transform.m_85849_();
    }
}

