/*
 * Decompiled with CFR 0.152.
 */
package vice.rubidium_extras.mixins.BorderlessFullscreen;

import com.mojang.blaze3d.platform.Window;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import vice.rubidium_extras.config.MagnesiumExtrasConfig;

@Mixin(value={Window.class})
public class WindowMixin {
    @Redirect(method={"setMode"}, at=@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwSetWindowMonitor(JJIIIII)V"))
    private void glfwSetWindowMonitor(long window, long monitor, int xpos, int ypos, int width, int height, int refreshRate) {
        if (!MagnesiumExtrasConfig.ConfigSpec.isLoaded()) {
            GLFW.glfwSetWindowMonitor((long)window, (long)monitor, (int)xpos, (int)ypos, (int)width, (int)height, (int)refreshRate);
            return;
        }
        if (MagnesiumExtrasConfig.fullScreenMode.get() == MagnesiumExtrasConfig.FullscreenMode.BORDERLESS) {
            if (monitor != 0L) {
                GLFW.glfwSetWindowSizeLimits((long)window, (int)0, (int)0, (int)width, (int)height);
            }
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)xpos, (int)ypos, (int)width, (int)height, (int)refreshRate);
        } else {
            GLFW.glfwSetWindowMonitor((long)window, (long)monitor, (int)xpos, (int)ypos, (int)width, (int)height, (int)refreshRate);
        }
    }
}

