/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.mekanism;

import com.supermartijn642.trashcans.compat.mekanism.GasFilterManager;
import com.supermartijn642.trashcans.compat.mekanism.MekanismCompatOff;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import java.util.ArrayList;
import java.util.function.Supplier;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.MekanismBlocks;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.ItemBlockGasTank;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class MekanismCompatOn
extends MekanismCompatOff {
    public MekanismCompatOn() {
        LiquidTrashCanFilters.register(new GasFilterManager(), "gas");
    }

    @Override
    public boolean isInstalled() {
        return true;
    }

    @Override
    public Capability<?> getGasHandlerCapability() {
        return Capabilities.GAS_HANDLER_CAPABILITY;
    }

    @Override
    public boolean doesItemHaveGasStored(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IGasItem)) {
            return false;
        }
        IGasItem item = (IGasItem)stack.func_77973_b();
        return item.getGas(stack) != null && item.getGas((ItemStack)stack).amount > 0;
    }

    @Override
    public boolean drainGasFromItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof IGasItem) {
            IGasItem item = (IGasItem)stack.func_77973_b();
            item.setGas(stack, null);
        }
        return false;
    }

    @Override
    public <R> R getGasHandler(ArrayList<ItemFilter> filters, Supplier<Boolean> whitelist) {
        return (R)new IGasHandler(){

            public int receiveGas(EnumFacing enumFacing, GasStack gasStack, boolean b) {
                return gasStack.amount;
            }

            public GasStack drawGas(EnumFacing enumFacing, int i, boolean b) {
                return null;
            }

            public boolean canReceiveGas(EnumFacing enumFacing, Gas gas) {
                return true;
            }

            public boolean canDrawGas(EnumFacing enumFacing, Gas gas) {
                return false;
            }

            public GasTankInfo[] getTankInfo() {
                return new GasTankInfo[]{new GasTankInfo(){

                    public GasStack getGas() {
                        return null;
                    }

                    public int getStored() {
                        return 0;
                    }

                    public int getMaxGas() {
                        return Integer.MAX_VALUE;
                    }
                }};
            }
        };
    }

    @Override
    public boolean isGasStack(Object obj) {
        return obj instanceof GasStack;
    }

    @Override
    public ItemStack getChemicalTankForGasStack(Object gasStack) {
        ItemStack stack = new ItemStack(MekanismBlocks.GasTank);
        if (stack.func_77973_b() instanceof IGasItem) {
            ItemBlockGasTank gasTank = (ItemBlockGasTank)stack.func_77973_b();
            GasStack gas = ((GasStack)gasStack).copy();
            gas.amount = gasTank.getMaxGas(stack);
            gasTank.setGas(stack, gas);
        }
        return stack;
    }
}

