/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.filter;

import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class LiquidTrashCanFilters {
    private static final Map<String, IFilterManager> managers = new HashMap<String, IFilterManager>();

    public static void register(IFilterManager manager, String id) {
        managers.put(id, manager);
    }

    public static ItemFilter createFilter(ItemStack stack) {
        for (Map.Entry<String, IFilterManager> entry : managers.entrySet()) {
            ItemFilter filter = entry.getValue().createFilter(stack);
            if (filter == null || !filter.isValid()) continue;
            filter.setId(entry.getKey());
            return filter;
        }
        return null;
    }

    public static NBTTagCompound write(ItemFilter filter) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("id", filter.getId());
        compound.func_74782_a("filter", (NBTBase)filter.write());
        return compound;
    }

    public static ItemFilter read(NBTTagCompound compound) {
        String id = compound.func_74779_i("id");
        if (managers.containsKey(id)) {
            ItemFilter filter = managers.get(id).readFilter(compound.func_74775_l("filter"));
            filter.setId(id);
            return filter.isValid() ? filter : null;
        }
        return null;
    }
}

