/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.screen;

import java.nio.DoubleBuffer;
import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.render.RenderPlanet;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class GameScreenCelestial
implements IGameScreen {
    private TextureManager renderEngine;
    private float frameA;
    private float frameBx;
    private float frameBy;
    private float centreX;
    private float centreY;
    private float scale;
    private final int lineSegments = 90;
    private final float cos = MathHelper.func_76134_b((float)0.06981317f);
    private final float sin = MathHelper.func_76126_a((float)0.06981317f);
    private DoubleBuffer planes;

    public GameScreenCelestial() {
        if (GCCoreUtil.getEffectiveSide().isClient()) {
            this.renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
            this.planes = BufferUtils.createDoubleBuffer((int)256);
        }
    }

    @Override
    public void setFrameSize(float frameSize) {
        this.frameA = frameSize;
    }

    @Override
    public void render(int type, float ticks, float scaleX, float scaleY, IScreenManager scr) {
        this.centreX = scaleX / 2.0f;
        this.centreY = scaleY / 2.0f;
        this.frameBx = scaleX - this.frameA;
        this.frameBy = scaleY - this.frameA;
        this.scale = Math.max(scaleX, scaleY) - 0.2f;
        this.drawBlackBackground(0.0f);
        this.planeEquation(this.frameA, this.frameA, 0.0f, this.frameA, this.frameBy, 0.0f, this.frameA, this.frameBy, 1.0f);
        GL11.glClipPlane((int)12288, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12288);
        this.planeEquation(this.frameBx, this.frameBy, 0.0f, this.frameBx, this.frameA, 0.0f, this.frameBx, this.frameA, 1.0f);
        GL11.glClipPlane((int)12289, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12289);
        this.planeEquation(this.frameA, this.frameBy, 0.0f, this.frameBx, this.frameBy, 0.0f, this.frameBx, this.frameBy, 1.0f);
        GL11.glClipPlane((int)12290, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12290);
        this.planeEquation(this.frameBx, this.frameA, 0.0f, this.frameA, this.frameA, 0.0f, this.frameA, this.frameA, 1.0f);
        GL11.glClipPlane((int)12291, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12291);
        switch (type) {
            case 2: {
                WorldProvider wp = scr.getWorldProvider();
                CelestialBody body = null;
                if (wp instanceof IGalacticraftWorldProvider) {
                    body = ((IGalacticraftWorldProvider)wp).getCelestialBody();
                }
                if (body == null) {
                    body = GalacticraftCore.planetOverworld;
                }
                this.drawCelestialBodies(body, ticks);
                break;
            }
            case 3: {
                this.drawCelestialBodiesZ(GalacticraftCore.planetOverworld, ticks);
                break;
            }
            case 4: {
                this.drawPlanetsTest(ticks);
            }
        }
        GL11.glDisable((int)12291);
        GL11.glDisable((int)12290);
        GL11.glDisable((int)12289);
        GL11.glDisable((int)12288);
    }

    private void drawBlackBackground(float greyLevel) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        GL11.glColor4f((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameA, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameA, (double)0.005f).func_181675_d();
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    private void drawCelestialBodies(CelestialBody body, float ticks) {
        Star star = null;
        SolarSystem solarSystem = null;
        if (body instanceof Planet) {
            solarSystem = ((Planet)body).getParentSolarSystem();
        } else if (body instanceof Moon) {
            solarSystem = ((Moon)body).getParentPlanet().getParentSolarSystem();
        } else if (body instanceof Satellite) {
            solarSystem = ((Satellite)body).getParentPlanet().getParentSolarSystem();
        }
        if (solarSystem == null) {
            solarSystem = GalacticraftCore.solarSystemSol;
        }
        if ((star = solarSystem.getMainStar()) != null && star.getBodyIcon() != null) {
            this.drawCelestialBody(star, 0.0f, 0.0f, ticks, 6.0f);
        }
        String mainSolarSystem = solarSystem.getTranslationKey();
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (planet.getParentSolarSystem() == null || planet.getBodyIcon() == null || !planet.getParentSolarSystem().getTranslationKey().equalsIgnoreCase(mainSolarSystem)) continue;
            Vector3f pos = this.getCelestialBodyPosition(planet, ticks);
            this.drawCircle(planet);
            this.drawCelestialBody(planet, pos.x, pos.y, ticks, planet.getRelativeDistanceFromCenter().unScaledDistance < 1.5f ? 2.0f : 2.8f);
        }
    }

    private void drawCelestialBodiesZ(CelestialBody planet, float ticks) {
        Vector3f pos;
        this.drawCelestialBody(planet, 0.0f, 0.0f, ticks, 11.0f);
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (moon.getParentPlanet() != planet || moon.getBodyIcon() == null) continue;
            pos = this.getCelestialBodyPosition(moon, ticks);
            this.drawCircle(moon);
            this.drawCelestialBody(moon, pos.x, pos.y, ticks, 4.0f);
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (satellite.getParentPlanet() != planet) continue;
            pos = this.getCelestialBodyPosition(satellite, ticks);
            this.drawCircle(satellite);
            this.drawCelestialBody(satellite, pos.x, pos.y, ticks, 3.0f);
        }
    }

    private void drawTexturedRectCBody(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private void drawCelestialBody(CelestialBody planet, float xPos, float yPos, float ticks, float relSize) {
        if (xPos + this.centreX > this.frameBx || xPos + this.centreX < this.frameA) {
            return;
        }
        if (yPos + this.centreY > this.frameBy || yPos + this.centreY < this.frameA) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(xPos + this.centreX), (float)(yPos + this.centreY), (float)0.0f);
        float alpha = 1.0f;
        CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre(planet, planet.getBodyIcon(), 12);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (preEvent.celestialBodyTexture != null) {
            this.renderEngine.func_110577_a(preEvent.celestialBodyTexture);
        }
        if (!preEvent.isCanceled()) {
            float size = relSize / 70.0f * this.scale;
            this.drawTexturedRectCBody(-size / 2.0f, -size / 2.0f, size, size);
        }
        CelestialBodyRenderEvent.Post postEvent = new CelestialBodyRenderEvent.Post(planet);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        GL11.glPopMatrix();
    }

    private void drawCircle(CelestialBody cBody) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.centreX, (float)this.centreY, (float)0.002f);
        GL11.glDisable((int)3553);
        float sd = 0.002514f * this.scale;
        float x = this.getScale(cBody);
        float y = 0.0f;
        float grey = 0.1f + 0.65f * Math.max(0.0f, 0.5f - x);
        x = x * this.scale / sd;
        GL11.glColor4f((float)grey, (float)grey, (float)grey, (float)1.0f);
        GL11.glLineWidth((float)0.002f);
        GL11.glScalef((float)sd, (float)sd, (float)sd);
        CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre(cBody, new Vector3f(0.0f, 0.0f, 0.0f));
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        if (!preEvent.isCanceled()) {
            GL11.glBegin((int)2);
            for (int i = 0; i < 90; ++i) {
                GL11.glVertex2f((float)x, (float)y);
                float temp = x;
                x = this.cos * x - this.sin * y;
                y = this.sin * temp + this.cos * y;
            }
            GL11.glEnd();
        }
        CelestialBodyRenderEvent.CelestialRingRenderEvent.Post postEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post(cBody);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    private Vector3f getCelestialBodyPosition(CelestialBody cBody, float ticks) {
        float timeScale = cBody instanceof Planet ? 200.0f : 2.0f;
        float distanceFromCenter = this.getScale(cBody) * this.scale;
        return new Vector3f((float)Math.sin(ticks / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter, (float)Math.cos(ticks / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter, 0.0f);
    }

    private float getScale(CelestialBody celestialBody) {
        float distance = celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        if (distance >= 1.375f) {
            distance = distance >= 1.5f ? (distance *= 1.15f) : (distance += 0.075f);
        }
        return 0.007142857f * distance * (celestialBody instanceof Planet ? 25.0f : 3.5f);
    }

    private void planeEquation(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        double[] result = new double[]{y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2), z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2), x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2), -(x1 * (y2 * z3 - y3 * z2) + x2 * (y3 * z1 - y1 * z3) + x3 * (y1 * z2 - y2 * z1))};
        this.planes.put(result, 0, 4);
        this.planes.position(0);
    }

    private void drawPlanetsTest(float ticks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.centreX, (float)this.centreY, (float)0.0f);
        int id = (int)(ticks / 600.0f) % 5;
        RenderPlanet.renderID(id, this.scale, ticks);
        GL11.glPopMatrix();
    }

    private void drawTexturedRectUV(float x, float y, float width, float height, float ticks) {
        for (int ysect = 0; ysect < 6; ++ysect) {
            float angle = 7.5f + 15.0f * (float)ysect;
            this.drawTexturedRectUVSixth(x, y, width, height, ticks / (900.0f - 80.0f * MathHelper.func_76134_b((float)angle)) % 1.0f, (float)ysect / 6.0f);
        }
    }

    private void drawTexturedRectUVSixth(float x, float y, float width, float height, float prog, float y0) {
        prog = 1.0f - prog;
        float y1 = (y0 /= 2.0f) + 0.083333336f;
        float y2 = 1.0f - y1;
        float y3 = 1.0f - y0;
        float yaa = y + height * y0;
        float yab = y + height * y1;
        float yba = y + height * y2;
        float ybb = y + height * y3;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        if (prog <= 0.75f) {
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)yab, 0.0).func_187315_a((double)prog, (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yab, 0.0).func_187315_a((double)(prog + 0.25f), (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yaa, 0.0).func_187315_a((double)(prog + 0.25f), (double)y0).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yaa, 0.0).func_187315_a((double)prog, (double)y0).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)ybb, 0.0).func_187315_a((double)prog, (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)ybb, 0.0).func_187315_a((double)(prog + 0.25f), (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yba, 0.0).func_187315_a((double)(prog + 0.25f), (double)y2).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yba, 0.0).func_187315_a((double)prog, (double)y2).func_181675_d();
            tessellator.func_78381_a();
        } else {
            double xp = x + width * (1.0f - prog) / 0.25f;
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)yab, 0.0).func_187315_a((double)prog, (double)y1).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yab, 0.0).func_187315_a(1.0, (double)y1).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yaa, 0.0).func_187315_a(1.0, (double)y0).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yaa, 0.0).func_187315_a((double)prog, (double)y0).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b((double)x, (double)ybb, 0.0).func_187315_a((double)prog, (double)y3).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)ybb, 0.0).func_187315_a(1.0, (double)y3).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yba, 0.0).func_187315_a(1.0, (double)y2).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)yba, 0.0).func_187315_a((double)prog, (double)y2).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(xp, (double)yab, 0.0).func_187315_a(0.0, (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yab, 0.0).func_187315_a((double)(prog - 0.75f), (double)y1).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yaa, 0.0).func_187315_a((double)(prog - 0.75f), (double)y0).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yaa, 0.0).func_187315_a(0.0, (double)y0).func_181675_d();
            tessellator.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(xp, (double)ybb, 0.0).func_187315_a(0.0, (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)ybb, 0.0).func_187315_a((double)(prog - 0.75f), (double)y3).func_181675_d();
            worldRenderer.func_181662_b((double)(x + width), (double)yba, 0.0).func_187315_a((double)(prog - 0.75f), (double)y2).func_181675_d();
            worldRenderer.func_181662_b(xp, (double)yba, 0.0).func_187315_a(0.0, (double)y2).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

