/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IDisguisable {
    default public ItemStack getDisguisedStack(IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world, pos);
        if (disguisedState != null) {
            ItemStack stack = new ItemStack(disguisedState.func_177230_c());
            if (stack.func_77973_b().func_77614_k()) {
                stack.func_77964_b(disguisedState.func_177230_c().func_176201_c(disguisedState));
            }
            return stack;
        }
        return this.getDefaultStack();
    }

    default public ItemStack getDefaultStack() {
        return new ItemStack((Block)this);
    }

    public static IBlockState getDisguisedBlockStateUnknown(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IDisguisable) {
            return ((IDisguisable)state.func_177230_c()).getDisguisedBlockState(world, pos);
        }
        return null;
    }

    default public IBlockState getDisguisedBlockState(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IModuleInventory) {
            IModuleInventory te = (IModuleInventory)tile;
            return this.getDisguisedBlockStateFromStack(world, pos, te.isModuleEnabled(ModuleType.DISGUISE) ? te.getModule(ModuleType.DISGUISE) : ItemStack.field_190927_a);
        }
        return null;
    }

    default public IBlockState getDisguisedBlockStateFromStack(IBlockAccess world, BlockPos pos, ItemStack module) {
        if (!module.func_190926_b()) {
            IBlockState disguisedState;
            if (!module.func_77942_o()) {
                module.func_77982_d(new NBTTagCompound());
            }
            if ((disguisedState = NBTUtil.func_190008_d((NBTTagCompound)module.func_77978_p().func_74775_l("SavedState"))) != null && disguisedState.func_177230_c() != Blocks.field_150350_a) {
                return disguisedState;
            }
            if (world != null && pos != null) {
                ItemStack disguisedStack = ModuleItem.getAddonAsStack(module);
                Block block = Block.func_149634_a((Item)disguisedStack.func_77973_b());
                boolean hasMeta = disguisedStack.func_77981_g();
                IBlockState iBlockState = disguisedState = hasMeta ? block.func_176203_a(disguisedStack.func_77952_i()) : block.func_176223_P();
                if (block != this) {
                    return disguisedState.func_185899_b(world, pos);
                }
            }
        }
        return null;
    }

    public static BlockFaceShape getDisguisedBlockFaceShape(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory && ((IModuleInventory)te).isModuleEnabled(ModuleType.DISGUISE)) {
            IBlockState disguisedState;
            ItemStack module = ((IModuleInventory)te).getModule(ModuleType.DISGUISE);
            if (!module.func_77942_o()) {
                module.func_77982_d(new NBTTagCompound());
            }
            if ((disguisedState = NBTUtil.func_190008_d((NBTTagCompound)module.func_77978_p().func_74775_l("SavedState"))) != null && disguisedState.func_177230_c() != Blocks.field_150350_a) {
                return disguisedState.func_193401_d(world, pos, face);
            }
            Block block = ModuleItem.getBlockAddon(module);
            if (block == null) {
                return BlockFaceShape.SOLID;
            }
            return block.func_176223_P().func_193401_d(world, pos, face);
        }
        return BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean shouldDisguisedSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (!(world.func_175625_s(pos) instanceof IModuleInventory)) {
            return true;
        }
        IModuleInventory te = (IModuleInventory)world.func_175625_s(pos);
        if (te.isModuleEnabled(ModuleType.DISGUISE)) {
            Block blockToDisguiseAs;
            IBlockState disguisedState;
            ItemStack disguiseModule = te.getModule(ModuleType.DISGUISE);
            if (!disguiseModule.func_77942_o()) {
                disguiseModule.func_77982_d(new NBTTagCompound());
            }
            if ((disguisedState = NBTUtil.func_190008_d((NBTTagCompound)disguiseModule.func_77978_p().func_74775_l("SavedState"))) != null && disguisedState.func_177230_c() != Blocks.field_150350_a ? !disguisedState.func_185914_p() || !disguisedState.func_185917_h() : (blockToDisguiseAs = ModuleItem.getBlockAddon(disguiseModule)) != null && (!blockToDisguiseAs.func_176223_P().func_185914_p() || !blockToDisguiseAs.func_176223_P().func_185917_h())) {
                return DisguisableBlock.checkForSideTransparency(world, world.func_180495_p(pos.func_177972_a(side)), pos.func_177972_a(side));
            }
        }
        return true;
    }
}

