/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class ReinforcedDispenserBlockEntity
extends TileEntityDispenser
implements IOwnable,
IModuleInventory,
INameSetter {
    private InsertOnlyInvWrapper insertOnlyHandler;
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Owner owner = new Owner();
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.owner.load(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c() && oldState.func_177230_c() != SCContent.reinforcedMovingPiston;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.func_70301_a(slot);
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.field_190577_o) : this.getDefaultName();
    }

    @Override
    public ITextComponent getDefaultName() {
        return Utils.localize(SCContent.reinforcedDispenser, new Object[0]);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(BlockUtils.isAllowedToExtractFromProtectedObject(facing, this) ? super.getCapability(capability, facing) : this.getInsertOnlyHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    private InsertOnlyInvWrapper getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = new InsertOnlyInvWrapper((IInventory)this);
        }
        return this.insertOnlyHandler;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onInsertDisguiseModule((TileEntity)this, stack, toggled);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onRemoveDisguiseModule((TileEntity)this, stack, toggled);
        }
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onLoad(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        DisguisableBlockEntity.onInvalidate((TileEntity)this);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
        if (shouldBeEnabled) {
            this.onModuleInserted(this.getModule(module), module, true);
        } else {
            this.onModuleRemoved(this.getModule(module), module, true);
        }
    }

    @Override
    public World myLevel() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos myPos() {
        return this.field_174879_c;
    }
}

