/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyBindings {
    public static KeyBinding cameraZoomIn;
    public static KeyBinding cameraZoomOut;
    public static TickingKeyMapping<SecurityCamera> cameraEmitRedstone;
    public static TickingKeyMapping<SecurityCamera> cameraActivateNightVision;
    public static TickingKeyMapping<SecurityCamera> setDefaultViewingDirection;

    private KeyBindings() {
    }

    public static void init() {
        cameraZoomIn = KeyBindings.register("cameraZoomIn", 13);
        cameraZoomOut = KeyBindings.register("cameraZoomOut", 12);
        cameraEmitRedstone = KeyBindings.registerTicking("cameraEmitRedstone", 19, CameraController::toggleRedstone);
        cameraActivateNightVision = KeyBindings.registerTicking("cameraActivateNightVision", 49, CameraController::toggleNightVision);
        setDefaultViewingDirection = KeyBindings.registerTicking("setDefaultViewingDirection", 22, CameraController::setDefaultViewingDirection);
    }

    private static KeyBinding register(String name, int defaultKey) {
        SCKeyMapping keyMapping = new SCKeyMapping(name, defaultKey);
        ClientRegistry.registerKeyBinding((KeyBinding)keyMapping);
        return keyMapping;
    }

    private static <T> TickingKeyMapping<T> registerTicking(String name, int defaultKey, Consumer<T> action) {
        TickingKeyMapping<T> keyMapping = new TickingKeyMapping<T>(name, defaultKey, action);
        ClientRegistry.registerKeyBinding(keyMapping);
        return keyMapping;
    }

    public static class TickingKeyMapping<T>
    extends SCKeyMapping {
        private static final int MAX_COOLDOWN = 30;
        private int cooldown = 30;
        private Consumer<T> action;

        public TickingKeyMapping(String name, int defaultKey, Consumer<T> action) {
            super(name, defaultKey);
            this.action = action;
        }

        public void tick(T t) {
            --this.cooldown;
            if (this.func_151468_f() && this.cooldown <= 0) {
                this.action.accept(t);
                this.cooldown = 30;
            }
        }
    }

    public static class SCKeyMapping
    extends KeyBinding {
        public SCKeyMapping(String name, int defaultKey) {
            super("key.securitycraft." + name, defaultKey, "key.categories.securitycraft");
        }
    }
}

