/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SyncLaserSideConfig
implements IMessage {
    private BlockPos pos;
    private NBTTagCompound sideConfig;

    public SyncLaserSideConfig() {
    }

    public SyncLaserSideConfig(BlockPos pos, Map<EnumFacing, Boolean> sideConfig) {
        this.pos = pos;
        this.sideConfig = LaserBlockBlockEntity.saveSideConfig(sideConfig);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.sideConfig);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.sideConfig = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<SyncLaserSideConfig, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(SyncLaserSideConfig message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                LaserBlockBlockEntity laser;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                TileEntity te = world.func_175625_s(message.pos);
                if (te instanceof LaserBlockBlockEntity && (laser = (LaserBlockBlockEntity)te).isOwnedBy((Entity)player)) {
                    IBlockState state = world.func_180495_p(message.pos);
                    laser.applyNewSideConfig(LaserBlockBlockEntity.loadSideConfig(message.sideConfig), (EntityPlayer)player);
                    world.func_184138_a(message.pos, state, state, 2);
                }
            });
            return null;
        }
    }
}

