/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.input.Mouse;

public class StateSelector
extends GuiScreen
implements IContainerListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/state_selector.png");
    private static final int PAGE_LENGTH = 5;
    private final StateSelectorAccessMenu menu;
    private final int xStart;
    private final int yStart;
    private final int slotToCheck;
    private final float previewXTranslation;
    private final float previewYTranslation;
    private final HoverChecker dragHoverChecker;
    private final List<Rectangle> extraAreas = new ArrayList<Rectangle>();
    private final RenderAccess renderAccess = new RenderAccess();
    private IBlockState state = Blocks.field_150350_a.func_176223_P();
    private List<IProperty<?>> properties = new ArrayList();
    private TileEntity te = null;
    private TileEntitySpecialRenderer teRenderer = null;
    private List<BlockStatePropertyButton<?>> propertyButtons = new ArrayList();
    private int page;
    private int amountOfPages;
    private GuiButton previousPageButton;
    private GuiButton nextPageButton;
    private boolean clickedInDragRegion = false;
    private float dragX = -15.0f;
    private float dragY = -135.0f;

    public StateSelector(StateSelectorAccessMenu menu, int xStart, int yStart, int slotToCheck, int dragStartX, int dragStartY) {
        menu.func_75132_a(this);
        this.menu = menu;
        this.xStart = xStart;
        this.yStart = yStart;
        this.slotToCheck = slotToCheck;
        this.previewXTranslation = (dragStartX += xStart) + 34;
        this.previewYTranslation = (dragStartY += yStart) + 36;
        this.dragHoverChecker = new HoverChecker(dragStartY, dragStartY + 47, dragStartX, dragStartX + 47);
    }

    public void func_73866_w_() {
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        if (this.menu.getStateStack().func_77973_b() instanceof ItemBlock) {
            ItemBlock blockItem = (ItemBlock)this.menu.getStateStack().func_77973_b();
            IBlockState savedState = this.menu.getSavedState();
            Block blockToCheck = blockItem.func_179223_d();
            this.state = blockToCheck == savedState.func_177230_c() ? savedState : blockItem.func_179223_d().func_176223_P();
        }
        this.previousPageButton = new ClickButton(0, this.xStart + 69, this.yStart + 125, 20, 20, "<", button -> this.turnPage(-1));
        this.nextPageButton = new ClickButton(1, this.xStart + 126, this.yStart + 125, 20, 20, ">", button -> this.turnPage(1));
        this.updateButtons(true);
        this.extraAreas.add(new Rectangle(this.xStart, 0, 193, new ScaledResolution(this.field_146297_k).func_78328_b()));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        if (Mouse.isButtonDown((int)0) && this.clickedInDragRegion) {
            float dy = Mouse.getDY();
            float dx = Mouse.getDX();
            if (dy != 0.0f) {
                this.dragX += dy;
            }
            if (dx != 0.0f) {
                this.dragY += dx;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.xStart, this.yStart, 0, 0, 193, 150);
        super.func_73863_a(mouseX, mouseY, partialTick);
        this.previousPageButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTick);
        this.nextPageButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTick);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.previewXTranslation, (float)this.previewYTranslation, (float)512.0f);
        GlStateManager.func_179109_b((float)-12.0f, (float)-12.0f, (float)-12.0f);
        GlStateManager.func_179114_b((float)this.dragX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.dragY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)12.0f, (float)12.0f, (float)12.0f);
        GlStateManager.func_179152_a((float)-26.0f, (float)-26.0f, (float)-26.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        this.renderBlockModel(this.state);
        if (this.teRenderer != null) {
            this.teRenderer.func_192841_a(this.te, 0.0, 0.0, 0.0, partialTick, -1, 1.0f);
        }
        GlStateManager.func_179121_F();
        for (int i = 0; i < this.propertyButtons.size(); ++i) {
            String propertyName = this.propertyButtons.get(i).getProperty().func_177701_a();
            this.field_146289_q.func_78276_b(propertyName, this.xStart + 91 - this.field_146289_q.func_78256_a(propertyName) - 2, this.yStart + i * 23 + 10, 0x404040);
        }
        this.field_146289_q.func_78276_b(this.page + "/" + this.amountOfPages, this.xStart + 100, this.yStart + 130, 0x404040);
    }

    public void updateButtons(boolean updateInfo) {
        if (updateInfo) {
            this.properties = new ArrayList(this.state.func_177227_a());
            this.amountOfPages = (int)Math.ceil((float)this.properties.size() / 5.0f);
            this.page = this.amountOfPages == 0 ? 0 : 1;
            this.updateBlockEntityInfo(true);
            this.dragX = -15.0f;
            this.dragY = -135.0f;
        }
        int buttonY = 0;
        int pageStartIndex = (this.page - 1) * 5;
        int i = 0;
        int buttonId = 2;
        this.field_146292_n.removeIf(this.propertyButtons::contains);
        this.propertyButtons.clear();
        for (IProperty<?> property : this.properties) {
            if (i < pageStartIndex) {
                ++i;
                continue;
            }
            if (i >= pageStartIndex + 5) break;
            Collection values = property.func_177700_c();
            Comparable defaultValue = this.state.func_177229_b(property);
            int defaultValueIndex = 0;
            for (Object o : values) {
                if (o == defaultValue) break;
                ++defaultValueIndex;
            }
            this.propertyButtons.add((BlockStatePropertyButton<?>)this.func_189646_b((GuiButton)new BlockStatePropertyButton(buttonId++, this.xStart + 91, this.yStart + buttonY + 5, 100, 20, defaultValueIndex, property)));
            buttonY += 23;
            ++i;
        }
        if (this.previousPageButton != null) {
            boolean bl = this.previousPageButton.field_146124_l = this.page > 1;
        }
        if (this.nextPageButton != null) {
            this.nextPageButton.field_146124_l = this.page != this.amountOfPages;
        }
    }

    public void turnPage(int direction) {
        this.page = (int)((float)this.page + Math.signum(direction));
        if (this.page > this.amountOfPages) {
            this.page = 1;
        } else if (this.page < 1) {
            this.page = this.amountOfPages;
        }
        this.updateButtons(false);
    }

    private void updateBlockEntityInfo(boolean reset) {
        if (reset) {
            this.te = null;
            this.teRenderer = null;
        }
        if (this.state.func_177230_c().hasTileEntity(this.state)) {
            if (this.te == null) {
                Minecraft mc = Minecraft.func_71410_x();
                this.te = this.state.func_177230_c().createTileEntity((World)mc.field_71441_e, this.state);
                this.te.field_145854_h = this.state.func_177230_c();
                this.te.func_145834_a((World)mc.field_71441_e);
                this.teRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(this.te);
            }
            this.te.field_145847_g = this.state.func_177230_c().func_176201_c(this.state);
        }
    }

    public void renderBlockModel(IBlockState state) {
        if (state.func_185901_i() == EnumBlockRenderType.MODEL) {
            BlockRendererDispatcher blockRenderer = this.field_146297_k.func_175602_ab();
            IBakedModel blockModel = blockRenderer.func_184389_a(state);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            blockRenderer.func_175019_b().func_178267_a((IBlockAccess)this.renderAccess, blockModel, state, BlockPos.field_177992_a, buffer, false);
            tessellator.func_78381_a();
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int button) {
        if (button == 0) {
            for (int i = 0; i < this.propertyButtons.size(); ++i) {
                BlockStatePropertyButton<?> bspb = this.propertyButtons.get(i);
                if (!bspb.onPress()) continue;
                bspb.func_146113_a(this.field_146297_k.func_147118_V());
                break;
            }
            if (this.previousPageButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                ((ClickButton)this.previousPageButton).onClick();
                this.previousPageButton.func_146113_a(this.field_146297_k.func_147118_V());
            } else if (this.nextPageButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                ((ClickButton)this.nextPageButton).onClick();
                this.nextPageButton.func_146113_a(this.field_146297_k.func_147118_V());
            }
            this.clickedInDragRegion = this.dragHoverChecker.checkHover(mouseX, mouseY);
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        this.clickedInDragRegion = false;
    }

    public void func_71111_a(Container container, int slotIndex, ItemStack newStack) {
        if (slotIndex == this.slotToCheck) {
            this.state = newStack.func_77973_b() instanceof ItemBlock && (this.state == null || ((ItemBlock)newStack.func_77973_b()).func_179223_d() != this.state.func_177230_c()) ? ((ItemBlock)newStack.func_77973_b()).func_179223_d().func_176203_a(newStack.func_77960_j()) : Blocks.field_150350_a.func_176223_P();
            this.updateButtons(true);
            if (this.menu != null) {
                this.menu.onStateChange(this.state);
            }
        }
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71112_a(Container container, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container container, IInventory inventory) {
    }

    public IBlockState getState() {
        return this.state;
    }

    public List<Rectangle> getExtraAreas() {
        return this.extraAreas;
    }

    public class RenderAccess
    implements IBlockAccess {
        public TileEntity func_175625_s(BlockPos pos) {
            return pos == BlockPos.field_177992_a ? StateSelector.this.te : null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return pos == BlockPos.field_177992_a ? StateSelector.this.state : Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return pos != BlockPos.field_177992_a || StateSelector.this.state != null && StateSelector.this.state.func_177230_c() == Blocks.field_150350_a;
        }

        public Biome func_180494_b(BlockPos pos) {
            return Biomes.field_76772_c;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            return Minecraft.func_71410_x().field_71441_e.func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean defaultValue) {
            return pos == BlockPos.field_177992_a ? StateSelector.this.state.isSideSolid((IBlockAccess)this, pos, side) : defaultValue;
        }
    }

    public class BlockStatePropertyButton<T extends Comparable<T>>
    extends GuiButtonExt {
        private int currentIndex;
        private final int toggleCount;
        private final IProperty<T> property;
        private T value;

        public BlockStatePropertyButton(int id, int xPos, int yPos, int width, int height, int initialValue, IProperty<T> property) {
            super(id, xPos, yPos, width, height, "");
            this.currentIndex = 0;
            this.property = property;
            this.currentIndex = initialValue;
            this.toggleCount = property.func_177700_c().size();
            this.onValueChange();
        }

        public void onValueChange() {
            if (this.property != null) {
                Collection values = this.property.func_177700_c();
                int i = 0;
                for (Comparable t : values) {
                    if (i++ != this.currentIndex) continue;
                    this.value = t;
                    break;
                }
                this.field_146126_j = this.property.func_177702_a(this.value);
            }
        }

        public boolean onPress() {
            if (this.field_146123_n) {
                this.currentIndex = Math.floorMod(this.currentIndex + 1, this.toggleCount);
                this.onValueChange();
                StateSelector.this.state = StateSelector.this.state.func_177226_a(this.property, this.value);
                StateSelector.this.updateBlockEntityInfo(false);
                StateSelector.this.menu.onStateChange(StateSelector.this.state);
            }
            return this.field_146123_n;
        }

        public IProperty<T> getProperty() {
            return this.property;
        }

        public T getValue() {
            return this.value;
        }
    }
}

