/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch;

import igentuman.galacticresearch.ISidedProxy;
import igentuman.galacticresearch.RegistryHandler;
import igentuman.galacticresearch.command.CommandHandler;
import igentuman.galacticresearch.common.data.SpaceMineProvider;
import igentuman.galacticresearch.handler.GREventHandler;
import igentuman.galacticresearch.handler.GRPlayerHandler;
import igentuman.galacticresearch.network.GRChannelHandler;
import igentuman.galacticresearch.network.GuiProxy;
import igentuman.galacticresearch.sky.SkyModel;
import igentuman.galacticresearch.util.GRHooks;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="galacticresearch", name="Galactic Research", version="1.0.0", dependencies="required-after:galacticraftplanets;after:extraplanets@[1.12.2-0.8.0,];", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class GalacticResearch {
    public static final String MODID = "galacticresearch";
    public static final String NAME = "Galactic Research";
    public static final String VERSION = "1.0.0";
    @Mod.Instance(value="galacticresearch")
    public static GalacticResearch instance;
    public static MinecraftServer server;
    public static SkyModel skyModel;
    public static SpaceMineProvider spaceMineProvider;
    public static GRChannelHandler packetPipeline;
    public static GRHooks hooks;
    @SidedProxy(serverSide="igentuman.galacticresearch.common.CommonProxy", clientSide="igentuman.galacticresearch.client.ClientProxy")
    public static ISidedProxy proxy;
    public Logger logger;
    public static GRPlayerHandler pHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RegistryHandler());
        pHandler = new GRPlayerHandler();
        MinecraftForge.EVENT_BUS.register((Object)new GREventHandler());
        MinecraftForge.EVENT_BUS.register((Object)pHandler);
        proxy.preInit(event);
        this.logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        hooks.hookPreInit();
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent ev) {
        server = ev.getServer();
        spaceMineProvider = SpaceMineProvider.get();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent ev) {
        server = ev.getServer();
        spaceMineProvider = SpaceMineProvider.get();
        skyModel.initSeed();
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent ev) {
        server = null;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        hooks.hookInit();
        proxy.init(event);
        this.logger.info("Starting Initialization.");
        ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiProxy());
        packetPipeline = GRChannelHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        hooks.hookPostInit();
        proxy.postInit(event);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent serverStartEvent) {
        CommandHandler.registerCommands(serverStartEvent);
    }

    static {
        skyModel = SkyModel.get();
        hooks = new GRHooks();
    }
}

