/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.ai.task;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.ai.task.minions.ExtraPlanetsMinions;
import igentuman.galacticresearch.ai.task.minions.GalaxtSpaceMinions;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntitySkeletonBoss;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCreeperBoss;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntitySpiderQueen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;

public class EntityAISpawnMinions
extends EntityAIBase {
    protected EntityLiving entity;
    protected Entity closestEntity;
    protected float maxDistance;
    private int counter = 10;
    protected Class<? extends Entity> watchedClass;

    public EntityAISpawnMinions(EntityLiving entityIn, Class<? extends Entity> watchTargetClass, float maxDistance) {
        this.entity = entityIn;
        this.watchedClass = watchTargetClass;
        this.maxDistance = maxDistance;
        this.func_75248_a(2);
    }

    public EntityAISpawnMinions(EntityLiving entityIn, Class<? extends Entity> watchTargetClass, float maxDistance, float chanceIn) {
        this.entity = entityIn;
        this.watchedClass = watchTargetClass;
        this.maxDistance = maxDistance;
        this.func_75248_a(2);
    }

    public boolean func_75250_a() {
        --this.counter;
        if (this.counter <= 0) {
            this.counter = Math.max(this.entity.field_70170_p.field_73012_v.nextInt(100), 60);
            if (this.entity.func_70638_az() != null) {
                this.closestEntity = this.entity.func_70638_az();
            }
            this.closestEntity = this.watchedClass == EntityPlayer.class ? this.entity.field_70170_p.func_190525_a(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, (double)this.maxDistance, Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)EntitySelectors.func_191324_b((Entity)this.entity))) : this.entity.field_70170_p.func_72857_a(this.watchedClass, this.entity.func_174813_aQ().func_72314_b((double)this.maxDistance, 3.0, (double)this.maxDistance), (Entity)this.entity);
            return this.closestEntity != null;
        }
        return false;
    }

    private void spawnMobs() {
        for (int i = 0; i < 1 + this.entity.field_70170_p.field_73012_v.nextInt(2); ++i) {
            EntityEvolvedSkeleton mob = null;
            if (this.entity instanceof EntitySkeletonBoss) {
                mob = new EntityEvolvedSkeleton(this.entity.field_70170_p);
            } else if (this.entity instanceof EntityCreeperBoss) {
                mob = new EntityEvolvedCreeper(this.entity.field_70170_p);
            } else if (this.entity instanceof EntitySpiderQueen) {
                mob = new EntityEvolvedSpider(this.entity.field_70170_p);
            }
            if (this.entity == null) {
                return;
            }
            if (mob == null && GalacticResearch.hooks.ExtraPlanetsLoaded) {
                mob = ExtraPlanetsMinions.spawn(this.entity);
            }
            if (mob == null && GalacticResearch.hooks.GalaxySpaceLoaded) {
                mob = GalaxtSpaceMinions.spawn(this.entity);
            }
            if (mob == null) {
                mob = new EntityEvolvedZombie(this.entity.field_70170_p);
            }
            float range = 3.0f;
            mob.func_70107_b(this.entity.field_70165_t + 0.5 + Math.random() * (double)range - (double)(range / 2.0f), this.entity.field_70163_u + 1.0, this.entity.field_70161_v + 0.5 + Math.random() * (double)range - (double)(range / 2.0f));
            mob.func_180482_a(this.entity.field_70170_p.func_175649_E(new BlockPos((Entity)mob)), null);
            mob.func_70624_b((EntityLivingBase)this.closestEntity);
            mob.field_98038_p = true;
            EntityAIBase task = null;
            for (EntityAITasks.EntityAITaskEntry t : mob.field_70715_bh.field_75782_a) {
                if (!(t.field_75733_a instanceof EntityAIHurtByTarget)) continue;
                task = t.field_75733_a;
                break;
            }
            if (task != null) {
                mob.field_70715_bh.func_85156_a(task);
            }
            if (mob instanceof EntityEvolvedSkeleton) {
                mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
            }
            this.closestEntity.field_70170_p.func_72838_d((Entity)mob);
        }
    }

    public void func_75246_d() {
        this.spawnMobs();
    }
}

