/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.client;

import com.google.common.collect.ImmutableList;
import igentuman.galacticresearch.client.capability.SpaceClientCapabilityHandler;
import igentuman.galacticresearch.client.compat.ExtraPlanets;
import igentuman.galacticresearch.client.model.ItemModelMiningRocket;
import igentuman.galacticresearch.client.model.ItemModelSatelliteRocket;
import igentuman.galacticresearch.client.render.entity.RenderMiningRocket;
import igentuman.galacticresearch.client.render.entity.RenderSatelliteRocket;
import igentuman.galacticresearch.client.render.tile.TileLaunchpadTowerRender;
import igentuman.galacticresearch.client.screen.GameScreenMission;
import igentuman.galacticresearch.client.screen.GameScreenTelescope;
import igentuman.galacticresearch.common.CommonProxy;
import igentuman.galacticresearch.common.entity.EntityMiningRocket;
import igentuman.galacticresearch.common.entity.EntitySatelliteRocket;
import igentuman.galacticresearch.common.tile.TileLaunchpadTower;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ModelTransformWrapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="galacticresearch", value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private void replaceModelDefault(ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, IModelState parentState, String ... variants) {
        ClientUtil.replaceModel((String)"galacticresearch", (ModelBakeEvent)event, (String)resLoc, (String)objLoc, visibleGroups, clazz, (IModelState)parentState, (String[])variants);
    }

    private void registerTexture(TextureStitchEvent.Pre event, String texture) {
        event.getMap().func_174942_a(new ResourceLocation("galacticresearch:blocks/" + texture));
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        ClientRegistry.bindTileEntitySpecialRenderer(TileLaunchpadTower.class, (TileEntitySpecialRenderer)new TileLaunchpadTowerRender());
        GalacticraftRegistry.registerScreen((IGameScreen)new GameScreenMission());
        GalacticraftRegistry.registerScreen((IGameScreen)new GameScreenTelescope());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        SpaceClientCapabilityHandler.register();
        super.postInit(event);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        RenderingRegistry.registerEntityRenderingHandler(EntitySatelliteRocket.class, manager -> new RenderSatelliteRocket(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityMiningRocket.class, manager -> new RenderMiningRocket(manager));
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (Loader.isModLoaded((String)"extraplanets")) {
            MinecraftForge.EVENT_BUS.register(ExtraPlanets.class);
        }
        OBJLoader.INSTANCE.addDomain("galacticresearch");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBakeEvent(ModelBakeEvent event) {
        this.replaceModelDefault(event, "satellite_rocket", "satellite_rocket.obj", (List<String>)ImmutableList.of((Object)"Rocket"), ItemModelSatelliteRocket.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        this.replaceModelDefault(event, "mining_rocket", "mining_rocket.obj", (List<String>)ImmutableList.of((Object)"Rocket"), ItemModelMiningRocket.class, (IModelState)TRSRTransformation.identity(), new String[0]);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre event) {
        this.registerTexture(event, "mining_rocket");
        this.registerTexture(event, "satellite_rocket");
    }
}

