/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.client.gui;

import com.google.common.collect.Lists;
import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.client.capability.PlayerClientSpaceData;
import igentuman.galacticresearch.client.capability.SpaceClientCapabilityHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.FMLClientHandler;

public class GRGuiCelestialSelection
extends GuiCelestialSelection {
    public GRGuiCelestialSelection(boolean mapMode, List<CelestialBody> possibleBodies, boolean canCreateStations) {
        super(mapMode, possibleBodies, canCreateStations);
    }

    private boolean isUnlocked(String name, PlayerClientSpaceData stats) {
        return stats.getUnlockedMissions().contains(name.toLowerCase()) || Arrays.asList(ModConfig.researchSystem.default_researched_objects).contains(name.toLowerCase());
    }

    public void func_73866_w_() {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        PlayerClientSpaceData stats = null;
        if (player != null) {
            stats = (PlayerClientSpaceData)playerBaseClient.getCapability(SpaceClientCapabilityHandler.PLAYER_SPACE_CLIENT_DATA, null);
        }
        this.bodiesToRender.clear();
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (!this.isUnlocked(planet.getName(), stats)) continue;
            this.bodiesToRender.add(planet);
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (!this.isUnlocked(moon.getParentPlanet().getName(), stats) || !this.isUnlocked(moon.getName(), stats)) continue;
            this.bodiesToRender.add(moon);
        }
        this.bodiesToRender.addAll(GalaxyRegistry.getRegisteredSatellites().values());
        GuiCelestialSelection.BORDER_SIZE = this.field_146294_l / 65;
        GuiCelestialSelection.BORDER_EDGE_SIZE = GuiCelestialSelection.BORDER_SIZE / 4;
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            this.bodiesToRender.add(solarSystem.getMainStar());
        }
    }

    protected List<CelestialBody> getChildren(Object object) {
        ArrayList bodyList = Lists.newArrayList();
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        PlayerClientSpaceData stats = null;
        if (player != null) {
            stats = (PlayerClientSpaceData)playerBaseClient.getCapability(SpaceClientCapabilityHandler.PLAYER_SPACE_CLIENT_DATA, null);
        }
        if (object instanceof Planet) {
            List moons = GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)object));
            for (Moon moon : moons) {
                if (!this.isUnlocked(moon.getName(), stats)) continue;
                bodyList.add(moon);
            }
        } else if (object instanceof SolarSystem) {
            List planets = GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)((SolarSystem)object));
            for (Planet planet : planets) {
                if (!this.isUnlocked(planet.getName(), stats)) continue;
                bodyList.add(planet);
            }
        }
        Collections.sort(bodyList);
        return bodyList;
    }

    public void drawButtons(int mousePosX, int mousePosY) {
        super.drawButtons(mousePosX, mousePosY);
        int LHS = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
        GRGuiCelestialSelection.func_73734_a((int)(LHS + 1), (int)(this.field_146295_m - LHS - 5), (int)(LHS + 500), (int)(this.field_146295_m - LHS - 20), (int)ColorUtil.to32BitColor((int)255, (int)0, (int)0, (int)0));
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.celestial_selection.advise", (Object[])new Object[0]), LHS + 5, this.field_146295_m - LHS - 15, RED);
    }
}

