/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.client.gui;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.common.container.ContainerTelescope;
import igentuman.galacticresearch.common.tile.TileTelescope;
import igentuman.galacticresearch.network.GRPacketSimple;
import igentuman.galacticresearch.sky.SkyModel;
import igentuman.galacticresearch.sky.body.Asteroid;
import igentuman.galacticresearch.sky.body.ISkyBody;
import igentuman.galacticresearch.sky.body.Researchable;
import igentuman.galacticresearch.sky.body.Star;
import igentuman.galacticresearch.util.WorldUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiTelescope
extends GuiContainerGC {
    private static final ResourceLocation guiTexture = new ResourceLocation("galacticresearch", "textures/gui/container/telescope_hd.png");
    private static final ResourceLocation overlay = new ResourceLocation("galacticresearch", "textures/gui/container/telescope_top_overlay.png");
    private final TileTelescope tile;
    float tmpX = 0.0f;
    float tmpY = 0.0f;
    private GuiButtonImage btnUp;
    private GuiButtonImage btnDown;
    private GuiButtonImage btnLeft;
    private GuiButtonImage btnRight;
    private GuiButton btnMultiplier;
    private GuiButtonImage btnHelp;
    private Map<String, GuiButtonImage> planets = new HashMap<String, GuiButtonImage>();
    public float sh = 0.0f;
    public int[] curStar = new int[]{1, 1};
    private GuiElementInfoRegion electricInfoRegion = new GuiElementInfoRegion(this.field_147003_i + 30, this.field_147009_r + 167, 64, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
    private GuiElementInfoRegion helpRegion = new GuiElementInfoRegion(this.field_147003_i + 154, this.field_147009_r + 164, 12, 12, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
    private GuiElementInfoRegion researchedRegion = new GuiElementInfoRegion(this.field_147003_i + 140, this.field_147009_r + 164, 12, 12, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
    private GuiButtonImage btnResearched;
    public static long lastTickWTime = 0L;
    public static float ticks = 0.0f;
    public static float lastXangle = 0.0f;
    public static float lastYangle = 0.0f;

    public GuiTelescope(InventoryPlayer par1InventoryPlayer, TileTelescope tile) {
        super((Container)new ContainerTelescope(par1InventoryPlayer, tile));
        this.tile = tile;
        this.field_147000_g = 201;
    }

    private void tickButtons() {
        if (this.field_146290_a != null && this.field_146290_a.func_146115_a()) {
            if (this.field_146290_a.field_146127_k == 4) {
                return;
            }
            this.func_146284_a(this.field_146290_a);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 200) {
            this.func_146284_a((GuiButton)this.btnUp);
            return;
        }
        if (keyCode == 208) {
            this.func_146284_a((GuiButton)this.btnDown);
            return;
        }
        if (keyCode == 203) {
            this.func_146284_a((GuiButton)this.btnLeft);
            return;
        }
        if (keyCode == 205) {
            this.func_146284_a((GuiButton)this.btnRight);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.TELESCOPE_UP_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 1: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.TELESCOPE_DOWN_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 2: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.TELESCOPE_LEFT_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 3: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.TELESCOPE_RIGHT_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
                break;
            }
            case 4: {
                GalacticResearch.packetPipeline.sendToServer((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.TELESCOPE_MULTIPLIER_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
            }
        }
    }

    public boolean isVisible(ISkyBody body) {
        return (float)body.getX() + body.getSize() / 4.0f > this.xAngle() && (float)body.getY() + body.getSize() / 4.0f > this.yAngle() && (float)body.getX() < this.xAngle() + (float)TileTelescope.viewportSize && (float)body.getY() < this.yAngle() + (float)TileTelescope.viewportSize && body.isVisible();
    }

    public float xAngle() {
        if (lastXangle == 0.0f) {
            lastXangle = this.tmpX;
        }
        this.tmpX = this.tile.xAngle;
        return lastXangle + (this.tile.xAngle - lastXangle) * ticks;
    }

    public float yAngle() {
        if (lastYangle == 0.0f) {
            lastYangle = this.tmpY;
        }
        this.tmpY = this.tile.yAngle;
        return lastYangle + (this.tile.yAngle - lastYangle) * ticks;
    }

    public float viewportX(float x) {
        return (float)(this.field_147003_i + 6) + x - this.xAngle();
    }

    public float viewportY(float y) {
        return (float)(this.field_147009_r + 24) + y - this.yAngle();
    }

    public void renderStars() {
        Star[] stars = SkyModel.get().getStars();
        if (stars == null) {
            return;
        }
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        for (Star star : stars) {
            if (star.equals(stars[0]) && (this.curStar[0] != star.getX() || this.curStar[1] != star.getY())) {
                this.curStar[0] = star.getX();
                this.curStar[1] = star.getY();
                this.sh = 0.0f;
            }
            if (!this.isVisible(star)) continue;
            float x = this.viewportX(star.getX());
            float y = this.viewportY(star.getY());
            int offset = star.getColor() * 3;
            this.func_175174_a(x * 2.0f + this.sh, y * 2.0f + this.sh, 0, 201 + offset, (int)star.getSize(), (int)star.getSize());
        }
        this.sh = (float)((double)this.sh + 0.033);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
    }

    private void renderFastScope() {
        List<Researchable> bodies = SkyModel.get().getCurrentSystemBodies(this.tile.dimension);
        if (bodies == null) {
            return;
        }
        for (ISkyBody iSkyBody : bodies) {
            Researchable res;
            if (iSkyBody == null || !(res = (Researchable)iSkyBody).isVisible()) continue;
            GlStateManager.func_179097_i();
            GL11.glDisable((int)32826);
            this.renderSmallBody(res);
            GlStateManager.func_179126_j();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void renderPlanets() {
        List<Researchable> bodies = SkyModel.get().getCurrentSystemBodies(this.tile.dimension);
        if (bodies == null) {
            return;
        }
        for (ISkyBody iSkyBody : bodies) {
            Researchable res;
            if (iSkyBody == null || !this.isVisible(res = (Researchable)iSkyBody)) continue;
            this.field_146297_k.func_110434_K().func_110577_a(res.getTexture());
            GlStateManager.func_179097_i();
            GL11.glDisable((int)32826);
            this.renderBody(res);
            GlStateManager.func_179126_j();
        }
    }

    public void renderScaledBody(Researchable res) {
        float x = this.viewportX(res.guiX(lastTickWTime, ticks));
        float y = this.viewportY(res.guiY(lastTickWTime, ticks));
        float scale = res.getSize() / 256.0f;
        int yOffset = res.yTexOffset();
        if (res.getName().equals("moon")) {
            yOffset = WorldUtil.getMoonPhase() * 32;
        }
        float centerX = x + res.getSize() / 2.0f;
        float centerY = y + res.getSize() / 2.0f;
        GlStateManager.func_179109_b((float)centerX, (float)centerY, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)(-centerX), (float)(-centerY), (float)0.0f);
        float viewportBondX = (float)(this.field_147003_i + 6 + TileTelescope.viewportSize) - this.viewportX(res.getX()) + 6.0f;
        float viewportBondY = (float)(this.field_147009_r + 24 + TileTelescope.viewportSize) - this.viewportY(res.getY()) + 6.0f;
        this.func_175174_a(x, y, 0, yOffset, (int)Math.min(viewportBondX / scale, res.getSize() / scale), (int)Math.min(viewportBondY / scale, res.getSize() / scale));
    }

    public void renderAsteroid(Asteroid res) {
        float x = this.viewportX(res.guiX(lastTickWTime, ticks));
        float y = this.viewportY(res.guiY(lastTickWTime, ticks));
        float centerX = x + res.getSize() / 2.0f;
        float centerY = y + res.getSize() / 2.0f;
        int yOffset = res.yTexOffset();
        GlStateManager.func_179109_b((float)centerX, (float)centerY, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().field_71441_e.func_82737_E(), (float)1.0f, (float)0.0f, (float)45.0f);
        GlStateManager.func_179109_b((float)(-centerX), (float)(-centerY), (float)0.0f);
        float viewportBondX = (float)(this.field_147003_i + 6 + TileTelescope.viewportSize) - this.viewportX(res.getX()) + 6.0f;
        float viewportBondY = (float)(this.field_147009_r + 24 + TileTelescope.viewportSize) - this.viewportY(res.getY()) + 6.0f;
        this.func_175174_a(x, y, 0, yOffset, (int)Math.min(viewportBondX, res.getSize()), (int)Math.min(viewportBondY, res.getSize()));
    }

    public void renderSmallBody(Researchable res) {
        GlStateManager.func_179094_E();
        float x = (int)this.viewportX((float)res.getX() * 0.037f + this.xAngle()) + 117;
        float y = (int)this.viewportY((float)res.getY() * 0.037f + this.yAngle()) + 65;
        int size = res.getSize() > 16.0f ? (res.getSize() > 28.0f ? 3 : 2) : 1;
        GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)0.7f);
        this.func_175174_a(x, y, 0, 201, size, size);
        GlStateManager.func_179121_F();
    }

    public void renderBody(Researchable res) {
        GlStateManager.func_179094_E();
        if (res.getName().toUpperCase().contains("ASTEROID-")) {
            this.renderAsteroid((Asteroid)res);
        } else {
            this.renderScaledBody(res);
        }
        GlStateManager.func_179121_F();
    }

    public void renderFocusArea() {
        int padding = 25;
        this.func_73729_b(this.field_147003_i + 6 + padding, this.field_147009_r + 24 + padding, 176, 123, 21, 21);
        this.func_73729_b(this.field_147003_i + 6 + padding, this.field_147009_r + 3 + TileTelescope.viewportSize - padding, 176, 144, 21, 21);
        this.func_73729_b(this.field_147003_i + 6 + TileTelescope.viewportSize - padding - 21, this.field_147009_r + 24 + padding, 176, 165, 21, 21);
        this.func_73729_b(this.field_147003_i + 6 + TileTelescope.viewportSize - padding - 21, this.field_147009_r + 24 + TileTelescope.viewportSize - padding - 21, 176, 186, 21, 21);
    }

    public void initButtons() {
        int xpos = this.field_147003_i + 142;
        int ypos = this.field_147009_r + 40;
        int size = 12;
        int padding = 6;
        this.btnUp = new GuiButtonImage(0, xpos, ypos - size - padding, size, size, 176, 83, 12, guiTexture);
        this.field_146292_n.add(this.btnUp);
        this.btnDown = new GuiButtonImage(1, xpos, ypos + size + padding, size, size, 176, 59, 12, guiTexture);
        this.field_146292_n.add(this.btnDown);
        this.btnLeft = new GuiButtonImage(2, xpos - size - padding, ypos, size, size, 176, 11, 12, guiTexture);
        this.field_146292_n.add(this.btnLeft);
        this.btnRight = new GuiButtonImage(3, xpos + size + padding, ypos, size, size, 176, 35, 12, guiTexture);
        this.field_146292_n.add(this.btnRight);
        this.btnMultiplier = new GuiButton(4, xpos - 4, ypos - 4, 20, 20, String.valueOf(this.tile.movementAmplifier));
        this.field_146292_n.add(this.btnMultiplier);
        this.btnHelp = new GuiButtonImage(5, xpos + size, this.field_147009_r + 164, 13, 14, 176, 109, 0, guiTexture);
        this.field_146292_n.add(this.btnHelp);
        this.btnResearched = new GuiButtonImage(6, xpos - 2, this.field_147009_r + 164, 12, 14, 0, 233, 0, guiTexture);
        this.field_146292_n.add(this.btnResearched);
    }

    public void updateResearchedData() {
        String[] bodies;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(GCCoreUtil.translate((String)"gui.telescope.researched"));
        for (String name : bodies = this.tile.getResearchedBodiesArray()) {
            if (name.toUpperCase().contains("ASTEROID-")) {
                lines.add(name);
                continue;
            }
            String planet = I18n.func_135052_a((String)("planet." + name), (Object[])new Object[0]);
            if (planet.equals("planet." + name)) {
                planet = I18n.func_135052_a((String)("moon." + name), (Object[])new Object[0]);
            }
            lines.add(planet);
        }
        if (bodies.length == 0) {
            lines.add(GCCoreUtil.translate((String)"gui.telescope.researched.none"));
        }
        this.researchedRegion.tooltipStrings = lines;
    }

    private void addResearchedRegion() {
        this.updateResearchedData();
        this.researchedRegion.xPosition = this.field_147003_i + 140;
        this.researchedRegion.yPosition = this.field_147009_r + 164;
        this.researchedRegion.parentWidth = this.field_146294_l;
        this.researchedRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.researchedRegion);
    }

    private void addHelpRegion() {
        ArrayList<String> help = new ArrayList<String>();
        help.add(GCCoreUtil.translate((String)"gui.help.desc.0"));
        help.add(GCCoreUtil.translate((String)"gui.help.desc.1"));
        help.add(GCCoreUtil.translate((String)"gui.help.desc.2"));
        this.helpRegion.tooltipStrings = help;
        this.helpRegion.xPosition = this.field_147003_i + 154;
        this.helpRegion.yPosition = this.field_147009_r + 164;
        this.helpRegion.parentWidth = this.field_146294_l;
        this.helpRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.helpRegion);
    }

    private void addElectricInfoRegion() {
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.tile.getEnergyStoredGC()) + " / " + (int)Math.floor(this.tile.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 32;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 165;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 9, (this.field_146295_m - this.field_147000_g) / 2 + 26, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElectricInfoRegion();
        this.addHelpRegion();
        this.addResearchedRegion();
        this.initButtons();
    }

    private int scale(double value, double maxValue) {
        return (int)(maxValue / 100.0 * value);
    }

    private void renderProgressBar() {
        int progress = this.tile.getObservationProgress();
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 150, 0, 249, Math.min(this.scale(progress, 159.0), 159), 7);
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"gui.telescope"), 60, 10, 0x404040);
        this.btnMultiplier.field_146126_j = String.valueOf(this.tile.movementAmplifier);
        String statusLine = I18n.func_135052_a((String)"gui.telescope.status.idle", (Object[])new Object[0]);
        if (!this.tile.curObserveBody.isEmpty()) {
            String planet = "";
            if (this.tile.curObserveBody.toUpperCase().contains("ASTEROID-")) {
                planet = "ASTEROID";
            } else {
                planet = I18n.func_135052_a((String)("planet." + this.tile.curObserveBody), (Object[])new Object[0]);
                if (planet.equals("planet." + this.tile.curObserveBody)) {
                    planet = I18n.func_135052_a((String)("moon." + this.tile.curObserveBody), (Object[])new Object[0]);
                }
            }
            statusLine = I18n.func_135052_a((String)"gui.telescope.status.researching", (Object[])new Object[]{planet});
        }
        if (this.tile.func_145831_w().func_175678_i(this.tile.func_174877_v())) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.telescope.status", (Object[])new Object[]{statusLine}), 8, 141, 0x404040);
            this.field_146289_q.func_78276_b(this.toPercent(this.xAngle() / (float)(1200 - TileTelescope.viewportSize)) + " | " + this.toPercent(this.yAngle() / (float)(1200 - TileTelescope.viewportSize)), 125, 80, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.telescope.sky_blocked", (Object[])new Object[0]), 8, 141, ColorUtil.to32BitColor((int)255, (int)255, (int)0, (int)0));
        }
        this.updateResearchedData();
        this.tickButtons();
    }

    private String toPercent(float v) {
        return String.valueOf((int)(v * 100.0f)) + "%";
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6 + 5, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(this.field_147003_i + 29, this.field_147009_r + 165, 176, 0, 11, 10);
        }
        this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 167, 187, 0, Math.min(this.tile.getScaledElecticalLevel(54), 54), 7);
        if (Minecraft.func_71410_x().field_71441_e.func_72896_J() && Minecraft.func_71410_x().field_71441_e.func_180494_b(this.tile.func_174877_v()).func_76738_d()) {
            return;
        }
        if (this.tile.func_145831_w().func_175678_i(this.tile.func_174877_v())) {
            this.renderStars();
            this.renderPlanets();
        }
        this.field_146297_k.func_110434_K().func_110577_a(overlay);
        this.func_73729_b(var5, var6 + 5, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        this.renderFocusArea();
        this.renderProgressBar();
        if (this.tile.func_145831_w().func_175678_i(this.tile.func_174877_v())) {
            this.renderFastScope();
        }
    }
}

