/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.client.screen;

import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.common.tile.TileTelescope;
import igentuman.galacticresearch.sky.body.Asteroid;
import igentuman.galacticresearch.sky.body.Researchable;
import igentuman.galacticresearch.sky.body.Star;
import java.nio.DoubleBuffer;
import java.util.List;
import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.screen.DrawGameScreen;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GameScreenTelescope
implements IGameScreen {
    private TextureManager renderEngine;
    private float frameA;
    private float frameBx;
    private float frameBy;
    private float centreX;
    private float centreY;
    private float scale;
    private TileTelescope telescope;
    private DoubleBuffer planes;

    public GameScreenTelescope() {
        if (GCCoreUtil.getEffectiveSide().isClient()) {
            this.renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
            this.planes = BufferUtils.createDoubleBuffer((int)256);
        }
    }

    public TileTelescope getTelescope(TileEntityTelemetry telemeter) {
        for (int i = 0; i < 6; ++i) {
            TileEntity te = telemeter.func_145831_w().func_175625_s(telemeter.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)i)));
            if (!(te instanceof TileTelescope)) continue;
            return (TileTelescope)te;
        }
        return null;
    }

    public void setFrameSize(float frameSize) {
        this.frameA = frameSize;
    }

    public void render(int type, float ticks, float scaleX, float scaleY, IScreenManager scr) {
        this.centreX = scaleX / 2.0f;
        this.centreY = scaleY / 2.0f;
        this.frameBx = scaleX - this.frameA;
        this.frameBy = scaleY - this.frameA;
        this.scale = Math.max(scaleX, scaleY) - 0.2f;
        DrawGameScreen screen = (DrawGameScreen)scr;
        this.drawBlackBackground(0.0f);
        this.planeEquation(this.frameA, this.frameA, 0.0f, this.frameA, this.frameBy, 0.0f, this.frameA, this.frameBy, 1.0f);
        GL11.glClipPlane((int)12288, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12288);
        this.planeEquation(this.frameBx, this.frameBy, 0.0f, this.frameBx, this.frameA, 0.0f, this.frameBx, this.frameA, 1.0f);
        GL11.glClipPlane((int)12289, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12289);
        this.planeEquation(this.frameA, this.frameBy, 0.0f, this.frameBx, this.frameBy, 0.0f, this.frameBx, this.frameBy, 1.0f);
        GL11.glClipPlane((int)12290, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12290);
        this.planeEquation(this.frameBx, this.frameA, 0.0f, this.frameA, this.frameA, 0.0f, this.frameA, this.frameA, 1.0f);
        GL11.glClipPlane((int)12291, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12291);
        TileEntityTelemetry telemeter = TileEntityTelemetry.getNearest((TileEntity)screen.driver);
        if (telemeter != null) {
            this.telescope = this.getTelescope(telemeter);
            if (this.telescope != null && this.telescope.getEnergyStoredGC() > 100.0f) {
                WorldProvider wp = scr.getWorldProvider();
                CelestialBody body = null;
                if (wp instanceof IGalacticraftWorldProvider) {
                    body = ((IGalacticraftWorldProvider)wp).getCelestialBody();
                }
                if (body == null) {
                    body = GalacticraftCore.planetOverworld;
                }
                this.drawStars();
                this.drawCelestialBodies(body);
            }
        }
        GL11.glDisable((int)12291);
        GL11.glDisable((int)12290);
        GL11.glDisable((int)12289);
        GL11.glDisable((int)12288);
    }

    private void drawBlackBackground(float greyLevel) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        GL11.glColor4f((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameA, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameA, (double)0.005f).func_181675_d();
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    private void drawStars() {
        Star[] stars = GalacticResearch.skyModel.getStars();
        this.renderEngine.func_110577_a(stars[0].getTexture());
        for (Star star : stars) {
            if (!star.isVisible()) continue;
            float xScaled = ((float)star.getX() - this.telescope.xAngle) / (float)TileTelescope.viewportSize * this.frameBx;
            float yScaled = ((float)star.getY() - this.telescope.yAngle) / (float)TileTelescope.viewportSize * this.frameBy;
            this.drawStar(star, xScaled, yScaled, star.getSize(), star.getColor());
        }
    }

    private void drawStar(Star star, float xPos, float yPos, float relSize, float color) {
        float size = relSize / 200.0f * this.scale;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(xPos + this.frameA), (float)(yPos + this.frameA), (float)0.0f);
        float alpha = 0.7f;
        GL11.glColor4f((float)1.0f, (float)(1.0f - color / 10.0f), (float)(1.0f - color / 20.0f), (float)alpha);
        this.drawTexturedRectCBody(0.0f, 0.0f, size, size);
        GL11.glPopMatrix();
    }

    private void drawCelestialBodies(CelestialBody body) {
        List<Researchable> researchables = GalacticResearch.skyModel.getCurrentSystemBodies(body.getDimensionID());
        for (Researchable res : researchables) {
            if (!this.telescope.isBodyVisible(res, TileTelescope.viewportSize, TileTelescope.viewportSize)) continue;
            float xScaled = ((float)res.getX() - this.telescope.xAngle) / (float)TileTelescope.viewportSize * this.frameBx;
            float yScaled = ((float)res.getY() - this.telescope.yAngle) / (float)TileTelescope.viewportSize * this.frameBy;
            this.drawCelestialBody(res, xScaled, yScaled, res.getSize());
        }
    }

    private void drawTexturedRectCBody(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private void drawCelestialBody(Researchable planet, float xPos, float yPos, float relSize) {
        float size = relSize / 70.0f * this.scale;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(xPos + this.frameA), (float)(yPos + this.frameA), (float)0.0f);
        float alpha = 1.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (planet instanceof Asteroid) {
            this.renderEngine.func_110577_a(new ResourceLocation("galacticresearch", "textures/gui/planets/asteroid.png"));
        } else {
            this.renderEngine.func_110577_a(planet.getTexture());
        }
        this.drawTexturedRectCBody(0.0f, 0.0f, size, size);
        GL11.glPopMatrix();
    }

    private void planeEquation(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        double[] result = new double[]{y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2), z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2), x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2), -(x1 * (y2 * z3 - y3 * z2) + x2 * (y3 * z1 - y1 * z3) + x3 * (y1 * z2 - y2 * z1))};
        this.planes.put(result, 0, 4);
        this.planes.position(0);
    }
}

