/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.capability;

import igentuman.galacticresearch.common.capability.PlayerSpaceData;
import igentuman.galacticresearch.common.capability.SpaceCapabilityHandler;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class SpaceDataProvider
implements ICapabilitySerializable<NBTTagCompound> {
    private final PlayerSpaceData spaceData;
    private EntityPlayerMP owner;

    public SpaceDataProvider(EntityPlayerMP owner) {
        this.owner = owner;
        this.spaceData = (PlayerSpaceData)SpaceCapabilityHandler.PLAYER_SPACE_DATA.getDefaultInstance();
        this.spaceData.setPlayer(new WeakReference<EntityPlayerMP>(this.owner));
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == SpaceCapabilityHandler.PLAYER_SPACE_DATA;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == SpaceCapabilityHandler.PLAYER_SPACE_DATA) {
            return (T)SpaceCapabilityHandler.PLAYER_SPACE_DATA.cast((Object)this.spaceData);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.spaceData.writeNBT(nbt);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.spaceData.readNBT(nbt);
    }
}

