/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.common.tile;

import appeng.core.worlddata.WorldData;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import com.mjr.extraplanets.tileEntities.blocks.TileEntityTier2LandingPad;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import igentuman.galacticresearch.GalacticResearch;
import igentuman.galacticresearch.ModConfig;
import igentuman.galacticresearch.common.block.BlockTelescope;
import igentuman.galacticresearch.common.capability.PlayerSpaceData;
import igentuman.galacticresearch.common.capability.SpaceCapabilityHandler;
import igentuman.galacticresearch.common.entity.EntityMiningRocket;
import igentuman.galacticresearch.common.entity.EntitySatelliteRocket;
import igentuman.galacticresearch.common.entity.IGRAutoRocket;
import igentuman.galacticresearch.common.tile.TileTelescope;
import igentuman.galacticresearch.integration.computer.IComputerIntegration;
import igentuman.galacticresearch.network.GRPacketSimple;
import igentuman.galacticresearch.util.GRSounds;
import igentuman.galacticresearch.util.Util;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.annotations.ForRemoval;
import micdoodle8.mods.galacticraft.annotations.ReplaceWith;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDish;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

public class TileMissionControlStation
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
ILandingPadAttachable,
IComputerIntegration {
    private BlockPos dishPos;
    private int fetchCounter = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int dimension;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int locationCounter = -2;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String locatorCords;
    public int[] locationCords;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String padCords = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String currentLocatable = this.getObjectsToLocate()[0];
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String locatorData = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String currentStation = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String teleDishPos = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String stations = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String missions = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String currentMission = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String missionsData = "";
    public HashMap<String, Integer> missionsDataMap = new HashMap();
    private TileTelescope telescope;
    public Object attachedDock;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int rocketState;
    public int refreshCountdown = 40;
    public List<String> completedMissions = new ArrayList<String>();
    public List<String> failedMissions = new ArrayList<String>();
    private int btnCooldown = 0;
    int playSoundDelay = 0;

    @Override
    public String[] getMethods() {
        return new String[]{"getComponentName", "getMissionsInfo", "selectMission", "activateMission", "missionDuration", "getSpaceStations", "getLocatableObjects", "selectSpaceStation", "selectObjectToLocate", "locateObject", "getLocationData", "setCoordinates"};
    }

    @Override
    public String getComponentName() {
        return "mission_control_station";
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.getComponentName()};
            }
            case 1: {
                return this.getMissionsInfo();
            }
            case 2: {
                return this.selectMission(args);
            }
            case 3: {
                return new Object[]{this.activateMission()};
            }
            case 4: {
                return new Object[]{ModConfig.machines.satellite_mission_duration * 20};
            }
            case 5: {
                return new Object[]{this.getStations()};
            }
            case 6: {
                return new Object[]{this.getObjectsToLocate()};
            }
            case 7: {
                return new Object[]{this.selectStation((String)args[0])};
            }
            case 8: {
                return new Object[]{this.selectLocatable((String)args[0])};
            }
            case 9: {
                return new Object[]{this.locate()};
            }
            case 10: {
                return new Object[]{this.getLocatorDataItems()};
            }
            case 11: {
                return new Object[]{this.setLocationCords((Integer)args[0], (Integer)args[1])};
            }
        }
        throw new NoSuchMethodException();
    }

    public TileMissionControlStation fetchPlayerStations(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return this;
        }
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        Iterator iterator = stats.getSpaceStationDimensionData().keySet().iterator();
        while (iterator.hasNext()) {
            int dim = (Integer)iterator.next();
            if (Arrays.stream(this.getStations()).anyMatch(v -> v.equals(String.valueOf(dim)))) continue;
            if (this.currentStation.isEmpty()) {
                this.currentStation = String.valueOf(dim);
            }
            if (this.stations.isEmpty()) {
                this.stations = String.valueOf(dim);
                continue;
            }
            this.stations = this.stations + ";" + String.valueOf(dim);
        }
        return this;
    }

    public boolean locate() {
        if (this.currentLocatable.isEmpty() || this.currentStation.isEmpty()) {
            return false;
        }
        this.locatorData = "";
        this.locationCounter = ModConfig.locator.location_duration;
        this.func_70296_d();
        return true;
    }

    public int getLocatableObjectId() {
        if (this.currentLocatable.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < this.getObjectsToLocate().length; ++i) {
            if (!this.getObjectsToLocate()[i].equals(this.currentLocatable)) continue;
            return i;
        }
        return 0;
    }

    public void selectLocatable(int id) {
        this.currentLocatable = this.getObjectsToLocate()[id];
    }

    public boolean selectLocatable(String name) {
        List<String> st = Arrays.asList(this.getObjectsToLocate());
        if (st.contains(name)) {
            this.currentLocatable = name;
            return true;
        }
        return false;
    }

    public void selectStation(int id) {
        try {
            this.currentStation = this.getStations()[id];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean selectStation(String name) {
        List<String> st = Arrays.asList(this.getStations());
        if (st.contains(name)) {
            this.currentStation = name;
            return true;
        }
        return false;
    }

    public int getCurStationId() {
        if (this.currentStation.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < this.getStations().length; ++i) {
            if (!this.getStations()[i].equals(this.currentStation)) continue;
            return i;
        }
        return 0;
    }

    public void decodePacketdata(ByteBuf buffer) {
        super.decodePacketdata(buffer);
        try {
            this.locationCords = new int[]{Integer.parseInt(this.locatorCords.split(",")[0]), Integer.parseInt(this.locatorCords.split(",")[1])};
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
    }

    public boolean setLocationCords(Integer x, Integer y) {
        this.locationCords = new int[]{x, y};
        this.locatorCords = x + "," + y;
        this.func_70296_d();
        return true;
    }

    public String getStationName(String dim) {
        if (dim.isEmpty()) {
            return "none";
        }
        return WorldUtil.getDimensionTypeById((int)Integer.parseInt(dim)).func_186065_b();
    }

    public String[] getStations() {
        return this.stations.split(";");
    }

    public String[] getObjectsToLocate() {
        return ModConfig.locator.getLocatableObjects();
    }

    public Object[] getMissionsInfo() {
        return new Object[]{this.missionsDataMap};
    }

    public Object[] selectMission(Object[] args) {
        String name = (String)args[0];
        boolean result = false;
        if (Arrays.asList(this.getMissions()).contains(name)) {
            this.currentMission = name;
            result = true;
        }
        return new Object[]{result};
    }

    public TileMissionControlStation() {
        super("container.mission_control_staion.name");
        this.storage.setMaxExtract(45.0f);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        this.locationCords = new int[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177952_p()};
        this.locatorCords = this.func_174877_v().func_177958_n() + "," + this.func_174877_v().func_177952_p();
    }

    public void serializeLocatorData(List<String> result) {
        this.locatorData = "";
        for (String s : result) {
            if (this.locatorData.isEmpty()) {
                this.locatorData = s;
                continue;
            }
            this.locatorData = this.locatorData + ";" + s;
        }
    }

    public void locateIEDeposits() {
        ArrayList<String> result = new ArrayList<String>();
        World worldIn = WorldUtil.getWorldForDimensionServer((int)Integer.parseInt(this.currentStation));
        for (int r = 0; r < ModConfig.locator.radius / 32; ++r) {
            String line;
            ExcavatorHandler.MineralWorldInfo info;
            for (int x = -r; x <= r; ++x) {
                int z = r / 2;
                info = ExcavatorHandler.getMineralWorldInfo((World)worldIn, (int)((this.getLocatorXCord() + x * 16) / 16), (int)((this.getLocatorZCord() + z * 16) / 16));
                if (info.mineral != null && info.depletion == 0 && !result.contains(line = this.getLocatorXCord() + x * 16 + "," + (this.getLocatorZCord() + z * 16))) {
                    result.add(line);
                }
                info = ExcavatorHandler.getMineralWorldInfo((World)worldIn, (int)((this.getLocatorXCord() + x * 16) / 16), (int)((this.getLocatorZCord() - z * 16) / 16));
                if (info.mineral == null || info.depletion != 0 || result.contains(line = this.getLocatorXCord() + x * 16 + "," + (this.getLocatorZCord() - z * 16))) continue;
                result.add(line);
            }
            for (int z = -r; z <= r; ++z) {
                int x = r / 2;
                info = ExcavatorHandler.getMineralWorldInfo((World)worldIn, (int)((this.getLocatorXCord() + x * 16) / 16), (int)((this.getLocatorZCord() + z * 16) / 16));
                if (info.mineral != null && info.depletion == 0 && !result.contains(line = this.getLocatorXCord() + x * 16 + "," + (this.getLocatorZCord() + z * 16))) {
                    result.add(line);
                }
                info = ExcavatorHandler.getMineralWorldInfo((World)worldIn, (int)((this.getLocatorXCord() - x * 16) / 16), (int)((this.getLocatorZCord() + z * 16) / 16));
                if (info.mineral == null || info.depletion != 0 || result.contains(line = this.getLocatorXCord() - x * 16 + "," + (this.getLocatorZCord() + z * 16))) continue;
                result.add(line);
            }
            if (result.size() <= 4) continue;
            this.serializeLocatorData(result);
            return;
        }
        this.serializeLocatorData(result);
    }

    public void locateVillages() {
        BlockPos m = GalacticResearch.server.func_71218_a(Integer.parseInt(this.currentStation)).func_190528_a("Village", new BlockPos(this.getLocatorXCord(), 0, this.getLocatorZCord()), true);
        if (m != null) {
            this.locatorData = m.func_177958_n() + "," + m.func_177952_p();
        }
    }

    public void locateMansions() {
        BlockPos m = GalacticResearch.server.func_71218_a(Integer.parseInt(this.currentStation)).func_190528_a("Mansion", new BlockPos(this.getLocatorXCord(), 0, this.getLocatorZCord()), true);
        if (m != null) {
            this.locatorData = m.func_177958_n() + "," + m.func_177952_p();
        }
    }

    public void locateMonuments() {
        BlockPos m = GalacticResearch.server.func_71218_a(Integer.parseInt(this.currentStation)).func_190528_a("Monument", new BlockPos(this.getLocatorXCord(), 0, this.getLocatorZCord()), true);
        if (m != null) {
            this.locatorData = m.func_177958_n() + "," + m.func_177952_p();
        }
    }

    public void locateTemples() {
        BlockPos m = GalacticResearch.server.func_71218_a(Integer.parseInt(this.currentStation)).func_190528_a("Temple", new BlockPos(this.getLocatorXCord(), 0, this.getLocatorZCord()), true);
        if (m != null) {
            this.locatorData = m.func_177958_n() + "," + m.func_177952_p();
        }
    }

    public void locateCustom(String name) {
        BlockPos m = GalacticResearch.server.func_71218_a(Integer.parseInt(this.currentStation)).func_190528_a(name, new BlockPos(this.getLocatorXCord(), 0, this.getLocatorZCord()), true);
        if (m != null) {
            this.locatorData = m.func_177958_n() + "," + m.func_177952_p();
        }
    }

    public void locateAE2Meteorites() {
        World worldIn = WorldUtil.getWorldForDimensionServer((int)Integer.parseInt(this.currentStation));
        Collection meteorites = WorldData.instance().spawnData().getNearByMeteorites(worldIn.field_73011_w.getDimension(), this.getLocatorXCord() / 16, this.getLocatorZCord() / 16);
        ArrayList<String> result = new ArrayList<String>();
        for (NBTTagCompound m : meteorites) {
            result.add(m.func_74762_e("x") + "," + m.func_74762_e("z"));
        }
        this.serializeLocatorData(result);
    }

    public void locateBossDungeons() {
        World worldIn = WorldUtil.getWorldForDimensionServer((int)Integer.parseInt(this.currentStation));
        ArrayList<String> result = new ArrayList<String>();
        if (!(worldIn.field_73011_w instanceof IGalacticraftWorldProvider)) {
            return;
        }
        int spacing = ((IGalacticraftWorldProvider)worldIn.field_73011_w).getDungeonSpacing();
        int x = MathHelper.func_76141_d((float)this.getLocatorXCord());
        int z = MathHelper.func_76141_d((float)this.getLocatorXCord());
        int quadrantX = x % spacing;
        int quadrantZ = z % spacing;
        int searchOffsetX = quadrantX / (spacing / 2);
        int searchOffsetZ = quadrantZ / (spacing / 2);
        for (int cx = searchOffsetX - 1; cx < searchOffsetX + 1; ++cx) {
            for (int cz = searchOffsetZ - 1; cz < searchOffsetZ + 1; ++cz) {
                long dungeonPos = MapGenDungeon.getDungeonPosForCoords((World)worldIn, (int)((x + cx * spacing) / 16), (int)((z + cz * spacing) / 16), (int)spacing);
                int i = 2 + ((int)(dungeonPos >> 32) << 4);
                int j = 2 + ((int)dungeonPos << 4);
                double oX = (double)i - (double)this.getLocatorXCord();
                double oZ = (double)j - (double)this.getLocatorXCord();
                result.add(oX + "," + oZ);
                if (result.size() <= 5) continue;
                this.serializeLocatorData(result);
                return;
            }
        }
        this.serializeLocatorData(result);
    }

    public void doLocate() {
        if (this.locationCounter > 0) {
            --this.locationCounter;
            return;
        }
        if (this.locationCounter == -2) {
            return;
        }
        this.locationCounter = -2;
        if (this.currentStation.isEmpty()) {
            return;
        }
        switch (this.currentLocatable) {
            case "ie_deposit": {
                this.locateIEDeposits();
                break;
            }
            case "village": {
                this.locateVillages();
                break;
            }
            case "mansion": {
                this.locateMansions();
                break;
            }
            case "temple": {
                this.locateTemples();
                break;
            }
            case "monument": {
                this.locateMonuments();
                break;
            }
            case "ae2_meteorite": {
                this.locateAE2Meteorites();
                break;
            }
            case "boss_dungeon": {
                this.locateBossDungeons();
                break;
            }
            default: {
                this.locateCustom(this.currentLocatable);
            }
        }
    }

    public String[] getLocatorDataItems() {
        ArrayList<String> items = new ArrayList<String>();
        for (String line : this.locatorData.split(";")) {
            String[] pairs = line.split(",");
            if (pairs[0].isEmpty()) continue;
            items.add("X: " + Float.valueOf(pairs[0]).intValue() + ", Z: " + Float.valueOf(pairs[1]).intValue());
        }
        if (items.size() == 0) {
            items.add(" ");
        }
        return (String[])items.stream().toArray(String[]::new);
    }

    public void playerAnalyzeData(EntityPlayer player) {
        try {
            EntityPlayerMP playerBaseClient = PlayerUtil.getPlayerBaseServerFromPlayerUsername((String)player.func_70005_c_(), (boolean)true);
            PlayerSpaceData cap = (PlayerSpaceData)playerBaseClient.getCapability(SpaceCapabilityHandler.PLAYER_SPACE_DATA, null);
            if (cap == null) {
                GalacticResearch.instance.logger.log(Level.WARN, "Analyze missions capability error");
                return;
            }
            for (String mission : this.getMissions()) {
                if (!this.isMissionComplete(mission)) continue;
                this.setMissionToPlayer(mission.toLowerCase(), player, cap);
                CelestialBody p = (CelestialBody)GalaxyRegistry.getRegisteredPlanets().get(mission);
                if (p == null) {
                    p = (CelestialBody)GalaxyRegistry.getRegisteredPlanets().get(mission.toLowerCase());
                }
                if (!(p instanceof Planet) || !ModConfig.researchSystem.research_moons_with_parent_planet) continue;
                for (Moon m : GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)p))) {
                    this.setMissionToPlayer(m.getName().toLowerCase(), player, cap);
                    GalacticResearch.instance.logger.info(m.getName().toLowerCase());
                }
            }
            GalacticResearch.packetPipeline.sendTo((IPacket)new GRPacketSimple(GRPacketSimple.EnumSimplePacket.SYNC_PLAYER_SPACE_DATA, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[]{cap.unlocked_missions}), (EntityPlayerMP)player);
        }
        catch (NullPointerException e) {
            GalacticResearch.instance.logger.log(Level.ERROR, "Analyze missions capability error");
        }
    }

    private void setMissionToPlayer(String mission, EntityPlayer player, PlayerSpaceData cap) {
        if (!cap.getUnlockedMissions().contains(mission)) {
            cap.addMission(mission);
            player.func_71023_q(10);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.analyzed.planet", new Object[]{mission}));
        }
    }

    public boolean isMissionComplete(String name) {
        return this.getMissionInfo(name) >= ModConfig.machines.satellite_mission_duration * 20;
    }

    public void fetchMissions() {
        TileTelescope te = this.getTelescope();
        if (te == null) {
            return;
        }
        for (String body : te.getResearchedBodiesArray()) {
            if (this.missions.contains(body)) continue;
            this.missions = this.missions.length() < 1 ? this.missions + body : this.missions + "," + body;
        }
        for (String m : this.getMissions()) {
            if (this.missionsDataMap.containsKey(m)) continue;
            this.missionsDataMap.put(m, -1);
        }
        this.serializeMissionData();
    }

    public void addResearchedMission(String name) {
        if (!this.missionsDataMap.containsKey(name)) {
            this.missionsDataMap.put(name, 0);
        }
        this.missionsDataMap.replace(name, ModConfig.machines.satellite_mission_duration * 20);
        if (!this.missions.contains(name)) {
            this.missions = this.missions.length() < 1 ? this.missions + name : this.missions + "," + name;
        }
        this.serializeMissionData();
    }

    public boolean func_180461_b(int slotID, @NotNull ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, @NotNull ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public int getLocatorXCord() {
        if (this.locationCords == null || this.locationCords.length == 0) {
            return this.func_174877_v().func_177958_n();
        }
        return this.locationCords[0];
    }

    public int getLocatorZCord() {
        if (this.locationCords == null || this.locationCords.length == 0) {
            return this.func_174877_v().func_177952_p();
        }
        return this.locationCords[1];
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public boolean connectToPad(TileEntityMulti te) {
        TileEntity main = this.field_145850_b.func_175625_s(te.mainBlockPosition);
        if (main instanceof TileEntityLandingPad) {
            ((TileEntityLandingPad)main).getConnectedTiles();
            if (this.attachedDock == null) {
                this.setAttachedPad((IFuelDock)main);
            }
            return true;
        }
        if (GalacticResearch.hooks.GalaxySpaceLoaded && main instanceof TileEntityAdvLandingPad) {
            ((TileEntityAdvLandingPad)main).getConnectedTiles();
            if (this.attachedDock == null) {
                this.setAttachedPad((IFuelDock)main);
            }
            return true;
        }
        if (GalacticResearch.hooks.ExtraPlanetsLoaded && main instanceof TileEntityTier2LandingPad) {
            ((TileEntityTier2LandingPad)main).getConnectedTiles();
            if (this.attachedDock == null) {
                this.setAttachedPad((IFuelDock)main);
            }
            return true;
        }
        return false;
    }

    public void updatePadConnection() {
        boolean tmpConnection;
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177964_d(1));
        if (te instanceof TileEntityMulti && (tmpConnection = this.connectToPad((TileEntityMulti)te))) {
            return;
        }
        te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177970_e(1));
        if (te instanceof TileEntityMulti && (tmpConnection = this.connectToPad((TileEntityMulti)te))) {
            return;
        }
        te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177985_f(1));
        if (te instanceof TileEntityMulti && (tmpConnection = this.connectToPad((TileEntityMulti)te))) {
            return;
        }
        te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177965_g(1));
        if (te instanceof TileEntityMulti && (tmpConnection = this.connectToPad((TileEntityMulti)te))) {
            return;
        }
        this.attachedDock = null;
    }

    public boolean hasTeleDish() {
        if (this.dishPos == null) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.dishPos);
        return te instanceof TileEntityDish;
    }

    public void fetchSolarSystems() {
        if (!this.hasTeleDish()) {
            return;
        }
        ++this.fetchCounter;
        if (this.fetchCounter > 200) {
            this.fetchCounter = 0;
            int lim = Math.min(4, GalacticResearch.skyModel.getCurrentSystemBodies(GCCoreUtil.getDimensionID((World)this.field_145850_b)).size() / 2);
            if (this.missionsDataMap.size() < lim) {
                return;
            }
            Random r = new Random(this.ticks);
            for (SolarSystem sys : GalaxyRegistry.getRegisteredSolarSystems().values()) {
                if (this.missionsDataMap.containsKey(sys.getName()) || r.nextInt(100) >= 5) continue;
                this.missions = this.missions + "," + sys.getName();
                this.missionsDataMap.put(sys.getName(), -1);
                this.serializeMissionData();
            }
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.refreshCountdown > 0) {
            --this.refreshCountdown;
        } else {
            this.refreshCountdown = 40;
            this.updatePadConnection();
        }
        if (!this.func_145831_w().field_72995_K) {
            if (this.btnCooldown > 0) {
                --this.btnCooldown;
            }
            if (this.getEnergyStoredGC() < 100.0f) {
                return;
            }
            if (this.locationCords == null) {
                this.locationCords = new int[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177952_p()};
            }
            this.doLocate();
            this.fetchMissions();
            this.fetchSolarSystems();
            this.updateRocketState();
            this.removeAsteroidMissions(true);
            this.updateMissionsStateCounter();
        } else {
            this.unserializeMissionData();
            this.getLocatorProgress();
            this.handleMissionsOnClient();
        }
    }

    public void handleMissionsOnClient() {
        if (this.playSoundDelay <= 0) {
            List<String> tmpFailed;
            List<String> tmpCompleted = this.completedMissions();
            if (!this.completedMissions.equals(tmpCompleted) && tmpCompleted.size() >= this.completedMissions.size()) {
                this.completedMissions = tmpCompleted;
                this.playMissionComplete(1.0f);
                return;
            }
            if (tmpCompleted.size() < this.completedMissions.size()) {
                this.completedMissions = tmpCompleted;
            }
            if (!this.failedMissions.equals(tmpFailed = this.completedMissions()) && tmpFailed.size() >= this.failedMissions.size()) {
                this.failedMissions = tmpFailed;
                this.playMissionFailed(1.0f);
            } else if (tmpFailed.size() < this.failedMissions.size()) {
                this.failedMissions = tmpFailed;
            }
        }
    }

    public List<String> completedMissions() {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String mission : this.missionsDataMap.keySet()) {
            if (!this.isMissionComplete(mission)) continue;
            tmp.add(mission);
        }
        return tmp;
    }

    public List<String> failedMissions() {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String mission : this.missionsDataMap.keySet()) {
            if (this.getMissionInfo(mission) != -3) continue;
            tmp.add(mission);
        }
        return tmp;
    }

    public void removeAsteroidMissions(boolean check) {
        for (String m : this.getMissions()) {
            if (!m.toUpperCase().contains("ASTEROID-")) continue;
            if (check) {
                if (GalacticResearch.spaceMineProvider.getMissions().containsKey(m)) continue;
                this.missionsDataMap.remove(m);
                if (!this.currentMission.equals(m)) continue;
                this.currentMission = "";
                continue;
            }
            this.missionsDataMap.remove(m);
            if (!this.currentMission.equals(m)) continue;
            this.currentMission = "";
        }
    }

    public void updateMissionsStateCounter() {
        int duration = ModConfig.machines.satellite_mission_duration * 20;
        if (this.missionsDataMap.isEmpty()) {
            return;
        }
        Set<String> tmp = this.missionsDataMap.keySet();
        for (String s : tmp) {
            try {
                int v = this.missionsDataMap.get(s);
                if (s.toUpperCase().contains("ASTEROID-")) {
                    if (v == -3) continue;
                    if (GalacticResearch.spaceMineProvider.getMissions().size() == 0) {
                        this.removeAsteroidMissions(false);
                        return;
                    }
                    try {
                        double left = GalacticResearch.spaceMineProvider.getMissions().get(s).intValue();
                        double initial = GalacticResearch.spaceMineProvider.getOreCnt(s);
                        double p = left / initial;
                        v = left <= 0.0 ? duration : (int)((double)duration - (double)duration * p) - 1;
                        this.missionsDataMap.replace(s, v);
                    }
                    catch (NullPointerException nullPointerException) {}
                    continue;
                }
                if (v <= 0 || v >= duration) continue;
                this.missionsDataMap.replace(s, ++v);
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.serializeMissionData();
    }

    public boolean activateMission() {
        if (this.currentMission.isEmpty() || this.rocketState != 1 || !this.missionsDataMap.containsKey(this.currentMission)) {
            return false;
        }
        IGRAutoRocket r = this.getRocket();
        if (r == null) {
            return false;
        }
        if (r instanceof IGRAutoRocket) {
            r.setMission(this.currentMission);
        }
        r.setAutolaunchSetting(EntityAutoRocket.EnumAutoLaunch.INSTANT);
        r.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.IGNITED);
        if (this.missionsDataMap.get(this.currentMission) < 0) {
            this.setMissionInfo(this.currentMission, 0);
        }
        return true;
    }

    public int getMissonPercent(String name) {
        int i = this.getMissionInfo(name);
        return (int)((double)i / (double)(ModConfig.machines.satellite_mission_duration * 20) * 100.0);
    }

    public void updateRocketState() {
        EntityAutoRocket r = (EntityAutoRocket)this.getRocket();
        if (r == null || !(r instanceof IGRAutoRocket)) {
            this.rocketState = -1;
            return;
        }
        this.rocketState = r.fuelTank.getFluidAmount() >= r.fuelTank.getCapacity() / 2 ? 1 : 0;
        if (this.currentMission.toUpperCase().contains("ASTEROID-") && !(r instanceof EntityMiningRocket)) {
            this.rocketState = -2;
        }
        if (!this.currentMission.toUpperCase().contains("ASTEROID-") && !(r instanceof EntitySatelliteRocket)) {
            this.rocketState = -2;
        }
    }

    public TileTelescope getTelescope() {
        if (this.telescope == null) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTelescope.field_185512_D)).func_176746_e()));
            if (te != null && te instanceof TileTelescope) {
                this.telescope = (TileTelescope)te;
                return this.telescope;
            }
            te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTelescope.field_185512_D)).func_176746_e().func_176734_d()));
            if (te != null && te instanceof TileTelescope) {
                this.telescope = (TileTelescope)te;
                return this.telescope;
            }
        }
        return this.telescope;
    }

    public void nextMission() {
        if (this.btnCooldown > 0) {
            return;
        }
        this.btnCooldown = 10;
        String[] tmp = this.getMissions();
        boolean f = false;
        for (String m : tmp) {
            if (this.currentMission.isEmpty() || f) {
                this.currentMission = m;
                return;
            }
            if (!this.currentMission.equals(m)) continue;
            f = true;
        }
    }

    public void prevMission() {
        if (this.btnCooldown > 0) {
            return;
        }
        this.btnCooldown = 10;
        String[] tmp = this.getMissions();
        int i = 0;
        for (String m : tmp) {
            if (this.currentMission.isEmpty()) {
                this.currentMission = m;
            }
            if (this.currentMission.equals(m)) {
                try {
                    this.currentMission = tmp[i - 1];
                    return;
                }
                catch (Exception e) {
                    this.currentMission = "";
                    return;
                }
            }
            ++i;
        }
    }

    public String[] getMissions() {
        return (String[])Arrays.stream(this.missions.split(",")).filter(val -> !val.isEmpty()).toArray(String[]::new);
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public int[] func_180463_a(@NotNull EnumFacing side) {
        return new int[]{0};
    }

    public EnumFacing getElectricInputDirection() {
        return ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTelescope.field_185512_D)).func_176734_d();
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction != null && type == NetworkType.POWER) {
            return this.getElectricalInputDirections().contains(direction);
        }
        return false;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        EnumFacing facing = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockTelescope.field_185512_D);
        return EnumSet.of(facing.func_176746_e(), facing.func_176735_f());
    }

    public void serializeMissionData() {
        this.missionsData = Util.serializeMap(this.missionsDataMap);
        this.func_70296_d();
    }

    public void setMissionInfo(String name, int v) {
        if (this.missionsDataMap.containsKey(name)) {
            this.missionsDataMap.replace(name, v);
        } else {
            this.missionsDataMap.put(name, v);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.serializeMissionData();
        }
    }

    public int getMissionInfo(String name) {
        if (this.missionsDataMap.containsKey(name)) {
            return this.missionsDataMap.get(name);
        }
        return -1;
    }

    public String getMissionStatusKey(String name) {
        int state = this.getMissionInfo(name);
        if (state >= ModConfig.machines.satellite_mission_duration * 20) {
            return "gui.mission.complete";
        }
        if (state == -1) {
            return "gui.mission.pending";
        }
        if (state == -3) {
            return "gui.mission.fail";
        }
        return "gui.mission.progress";
    }

    @SideOnly(value=Side.CLIENT)
    public void playMissionComplete(float volume) {
        this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), GRSounds.mcs_mission_complete, SoundCategory.BLOCKS, volume, 1.0f, false);
        this.playSoundDelay = 40;
    }

    @SideOnly(value=Side.CLIENT)
    public void playMissionFailed(float volume) {
        this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), GRSounds.mcs_mission_fail, SoundCategory.BLOCKS, volume, 1.0f, false);
        this.playSoundDelay = 40;
    }

    public int getLocatorProgress() {
        if (this.playSoundDelay > 0) {
            --this.playSoundDelay;
        }
        if (this.locationCounter == -2) {
            return 0;
        }
        int progress = (int)((float)(ModConfig.locator.location_duration - this.locationCounter) / (float)ModConfig.locator.location_duration * 100.0f);
        if (this.field_145850_b.field_72995_K && progress >= 99 && this.playSoundDelay <= 0) {
            this.playMissionComplete(0.5f);
        }
        return progress;
    }

    public void unserializeMissionData() {
        this.missionsDataMap = Util.unserializeMap(this.missionsData);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentLocatable = nbt.func_74779_i("currentLocatable");
        this.currentStation = nbt.func_74779_i("currentStation");
        this.locatorData = nbt.func_74779_i("locatorData");
        this.dimension = nbt.func_74762_e("dimension");
        this.locationCounter = nbt.func_74762_e("locationCounter");
        this.locationCords = nbt.func_74759_k("locationCords");
        this.padCords = nbt.func_74779_i("padCords");
        this.currentMission = nbt.func_74779_i("currentMission");
        this.missions = nbt.func_74779_i("missions");
        this.stations = nbt.func_74779_i("stations");
        this.missionsData = nbt.func_74779_i("missionsData");
        this.teleDishPos = nbt.func_74779_i("teleDishPos");
        String[] parts = this.teleDishPos.split(",");
        if (parts.length == 3) {
            this.dishPos = new BlockPos(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        this.unserializeMissionData();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.serializeMissionData();
        nbt.func_74778_a("currentLocatable", this.currentLocatable);
        nbt.func_74778_a("currentStation", this.currentStation);
        nbt.func_74778_a("locatorData", this.locatorData);
        nbt.func_74778_a("stations", this.stations);
        nbt.func_74768_a("dimension", this.dimension);
        nbt.func_74768_a("locationCounter", this.locationCounter);
        nbt.func_74783_a("locationCords", this.locationCords);
        nbt.func_74778_a("padCords", this.padCords);
        nbt.func_74778_a("currentMission", this.currentMission);
        nbt.func_74778_a("missions", this.missions);
        nbt.func_74778_a("missionsData", this.missionsData);
        nbt.func_74778_a("teleDishPos", this.teleDishPos);
        return nbt;
    }

    @Deprecated
    @ForRemoval(deadline="4.1.0")
    @ReplaceWith(value="byIndex()")
    public EnumFacing getFront() {
        return this.byIndex();
    }

    public boolean canAttachToLandingPad(IBlockAccess iBlockAccess, BlockPos blockPos) {
        boolean flag;
        TileEntity tile = this.field_145850_b.func_175625_s(blockPos);
        boolean bl = flag = tile instanceof TileEntityLandingPad || TileMissionControlStation.isGSPadTile(tile) || TileMissionControlStation.isEPPadTile(tile);
        if (flag) {
            this.setAttachedPad((IFuelDock)tile);
        }
        return flag;
    }

    public BlockPos getPadCords() {
        if (this.padCords.isEmpty()) {
            return new BlockPos(0, 0, 0);
        }
        String[] cords = this.padCords.split(",");
        return new BlockPos(Integer.parseInt(cords[0]), Integer.parseInt(cords[1]), Integer.parseInt(cords[2]));
    }

    public void setAttachedPad(IFuelDock pad) {
        this.attachedDock = pad;
        BlockPos bp = ((TileEntity)this.attachedDock).func_174877_v();
        this.padCords = bp.func_177958_n() + "," + bp.func_177956_o() + "," + bp.func_177952_p();
    }

    private static boolean isGSPadTile(TileEntity tile) {
        boolean result = false;
        if (GalacticResearch.hooks.GalaxySpaceLoaded) {
            result = tile instanceof TileEntityAdvLandingPad;
        }
        return result;
    }

    private static boolean isEPPadTile(TileEntity tile) {
        boolean result = false;
        if (GalacticResearch.hooks.ExtraPlanetsLoaded) {
            result = tile instanceof TileEntityTier2LandingPad;
        }
        return result;
    }

    public IGRAutoRocket getRocket() {
        TileEntity dock;
        if (this.attachedDock instanceof TileEntityLandingPad) {
            TileEntityLandingPad pad = (TileEntityLandingPad)this.attachedDock;
            IDockable rocket = pad.getDockedEntity();
            if (rocket instanceof IGRAutoRocket) {
                return (IGRAutoRocket)rocket;
            }
        } else if (TileMissionControlStation.isGSPadTile((TileEntity)this.attachedDock)) {
            TileEntityAdvLandingPad pad = (TileEntityAdvLandingPad)this.attachedDock;
            IDockable rocket = pad.getDockedEntity();
            if (rocket instanceof IGRAutoRocket) {
                return (IGRAutoRocket)rocket;
            }
        } else if (TileMissionControlStation.isEPPadTile((TileEntity)this.attachedDock)) {
            TileEntityTier2LandingPad pad = (TileEntityTier2LandingPad)this.attachedDock;
            IDockable rocket = pad.getDockedEntity();
            if (rocket instanceof IGRAutoRocket) {
                return (IGRAutoRocket)rocket;
            }
        } else if (!this.padCords.isEmpty() && (dock = this.field_145850_b.func_175625_s(this.getPadCords())) instanceof TileEntityLandingPad) {
            this.setAttachedPad((IFuelDock)dock);
            return this.getRocket();
        }
        return null;
    }

    public void bindTeleDish(int[] teledishPos) {
        this.teleDishPos = teledishPos[0] + "," + teledishPos[1] + "," + teledishPos[2];
        this.dishPos = new BlockPos(teledishPos[0], teledishPos[1], teledishPos[2]);
    }
}

