/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.handler;

import igentuman.galacticresearch.ModConfig;
import java.util.ArrayList;
import java.util.Collections;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GRPlayerHandler {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            this.onPlayerLogin((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        GCPlayerStats oldStats = GCPlayerStats.get((Entity)event.getOriginal());
        GCPlayerStats newStats = GCPlayerStats.get((Entity)event.getEntityPlayer());
        newStats.copyFrom(oldStats, !event.isWasDeath() || event.getOriginal().field_70170_p.func_82736_K().func_82766_b("keepInventory"));
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayerMP) && event.getObject() instanceof EntityPlayer && ((EntityPlayer)event.getObject()).field_70170_p.field_72995_K) {
            this.onAttachCapabilityClient(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onAttachCapabilityClient(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerSP) {
            // empty if block
        }
    }

    private void onPlayerLogin(EntityPlayerMP player) {
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_GET_CELESTIAL_BODY_LIST, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[0]), player);
        int repeatCount = stats.getBuildFlags() >> 9;
        if (repeatCount < 3) {
            stats.setBuildFlags(stats.getBuildFlags() & 0x600);
        }
        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATS, GCCoreUtil.getDimensionID((World)player.field_70170_p), stats.getMiscNetworkedStats()), player);
        ColorUtil.sendUpdatedColorsToPlayer((GCPlayerStats)stats);
    }

    protected void updateSchematics(EntityPlayerMP player, GCPlayerStats stats) {
        SchematicRegistry.addUnlockedPage((EntityPlayerMP)player, (ISchematicPage)SchematicRegistry.getMatchingRecipeForID((int)ModConfig.machines.satellite_rocket_schematic_id));
        Collections.sort(stats.getUnlockedSchematics());
        if (player.field_71135_a != null && (stats.getUnlockedSchematics().size() != stats.getLastUnlockedSchematics().size() || (player.field_70173_aa - 1) % 100 == 0)) {
            Integer[] iArray = new Integer[stats.getUnlockedSchematics().size()];
            for (int i = 0; i < iArray.length; ++i) {
                ISchematicPage page = (ISchematicPage)stats.getUnlockedSchematics().get(i);
                iArray[i] = page == null ? -2 : page.getPageID();
            }
            ArrayList<Integer[]> objList = new ArrayList<Integer[]>();
            objList.add(iArray);
            GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SCHEMATIC_LIST, GCCoreUtil.getDimensionID((World)player.field_70170_p), objList), player);
        }
    }

    public void onPlayerUpdate(EntityPlayerMP player) {
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        this.updateSchematics(player, stats);
    }
}

