/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.network;

import igentuman.galacticresearch.network.GRPacketHandler;
import igentuman.galacticresearch.network.GRPacketSimple;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.EnumMap;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class GRChannelHandler
extends FMLIndexedMessageToMessageCodec<IPacket> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;

    private GRChannelHandler() {
        this.addDiscriminator(0, GRPacketSimple.class);
    }

    public static GRChannelHandler init() {
        GRChannelHandler channelHandler = new GRChannelHandler();
        channelHandler.channels = NetworkRegistry.INSTANCE.newChannel("galacticresearch1", new ChannelHandler[]{channelHandler, new GRPacketHandler()});
        return channelHandler;
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket msg, ByteBuf target) throws Exception {
        msg.encodeInto(target);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket msg) {
        try {
            msg.decodeInto(source);
        }
        catch (IndexOutOfBoundsException var5) {
            GalacticraftCore.logger.error("Incomplete Galacticraft entity packet: dimension " + msg.getDimensionID(), new Object[0]);
        }
    }

    public void sendToAll(IMessage message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToAll(IPacket message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendTo(IPacket message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToAllAround(IPacket message, NetworkRegistry.TargetPoint point) {
        try {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
        catch (Exception var4) {
            GalacticraftCore.logger.error("Forge error when sending network packet to nearby players - this is not a Galacticraft bug, does another mod make fake players?", new Object[0]);
            var4.printStackTrace();
        }
    }

    public void sendToDimension(IPacket message, int dimensionID) {
        try {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionID);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
        catch (Exception var4) {
            GalacticraftCore.logger.error("Forge error when sending network packet to all players in dimension - this is not a Galacticraft bug, does another mod make fake players?", new Object[0]);
            var4.printStackTrace();
        }
    }

    public void sendToServer(IPacket message) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            this.channels.get(Side.CLIENT).writeOutbound(new Object[]{message});
        }
    }
}

