/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.sky.body;

import igentuman.galacticresearch.sky.SkyModel;
import igentuman.galacticresearch.sky.body.Researchable;
import igentuman.galacticresearch.util.WorldUtil;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import net.minecraft.util.ResourceLocation;

public class Asteroid
extends Researchable {
    @Override
    public boolean isVerticalReversed() {
        Random r = new Random(SkyModel.get().seed + (long)this.nameToSeed() + (long)this.rarity + (long)WorldUtil.getDay());
        return r.nextInt(10) < 3;
    }

    @Override
    public boolean isHorizontalReversed() {
        Random r = new Random(SkyModel.get().seed + (long)this.nameToSeed() + (long)this.rarity + (long)WorldUtil.getDay() + 100L);
        return r.nextInt(10) < 4;
    }

    @Override
    public float getSize() {
        return 16.0f;
    }

    private int nameToSeed() {
        return Math.abs(this.body.getName().hashCode());
    }

    private int initialX() {
        long seed = SkyModel.get().seed + (long)this.nameToSeed();
        return new Random(seed).nextInt(SkyModel.width);
    }

    private int initialY() {
        long seed = (SkyModel.get().seed + (long)this.nameToSeed()) / 2L;
        return new Random(seed).nextInt(SkyModel.height);
    }

    public Asteroid(String name) {
        super(new Planet(name).setRelativeSize(1.0f).setRelativeOrbitTime(20.0f));
        this.x = this.initialX();
        this.y = this.initialY();
    }

    @Override
    public boolean isVisible() {
        Random r = new Random(SkyModel.get().seed / 20L + (long)(this.nameToSeed() / 100) + (long)this.rarity + (long)WorldUtil.getDay());
        return r.nextInt((int)(10.0 / (1.0 / (double)this.rarity))) < this.rarity * 500;
    }

    @Override
    public int speed() {
        if (this.speed == 0) {
            Random r = new Random(SkyModel.get().seed / 20L + (long)(this.nameToSeed() / 50) + (long)this.rarity);
            this.speed = r.nextInt(20);
        }
        return Math.max(5, this.speed);
    }

    @Override
    public int getX() {
        int sx = (int)((long)this.x + this.time() / (long)this.speed());
        int cx = sx / SkyModel.width;
        if (this.isHorizontalReversed()) {
            return SkyModel.width - (sx - cx * SkyModel.width);
        }
        return sx - cx * SkyModel.width;
    }

    @Override
    public int getY() {
        int sy = (int)((long)this.y + this.time() / (long)this.speed());
        int cy = sy / SkyModel.height;
        if (this.isVerticalReversed()) {
            return SkyModel.height - (sy - cy * SkyModel.height);
        }
        return sy - cy * SkyModel.height;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("galacticresearch", "textures/gui/planets/minable_asteroids.png");
    }

    @Override
    public int yTexOffset() {
        Random r = new Random(this.body.getName().hashCode());
        int i = r.nextInt(6);
        return i * 16 + i;
    }
}

