/*
 * Decompiled with CFR 0.152.
 */
package igentuman.galacticresearch.sky.body;

import igentuman.galacticresearch.sky.SkyModel;
import igentuman.galacticresearch.sky.body.ISkyBody;
import igentuman.galacticresearch.util.WorldUtil;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class Star
implements ISkyBody {
    private int x;
    private int y;
    private int size;
    private int color;
    private static Random rand;
    private double s = 0.05;
    private int speed = 8;

    public static Star generate() {
        if (rand == null) {
            rand = new Random(SkyModel.get().seed);
        }
        return new Star(rand.nextInt(SkyModel.width), rand.nextInt(SkyModel.height), rand.nextInt(3) + 1, rand.nextInt(3) + 1);
    }

    public Star(int x, int y, int size, int color) {
        this.x = x;
        this.y = y;
        this.size = size;
        this.color = color;
    }

    public float guiX(long lastTime, float ticks) {
        float sx = (float)this.x + (float)this.time() / (float)this.speed;
        int cx = (int)(sx / (float)SkyModel.width);
        float xc = sx - (float)(cx * SkyModel.width);
        sx = (float)this.x + (float)lastTime / (float)this.speed;
        cx = (int)(sx / (float)SkyModel.width);
        float xl = sx - (float)(cx * SkyModel.width);
        return xl + (xc - xl) * ticks;
    }

    public float guiY(long lastTime, float ticks) {
        float sy = (float)this.y + (float)this.time() / (float)this.speed;
        int cy = (int)(sy / (float)SkyModel.height);
        float yc = sy - (float)(cy * SkyModel.height);
        sy = (float)this.y + (float)lastTime / (float)this.speed;
        cy = (int)(sy / (float)SkyModel.height);
        float yl = sy - (float)(cy * SkyModel.height);
        return yl + (yc - yl) * ticks;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public long time() {
        return WorldUtil.getClientDayTime();
    }

    @Override
    public int getX() {
        int w = (int)(((double)this.x + (double)this.time() * this.s) / (double)SkyModel.width);
        return (int)((double)this.x + (double)this.time() * this.s - (double)(w * SkyModel.width));
    }

    @Override
    public int getY() {
        double m = 0.5;
        if (Minecraft.func_71410_x().field_71441_e.func_72935_r()) {
            m = 1.0;
        }
        int w = (int)(((double)this.y + (double)this.time() * this.s * m) / (double)SkyModel.height);
        return (int)((double)this.y + (double)this.time() * this.s * m - (double)(w * SkyModel.height));
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("galacticresearch", "textures/gui/planets/star.png");
    }
}

