/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.repack.org.msgpack.value;

import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableArrayValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableBinaryValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableBooleanValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableExtensionValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableFloatValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableIntegerValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableMapValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableNilValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableStringValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.MapValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.Value;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableArrayValueImpl;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableBigIntegerValueImpl;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableBinaryValueImpl;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableBooleanValueImpl;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableDoubleValueImpl;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableExtensionValueImpl;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableLongValueImpl;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableMapValueImpl;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableNilValueImpl;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableStringValueImpl;

public final class ValueFactory {
    private ValueFactory() {
    }

    public static ImmutableNilValue newNil() {
        return ImmutableNilValueImpl.get();
    }

    public static ImmutableBooleanValue newBoolean(boolean v) {
        return v ? ImmutableBooleanValueImpl.TRUE : ImmutableBooleanValueImpl.FALSE;
    }

    public static ImmutableIntegerValue newInteger(byte v) {
        return new ImmutableLongValueImpl(v);
    }

    public static ImmutableIntegerValue newInteger(short v) {
        return new ImmutableLongValueImpl(v);
    }

    public static ImmutableIntegerValue newInteger(int v) {
        return new ImmutableLongValueImpl(v);
    }

    public static ImmutableIntegerValue newInteger(long v) {
        return new ImmutableLongValueImpl(v);
    }

    public static ImmutableIntegerValue newInteger(BigInteger v) {
        return new ImmutableBigIntegerValueImpl(v);
    }

    public static ImmutableFloatValue newFloat(float v) {
        return new ImmutableDoubleValueImpl(v);
    }

    public static ImmutableFloatValue newFloat(double v) {
        return new ImmutableDoubleValueImpl(v);
    }

    public static ImmutableBinaryValue newBinary(byte[] b) {
        return ValueFactory.newBinary(b, false);
    }

    public static ImmutableBinaryValue newBinary(byte[] b, boolean omitCopy) {
        if (omitCopy) {
            return new ImmutableBinaryValueImpl(b);
        }
        return new ImmutableBinaryValueImpl(Arrays.copyOf(b, b.length));
    }

    public static ImmutableBinaryValue newBinary(byte[] b, int off, int len) {
        return ValueFactory.newBinary(b, off, len, false);
    }

    public static ImmutableBinaryValue newBinary(byte[] b, int off, int len, boolean omitCopy) {
        if (omitCopy && off == 0 && len == b.length) {
            return new ImmutableBinaryValueImpl(b);
        }
        return new ImmutableBinaryValueImpl(Arrays.copyOfRange(b, off, len));
    }

    public static ImmutableStringValue newString(String s) {
        return new ImmutableStringValueImpl(s);
    }

    public static ImmutableStringValue newString(byte[] b) {
        return new ImmutableStringValueImpl(b);
    }

    public static ImmutableStringValue newString(byte[] b, boolean omitCopy) {
        if (omitCopy) {
            return new ImmutableStringValueImpl(b);
        }
        return new ImmutableStringValueImpl(Arrays.copyOf(b, b.length));
    }

    public static ImmutableStringValue newString(byte[] b, int off, int len) {
        return ValueFactory.newString(b, off, len, false);
    }

    public static ImmutableStringValue newString(byte[] b, int off, int len, boolean omitCopy) {
        if (omitCopy && off == 0 && len == b.length) {
            return new ImmutableStringValueImpl(b);
        }
        return new ImmutableStringValueImpl(Arrays.copyOfRange(b, off, len));
    }

    public static ImmutableArrayValue newArray(List<? extends Value> list) {
        if (list.isEmpty()) {
            return ImmutableArrayValueImpl.empty();
        }
        Value[] array = list.toArray(new Value[list.size()]);
        return new ImmutableArrayValueImpl(array);
    }

    public static ImmutableArrayValue newArray(Value ... array) {
        if (array.length == 0) {
            return ImmutableArrayValueImpl.empty();
        }
        return new ImmutableArrayValueImpl(Arrays.copyOf(array, array.length));
    }

    public static ImmutableArrayValue newArray(Value[] array, boolean omitCopy) {
        if (array.length == 0) {
            return ImmutableArrayValueImpl.empty();
        }
        if (omitCopy) {
            return new ImmutableArrayValueImpl(array);
        }
        return new ImmutableArrayValueImpl(Arrays.copyOf(array, array.length));
    }

    public static ImmutableArrayValue emptyArray() {
        return ImmutableArrayValueImpl.empty();
    }

    public static <K extends Value, V extends Value> ImmutableMapValue newMap(Map<K, V> map) {
        Value[] kvs = new Value[map.size() * 2];
        int index = 0;
        for (Map.Entry<K, V> pair : map.entrySet()) {
            kvs[index] = (Value)pair.getKey();
            kvs[++index] = (Value)pair.getValue();
            ++index;
        }
        return new ImmutableMapValueImpl(kvs);
    }

    public static ImmutableMapValue newMap(Value ... kvs) {
        if (kvs.length == 0) {
            return ImmutableMapValueImpl.empty();
        }
        return new ImmutableMapValueImpl(Arrays.copyOf(kvs, kvs.length));
    }

    public static ImmutableMapValue newMap(Value[] kvs, boolean omitCopy) {
        if (kvs.length == 0) {
            return ImmutableMapValueImpl.empty();
        }
        if (omitCopy) {
            return new ImmutableMapValueImpl(kvs);
        }
        return new ImmutableMapValueImpl(Arrays.copyOf(kvs, kvs.length));
    }

    public static ImmutableMapValue emptyMap() {
        return ImmutableMapValueImpl.empty();
    }

    @SafeVarargs
    public static MapValue newMap(Map.Entry<? extends Value, ? extends Value> ... pairs) {
        Value[] kvs = new Value[pairs.length * 2];
        for (int i = 0; i < pairs.length; i += 2) {
            kvs[i * 2] = pairs[i].getKey();
            kvs[i * 2 + 1] = pairs[i].getValue();
        }
        return ValueFactory.newMap(kvs, true);
    }

    public static MapBuilder newMapBuilder() {
        return new MapBuilder();
    }

    public static Map.Entry<Value, Value> newMapEntry(Value key, Value value) {
        return new AbstractMap.SimpleEntry<Value, Value>(key, value);
    }

    public static ImmutableExtensionValue newExtension(byte type, byte[] data) {
        return new ImmutableExtensionValueImpl(type, data);
    }

    public static class MapBuilder {
        private final Map<Value, Value> map = new LinkedHashMap<Value, Value>();

        public MapValue build() {
            return ValueFactory.newMap(this.map);
        }

        public MapBuilder put(Map.Entry<? extends Value, ? extends Value> pair) {
            this.put(pair.getKey(), pair.getValue());
            return this;
        }

        public MapBuilder put(Value key, Value value) {
            this.map.put(key, value);
            return this;
        }

        public MapBuilder putAll(Iterable<? extends Map.Entry<? extends Value, ? extends Value>> entries) {
            for (Map.Entry<? extends Value, ? extends Value> entry : entries) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public MapBuilder putAll(Map<? extends Value, ? extends Value> map) {
            for (Map.Entry<? extends Value, ? extends Value> entry : map.entrySet()) {
                this.put(entry);
            }
            return this;
        }
    }
}

