/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl;

import java.io.IOException;
import java.math.BigInteger;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageFormat;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessageIntegerOverflowException;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.core.MessagePacker;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableIntegerValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ImmutableNumberValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.IntegerValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.Value;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.ValueType;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.AbstractImmutableValue;
import kr.pe.ecmaxp.openpython.repack.org.msgpack.value.impl.ImmutableBigIntegerValueImpl;

public class ImmutableLongValueImpl
extends AbstractImmutableValue
implements ImmutableIntegerValue {
    private final long value;
    private static final long BYTE_MIN = -128L;
    private static final long BYTE_MAX = 127L;
    private static final long SHORT_MIN = -32768L;
    private static final long SHORT_MAX = 32767L;
    private static final long INT_MIN = Integer.MIN_VALUE;
    private static final long INT_MAX = Integer.MAX_VALUE;

    public ImmutableLongValueImpl(long value) {
        this.value = value;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.INTEGER;
    }

    @Override
    public ImmutableIntegerValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableNumberValue asNumberValue() {
        return this;
    }

    @Override
    public ImmutableIntegerValue asIntegerValue() {
        return this;
    }

    @Override
    public byte toByte() {
        return (byte)this.value;
    }

    @Override
    public short toShort() {
        return (short)this.value;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public float toFloat() {
        return this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public boolean isInByteRange() {
        return -128L <= this.value && this.value <= 127L;
    }

    @Override
    public boolean isInShortRange() {
        return -32768L <= this.value && this.value <= 32767L;
    }

    @Override
    public boolean isInIntRange() {
        return Integer.MIN_VALUE <= this.value && this.value <= Integer.MAX_VALUE;
    }

    @Override
    public boolean isInLongRange() {
        return true;
    }

    @Override
    public MessageFormat mostSuccinctMessageFormat() {
        return ImmutableBigIntegerValueImpl.mostSuccinctMessageFormat(this);
    }

    @Override
    public byte asByte() {
        if (!this.isInByteRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        if (!this.isInShortRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (short)this.value;
    }

    @Override
    public int asInt() {
        if (!this.isInIntRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public void writeTo(MessagePacker pk) throws IOException {
        pk.packLong(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isIntegerValue()) {
            return false;
        }
        IntegerValue iv = v.asIntegerValue();
        if (!iv.isInLongRange()) {
            return false;
        }
        return this.value == iv.toLong();
    }

    public int hashCode() {
        if (Integer.MIN_VALUE <= this.value && this.value <= Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public String toJson() {
        return Long.toString(this.value);
    }

    public String toString() {
        return this.toJson();
    }
}

