/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.thumbsf;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kr.pe.ecmaxp.thumbsf.DecoderKt;
import kr.pe.ecmaxp.thumbsf.MemoryFlag;
import kr.pe.ecmaxp.thumbsf.MemoryRegion;
import kr.pe.ecmaxp.thumbsf.exc.InvalidMemoryException;
import kr.pe.ecmaxp.thumbsf.exc.UnexceptedLogicError;
import kr.pe.ecmaxp.thumbsf.exc.UnknownInstructionException;
import kr.pe.ecmaxp.thumbsf.exc.UnsupportedInstructionException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0000J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0096\u0002J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u001e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0002H\u0002J\u0016\u0010\u001d\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bJ\u0016\u0010&\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0012J\u0016\u0010(\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u001fJ\u0016\u0010*\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bJ\u0016\u0010,\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\"R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006."}, d2={"Lkr/pe/ecmaxp/thumbsf/Memory;", "", "Lkr/pe/ecmaxp/thumbsf/MemoryRegion;", "_list", "", "([Lkr/pe/ecmaxp/thumbsf/MemoryRegion;)V", "_execCache", "", "[Lkr/pe/ecmaxp/thumbsf/MemoryRegion;", "copy", "fetchCode", "", "address", "findRegion", "flash", "", "size", "firmware", "", "fork", "iterator", "", "loadExecCache", "Lkotlin/Pair;", "pc", "map", "flag", "Lkr/pe/ecmaxp/thumbsf/MemoryFlag;", "region", "readBuffer", "readByte", "", "readInt", "readShort", "", "readString", "", "maxSize", "writeBuffer", "buffer", "writeByte", "byteValue", "writeInt", "value", "writeShort", "shortValue", "OpenPython"})
public final class Memory
implements Iterable<MemoryRegion>,
KMappedMarker {
    private int[] _execCache;
    private final MemoryRegion[] _list;

    @Override
    @NotNull
    public Iterator<MemoryRegion> iterator() {
        Iterator iterator;
        ArrayList<MemoryRegion> list = new ArrayList<MemoryRegion>();
        Iterator iterator2 = iterator = ArrayIteratorKt.iterator((Object[])this._list);
        while (iterator2.hasNext()) {
            MemoryRegion region = (MemoryRegion)iterator2.next();
            if (!(Intrinsics.areEqual((Object)region, (Object)MemoryRegion.Companion.getEmptyPage()) ^ true)) continue;
            list.add(region);
        }
        Iterator<MemoryRegion> iterator3 = list.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator3, (String)"list.iterator()");
        return iterator3;
    }

    @NotNull
    public final Memory fork() {
        return new Memory(this._list);
    }

    @NotNull
    public final Memory copy() {
        Memory memory = new Memory(null, 1, null);
        for (MemoryRegion region : this._list) {
            if (Intrinsics.areEqual((Object)region, (Object)MemoryRegion.Companion.getEmptyPage())) continue;
            MemoryRegion newRegion = new MemoryRegion(region.getBegin(), region.getSize(), region.getFlag());
            int size = region.getBuffer$OpenPython().length;
            System.arraycopy(region.getBuffer$OpenPython(), 0, newRegion.getBuffer$OpenPython(), 0, size);
            memory.map(newRegion);
        }
        return memory;
    }

    private final void map(MemoryRegion region) throws InvalidMemoryException {
        int key = region.getBegin() >>> 24;
        if (Intrinsics.areEqual((Object)this._list[key], (Object)MemoryRegion.Companion.getEmptyPage()) ^ true) {
            throw (Throwable)new InvalidMemoryException(region.getBegin());
        }
        if (region.getBegin() << 8 >>> 24 != 0) {
            throw (Throwable)new InvalidMemoryException(region.getBegin());
        }
        this._list[key] = region;
    }

    public final void map(int address, int size, @NotNull MemoryFlag flag) throws InvalidMemoryException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)flag), (String)"flag");
        this.map(new MemoryRegion(address, size, flag));
    }

    public final void flash(int address, int size, @NotNull byte[] firmware) throws InvalidMemoryException {
        Intrinsics.checkParameterIsNotNull((Object)firmware, (String)"firmware");
        this.map(address, size, MemoryFlag.RX);
        this.writeBuffer(address, firmware);
        this.loadExecCache(address);
    }

    private final MemoryRegion findRegion(int address) {
        return this._list[address >>> 24];
    }

    @NotNull
    public final byte[] readBuffer(int address, int size) throws InvalidMemoryException {
        return this.findRegion(address).readBuffer(address, size);
    }

    public final void writeBuffer(int address, @NotNull byte[] buffer) throws InvalidMemoryException {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this.findRegion(address).writeBuffer(address, buffer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readString(int address, int maxSize) throws InvalidMemoryException {
        MemoryRegion region = this.findRegion(address);
        int size = Math.min(region.getEnd() - address, maxSize);
        byte[] buffer = new byte[size];
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void pos;
            byte ch;
            buffer[pos] = ch = this.readByte(address + pos);
            if (ch == (byte)0) {
                size = pos;
                break;
            }
            ++pos;
        }
        n = 0;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        return new String(buffer, n, size, charset2);
    }

    public final int fetchCode(int address) throws InvalidMemoryException {
        return this.findRegion(address).readShort(address) & 0xFFFF;
    }

    public final int readInt(int address) throws InvalidMemoryException {
        return this.findRegion(address).readInt(address);
    }

    public final short readShort(int address) throws InvalidMemoryException {
        return this.findRegion(address).readShort(address);
    }

    public final byte readByte(int address) throws InvalidMemoryException {
        return this.findRegion(address).readByte(address);
    }

    public final void writeInt(int address, int value) throws InvalidMemoryException {
        this.findRegion(address).writeInt(address, value);
    }

    public final void writeShort(int address, short shortValue) throws InvalidMemoryException {
        this.findRegion(address).writeShort(address, shortValue);
    }

    public final void writeByte(int address, byte byteValue) throws InvalidMemoryException {
        this.findRegion(address).writeByte(address, byteValue);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<int[], Integer> loadExecCache(int pc) throws InvalidMemoryException {
        MemoryRegion region = this.findRegion(pc);
        int base = region.getBegin();
        if (region.getFlag() != MemoryFlag.RX) {
            throw (Throwable)new InvalidMemoryException(pc);
        }
        if (this._execCache == null) {
            this._execCache = new int[region.getSize()];
            if (this._execCache == null) {
                Intrinsics.throwNpe();
            }
            int[] buffer = this._execCache;
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)region.getBegin(), (int)region.getEnd())), (int)2);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void code;
                    Pair<Integer, Integer> result;
                    void addr;
                    try {
                        result = DecoderKt.decode(this, (int)addr);
                    }
                    catch (UnknownInstructionException e) {
                        result = DecoderKt.insnx(83, this.fetchCode((int)addr));
                    }
                    catch (UnsupportedInstructionException e) {
                        result = DecoderKt.insnx(83, this.fetchCode((int)addr));
                    }
                    Pair<Integer, Integer> pair = result;
                    int e = ((Number)pair.component1()).intValue();
                    int imm32 = ((Number)pair.component2()).intValue();
                    switch (code & 0xFF) {
                        case 0: {
                            throw (Throwable)((Object)new UnexceptedLogicError());
                        }
                    }
                    buffer[addr - base] = code;
                    buffer[addr - base + true] = imm32;
                    if (addr == n2) break;
                    addr += n3;
                }
            }
        }
        if (this._execCache == null) {
            Intrinsics.throwNpe();
        }
        return new Pair((Object)this._execCache, (Object)base);
    }

    public Memory(@NotNull MemoryRegion[] _list) {
        Intrinsics.checkParameterIsNotNull((Object)_list, (String)"_list");
        this._list = _list;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ Memory(MemoryRegion[] memoryRegionArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            int size$iv = 256;
            MemoryRegion[] result$iv = new MemoryRegion[size$iv];
            int n2 = 0;
            int n3 = result$iv.length;
            while (n2 < n3) {
                MemoryRegion memoryRegion;
                void i$iv;
                void var8_8 = i$iv;
                void var12_10 = i$iv++;
                MemoryRegion[] memoryRegionArray2 = result$iv;
                memoryRegionArray2[var12_10] = memoryRegion = MemoryRegion.Companion.getEmptyPage();
            }
            memoryRegionArray = result$iv;
        }
        this(memoryRegionArray);
    }

    public Memory() {
        this(null, 1, null);
    }
}

