/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.ecmaxp.thumbsf;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kr.pe.ecmaxp.thumbsf.MemoryFlag;
import kr.pe.ecmaxp.thumbsf.exc.InvalidMemoryException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u000bJ\u0016\u0010\"\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0017J\u0016\u0010$\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003J\u0016\u0010&\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006)"}, d2={"Lkr/pe/ecmaxp/thumbsf/MemoryRegion;", "", "begin", "", "size", "flag", "Lkr/pe/ecmaxp/thumbsf/MemoryFlag;", "(IILkr/pe/ecmaxp/thumbsf/MemoryFlag;)V", "getBegin", "()I", "buffer", "", "getBuffer$OpenPython", "()[B", "end", "getEnd", "getFlag", "()Lkr/pe/ecmaxp/thumbsf/MemoryFlag;", "getSize", "loadKey", "address", "readBuffer", "readByte", "", "readInt", "readShort", "", "toString", "", "valid", "", "writeBuffer", "", "buf", "writeByte", "byteValue", "writeInt", "value", "writeShort", "shortValue", "Companion", "OpenPython"})
public final class MemoryRegion {
    private final int end;
    @NotNull
    private final byte[] buffer;
    private final int begin;
    private final int size;
    @NotNull
    private final MemoryFlag flag;
    @NotNull
    private static final MemoryRegion EmptyPage;
    public static final Companion Companion;

    public final int getEnd() {
        return this.end;
    }

    @NotNull
    public final byte[] getBuffer$OpenPython() {
        return this.buffer;
    }

    @NotNull
    public String toString() {
        return "MemoryRegion(begin=" + this.begin + ", size=" + this.size + ", flag=" + (Object)((Object)this.flag) + ')';
    }

    public final boolean valid(int address, int size) {
        return this.begin <= address && address + size <= this.end;
    }

    @NotNull
    public final byte[] readBuffer(int address, int size) throws InvalidMemoryException {
        if (this.flag != MemoryFlag.RX && this.flag != MemoryFlag.RW) {
            throw (Throwable)new InvalidMemoryException(address);
        }
        int pos = this.loadKey(address, size);
        byte[] byArray = this.buffer;
        int n = pos + size;
        byte[] byArray2 = Arrays.copyOfRange(byArray, pos, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOfR\u2026this, fromIndex, toIndex)");
        return byArray2;
    }

    public final void writeBuffer(int address, @NotNull byte[] buf) throws InvalidMemoryException {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        if (this.flag != MemoryFlag.RX && this.flag != MemoryFlag.RW) {
            throw (Throwable)new InvalidMemoryException(address);
        }
        int size = buf.length;
        int pos = this.loadKey(address, size);
        System.arraycopy(buf, 0, this.buffer, pos, size);
    }

    private final int loadKey(int address, int size) {
        int key = address - this.begin;
        if (key < 0 || this.end < address + size) {
            throw (Throwable)new InvalidMemoryException(address);
        }
        return key;
    }

    public final int readInt(int address) throws InvalidMemoryException {
        int pos = this.loadKey(address, 4);
        byte[] buf = this.buffer;
        return buf[pos++] & 0xFF | (buf[pos++] & 0xFF) << 8 | (buf[pos++] & 0xFF) << 16 | (buf[pos] & 0xFF) << 24;
    }

    public final short readShort(int address) throws InvalidMemoryException {
        int pos = this.loadKey(address, 2);
        byte[] buf = this.buffer;
        return (short)(buf[pos++] & 0xFF | buf[pos] << 8);
    }

    public final byte readByte(int address) throws InvalidMemoryException {
        int pos = this.loadKey(address, 1);
        byte[] buf = this.buffer;
        return buf[pos];
    }

    public final void writeInt(int address, int value) throws InvalidMemoryException {
        int pos = this.loadKey(address, 4);
        byte[] buf = this.buffer;
        buf[pos++] = (byte)value;
        buf[pos++] = (byte)(value >> 8);
        buf[pos++] = (byte)(value >> 16);
        buf[pos] = (byte)(value >> 24);
    }

    public final void writeShort(int address, short shortValue) throws InvalidMemoryException {
        int pos = this.loadKey(address, 2);
        byte[] buf = this.buffer;
        buf[pos++] = (byte)shortValue;
        buf[pos] = (byte)(shortValue >> 8);
    }

    public final void writeByte(int address, byte byteValue) throws InvalidMemoryException {
        int pos = this.loadKey(address, 1);
        byte[] buf = this.buffer;
        buf[pos] = byteValue;
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final MemoryFlag getFlag() {
        return this.flag;
    }

    public MemoryRegion(int begin, int size, @NotNull MemoryFlag flag) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)flag), (String)"flag");
        this.begin = begin;
        this.size = size;
        this.flag = flag;
        this.end = this.begin + this.size;
        this.buffer = new byte[this.size];
    }

    static {
        Companion = new Companion(null);
        EmptyPage = new MemoryRegion(0, 0, MemoryFlag.RW);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkr/pe/ecmaxp/thumbsf/MemoryRegion$Companion;", "", "()V", "EmptyPage", "Lkr/pe/ecmaxp/thumbsf/MemoryRegion;", "getEmptyPage", "()Lkr/pe/ecmaxp/thumbsf/MemoryRegion;", "OpenPython"})
    public static final class Companion {
        @NotNull
        public final MemoryRegion getEmptyPage() {
            return EmptyPage;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

