/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.entity.EntityBlackHoleStorage;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.tileentity.TileEntityBlackHoleStorage;
import stevekung.mods.moreplanets.utils.BlocksItemsRegistry;
import stevekung.mods.moreplanets.utils.EnumParticleTypesMP;
import stevekung.mods.moreplanets.utils.IDescription;
import stevekung.mods.moreplanets.utils.ItemDescription;
import stevekung.mods.moreplanets.utils.blocks.BlockBaseMP;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class BlockBlackHoleStorage
extends BlockBaseMP
implements ITileEntityProvider,
IDescription {
    public BlockBlackHoleStorage(String name) {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
        this.func_149663_c(name);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBlackHoleStorage) {
            TileEntityBlackHoleStorage storage = (TileEntityBlackHoleStorage)tile;
            if (!storage.disableBlackHole) {
                for (int i = 0; i < 16; ++i) {
                    double x = (double)((float)pos.func_177958_n() + rand.nextFloat()) - 0.5;
                    double y = (double)pos.func_177956_o() + 0.5;
                    double z = (float)pos.func_177952_p() + rand.nextFloat();
                    double motionX = rand.nextDouble() - 0.5;
                    double motionZ = rand.nextDouble() - 0.5;
                    MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.DARK_PORTAL, x + 0.5, y, z, motionX, 1.0, 0.0);
                    MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.DARK_PORTAL, x + 0.5, y, z + 0.0, 0.0, 1.0, motionZ);
                }
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        TileEntity tile = world.func_175625_s(pos);
        world.func_175656_a(pos, this.func_176223_P());
        if (!world.field_72995_K && placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            EntityBlackHoleStorage blackHole = new EntityBlackHoleStorage(world);
            blackHole.setTileEntityPos(pos);
            blackHole.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 2, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)blackHole);
            world.func_184133_a(null, pos.func_177982_a(0, 2, 0), MPSounds.BLACK_HOLE_CREATED, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (tile instanceof TileEntityBlackHoleStorage) {
                TileEntityBlackHoleStorage storage = (TileEntityBlackHoleStorage)tile;
                storage.ownerUUID = player.func_146103_bH().getId().toString();
                if (itemStack.func_77942_o()) {
                    storage.inventory = NonNullList.func_191197_a((int)storage.func_70302_i_(), (Object)ItemStack.field_190927_a);
                    storage.disableBlackHole = itemStack.func_77978_p().func_74767_n("Disable");
                    storage.useHopper = itemStack.func_77978_p().func_74767_n("Hopper");
                    storage.collectMode = itemStack.func_77978_p().func_74779_i("Mode");
                    ItemStackHelper.func_191283_b((NBTTagCompound)itemStack.func_77978_p(), (NonNullList)storage.inventory);
                    storage.fluidTank.readFromNBT(itemStack.func_77978_p().func_74775_l("XpFluid"));
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        int slot = player.field_71071_by.field_70461_c;
        if (tile instanceof TileEntityBlackHoleStorage) {
            TileEntityBlackHoleStorage storage = (TileEntityBlackHoleStorage)tile;
            FluidActionResult result = FluidUtil.interactWithFluidHandler((ItemStack)player.field_71071_by.func_70448_g(), (IFluidHandler)((IFluidHandler)storage.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)), (EntityPlayer)player);
            if (result.isSuccess()) {
                player.field_71071_by.func_70299_a(slot, result.result);
                if (player.field_71069_bz != null) {
                    player.field_71069_bz.func_75142_b();
                }
                return true;
            }
            if (player.func_146103_bH().getId().toString().equals(storage.ownerUUID)) {
                if (player.func_70093_af() && storage.fluidTank.getFluidAmount() > 0) {
                    Random rand = world.field_73012_v;
                    storage.drainExp(player);
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.8f));
                } else {
                    player.openGui((Object)"moreplanets", -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            } else {
                player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.bh_storage_not_owner.message")).func_150255_a(JsonUtils.red()));
            }
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        world.func_175666_e(pos, (Block)this);
        world.func_184133_a(null, pos.func_177982_a(0, 2, 0), MPSounds.BLACK_HOLE_DESTROYED, SoundCategory.BLOCKS, 1.0f, 1.0f);
        super.func_180663_b(world, pos, state);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        player.func_71020_j(0.025f);
        if (tile instanceof TileEntityBlackHoleStorage) {
            ItemStack itemStack = new ItemStack((Block)this);
            NBTTagCompound nbt = new NBTTagCompound();
            TileEntityBlackHoleStorage storage = (TileEntityBlackHoleStorage)tile;
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)storage.inventory);
            nbt.func_74757_a("Disable", storage.disableBlackHole);
            nbt.func_74757_a("Hopper", storage.useHopper);
            nbt.func_74778_a("Mode", storage.collectMode);
            if (storage.fluidTank.getFluid() != null) {
                NBTTagCompound fluidNbt = new NBTTagCompound();
                fluidNbt.func_74778_a("FluidName", "xpjuice");
                fluidNbt.func_74768_a("Amount", storage.fluidTank.getFluidAmount());
                nbt.func_74782_a("XpFluid", (NBTBase)fluidNbt);
            }
            itemStack.func_77982_d(nbt);
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
        }
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBlackHoleStorage) {
            TileEntityBlackHoleStorage storage = (TileEntityBlackHoleStorage)tile;
            if (!player.func_146103_bH().getId().toString().equals(storage.ownerUUID)) {
                return -1.0f;
            }
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBlackHoleStorage();
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory() {
        return EnumSortCategoryBlock.MACHINE_BLOCK;
    }

    @Override
    public ItemDescription getDescription() {
        return (itemStack, list) -> list.addAll(BlocksItemsRegistry.getDescription(this.func_149739_a() + ".description"));
    }

    @Override
    public ColorUtils.RGB getRarity() {
        return ColorUtils.stringToRGB((String)"0, 255, 207");
    }
}

