/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.entity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.entity.IImmuneBlackHole;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.utils.DamageSourceMP;
import stevekung.mods.moreplanets.utils.EnumParticleTypesMP;

public class EntityBlackHole
extends Entity {
    private int lifeTick;
    private int spawnBlockRadiusTick;
    private static final DataParameter<Integer> RANGE = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAX_LIFE = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityBlackHole(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityBlackHole(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RANGE, (Object)0);
        this.field_70180_af.func_187214_a(MAX_LIFE, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70091_d(MoverType.SELF, 0.0, 0.0, 0.0);
        int range = this.getRange();
        double nearestRange = 0.1;
        for (Entity entity : this.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range))) {
            this.applyGravityToEntities(0.4f, 5000.0f, 2500.0f, 0.3f, range, entity, this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5);
            for (Entity nearest : this.field_70170_p.func_72872_a(entity.getClass(), new AxisAlignedBB(this.field_70165_t - nearestRange, this.field_70163_u - nearestRange, this.field_70161_v - nearestRange, this.field_70165_t + nearestRange, this.field_70163_u + nearestRange, this.field_70161_v + nearestRange))) {
                if (nearest instanceof EntityPlayer && ((EntityPlayer)nearest).field_71075_bZ.field_75098_d || nearest instanceof IImmuneBlackHole && ((IImmuneBlackHole)nearest).isImmune()) {
                    return;
                }
                if (nearest instanceof EntityPlayer) {
                    nearest.func_70097_a(DamageSourceMP.BLACK_HOLE, 10.0f);
                }
                if (nearest instanceof EntityPlayer || nearest instanceof EntityBlackHole) continue;
                nearest.func_70106_y();
            }
        }
        int fallingBlockSize = this.field_70170_p.func_72872_a(EntityFallingBlock.class, new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range)).size();
        if (this.lifeTick == 0) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), MPSounds.BLACK_HOLE_CREATED, SoundCategory.AMBIENT, 2.0f, 1.0f);
        }
        if (this.lifeTick < this.getMaxLife()) {
            ++this.lifeTick;
        }
        if (this.lifeTick % 80 == 0 && this.spawnBlockRadiusTick < 15 && fallingBlockSize <= 32) {
            ++this.spawnBlockRadiusTick;
        }
        if (this.lifeTick % 20 == 0) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), MPSounds.BLACK_HOLE_AMBIENT, SoundCategory.AMBIENT, 2.0f, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.lifeTick == this.getMaxLife()) {
                this.func_70106_y();
                if (ConfigManagerMP.moreplanets_general.enableBlackHoleExplosion) {
                    this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0f, true);
                }
            }
            this.spawnFallingBlock();
        } else {
            for (int i = 0; i < 16; ++i) {
                double d0 = this.field_70165_t + (double)this.field_70146_Z.nextFloat();
                double d1 = this.field_70163_u - 0.5 + (double)this.field_70146_Z.nextFloat();
                double d2 = this.field_70161_v + (double)this.field_70146_Z.nextFloat();
                double d3 = ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.5;
                int j = this.field_70146_Z.nextInt(2) * 2 - 1;
                d0 = this.field_70165_t + 0.25 * (double)j;
                d3 = this.field_70146_Z.nextFloat() * 2.0f * (float)j;
                d2 = this.field_70161_v + 0.25 * (double)j;
                d5 = this.field_70146_Z.nextFloat() * 2.0f * (float)j;
                MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.DARK_PORTAL, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    public void func_70106_y() {
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), MPSounds.BLACK_HOLE_DESTROYED, SoundCategory.AMBIENT, 2.0f, 1.0f);
        super.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.lifeTick = nbt.func_74762_e("LifeTick");
        this.spawnBlockRadiusTick = nbt.func_74762_e("SpawnBlockRadiusTick");
        this.setRange(nbt.func_74762_e("Range"));
        this.setMaxLife(nbt.func_74762_e("MaxLife"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("LifeTick", this.lifeTick);
        nbt.func_74768_a("SpawnBlockRadiusTick", this.spawnBlockRadiusTick);
        nbt.func_74768_a("Range", this.getRange());
        nbt.func_74768_a("MaxLife", this.getMaxLife());
    }

    public void setRange(int range) {
        this.field_70180_af.func_187227_b(RANGE, (Object)range);
    }

    public void setMaxLife(int maxLife) {
        this.field_70180_af.func_187227_b(MAX_LIFE, (Object)maxLife);
    }

    private int getRange() {
        return (Integer)this.field_70180_af.func_187225_a(RANGE);
    }

    private int getMaxLife() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_LIFE);
    }

    private void spawnFallingBlock() {
        int blockPosX = MathHelper.func_76128_c((double)this.field_70165_t);
        int blockPosY = MathHelper.func_76128_c((double)this.field_70163_u);
        int blockPosZ = MathHelper.func_76128_c((double)this.field_70161_v);
        int radius = 1 + this.spawnBlockRadiusTick;
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos pos;
                    IBlockState state;
                    Block block;
                    double dist = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
                    if (!(dist <= (double)radius) || (block = (state = this.field_70170_p.func_180495_p(pos = new BlockPos(blockPosX + x, blockPosY + y, blockPosZ + z))).func_177230_c()).isAir(state, (IBlockAccess)this.field_70170_p, pos)) continue;
                    this.field_70170_p.func_175698_g(pos);
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_70170_p, (double)(blockPosX + x), (double)(blockPosY + y), (double)(blockPosZ + z), state);
                    fallingBlock.field_145812_b = 1;
                    fallingBlock.field_145813_c = false;
                    fallingBlock.field_70181_x += 0.5;
                    fallingBlock.func_70012_b((double)(blockPosX + x) + 0.5, (double)(blockPosY + y), (double)(blockPosZ + z) + 0.5, 0.0f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)fallingBlock);
                }
            }
        }
    }

    private void applyGravityToEntities(float gravStrength, float maxGravXZ, float maxGravY, float minGrav, float range, Entity entity, double xCoord, double yCoord, double zCoord) {
        double dist = Math.sqrt(Math.pow(xCoord + 0.5 - entity.field_70165_t, 2.0) + Math.pow(zCoord + 0.5 - entity.field_70161_v, 2.0) + Math.pow(yCoord + 0.5 - entity.field_70163_u, 2.0));
        if (dist > (double)range) {
            return;
        }
        double xDisplacment = entity.field_70165_t - (xCoord + 0.5);
        double yDisplacment = entity.field_70163_u - (yCoord + 0.5);
        double zDisplacment = entity.field_70161_v - (zCoord + 0.5);
        double theta = Math.acos(zDisplacment / dist);
        double phi = Math.atan2(yDisplacment, xDisplacment);
        double gravForce = (double)gravStrength * (1.0 - dist / (double)range);
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || entity instanceof IImmuneBlackHole && ((IImmuneBlackHole)entity).isImmune()) {
            return;
        }
        double vecX = -(gravForce *= 2.0) * Math.sin(theta) * Math.cos(phi);
        double vecY = -gravForce * Math.sin(theta) * Math.sin(phi);
        double vecZ = -gravForce * Math.cos(theta);
        if (Math.abs(vecX) > (double)maxGravXZ) {
            vecX *= (double)maxGravXZ / Math.abs(vecX);
        }
        if (Math.abs(vecY) > (double)maxGravY) {
            vecY *= (double)maxGravY / Math.abs(vecY);
        }
        if (Math.abs(vecZ) > (double)maxGravXZ) {
            vecZ *= (double)maxGravXZ / Math.abs(vecZ);
        }
        if (Math.abs(vecX) < (double)minGrav) {
            vecX = 0.0;
        }
        if (Math.abs(vecY) < (double)minGrav) {
            vecY = 0.0;
        }
        if (Math.abs(vecZ) < (double)minGrav) {
            vecZ = 0.0;
        }
        entity.func_70024_g(vecX, vecY, vecZ);
    }
}

