/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils.items;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.utils.items.ItemFoodMP;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class ItemAllFood
extends ItemFoodMP {
    private final ItemType type;

    public ItemAllFood(String name, ItemType type) {
        this.func_77655_b(name);
        this.type = type;
    }

    protected void func_77849_c(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (this.type == ItemType.INFECTED_GOLDEN_APPLE) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 2400, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 120, 1));
            } else if (this.type == ItemType.GOLDEN_ALIEN_BERRY) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 3600, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 1));
            } else if (this.type == ItemType.ENCHANTED_INFECTED_GOLDEN_APPLE) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 2400, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, 4));
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 6000, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 6000, 0));
            }
        }
    }

    public IRarity getForgeRarity(ItemStack itemStack) {
        return this.type == ItemType.INFECTED_GOLDEN_APPLE || this.type == ItemType.GOLDEN_ALIEN_BERRY ? EnumRarity.RARE : (this.type == ItemType.ENCHANTED_INFECTED_GOLDEN_APPLE ? EnumRarity.EPIC : super.getForgeRarity(itemStack));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return this.type == ItemType.ENCHANTED_INFECTED_GOLDEN_APPLE;
    }

    public int func_77626_a(ItemStack itemStack) {
        if (this.type == ItemType.CHEESE_MILK_CURD || this.type == ItemType.JELLY_BEANS) {
            return 8;
        }
        if (this.type == ItemType.TERRABERRY) {
            return 18;
        }
        return 32;
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.type == ItemType.ENCHANTED_INFECTED_GOLDEN_APPLE ? LangUtils.translate((String)"item.infected_golden_apple") : super.func_77667_c(itemStack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.type == ItemType.INFECTED_GOLDEN_APPLE || this.type == ItemType.ENCHANTED_INFECTED_GOLDEN_APPLE || this.type == ItemType.GOLDEN_ALIEN_BERRY) {
            if (player.func_71043_e(true)) {
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (this.type == ItemType.TERRABERRY) {
            if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, itemStack) && state.func_177230_c() == MPBlocks.INFECTED_FARMLAND && world.func_175623_d(pos.func_177984_a())) {
                world.func_180501_a(pos.func_177984_a(), MPBlocks.TERRABERRY.func_176223_P(), 11);
                itemStack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public int func_150905_g(ItemStack itemStack) {
        return this.type.getHunger();
    }

    public float func_150906_h(ItemStack itemStack) {
        return this.type.getSaturation();
    }

    public static enum ItemType {
        CHEESE_MILK_CURD(3, 0.35f),
        RAW_CHEESE_BEEF(3, 0.2f),
        COOKED_CHEESE_BEEF(8, 0.8f),
        CHEESE_SPORE_BERRY(4, 0.4f),
        INFECTED_APPLE(4, 0.3f),
        INFECTED_GOLDEN_APPLE(4, 1.2f),
        ENCHANTED_INFECTED_GOLDEN_APPLE(4, 1.5f),
        INFECTED_MELON_SLICE(3, 0.4f),
        ALIEN_BERRY(4, 1.0f),
        GOLDEN_ALIEN_BERRY(5, 1.25f),
        TERRABERRY(6, 1.5f),
        RAW_SHLIME_MEAT(3, 0.3f),
        COOKED_SHLIME_MEAT(8, 0.8f),
        STRAWBERRY(4, 0.25f),
        GIANT_BLUEBERRY(6, 0.45f),
        CHOCOLATE_BAR(5, 0.6f),
        JELLY_BEANS(1, 0.05f),
        MARSHMALLOW(3, 0.15f),
        COOKED_MARSHMALLOW(6, 0.35f),
        RED_CANDY_CANE_STICK(4, 0.5f),
        GREEN_CANDY_CANE_STICK(4, 0.5f),
        BLUE_CANDY_CANE_STICK(4, 0.5f),
        ORANGE_CANDY_CANE_STICK(4, 0.5f),
        PINK_CANDY_CANE_STICK(4, 0.5f),
        YELLOW_CANDY_CANE_STICK(4, 0.5f),
        PURPLE_CANDY_CANE_STICK(4, 0.5f),
        RAINBOW_CANDY_CANE_STICK(4, 0.5f),
        GRAPE_JELLY(4, 0.35f),
        RASPBERRY_JELLY(4, 0.35f),
        STRAWBERRY_JELLY(4, 0.35f),
        BERRY_JELLY(4, 0.35f),
        LIME_JELLY(4, 0.35f),
        ORANGE_JELLY(4, 0.35f),
        GREEN_JELLY(4, 0.35f),
        LEMON_JELLY(4, 0.35f),
        BLUE_PEAR(4, 0.025f);

        private int hunger;
        private float saturation;

        private ItemType(int hunger, float saturation) {
            this.hunger = hunger;
            this.saturation = saturation;
        }

        public int getHunger() {
            return this.hunger;
        }

        public float getSaturation() {
            return this.saturation;
        }
    }
}

