/*
 * Decompiled with CFR 0.152.
 */
package fr.blueslime.slimeperipherals.logic.electroniclock;

import fr.blueslime.slimeperipherals.logic.electroniclock.ElectronicPadEntry;
import fr.blueslime.slimeperipherals.tileentity.TileEntityElectronicLock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElectronicPadData
implements INBTSerializable<NBTTagList> {
    public static final int ENTRIES_NB = 12;
    public static final ElectronicPadData ITEMS = new Builder().with(0, new ItemStack(Blocks.field_150364_r)).with(1, new ItemStack((Block)Blocks.field_150354_m)).with(2, new ItemStack(Blocks.field_150347_e)).with(3, new ItemStack(Blocks.field_150371_ca)).with(4, new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176333_M)).with(5, new ItemStack(Blocks.field_150357_h)).with(6, new ItemStack(Blocks.field_150426_aN)).with(7, new ItemStack(Blocks.field_189877_df)).with(8, new ItemStack(Blocks.field_150359_w)).with(9, new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.RED.func_176765_a())).with(10, new ItemStack(Blocks.field_150402_ci)).with(11, new ItemStack(Blocks.field_150406_ce, 1, EnumDyeColor.GREEN.func_176765_a())).build();
    private final ElectronicPadEntry[] entries;

    public ElectronicPadData() {
        this.entries = new ElectronicPadEntry[12];
    }

    private ElectronicPadData(ElectronicPadEntry[] entries) {
        this.entries = entries;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(TileEntityElectronicLock te, double x, double y, double z) {
        for (int i = 0; i < 12; ++i) {
            this.entries[i].render(x, y, z, te.getOrientation(), te.isClicked(i));
        }
    }

    public NBTTagList serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < 12; ++i) {
            if (this.entries[i] == null) continue;
            nbtTagList.func_74742_a((NBTBase)this.entries[i].serializeNBT());
        }
        return nbtTagList;
    }

    public void deserializeNBT(NBTTagList nbtTagList) {
        for (int i = 0; i < 12; ++i) {
            this.entries[i] = new ElectronicPadEntry(i);
            this.entries[i].deserializeNBT(nbtTagList.func_150305_b(i));
        }
    }

    public ElectronicPadEntry getEntry(int index) {
        return this.entries[index];
    }

    public static class Builder {
        private final ElectronicPadEntry[] entries = new ElectronicPadEntry[12];

        public ElectronicPadData build() {
            if (!this.validate()) {
                throw new IllegalStateException("A pad entry cannot be null");
            }
            return new ElectronicPadData(this.entries);
        }

        public Builder with(int pos, ItemStack stack) {
            this.entries[pos] = new ElectronicPadEntry(pos, stack);
            return this;
        }

        public boolean validate() {
            for (int i = 0; i < 12; ++i) {
                if (this.entries[i] != null) continue;
                return false;
            }
            return true;
        }
    }
}

