/*
 * Decompiled with CFR 0.152.
 */
package fr.blueslime.slimeperipherals.logic.electroniclock;

import fr.blueslime.slimeperipherals.block.BlockMagneticCardReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElectronicPadEntry
implements INBTSerializable<NBTTagCompound> {
    private static final String PAD_POSITION_NBT = "PadPosition";
    private static final String STACK_NBT = "Item";
    private int padPosition;
    private ItemStack stack;

    public ElectronicPadEntry(int padPosition) {
        this(padPosition, ItemStack.field_190927_a);
    }

    public ElectronicPadEntry(int padPosition, ItemStack stack) {
        this.padPosition = padPosition;
        this.stack = stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(double x, double y, double z, BlockMagneticCardReader.EnumOrientation orientation, boolean clicked) {
        Vec3d renderPosition = ElectronicPadEntry.getPositionWithOrientation(x, y, z, this.padPosition, orientation);
        if (clicked) {
            renderPosition = renderPosition.func_178787_e(ElectronicPadEntry.getClickedTranslate(orientation));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)renderPosition.field_72450_a, (double)renderPosition.field_72448_b, (double)renderPosition.field_72449_c);
        GlStateManager.func_179152_a((float)0.125f, (float)0.125f, (float)0.125f);
        GlStateManager.func_179137_b((double)0.25, (double)0.25, (double)0.25);
        if (orientation.isHorizontal()) {
            if (orientation == BlockMagneticCardReader.EnumOrientation.DOWN_NORTH || orientation == BlockMagneticCardReader.EnumOrientation.DOWN_SOUTH || orientation == BlockMagneticCardReader.EnumOrientation.UP_NORTH || orientation == BlockMagneticCardReader.EnumOrientation.UP_SOUTH) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.stack, ItemCameraTransforms.TransformType.FIXED);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74768_a(PAD_POSITION_NBT, this.padPosition);
        nbtTagCompound.func_74782_a(STACK_NBT, (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        return nbtTagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbtTagCompound) {
        this.padPosition = nbtTagCompound.func_74762_e(PAD_POSITION_NBT);
        this.stack = new ItemStack(nbtTagCompound.func_74775_l(STACK_NBT));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public static AxisAlignedBB getEntryAABB(double x, double y, double z, int padPosition, BlockMagneticCardReader.EnumOrientation orientation) {
        AxisAlignedBB box = ElectronicPadEntry.getRelativeEntryAABB(padPosition, orientation);
        return new AxisAlignedBB(box.field_72340_a + x, box.field_72338_b + y, box.field_72339_c + z, box.field_72336_d + x, box.field_72337_e + y, box.field_72334_f + z);
    }

    private static Vec3d getPositionWithOrientation(double x, double y, double z, int padPosition, BlockMagneticCardReader.EnumOrientation orientation) {
        Vec3d relative = ElectronicPadEntry.getRelativeFromOrientation(padPosition, orientation);
        return new Vec3d(x + relative.field_72450_a, y + relative.field_72448_b, z + relative.field_72449_c);
    }

    private static Vec3d getRelativeFromOrientation(int padPosition, BlockMagneticCardReader.EnumOrientation orientation) {
        double padColumn = padPosition % 3;
        double padLine = Math.floor(padPosition / 3);
        switch (orientation) {
            case SOUTH: {
                return new Vec3d(0.375 + padColumn * 0.0625 + padColumn * 0.03125, 0.59375 - padLine * 0.0625 - padLine * 0.03125, 0.09375);
            }
            case NORTH: {
                return new Vec3d(0.5625 - padColumn * 0.0625 - padColumn * 0.03125, 0.59375 - padLine * 0.0625 - padLine * 0.03125, 0.84375);
            }
            case WEST: {
                return new Vec3d(0.84375, 0.59375 - padLine * 0.0625 - padLine * 0.03125, 0.375 + padColumn * 0.0625 + padColumn * 0.03125);
            }
            case EAST: {
                return new Vec3d(0.09375, 0.59375 - padLine * 0.0625 - padLine * 0.03125, 0.5625 - padColumn * 0.0625 - padColumn * 0.03125);
            }
            case UP_SOUTH: {
                return new Vec3d(0.5625 - padColumn * 0.0625 - padColumn * 0.03125, 0.09375, 0.59375 - padLine * 0.0625 - padLine * 0.03125);
            }
            case UP_NORTH: {
                return new Vec3d(0.375 + padColumn * 0.0625 + padColumn * 0.03125, 0.09375, 0.34375 + padLine * 0.0625 + padLine * 0.03125);
            }
            case UP_WEST: {
                return new Vec3d(0.34375 + padLine * 0.0625 + padLine * 0.03125, 0.09375, 0.5625 - padColumn * 0.0625 - padColumn * 0.03125);
            }
            case UP_EAST: {
                return new Vec3d(0.59375 - padLine * 0.0625 - padLine * 0.03125, 0.09375, 0.375 + padColumn * 0.0625 + padColumn * 0.03125);
            }
            case DOWN_SOUTH: {
                return new Vec3d(0.5625 - padColumn * 0.0625 - padColumn * 0.03125, 0.84375, 0.34375 + padLine * 0.0625 + padLine * 0.03125);
            }
            case DOWN_NORTH: {
                return new Vec3d(0.375 + padColumn * 0.0625 + padColumn * 0.03125, 0.84375, 0.59375 - padLine * 0.0625 - padLine * 0.03125);
            }
            case DOWN_WEST: {
                return new Vec3d(0.59375 - padLine * 0.0625 - padLine * 0.03125, 0.84375, 0.5625 - padColumn * 0.0625 - padColumn * 0.03125);
            }
            case DOWN_EAST: {
                return new Vec3d(0.34375 + padLine * 0.0625 + padLine * 0.03125, 0.84375, 0.375 + padColumn * 0.0625 + padColumn * 0.03125);
            }
        }
        throw new IllegalStateException("Invalid orientation");
    }

    private static Vec3d getClickedTranslate(BlockMagneticCardReader.EnumOrientation orientation) {
        switch (orientation) {
            case SOUTH: {
                return new Vec3d(0.0, 0.0, -0.015625);
            }
            case NORTH: {
                return new Vec3d(0.0, 0.0, 0.015625);
            }
            case WEST: {
                return new Vec3d(0.015625, 0.0, 0.0);
            }
            case EAST: {
                return new Vec3d(-0.015625, 0.0, 0.0);
            }
            case UP_SOUTH: 
            case UP_NORTH: 
            case UP_WEST: 
            case UP_EAST: {
                return new Vec3d(0.0, -0.015625, 0.0);
            }
            case DOWN_SOUTH: 
            case DOWN_NORTH: 
            case DOWN_WEST: 
            case DOWN_EAST: {
                return new Vec3d(0.0, 0.015625, 0.0);
            }
        }
        throw new IllegalStateException("Invalid orientation");
    }

    private static AxisAlignedBB getRelativeEntryAABB(int padPosition, BlockMagneticCardReader.EnumOrientation orientation) {
        Vec3d relative = ElectronicPadEntry.getRelativeFromOrientation(padPosition, orientation);
        return new AxisAlignedBB(relative.field_72450_a, relative.field_72448_b, relative.field_72449_c, relative.field_72450_a + 0.0625, relative.field_72448_b + 0.0625, relative.field_72449_c + 0.0625).func_186662_g(0.002);
    }

    public static int getPadPositionFromHitPoint(float hitX, float hitY, float hitZ, BlockMagneticCardReader.EnumOrientation orientation) {
        for (int i = 0; i < 12; ++i) {
            AxisAlignedBB buttonCube = ElectronicPadEntry.getRelativeEntryAABB(i, orientation);
            if (!buttonCube.func_72318_a(new Vec3d((double)hitX, (double)hitY, (double)hitZ))) continue;
            return i;
        }
        return -1;
    }
}

