/*
 * Decompiled with CFR 0.152.
 */
package fr.blueslime.slimeperipherals.tileentity;

import fr.blueslime.slimeperipherals.block.BlockElectronicLock;
import fr.blueslime.slimeperipherals.block.BlockMagneticCardReader;
import fr.blueslime.slimeperipherals.init.ModBlocks;
import fr.blueslime.slimeperipherals.init.ModItems;
import fr.blueslime.slimeperipherals.item.ItemElectronicPad;
import fr.blueslime.slimeperipherals.logic.electroniclock.ElectronicPadData;
import fr.blueslime.slimeperipherals.logic.electroniclock.ElectronicPadEntry;
import fr.blueslime.slimeperipherals.tileentity.TileEntityPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityElectronicLock
extends TileEntityPeripheral {
    public static final String PERIPHERAL_NAME = "electronic_lock";
    private static final String STATE_NBT = "State";
    private static final String PAD_NBT = "Pad";
    private static final String CLICKED_LIST_NBT = "Clicked";
    private BlockElectronicLock.EnumState state = BlockElectronicLock.EnumState.IDLE;
    private ItemStack pad = ItemStack.field_190927_a;
    private ElectronicPadData padData = null;
    private Map<Integer, Integer> clickedButtonsTimeouts = new HashMap<Integer, Integer>();
    private boolean dirtyState = true;

    public TileEntityElectronicLock() {
        this.setHasEventQueue();
        this.computerMethodRegistry.register("acceptInputs", this::onMethodAcceptInputs);
        this.computerMethodRegistry.register("setIdle", this::onMethodSetIdle);
        this.computerMethodRegistry.register("setRejected", this::onMethodSetRejected);
        this.computerMethodRegistry.register("getState", this::onMethodGetState);
    }

    public void onPlayerInteract(EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.pad.func_190926_b()) {
            return;
        }
        int padPosition = ElectronicPadEntry.getPadPositionFromHitPoint(hitX, hitY, hitZ, (BlockMagneticCardReader.EnumOrientation)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockElectronicLock.ORIENTATION)));
        if (this.clickedButtonsTimeouts.containsKey(padPosition)) {
            return;
        }
        if (padPosition != -1) {
            this.pushEvent(new Object[]{player.func_70005_c_(), padPosition});
            this.field_145850_b.func_184133_a(player, this.field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
            this.clickedButtonsTimeouts.put(padPosition, 20);
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 2);
        }
    }

    public void onPadMovement(EntityPlayer player, ItemStack stack) {
        if (!this.assertInteractWithSecurity(player)) {
            return;
        }
        if (!this.pad.func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)this.field_174879_c.func_177956_o(), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (ItemStack)this.pad);
            this.pad = ItemStack.field_190927_a;
            this.padData = null;
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 2);
            return;
        }
        if (stack.func_77973_b() != ModItems.ELECTRONIC_PAD) {
            return;
        }
        this.pad = stack.func_77946_l();
        this.pad.func_190920_e(1);
        this.padData = ItemElectronicPad.getPadData(this.pad);
        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 2);
    }

    public void onBlockBreak() {
        if (!this.pad.func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)this.field_174879_c.func_177956_o(), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (ItemStack)this.pad);
        }
        this.pad = ItemStack.field_190927_a;
    }

    @Override
    public void func_73660_a() {
        IBlockState blockState;
        super.func_73660_a();
        this.clickedButtonsTimeouts.forEach((position, ticks) -> this.clickedButtonsTimeouts.put((Integer)position, ticks - 1));
        if (this.clickedButtonsTimeouts.values().removeIf(ticks -> ticks <= 0)) {
            blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 2);
        }
        if (this.dirtyState) {
            blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState.func_177226_a(BlockElectronicLock.STATE, (Comparable)((Object)this.state)), 3);
            this.dirtyState = false;
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (newState.func_177230_c() == oldState.func_177230_c() && oldState.func_177230_c() == ModBlocks.ELECTRONIC_LOCK) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.state = BlockElectronicLock.EnumState.values()[nbtTagCompound.func_74762_e(STATE_NBT)];
        if (nbtTagCompound.func_74764_b(PAD_NBT)) {
            this.pad = new ItemStack(nbtTagCompound.func_74775_l(PAD_NBT));
            this.padData = ItemElectronicPad.getPadData(this.pad);
        }
        this.dirtyState = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a(STATE_NBT, this.state.ordinal());
        if (!this.pad.func_190926_b()) {
            nbtTagCompound.func_74782_a(PAD_NBT, (NBTBase)this.pad.func_77955_b(new NBTTagCompound()));
        }
        return nbtTagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound nbtTagCompound = packet.func_148857_g();
        if (nbtTagCompound.func_74764_b(PAD_NBT)) {
            this.pad = new ItemStack(nbtTagCompound.func_74775_l(PAD_NBT));
            this.padData = ItemElectronicPad.getPadData(this.pad);
        } else {
            this.pad = ItemStack.field_190927_a;
            this.padData = null;
        }
        int[] clickedArray = nbtTagCompound.func_74759_k(CLICKED_LIST_NBT);
        this.clickedButtonsTimeouts.clear();
        for (int i = 0; i < clickedArray.length; ++i) {
            if (clickedArray[i] <= 0) continue;
            this.clickedButtonsTimeouts.put(i, clickedArray[i]);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        if (!this.pad.func_190926_b()) {
            nbtTagCompound.func_74782_a(PAD_NBT, (NBTBase)this.pad.func_77955_b(new NBTTagCompound()));
        }
        int[] clickedArray = new int[12];
        this.clickedButtonsTimeouts.forEach((position, ticks) -> {
            clickedArray[position.intValue()] = ticks;
        });
        nbtTagCompound.func_74783_a(CLICKED_LIST_NBT, clickedArray);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTagCompound);
    }

    @Override
    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public BlockMagneticCardReader.EnumOrientation getOrientation() {
        return (BlockMagneticCardReader.EnumOrientation)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockElectronicLock.ORIENTATION));
    }

    public ElectronicPadData getPadData() {
        return this.padData;
    }

    @Override
    public String getComputerName() {
        return PERIPHERAL_NAME;
    }

    public boolean isClicked(int index) {
        return this.clickedButtonsTimeouts.containsKey(index);
    }

    private Object[] onMethodAcceptInputs(Object[] args) {
        this.state = (Boolean)args[0] != false ? BlockElectronicLock.EnumState.WAITING_INPUT : BlockElectronicLock.EnumState.IDLE;
        this.dirtyState = true;
        return new Object[0];
    }

    private Object[] onMethodSetIdle(Object[] args) {
        this.state = BlockElectronicLock.EnumState.IDLE;
        this.dirtyState = true;
        return new Object[0];
    }

    private Object[] onMethodSetRejected(Object[] args) {
        this.state = BlockElectronicLock.EnumState.REJECTED;
        this.dirtyState = true;
        return new Object[0];
    }

    private Object[] onMethodGetState(Object[] args) {
        return new Object[]{this.state.func_176610_l()};
    }
}

