/*
 * Decompiled with CFR 0.152.
 */
package fr.blueslime.slimeperipherals.tileentity;

import fr.blueslime.slimeperipherals.block.BlockRFIDWriter;
import fr.blueslime.slimeperipherals.init.ModBlocks;
import fr.blueslime.slimeperipherals.item.ItemCard;
import fr.blueslime.slimeperipherals.tileentity.TileEntityPeripheral;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityRFIDWriter
extends TileEntityPeripheral
implements ITickable {
    private static final String STATE_NBT = "State";
    private static final String CARD_NBT = "Card";
    private static final String DATA_TO_WRITE_NBT = "DataToWrite";
    private static final String OPERATION_TICKS_NBT = "OperationTicks";
    private static final int TICKS_NEEDED_TO_WRITE = 100;
    private BlockRFIDWriter.EnumState state = BlockRFIDWriter.EnumState.IDLE;
    private String dataToWrite;
    private ItemStack currentStack = ItemStack.field_190927_a;
    private boolean dirtyState = true;
    private int operationTicks = 0;

    public TileEntityRFIDWriter() {
        this.computerMethodRegistry.register("writeData", this::onMethodWriteData);
        this.computerMethodRegistry.register("getProgress", this::onMethodGetProgress);
        this.computerMethodRegistry.register("getState", this::onMethodGetState);
    }

    public void onCardPlace(EntityPlayer player, ItemStack stack) {
        if (!this.currentStack.func_190926_b()) {
            this.onCardTake();
            return;
        }
        this.currentStack = stack.func_77946_l();
        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
        this.dirtyState = true;
    }

    public void onCardTake() {
        if (this.state == BlockRFIDWriter.EnumState.BUSY || this.currentStack.func_190926_b()) {
            return;
        }
        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)this.field_174879_c.func_177956_o(), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (ItemStack)this.currentStack);
        this.currentStack = ItemStack.field_190927_a;
        this.dirtyState = true;
    }

    public void onBlockBreak() {
        if (!this.currentStack.func_190926_b()) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)this.field_174879_c.func_177956_o(), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (ItemStack)this.currentStack);
        }
        this.currentStack = ItemStack.field_190927_a;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.state == BlockRFIDWriter.EnumState.WAITING_CARD && !this.currentStack.func_190926_b()) {
            this.state = BlockRFIDWriter.EnumState.BUSY;
            this.operationTicks = 0;
            this.dirtyState = true;
        } else if (this.state == BlockRFIDWriter.EnumState.BUSY) {
            ++this.operationTicks;
            if (this.operationTicks >= 100) {
                ItemCard.setData(this.currentStack, this.dataToWrite);
                this.state = BlockRFIDWriter.EnumState.IDLE;
                this.operationTicks = 0;
                this.dirtyState = true;
            }
        }
        if (this.dirtyState) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState.func_177226_a(BlockRFIDWriter.STATE, (Comparable)((Object)this.state)).func_177226_a((IProperty)BlockRFIDWriter.FILLED, (Comparable)Boolean.valueOf(!this.currentStack.func_190926_b())), 3);
            this.dirtyState = false;
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (newState.func_177230_c() == oldState.func_177230_c() && oldState.func_177230_c() == ModBlocks.RFID_WRITER) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.state = BlockRFIDWriter.EnumState.values()[nbtTagCompound.func_74762_e(STATE_NBT)];
        if (nbtTagCompound.func_74764_b(CARD_NBT)) {
            this.currentStack = new ItemStack(nbtTagCompound.func_74775_l(CARD_NBT));
        }
        if (this.state == BlockRFIDWriter.EnumState.WAITING_CARD) {
            this.dataToWrite = nbtTagCompound.func_74779_i(DATA_TO_WRITE_NBT);
        } else if (this.state == BlockRFIDWriter.EnumState.BUSY) {
            this.operationTicks = nbtTagCompound.func_74762_e(OPERATION_TICKS_NBT);
        }
        this.dirtyState = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a(STATE_NBT, this.state.ordinal());
        if (!this.currentStack.func_190926_b()) {
            NBTTagCompound stackTag = new NBTTagCompound();
            this.currentStack.func_77955_b(stackTag);
            nbtTagCompound.func_74782_a(CARD_NBT, (NBTBase)stackTag);
        }
        if (this.state == BlockRFIDWriter.EnumState.WAITING_CARD) {
            nbtTagCompound.func_74778_a(DATA_TO_WRITE_NBT, this.dataToWrite);
        } else if (this.state == BlockRFIDWriter.EnumState.BUSY) {
            nbtTagCompound.func_74768_a(OPERATION_TICKS_NBT, this.operationTicks);
        }
        return nbtTagCompound;
    }

    @Override
    public String getComputerName() {
        return "rfid_writer";
    }

    private Object[] onMethodWriteData(Object[] args) {
        this.dataToWrite = String.valueOf(args[0]);
        this.state = BlockRFIDWriter.EnumState.WAITING_CARD;
        this.dirtyState = true;
        return new Object[0];
    }

    private Object[] onMethodGetProgress(Object[] args) {
        return new Object[]{this.operationTicks, 100};
    }

    private Object[] onMethodGetState(Object[] args) {
        return new Object[]{this.state.func_176610_l()};
    }
}

