/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import java.io.IOException;
import marytts.machinelearning.Cluster;
import marytts.util.io.MaryRandomAccessFile;
import marytts.util.math.MathUtils;

public class GaussianComponent {
    public double[] meanVector;
    public double[][] covMatrix;
    private double[][] invCovMatrix;
    private double detCovMatrix;
    private double constantTerm;
    private double constantTermLog;

    public GaussianComponent() {
        this(0, true);
    }

    public GaussianComponent(int featureDimensionIn, boolean isDiagonal) {
        this.init(featureDimensionIn, isDiagonal);
    }

    public GaussianComponent(GaussianComponent existing) {
        this.init(existing.meanVector, existing.covMatrix);
    }

    public GaussianComponent(Cluster c) {
        this.init(c.meanVector, c.covMatrix);
    }

    public void init(int featureDimensionIn, boolean isDiagonal) {
        if (featureDimensionIn > 0) {
            this.meanVector = new double[featureDimensionIn];
            this.covMatrix = isDiagonal ? new double[1][featureDimensionIn] : new double[featureDimensionIn][featureDimensionIn];
        } else {
            this.meanVector = null;
            this.covMatrix = null;
        }
    }

    public void init(double[] meanVectorIn, double[][] covMatrixIn) {
        this.setMeanVector(meanVectorIn);
        this.setCovMatrix(covMatrixIn);
        int i = 0;
        while (i < this.covMatrix.length) {
            assert (this.meanVector.length == this.covMatrix[i].length);
            ++i;
        }
    }

    public void setMeanVector(double[] meanVectorIn) {
        this.setMeanVector(meanVectorIn, 0, meanVectorIn.length);
    }

    public void setMeanVector(double[] bigVector, int startIndex, int meanLength) {
        if (bigVector != null && meanLength > 0) {
            if (startIndex + meanLength > bigVector.length) {
                meanLength = bigVector.length - startIndex;
            }
            if (this.meanVector == null || meanLength != this.meanVector.length) {
                this.meanVector = new double[meanLength];
            }
            int i = 0;
            while (i < meanLength) {
                this.meanVector[i] = bigVector[startIndex + i];
                ++i;
            }
        } else {
            this.meanVector = null;
        }
    }

    public void setCovMatrix(double[][] covMatrixIn) {
        if (covMatrixIn.length == 1) {
            this.setCovMatrix(covMatrixIn, 0, 0, covMatrixIn[0].length);
        } else {
            this.setCovMatrix(covMatrixIn, 0, 0, covMatrixIn.length);
        }
    }

    public void setCovMatrix(double[][] bigCovMatrix, int rowStartIndex, int colStartIndex, int covLength) {
        if (bigCovMatrix != null && covLength > 0) {
            if (bigCovMatrix.length == 1) {
                int startIndex = Math.max(rowStartIndex, colStartIndex);
                if (startIndex + covLength > bigCovMatrix[0].length) {
                    covLength = bigCovMatrix[0].length - startIndex;
                }
                if (this.covMatrix == null || this.covMatrix.length > 1 || this.covMatrix[0].length != covLength) {
                    this.covMatrix = new double[1][covLength];
                }
                System.arraycopy(bigCovMatrix[0], startIndex, this.covMatrix[0], 0, covLength);
            } else {
                int i = 0;
                while (i < bigCovMatrix.length) {
                    if (colStartIndex + covLength > bigCovMatrix[i].length) {
                        covLength = bigCovMatrix[i].length - colStartIndex;
                    }
                    ++i;
                }
                if (rowStartIndex + covLength > bigCovMatrix.length) {
                    covLength = bigCovMatrix.length - rowStartIndex;
                }
                if (this.covMatrix == null) {
                    this.covMatrix = new double[covLength][];
                }
                i = rowStartIndex;
                while (i < rowStartIndex + covLength) {
                    if (this.covMatrix[i - rowStartIndex] == null || this.covMatrix[i - rowStartIndex].length != covLength) {
                        this.covMatrix[i - rowStartIndex] = new double[covLength];
                    }
                    int j = colStartIndex;
                    while (j < colStartIndex + covLength) {
                        this.covMatrix[i - rowStartIndex][j - colStartIndex] = bigCovMatrix[i][j];
                        ++j;
                    }
                    ++i;
                }
            }
        } else {
            this.covMatrix = null;
        }
        this.setDerivedValues();
    }

    public void setDerivedValues() {
        if (this.covMatrix != null) {
            this.invCovMatrix = MathUtils.inverse(this.covMatrix);
            this.detCovMatrix = MathUtils.determinant(this.covMatrix);
            this.constantTerm = MathUtils.getGaussianPdfValueConstantTerm(this.covMatrix[0].length, this.detCovMatrix);
            this.constantTermLog = MathUtils.getGaussianPdfValueConstantTermLog(this.covMatrix[0].length, this.detCovMatrix);
        } else {
            this.invCovMatrix = null;
            this.detCovMatrix = 0.0;
            this.constantTerm = 0.0;
            this.constantTermLog = 0.0;
        }
    }

    public boolean isDiagonalCovariance() {
        return this.meanVector != null && this.covMatrix != null && this.covMatrix.length == 1 && this.meanVector.length > 1 && this.covMatrix[0].length == this.meanVector.length;
    }

    public double[] getCovMatrixDiagonal() {
        if (this.covMatrix != null) {
            return this.covMatrix[0];
        }
        return null;
    }

    public double[][] getInvCovMatrix() {
        return this.invCovMatrix;
    }

    public double getDetCovMatrix() {
        return this.detCovMatrix;
    }

    public double getConstantTerm() {
        return this.constantTerm;
    }

    public double getConstantTermLog() {
        return this.constantTermLog;
    }

    public void write(MaryRandomAccessFile stream) throws IOException {
        int i;
        boolean isDiagonal = this.isDiagonalCovariance();
        stream.writeBooleanEndian(isDiagonal);
        if (this.meanVector != null) {
            stream.writeIntEndian(this.meanVector.length);
            stream.writeDoubleEndian(this.meanVector);
        } else {
            stream.writeIntEndian(0);
        }
        if (this.covMatrix != null) {
            stream.writeIntEndian(this.covMatrix.length);
        } else {
            stream.writeIntEndian(0);
        }
        if (this.covMatrix != null) {
            i = 0;
            while (i < this.covMatrix.length) {
                if (this.covMatrix[i] != null) {
                    stream.writeIntEndian(this.covMatrix[i].length);
                    stream.writeDoubleEndian(this.covMatrix[i]);
                } else {
                    stream.writeIntEndian(0);
                }
                ++i;
            }
        }
        if (this.invCovMatrix != null) {
            stream.writeIntEndian(this.invCovMatrix.length);
        } else {
            stream.writeIntEndian(0);
        }
        if (this.invCovMatrix != null) {
            i = 0;
            while (i < this.invCovMatrix.length) {
                if (this.invCovMatrix[i] != null) {
                    stream.writeIntEndian(this.invCovMatrix[i].length);
                    stream.writeDoubleEndian(this.invCovMatrix[i]);
                } else {
                    stream.writeIntEndian(0);
                }
                ++i;
            }
        }
        stream.writeDoubleEndian(this.detCovMatrix);
        stream.writeDoubleEndian(this.constantTerm);
        stream.writeDoubleEndian(this.constantTermLog);
    }

    public void read(MaryRandomAccessFile stream) throws IOException {
        int tmpLen2;
        int i;
        stream.readBooleanEndian();
        int tmpLen = stream.readIntEndian();
        this.meanVector = (double[])(tmpLen > 0 ? stream.readDoubleEndian(tmpLen) : null);
        tmpLen = stream.readIntEndian();
        if (tmpLen > 0) {
            this.covMatrix = new double[tmpLen][];
            i = 0;
            while (i < tmpLen) {
                tmpLen2 = stream.readIntEndian();
                this.covMatrix[i] = (double[])(tmpLen2 > 0 ? stream.readDoubleEndian(tmpLen2) : null);
                ++i;
            }
        } else {
            this.covMatrix = null;
        }
        tmpLen = stream.readIntEndian();
        if (tmpLen > 0) {
            this.invCovMatrix = new double[tmpLen][];
            i = 0;
            while (i < tmpLen) {
                tmpLen2 = stream.readIntEndian();
                this.invCovMatrix[i] = (double[])(tmpLen2 > 0 ? stream.readDoubleEndian(tmpLen2) : null);
                ++i;
            }
        } else {
            this.invCovMatrix = null;
        }
        this.detCovMatrix = stream.readDoubleEndian();
        this.constantTerm = stream.readDoubleEndian();
        this.constantTermLog = stream.readDoubleEndian();
    }

    public double probability(double[] x) {
        double P = this.covMatrix.length == 1 ? MathUtils.getGaussianPdfValue(x, this.meanVector, this.covMatrix[0], this.getConstantTerm()) : MathUtils.getGaussianPdfValue(x, this.meanVector, this.getDetCovMatrix(), this.getInvCovMatrix());
        return P;
    }
}

