/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.signalproc.analysis.MfccFileHeader;
import marytts.signalproc.analysis.Mfccs;
import marytts.util.io.BasenameList;
import marytts.util.io.FileUtils;
import marytts.util.io.MaryRandomAccessFile;
import marytts.util.string.StringUtils;

public class MfccRaw2MfccConverter {
    public static void convertFolder(String folder, String rawMfccFileExtension, String outputMfccFileExtension, int dimension, int samplingRateInHz, float windowSizeInSeconds, float skipSizeInSeconds) {
        folder = StringUtils.checkLastSlash(folder);
        BasenameList b = new BasenameList(folder, rawMfccFileExtension);
        int numFiles = b.getListAsVector().size();
        int i = 0;
        while (i < numFiles) {
            String rawMfccFile = String.valueOf(folder) + b.getName(i) + rawMfccFileExtension;
            String outputMfccFile = StringUtils.modifyExtension(rawMfccFile, outputMfccFileExtension);
            MfccRaw2MfccConverter.rawFile2mfccFile(rawMfccFile, outputMfccFile, dimension, samplingRateInHz, windowSizeInSeconds, skipSizeInSeconds);
            System.out.println("Converted MFCC file " + String.valueOf(i + 1) + " of " + String.valueOf(numFiles));
            ++i;
        }
    }

    public static void rawFile2mfccFile(String rawFile, String mfccFile, int dimension, int samplingRateInHz, float windowSizeInSeconds, float skipSizeInSeconds) {
        Mfccs m = MfccRaw2MfccConverter.readRawMfccFile(rawFile, dimension);
        m.params.samplingRate = samplingRateInHz;
        m.params.skipsize = skipSizeInSeconds;
        m.params.winsize = windowSizeInSeconds;
        m.writeMfccFile(mfccFile);
    }

    public static Mfccs readRawMfccFile(String rawMfccFile, int dimension) {
        MfccFileHeader params = new MfccFileHeader();
        File f = new File(rawMfccFile);
        long fileSize = f.length();
        int numfrm = (int)((double)fileSize / (4.0 * (double)dimension));
        Mfccs m = new Mfccs(numfrm, dimension);
        params.numfrm = numfrm;
        params.dimension = dimension;
        if (rawMfccFile != "" && FileUtils.exists(rawMfccFile)) {
            MaryRandomAccessFile stream = null;
            try {
                stream = new MaryRandomAccessFile(rawMfccFile, "rw");
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            if (stream != null) {
                try {
                    Mfccs.readMfccsFromFloat(stream, params, m.mfccs);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return m;
    }

    public static void main(String[] args) {
        String rawMfccFileExtension = ".mgc";
        String outputMfccFileExtension = ".mfc";
        int dimension = 25;
        int samplingRateInHz = 16000;
        float windowSizeInSeconds = 0.04f;
        float skipSizeInSeconds = 0.005f;
        dimension = 21;
        String baseFolder = "D:/Oytun/DFKI/voices/hmmVoiceConversionTest/lspRaw_21Dimensional/";
        String folder = String.valueOf(baseFolder) + "hmm_gen_parameters";
        MfccRaw2MfccConverter.convertFolder(folder, rawMfccFileExtension, outputMfccFileExtension, dimension, samplingRateInHz, windowSizeInSeconds, skipSizeInSeconds);
        folder = String.valueOf(baseFolder) + "original_parameters";
        MfccRaw2MfccConverter.convertFolder(folder, rawMfccFileExtension, outputMfccFileExtension, dimension, samplingRateInHz, windowSizeInSeconds, skipSizeInSeconds);
        folder = String.valueOf(baseFolder) + "test/hmm_gen_parameters";
        MfccRaw2MfccConverter.convertFolder(folder, rawMfccFileExtension, outputMfccFileExtension, dimension, samplingRateInHz, windowSizeInSeconds, skipSizeInSeconds);
        folder = String.valueOf(baseFolder) + "test/original_parameters";
        MfccRaw2MfccConverter.convertFolder(folder, rawMfccFileExtension, outputMfccFileExtension, dimension, samplingRateInHz, windowSizeInSeconds, skipSizeInSeconds);
    }
}

