/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis;

import java.util.Arrays;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartLpc;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.signalproc.window.Window;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class NoisePartLpFilterPostHpfLpcSynthesizer {
    public static double[] synthesize(HntmSpeechSignal hnmSignal, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParams) {
        boolean isNoised;
        double[] noisePart = null;
        double[] noisePart2 = null;
        double[] weights = null;
        float tsi = 0.0f;
        int startIndex = 0;
        int outputLen = SignalProcUtils.time2sample(hnmSignal.originalDurationInSeconds, hnmSignal.samplingRateInHz);
        int lpOrder = 0;
        double[] excitation = MathUtils.random(outputLen, -0.5, 0.5);
        int fftSizeNoise = SignalProcUtils.getDFTSize(hnmSignal.samplingRateInHz);
        int i = 0;
        while (i < hnmSignal.frames.length) {
            boolean bl = isNoised = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
            if (isNoised && hnmSignal.frames[i].n != null && hnmSignal.frames[i].n instanceof FrameNoisePartLpc && ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs != null) {
                lpOrder = ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs.length;
                break;
            }
            ++i;
        }
        if (lpOrder > 0) {
            int j;
            int n;
            int pmIndNext;
            noisePart = new double[outputLen];
            Arrays.fill(noisePart, 0.0);
            noisePart2 = new double[outputLen];
            Arrays.fill(noisePart2, 0.0);
            weights = new double[outputLen];
            Arrays.fill(weights, 0.0);
            int pmInd = 0;
            int start = 0;
            double[] tmpy = null;
            double[] tmpalpha = null;
            i = 0;
            while (i < hnmSignal.frames.length) {
                pmInd = SignalProcUtils.time2sample(hnmSignal.frames[i].tAnalysisInSeconds, hnmSignal.samplingRateInHz);
                pmIndNext = i < hnmSignal.frames.length - 1 ? SignalProcUtils.time2sample(hnmSignal.frames[i + 1].tAnalysisInSeconds, hnmSignal.samplingRateInHz) : outputLen - 1;
                start = pmInd;
                boolean bl = isNoised = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                if (isNoised && hnmSignal.frames[i].n != null && hnmSignal.frames[i].n instanceof FrameNoisePartLpc && ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs != null) {
                    double tmp;
                    int count;
                    if (i < hnmSignal.frames.length - 1) {
                        n = 0;
                        while (n <= pmIndNext - pmInd) {
                            tmpy = new double[Math.max(start - 1, 0) - Math.max(start - lpOrder, 0) + 1];
                            count = 0;
                            j = Math.max(start - 1, 0);
                            while (j >= Math.max(start - lpOrder, 0)) {
                                tmpy[count++] = noisePart[j];
                                --j;
                            }
                            tmpalpha = new double[tmpy.length];
                            j = 0;
                            while (j < tmpy.length) {
                                tmpalpha[j] = ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs[j];
                                ++j;
                            }
                            tmp = 0.0;
                            j = 0;
                            while (j < tmpalpha.length) {
                                tmp += tmpalpha[j] * tmpy[j];
                                ++j;
                            }
                            if (start < outputLen) {
                                noisePart[start] = (double)((FrameNoisePartLpc)hnmSignal.frames[i].n).lpGain * excitation[start] + tmp;
                                ++start;
                                ++n;
                                continue;
                            }
                            break;
                        }
                    } else {
                        n = 0;
                        while (n < outputLen - pmInd) {
                            tmpy = new double[Math.max(start - 1, 0) - Math.max(start - lpOrder, 0) + 1];
                            count = 0;
                            j = Math.max(start - 1, 0);
                            while (j >= Math.max(start - lpOrder, 0)) {
                                tmpy[count++] = noisePart[j];
                                --j;
                            }
                            tmpalpha = new double[tmpy.length];
                            j = 0;
                            while (j < tmpy.length) {
                                tmpalpha[j] = ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs[j];
                                ++j;
                            }
                            tmp = 0.0;
                            j = 0;
                            while (j < tmpalpha.length) {
                                tmp += tmpalpha[j] * tmpy[j];
                                ++j;
                            }
                            if (start < outputLen) {
                                noisePart[start] = (double)((FrameNoisePartLpc)hnmSignal.frames[i].n).lpGain * excitation[start] + tmp;
                                ++start;
                                ++n;
                                continue;
                            }
                            break;
                        }
                    }
                }
                pmInd = pmIndNext;
                ++i;
            }
            if (analysisParams.preemphasisCoefNoise > 0.0f) {
                noisePart = SignalProcUtils.removePreemphasis(noisePart, analysisParams.preemphasisCoefNoise);
            }
            MathUtils.adjustMean(noisePart, 0.0);
            int startInd = 0;
            i = 0;
            while (i < hnmSignal.frames.length - 2) {
                pmInd = SignalProcUtils.time2sample(hnmSignal.frames[i].tAnalysisInSeconds, hnmSignal.samplingRateInHz);
                pmIndNext = i <= hnmSignal.frames.length - 3 ? SignalProcUtils.time2sample(hnmSignal.frames[i + 2].tAnalysisInSeconds, hnmSignal.samplingRateInHz) : outputLen - 1;
                startInd = start = pmInd;
                boolean isPrevNoised = false;
                if (i > 0) {
                    isPrevNoised = hnmSignal.frames[i - 1].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                }
                isNoised = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                boolean isNextNoised = false;
                if (i < hnmSignal.frames.length - 1) {
                    boolean bl = isNextNoised = hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                }
                if (isNoised && hnmSignal.frames[i].n != null && hnmSignal.frames[i].n instanceof FrameNoisePartLpc && ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs != null) {
                    int halfLen;
                    int endInd = Math.min(pmIndNext, outputLen - 1);
                    double[] tmpFrm = ArrayUtils.subarray(noisePart, startInd, endInd - startInd + 1);
                    if (synthesisParams.hpfAfterNoiseSynthesis && hnmSignal.frames[i].maximumFrequencyOfVoicingInHz - analysisParams.overlapBetweenHarmonicAndNoiseRegionsInHz > 0.0f) {
                        tmpFrm = SignalProcUtils.fdFilter(tmpFrm, hnmSignal.frames[i].maximumFrequencyOfVoicingInHz - analysisParams.overlapBetweenHarmonicAndNoiseRegionsInHz, 0.5f * (float)hnmSignal.samplingRateInHz, hnmSignal.samplingRateInHz, fftSizeNoise);
                    }
                    tmpFrm = SignalProcUtils.normalizeAverageSampleEnergy(tmpFrm, ((FrameNoisePartLpc)hnmSignal.frames[i].n).origAverageSampleEnergy);
                    Window winNoise = Window.get(analysisParams.noiseAnalysisWindowType, endInd - startInd + 1);
                    winNoise.normalizePeakValue(1.0f);
                    double[] wgtNoise = winNoise.getCoeffs();
                    if (!isPrevNoised) {
                        halfLen = (int)Math.floor(0.5 * (double)tmpFrm.length + 0.5);
                        j = 0;
                        while (j < halfLen) {
                            int n2 = startInd + j;
                            noisePart2[n2] = noisePart2[n2] + tmpFrm[j] * wgtNoise[j];
                            ++j;
                        }
                        j = halfLen + 1;
                        while (j < tmpFrm.length) {
                            int n3 = startInd + j;
                            noisePart2[n3] = noisePart2[n3] + tmpFrm[j] * wgtNoise[j];
                            int n4 = startInd + j;
                            weights[n4] = weights[n4] + wgtNoise[j];
                            ++j;
                        }
                    } else if (!isNextNoised) {
                        halfLen = (int)Math.floor(0.5 * (double)tmpFrm.length + 0.5);
                        j = 0;
                        while (j < halfLen) {
                            int n5 = startInd + j;
                            noisePart2[n5] = noisePart2[n5] + tmpFrm[j] * wgtNoise[j];
                            int n6 = startInd + j;
                            weights[n6] = weights[n6] + wgtNoise[j];
                            ++j;
                        }
                        j = halfLen + 1;
                        while (j < tmpFrm.length) {
                            int n7 = startInd + j;
                            noisePart2[n7] = noisePart2[n7] + tmpFrm[j] * wgtNoise[j];
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < tmpFrm.length) {
                            int n8 = startInd + j;
                            noisePart2[n8] = noisePart2[n8] + tmpFrm[j] * wgtNoise[j];
                            int n9 = startInd + j;
                            weights[n9] = weights[n9] + wgtNoise[j];
                            ++j;
                        }
                    }
                }
                pmInd = pmIndNext;
                ++i;
            }
            i = 0;
            while (i < outputLen) {
                if (weights[i] > 1.0E-20) {
                    int n10 = i;
                    noisePart2[n10] = noisePart2[n10] / weights[i];
                }
                ++i;
            }
            System.arraycopy(noisePart2, 0, noisePart, 0, outputLen);
            if (synthesisParams.applyTriangularNoiseEnvelopeForVoicedParts) {
                float tsiNext = 0.0f;
                i = 0;
                while (i < hnmSignal.frames.length) {
                    boolean isVoiced;
                    boolean bl = isVoiced = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz > 0.0f;
                    if (isVoiced) {
                        int startIndexNext;
                        tsi = i == 0 ? 0.0f : hnmSignal.frames[i].tAnalysisInSeconds;
                        startIndex = SignalProcUtils.time2sample(tsi, hnmSignal.samplingRateInHz);
                        if (i < hnmSignal.frames.length - 1) {
                            tsiNext = Math.max(0.0f, hnmSignal.frames[i + 1].tAnalysisInSeconds);
                            startIndexNext = SignalProcUtils.time2sample(tsiNext, hnmSignal.samplingRateInHz);
                        } else {
                            startIndexNext = outputLen - 1;
                            tsiNext = SignalProcUtils.sample2time(startIndexNext, hnmSignal.samplingRateInHz);
                        }
                        int enEnvLen = startIndexNext - startIndex + 1;
                        if (enEnvLen > 0) {
                            double[] enEnv = new double[enEnvLen];
                            int l1 = SignalProcUtils.time2sample(0.15 * (double)(tsiNext - tsi), hnmSignal.samplingRateInHz);
                            int l2 = SignalProcUtils.time2sample(0.85 * (double)(tsiNext - tsi), hnmSignal.samplingRateInHz);
                            int lMid = (int)Math.floor(0.5 * (double)(l1 + l2) + 0.5);
                            n = 0;
                            while (n < l1) {
                                enEnv[n] = synthesisParams.energyTriangleLowerValue;
                                ++n;
                            }
                            n = l1;
                            while (n < lMid) {
                                enEnv[n] = (double)(n - l1) * (synthesisParams.energyTriangleUpperValue - synthesisParams.energyTriangleLowerValue) / (double)(lMid - l1) + synthesisParams.energyTriangleLowerValue;
                                ++n;
                            }
                            n = lMid;
                            while (n < l2) {
                                enEnv[n] = (double)(n - lMid) * (synthesisParams.energyTriangleLowerValue - synthesisParams.energyTriangleUpperValue) / (double)(l2 - lMid) + synthesisParams.energyTriangleUpperValue;
                                ++n;
                            }
                            n = l2;
                            while (n < enEnvLen) {
                                enEnv[n] = synthesisParams.energyTriangleLowerValue;
                                ++n;
                            }
                            n = startIndex;
                            while (n <= Math.min(noisePart.length - 1, startIndexNext)) {
                                int n11 = n;
                                noisePart[n11] = noisePart[n11] * enEnv[n - startIndex];
                                ++n;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return noisePart;
    }
}

