/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.signalproc.analysis.AlignedLabels;
import marytts.signalproc.analysis.Labels;
import marytts.util.data.text.XwavesLabelfileReader;
import marytts.util.string.StringUtils;

public class TranscriptionAligner {
    protected Map<String, Integer> aligncost = new HashMap<String, Integer>();
    protected int defaultcost = 10;
    protected int defaultBoundaryCost;
    protected int skipcost;
    protected AllophoneSet allophoneSet;
    protected String possibleBnd;
    protected String entrySeparator;
    protected boolean ensureInitialBoundary = false;

    public TranscriptionAligner() {
        this(null);
    }

    public TranscriptionAligner(AllophoneSet allophoneSet) {
        this(allophoneSet, null);
    }

    public TranscriptionAligner(AllophoneSet allophoneSet, String entrySeparator) {
        this.allophoneSet = allophoneSet;
        this.possibleBnd = allophoneSet != null ? allophoneSet.getSilence().name() : "_";
        this.entrySeparator = entrySeparator != null ? entrySeparator : "|";
        this.setDistance();
        this.defaultcost = this.getMaxCost();
        this.defaultBoundaryCost = 20 * this.defaultcost;
        this.aligncost.put(String.valueOf(this.possibleBnd) + " " + this.possibleBnd, 0);
        this.skipcost = this.defaultcost * 1 / 10;
    }

    public void SetEnsureInitialBoundary(boolean value) {
        this.ensureInitialBoundary = value;
    }

    public boolean getEnsureInitialBoundary() {
        return this.ensureInitialBoundary;
    }

    public String getEntrySeparator() {
        return this.entrySeparator;
    }

    public static String readLabelFile(String entrySeparator, boolean ensureInitialBoundary, String trfname) throws IOException {
        try (BufferedReader lab = new BufferedReader(new FileReader(trfname));){
            XwavesLabelfileReader xlds = new XwavesLabelfileReader(trfname);
            String result = StringUtils.join(entrySeparator, xlds.getLabelSymbols());
            if (ensureInitialBoundary && result.charAt(0) != '_') {
                result = "_" + entrySeparator + result;
            }
            String string = result;
            return string;
        }
    }

    private void setDistance() {
        if (this.allophoneSet == null) {
            System.err.println("No allophone set -- cannot use intelligent distance metrics");
            return;
        }
        for (String fromSym : this.allophoneSet.getAllophoneNames()) {
            for (String toSym : this.allophoneSet.getAllophoneNames()) {
                int diff = 0;
                Allophone fromPh = this.allophoneSet.getAllophone(fromSym);
                Allophone toPh = this.allophoneSet.getAllophone(toSym);
                diff += !fromSym.equals(toSym) ? 2 : 0;
                diff += fromPh.isFricative() != toPh.isFricative() ? 2 : 0;
                diff += fromPh.isGlide() != toPh.isGlide() ? 2 : 0;
                diff += fromPh.isLiquid() != toPh.isLiquid() ? 2 : 0;
                diff += fromPh.isNasal() != toPh.isNasal() ? 2 : 0;
                diff += fromPh.isPlosive() != toPh.isPlosive() ? 1 : 0;
                diff += fromPh.isSonorant() != toPh.isSonorant() ? 2 : 0;
                diff += fromPh.isSyllabic() != toPh.isSyllabic() ? 1 : 0;
                diff += fromPh.isVoiced() != toPh.isVoiced() ? 1 : 0;
                diff += fromPh.isVowel() != toPh.isVowel() ? 2 : 0;
                String key = String.valueOf(fromSym) + " " + toSym;
                this.aligncost.put(key, diff += Math.abs(fromPh.sonority() - toPh.sonority()));
            }
        }
    }

    protected String distanceAlign(String in, String out) {
        String[] istr = in.split(Pattern.quote(this.entrySeparator));
        String[] ostr = out.split(Pattern.quote(this.entrySeparator));
        String delim = "#";
        int[] p_d = new int[ostr.length + 1];
        int[] d = new int[ostr.length + 1];
        boolean[] p_sk = new boolean[ostr.length + 1];
        boolean[] sk = new boolean[ostr.length + 1];
        String[] p_al = new String[ostr.length + 1];
        String[] al = new String[ostr.length + 1];
        p_d[0] = 0;
        p_al[0] = "";
        p_sk[0] = true;
        int j = 1;
        while (j < ostr.length + 1) {
            p_al[j] = String.valueOf(p_al[j - 1]) + " " + ostr[j - 1];
            p_d[j] = p_d[j - 1] + this.symDist(istr[0], ostr[j - 1]);
            p_sk[j] = false;
            ++j;
        }
        int skConst = this.skipcost;
        int i = 1;
        while (i < istr.length) {
            d[0] = p_d[0] + skConst;
            al[0] = String.valueOf(p_al[0]) + " " + delim;
            sk[0] = true;
            int j2 = 1;
            while (j2 < ostr.length + 1) {
                int sk_cost;
                int tr_cost = this.symDist(istr[i], ostr[j2 - 1]);
                int n = sk_cost = p_sk[j2] ? skConst : 0;
                if (sk_cost + p_d[j2] < tr_cost + d[j2 - 1]) {
                    d[j2] = sk_cost + p_d[j2];
                    al[j2] = String.valueOf(p_al[j2]) + " " + delim;
                    sk[j2] = true;
                } else {
                    d[j2] = tr_cost + d[j2 - 1];
                    al[j2] = String.valueOf(al[j2 - 1]) + " " + ostr[j2 - 1];
                    sk[j2] = false;
                }
                ++j2;
            }
            int[] _d = p_d;
            p_d = d;
            d = _d;
            boolean[] _sk = p_sk;
            p_sk = sk;
            sk = _sk;
            String[] _al = p_al;
            p_al = al;
            al = _al;
            ++i;
        }
        return p_al[ostr.length];
    }

    public AlignedLabels alignLabels(Labels first, Labels second) {
        String secondLabels;
        String firstLabels = StringUtils.join(this.entrySeparator, first.getLabelSymbols());
        String aligned = this.distanceAlign(firstLabels, secondLabels = StringUtils.join(this.entrySeparator, second.getLabelSymbols()));
        if (aligned.endsWith("#")) {
            aligned = String.valueOf(aligned) + " ";
        }
        String[] fields = aligned.split("#");
        assert (fields.length == first.items.length);
        int iSecond = -1;
        int[] map = new int[fields.length];
        int i = 0;
        while (i < fields.length) {
            String f = fields[i].trim();
            int numLabels = f.equals("") ? 0 : f.split(" ").length;
            map[i] = Math.max(iSecond += numLabels, 0);
            ++i;
        }
        return new AlignedLabels(first, second, map);
    }

    private int getMaxCost() {
        if (this.aligncost.isEmpty()) {
            return this.defaultcost;
        }
        int maxMapping = Collections.max(this.aligncost.values());
        return maxMapping > this.defaultcost ? maxMapping : this.defaultcost;
    }

    private int symDist(String aString1, String aString2) {
        String key = String.valueOf(aString1) + " " + aString2;
        if (this.aligncost.containsKey(key)) {
            return this.aligncost.get(key);
        }
        if (aString1.equals(aString2)) {
            return 0;
        }
        if (aString1.equals(this.possibleBnd) || aString2.equals(this.possibleBnd)) {
            return this.defaultBoundaryCost;
        }
        return this.defaultcost;
    }
}

