/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.SynthesisException;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.server.MaryProperties;
import marytts.unitselection.UnitSelectionVoice;
import marytts.unitselection.concat.BaseUnitConcatenator;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.SelectedUnit;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryNormalisedWriter;
import marytts.util.dom.NameNodeFilter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class UnitSelectionSynthesizer
implements WaveformSynthesizer {
    private Logger logger;

    @Override
    public void startup() throws Exception {
        this.logger = MaryUtils.getLogger("UnitSelectionSynthesizer");
        this.logger.debug("Register UnitSelection voices:");
        List<String> voiceNames = MaryProperties.getList("unitselection.voices.list");
        for (String voiceName : voiceNames) {
            long time = System.currentTimeMillis();
            UnitSelectionVoice unitSelVoice = new UnitSelectionVoice(voiceName, this);
            this.logger.debug("Voice '" + unitSelVoice + "'");
            Voice.registerVoice(unitSelVoice);
            long newtime = System.currentTimeMillis() - time;
            this.logger.info("Loading of voice " + voiceName + " took " + newtime + " milliseconds");
        }
        this.logger.info("started.");
    }

    @Override
    public void powerOnSelfTest() throws Error {
        try {
            Collection<Voice> myVoices = Voice.getAvailableVoices(this);
            if (myVoices.size() == 0) {
                return;
            }
            UnitSelectionVoice unitSelVoice = (UnitSelectionVoice)myVoices.iterator().next();
            assert (unitSelVoice != null);
            MaryData in = new MaryData(MaryDataType.get("ACOUSTPARAMS"), unitSelVoice.getLocale());
            if (!unitSelVoice.getDomain().equals("general")) {
                this.logger.info("Cannot perform power-on self test using limited-domain voice '" + unitSelVoice.getName() + "' - skipping.");
                return;
            }
            String exampleText = MaryDataType.ACOUSTPARAMS.exampleText(unitSelVoice.getLocale());
            if (exampleText != null) {
                in.readFrom(new StringReader(exampleText));
                in.setDefaultVoice(unitSelVoice);
                if (in == null) {
                    System.out.println(String.valueOf(exampleText) + " is null");
                }
                ArrayList<Element> tokensAndBoundaries = new ArrayList<Element>();
                TreeWalker tw = ((DocumentTraversal)((Object)in.getDocument())).createTreeWalker(in.getDocument(), 1, new NameNodeFilter("t", "boundary"), false);
                Element el = null;
                while ((el = (Element)tw.nextNode()) != null) {
                    tokensAndBoundaries.add(el);
                }
                AudioInputStream ais = this.synthesize(tokensAndBoundaries, unitSelVoice, null);
                assert (ais != null);
            } else {
                this.logger.debug("No example text -- no power-on self test!");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Module " + this.toString() + ": Power-on self test failed.", t);
        }
        this.logger.info("Power-on self test complete.");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public AudioInputStream synthesize(List<Element> tokensAndBoundaries, Voice voice, String outputParams) throws SynthesisException {
        block18: {
            if (!UnitSelectionSynthesizer.$assertionsDisabled && !(voice instanceof UnitSelectionVoice)) {
                throw new AssertionError();
            }
            v = (UnitSelectionVoice)voice;
            udb = v.getDatabase();
            unitSel = v.getUnitSelector();
            unitConcatenator = outputParams != null && outputParams.contains("MODIFICATION") != false ? v.getModificationConcatenator() : v.getConcatenator();
            database = v.getDatabase();
            this.logger.debug("Selecting units with a " + unitSel.getClass().getName() + " from a " + database.getClass().getName());
            selectedUnits = unitSel.selectUnits(tokensAndBoundaries, voice);
            this.logger.debug("Now creating audio with a " + unitConcatenator.getClass().getName());
            audio = null;
            try {
                audio = unitConcatenator.getAudio(selectedUnits);
                break block18;
            }
            catch (IOException ioe) {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                selIt = selectedUnits.iterator();
                ** while (selIt.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                pw.println(selIt.next());
                continue;
            }
lbl22:
            // 1 sources

            throw new SynthesisException("Problems generating audio for unit chain: " + sw.toString(), ioe);
        }
        endInSeconds = 0.0f;
        durLeftHalfInSeconds = 0.0f;
        unitString = "";
        unitAttrName = "units";
        for (SelectedUnit su : selectedUnits) {
            t = su.getTarget();
            halfphone = t instanceof HalfPhoneTarget;
            concatenationData = su.getConcatenationData();
            if (!UnitSelectionSynthesizer.$assertionsDisabled && !(concatenationData instanceof BaseUnitConcatenator.UnitData)) {
                throw new AssertionError();
            }
            unitData = (BaseUnitConcatenator.UnitData)concatenationData;
            unit = su.getUnit();
            unitDurationInSamples = unitData.getUnitDuration();
            unitDurationInSeconds = (float)unitDurationInSamples / (float)database.getUnitFileReader().getSampleRate();
            prevEndInMillis = (int)(1000.0f * endInSeconds);
            endInMillis = (int)(1000.0f * (endInSeconds += unitDurationInSeconds));
            unitDurationInMillis = endInMillis - prevEndInMillis;
            unitString = String.valueOf(t.getName()) + " " + udb.getFilename(unit) + " " + unit.index + " " + unitDurationInSeconds;
            if (halfphone) {
                if (((HalfPhoneTarget)t).isLeftHalf()) {
                    durLeftHalfInSeconds = unitDurationInSeconds;
                } else {
                    totalUnitDurInSeconds = durLeftHalfInSeconds + unitDurationInSeconds;
                    prevEndInSeconds = endInSeconds - totalUnitDurInSeconds;
                    prevEndInMillis = (int)(1000.0f * prevEndInSeconds);
                    unitDurationInMillis = endInMillis - prevEndInMillis;
                    durLeftHalfInSeconds = 0.0f;
                }
            }
            if ((maryxmlElement = t.getMaryxmlElement()) != null) {
                if (maryxmlElement.getNodeName().equals("ph")) {
                    if (!maryxmlElement.hasAttribute("d") || !maryxmlElement.hasAttribute("end")) {
                        throw new IllegalStateException("No duration information in MaryXML -- check log file for messages warning about unloadable acoustic models instead of voice-specific acoustic feature predictors");
                    }
                    maryxmlElement.setAttribute("d", String.valueOf(unitDurationInMillis));
                    maryxmlElement.setAttribute("end", String.valueOf(endInSeconds));
                } else {
                    if (!UnitSelectionSynthesizer.$assertionsDisabled && !maryxmlElement.getNodeName().equals("boundary")) {
                        throw new AssertionError();
                    }
                    maryxmlElement.setAttribute("duration", String.valueOf(unitDurationInMillis));
                }
                if (maryxmlElement.hasAttribute(unitAttrName)) {
                    prevUnitString = maryxmlElement.getAttribute(unitAttrName);
                    maryxmlElement.setAttribute(unitAttrName, String.valueOf(prevUnitString) + "; " + unitString);
                    continue;
                }
                maryxmlElement.setAttribute(unitAttrName, unitString);
                continue;
            }
            this.logger.debug("Unit " + su.getTarget().getName() + " of length " + unitDurationInMillis + " ms has no maryxml element.");
        }
        if (this.logger.getEffectiveLevel().equals(Level.DEBUG)) {
            try {
                writer = new MaryNormalisedWriter();
                debugOut = new ByteArrayOutputStream();
                writer.output(tokensAndBoundaries.get(0).getOwnerDocument(), debugOut);
                this.logger.debug("Propagating the realised unit durations to the XML tree: \n" + debugOut.toString());
            }
            catch (Exception e) {
                this.logger.warn("Problem writing XML to logfile: " + e);
            }
        }
        return audio;
    }
}

